/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.types.resources;

import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildFileUtil;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.enterprise.build.ant.types.resources.BuildableResource;
import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFileHandle;
import com.ibm.team.enterprise.build.common.buildreport.BuildFileDefaultHandler;
import com.ibm.team.enterprise.build.common.buildreport.BuildFileXMLModel;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BuildableResourceCollection
extends DataType
implements ResourceCollection {
    private static final String VARIABLE_PROPERTY_PREFIX = "team.enterprise.build.var.";
    private static final String VALUE_ELEMENT = "value";
    private static final String NAME_ELEMENT = "name";
    private static final String VARIABLE_ELEMENT = "variable";
    private static final String VARIABLES_ELEMENT = "variables";
    private static final String UTF_8 = "UTF-8";
    private File fBuildableList;
    private static final String BUILD_FILE_NAME_SPACE = "http://www.ibm.com/team/enterprise/build/buildablefiles/1.0/";
    private static final String DEPENDENCY_SET_NAME_SPACE = "http://www.ibm.com/team/enterprise/build/dependencyset/1.0/";
    private static final String BUILD_PATH_ATTRIBUTE = "buildPath";
    private static final String BUILD_FILE_ATTRIBUTE = "buildFile";
    private static final String MACRO_ATTRIBUTE = "buildMacro";
    private static final String FILE_ELEMENT = "file";
    private static final String PROJECT_ELEMENT = "project";
    private static final String COMPONENT_ELEMENT = "component";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String LANGDEFNAME_ATTRIBUTE = "langDefName";
    private static final String UUID_ATTRIBUTE = "uuid";
    private static final String LANGUAGE_CODE_ATTRIBUTE = "languageCode";
    private static final String LANGDEFSTATEID_ATTRIBUTE = "langDefStateId";
    private static final String INPUT_TYPE_ATTRIBUTE = "inputType";
    private static final String SRC_LIB_ATTRIBUTE = "srcLib";
    private static final String OBJ_LIB_ATTRIBUTE = "objLib";
    private static final String VERSION_ID_ATTRIBUTE = "versionId";
    private static final String REASON_ATTRIBUTE = "reason";
    private static final String HFS_ATTRIBUTE = "hfs";
    private static final String DEPENDENCY_SET_ELEMENT = "dependency-set";
    private static final String REBUILD_ATTRIBUITE = "rebuild";
    private static final String OUTPUTS_ELEMENT = "outputs";
    private static final String PARSER_OUTPUTS_ELEMENT = "parserOutputs";
    private static final String WORK_ITEMS_ELEMENT = "workItems";
    private static final String WORK_ITEM_ELEMENT = "workItem";
    private static final int DEFAULT_SIZE = 8;
    private final List fResources = new ArrayList(8);

    public boolean isFilesystemOnly() {
        return false;
    }

    public Iterator<Resource> iterator() {
        if (this.isReference()) {
            return ((BuildableResourceCollection)((Object)this.getCheckedRef(this.getProject()))).iterator();
        }
        if (this.fBuildableList == null || !this.fBuildableList.exists()) {
            throw new BuildException(NLS.bind((String)Messages.BUILDABLE_FILE_NOT_FOUND, (Object)this.fBuildableList));
        }
        this.initialize();
        return this.fResources.iterator();
    }

    public int size() {
        if (this.isReference()) {
            return ((BuildableResourceCollection)((Object)this.getCheckedRef())).size();
        }
        this.dieOnCircularReference();
        this.initialize();
        return this.fResources.size();
    }

    public File getBuildableList() {
        return this.fBuildableList;
    }

    public void setBuildableList(File buildableList) {
        this.fBuildableList = buildableList;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator<Resource> iterator = this.iterator();
        while (iterator.hasNext()) {
            BuildableResource resource = (BuildableResource)iterator.next();
            buffer.append(resource.getBuildPath());
            String memberName = resource.getBuildFile();
            if (memberName != null) {
                buffer.append("(" + memberName + ")");
            }
            if (!iterator.hasNext()) continue;
            buffer.append(" : ");
        }
        return buffer.toString();
    }

    private void initialize() {
        if (this.fResources != null && this.fResources.size() > 0) {
            return;
        }
        if (this.fBuildableList == null || !this.fBuildableList.exists()) {
            throw new BuildException(NLS.bind((String)Messages.BUILDABLE_FILE_READ_ERROR, (Object)this.fBuildableList));
        }
        this.log("beginning parse of buildableFiles", 4);
        this.parseBuildableList();
        this.log("done parsing of buildableFiles", 4);
    }

    private void parseBuildableList() {
        SAXParserFactory fac = SAXParserFactory.newInstance();
        fac.setNamespaceAware(true);
        try {
            SAXParser parser = fac.newSAXParser();
            parser.parse(this.fBuildableList, (DefaultHandler)((Object)new BuildableResourceCollectionParser()));
        }
        catch (ParserConfigurationException e) {
            this.log(e.getMessage(), 3);
            throw new BuildException(NLS.bind((String)Messages.BUILDABLE_PARSE_EXCEPTION, (Object)this.fBuildableList));
        }
        catch (SAXException e) {
            this.log(e.getMessage(), 3);
            throw new BuildException(NLS.bind((String)Messages.BUILDABLE_PARSE_EXCEPTION, (Object)this.fBuildableList));
        }
        catch (IOException e) {
            this.log(e.getMessage(), 3);
            throw new BuildException(NLS.bind((String)Messages.BUILDABLE_FILE_READ_ERROR, (Object)this.fBuildableList));
        }
    }

    public void log(String msg, int msgLevel) {
        String msg2 = "[antz:buildableset] " + msg;
        if (this.getProject() != null) {
            this.getProject().log(msg2, msgLevel);
        } else if (msgLevel <= 2) {
            System.err.println(msg2);
        }
    }

    public static void updateDependencySet(BuildableResource resource, boolean rebuild, List<IInputBuildFileHandle> inputList) throws Exception {
        resource.setRebuild(rebuild);
        IItemManager itemManager = InitTask.getInstance().getTeamRepository().itemManager();
        for (IInputBuildFileHandle input : inputList) {
            if (input == null) continue;
            IInputBuildFile bf = (IInputBuildFile)itemManager.fetchCompleteItem((IItemHandle)input, 0, null);
            resource.addInputFile(BuildFileUtil.getXMLModelFromInputBuildFile(bf));
        }
    }

    public static void updateDependencySet(final BuildableResource resource, String dependencySetElementXML) throws ParserConfigurationException, SAXException, IOException {
        if (resource == null) {
            return;
        }
        long start = System.currentTimeMillis();
        SAXParserFactory fac = SAXParserFactory.newInstance();
        fac.setNamespaceAware(true);
        SAXParser parser = fac.newSAXParser();
        ByteArrayInputStream ins = new ByteArrayInputStream(dependencySetElementXML.getBytes(UTF_8));
        parser.parse((InputStream)ins, (DefaultHandler)new BuildFileDefaultHandler(){

            public void finishedInputFile(BuildFileXMLModel buildFile) {
                resource.addInputFile(buildFile);
            }
        });
        long end = System.currentTimeMillis();
        resource.log("Updating Dependency Set for " + resource.getBuildPath() + "/" + resource.getBuildFile() + " took " + (end - start) + "ms", 4);
    }

    private class BuildableResourceCollectionParser
    extends BuildFileDefaultHandler {
        protected String currentComponentName = null;
        protected String currentProjectName = null;
        protected BuildableResource currentResource = null;
        protected HashMap<String, String> currentVariablesMap = null;
        protected boolean inDependencySet = false;
        protected String currentVarName = null;
        protected String currentVarValue = null;
        protected HashSet<BuildFileXMLModel> currentOutputFiles = null;
        protected HashSet<BuildFileXMLModel> currentParserOutputFiles = null;
        protected HashSet<String> currentWorkItems = null;

        private BuildableResourceCollectionParser() {
        }

        public void startDocument() throws SAXException {
            super.startDocument();
        }

        public void endDocument() throws SAXException {
            super.endDocument();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (BuildableResourceCollection.BUILD_FILE_NAME_SPACE.equals(uri)) {
                if (BuildableResourceCollection.COMPONENT_ELEMENT.equals(localName)) {
                    this.currentComponentName = attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, "name");
                } else if (BuildableResourceCollection.PROJECT_ELEMENT.equals(localName)) {
                    this.currentProjectName = attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, "name");
                } else if (BuildableResourceCollection.FILE_ELEMENT.equals(localName)) {
                    String buildPath = attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, BuildableResourceCollection.BUILD_PATH_ATTRIBUTE);
                    String buildFile = attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, BuildableResourceCollection.BUILD_FILE_ATTRIBUTE);
                    String buildMacro = attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, BuildableResourceCollection.MACRO_ATTRIBUTE);
                    String langDefName = attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, BuildableResourceCollection.LANGDEFNAME_ATTRIBUTE);
                    String languageCode = attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, BuildableResourceCollection.LANGUAGE_CODE_ATTRIBUTE);
                    String langDefStateId = attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, BuildableResourceCollection.LANGDEFSTATEID_ATTRIBUTE);
                    String uuid = attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, BuildableResourceCollection.UUID_ATTRIBUTE);
                    String inputType = attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, BuildableResourceCollection.INPUT_TYPE_ATTRIBUTE);
                    String srcLib = attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, BuildableResourceCollection.SRC_LIB_ATTRIBUTE);
                    String objLib = attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, BuildableResourceCollection.OBJ_LIB_ATTRIBUTE);
                    String versionId = attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, BuildableResourceCollection.VERSION_ID_ATTRIBUTE);
                    String reason = attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, BuildableResourceCollection.REASON_ATTRIBUTE);
                    boolean hfs = Boolean.parseBoolean(attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, BuildableResourceCollection.HFS_ATTRIBUTE));
                    boolean rebuild = Boolean.parseBoolean(attributes.getValue(BuildableResourceCollection.BUILD_FILE_NAME_SPACE, BuildableResourceCollection.REBUILD_ATTRIBUITE));
                    this.currentResource = new BuildableResource(buildPath, buildFile, this.currentComponentName, this.currentProjectName, buildMacro, langDefName, uuid, languageCode, inputType, srcLib, objLib, rebuild, langDefStateId, versionId, hfs, reason);
                } else if (BuildableResourceCollection.VARIABLES_ELEMENT.equals(localName)) {
                    this.currentVariablesMap = new HashMap();
                } else if (BuildableResourceCollection.OUTPUTS_ELEMENT.equals(localName)) {
                    this.currentOutputFiles = new HashSet();
                } else if (BuildableResourceCollection.PARSER_OUTPUTS_ELEMENT.equals(localName)) {
                    this.currentParserOutputFiles = new HashSet();
                } else if (BuildableResourceCollection.WORK_ITEMS_ELEMENT.equals(localName)) {
                    this.currentWorkItems = new HashSet();
                }
            } else if (BuildableResourceCollection.DEPENDENCY_SET_NAME_SPACE.equals(uri) && BuildableResourceCollection.DEPENDENCY_SET_ELEMENT.equals(localName)) {
                this.inDependencySet = true;
            }
            super.startElement(uri, localName, qName, attributes);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (BuildableResourceCollection.BUILD_FILE_NAME_SPACE.equals(uri)) {
                if (BuildableResourceCollection.COMPONENT_ELEMENT.equals(localName)) {
                    this.currentComponentName = null;
                } else if (BuildableResourceCollection.PROJECT_ELEMENT.equals(localName)) {
                    this.currentProjectName = null;
                } else if (BuildableResourceCollection.FILE_ELEMENT.equals(localName)) {
                    BuildableResourceCollection.this.log(NLS.bind((String)Messages.BUILDABLE_RESOURCE_ADDED, (Object)this.currentResource.toString()), 4);
                    BuildableResourceCollection.this.fResources.add(this.currentResource);
                    this.currentResource = null;
                } else if (BuildableResourceCollection.VARIABLES_ELEMENT.equals(localName)) {
                    this.currentResource.setVariables(this.currentVariablesMap);
                    this.currentVariablesMap = null;
                } else if (BuildableResourceCollection.VARIABLE_ELEMENT.equals(localName)) {
                    if (this.currentVarName != null && this.currentVarName.length() > 0 && this.currentVarValue != null) {
                        if (this.currentVarName.startsWith(BuildableResourceCollection.VARIABLE_PROPERTY_PREFIX)) {
                            this.currentVarName = this.currentVarName.substring(BuildableResourceCollection.VARIABLE_PROPERTY_PREFIX.length());
                        }
                        this.currentVariablesMap.put(this.currentVarName, this.currentVarValue);
                    }
                } else if ("name".equals(localName)) {
                    this.currentVarName = this.currentContent;
                } else if (BuildableResourceCollection.VALUE_ELEMENT.equals(localName)) {
                    this.currentVarValue = this.currentContent;
                } else if (BuildableResourceCollection.OUTPUTS_ELEMENT.equals(localName)) {
                    this.currentResource.setOutputFiles(this.currentOutputFiles);
                    this.currentOutputFiles = null;
                } else if (BuildableResourceCollection.PARSER_OUTPUTS_ELEMENT.equals(localName)) {
                    this.currentResource.setParserOutputFiles(this.currentParserOutputFiles);
                    this.currentParserOutputFiles = null;
                } else if (BuildableResourceCollection.WORK_ITEMS_ELEMENT.equals(localName)) {
                    this.currentResource.setWorkItems(this.currentWorkItems);
                    this.currentWorkItems = null;
                } else if (BuildableResourceCollection.WORK_ITEM_ELEMENT.equals(localName)) {
                    this.currentWorkItems.add(this.currentContent);
                }
            } else if (BuildableResourceCollection.DEPENDENCY_SET_NAME_SPACE.equals(uri) && BuildableResourceCollection.DEPENDENCY_SET_ELEMENT.equals(localName)) {
                this.inDependencySet = false;
            }
            super.endElement(uri, localName, qName);
        }

        public void finishedInputFile(BuildFileXMLModel buildFile) {
            if (this.inDependencySet) {
                this.currentResource.addInputFile(buildFile);
            }
        }

        public void finishedOutputFile(BuildFileXMLModel buildFile) {
            if (this.currentOutputFiles != null) {
                this.currentOutputFiles.add(buildFile);
            }
        }

        public void finishedParserOutputFile(BuildFileXMLModel buildFile) {
            if (this.currentParserOutputFiles != null) {
                this.currentParserOutputFiles.add(buildFile);
            }
        }
    }
}

