/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.types.resources;

import com.ibm.team.build.common.IStaticReset;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.build.ant.IBuildableResource;
import com.ibm.team.enterprise.build.ant.IFileSystemUtil;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildFileUtil;
import com.ibm.team.enterprise.build.ant.internal.utils.FileSystemUtilFactory;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.util.BuildMapSerializer;
import com.ibm.team.enterprise.build.common.buildreport.BuildFileXMLModel;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.workitem.client.IWorkItemClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.eclipse.emf.common.util.URI;

public class BuildableResource
extends Resource
implements IBuildableResource,
IStaticReset {
    private static final String NUMBER_OF_SOURCES = "NUMBER_OF_SOURCES";
    private static final String ZERO = "0";
    private static final String DOT = ".";
    private static final String ZERO_LENGTH_STRING = "";
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String BUILDMAP_XML = "buildmap.xml";
    private static final String MVS_NAME_SUFFIX = "'";
    private static final String MVS_NAME_PREFIX = "//'";
    private static final String RIGHT_PARENTHESIS = ")";
    private static final String LEFT_PARENTHESIS = "(";
    private static final String BUILD_LABEL = "buildLabel";
    public static final String GENERATED_OUTPUTS_LIST = "generatedOutputs.properties";
    private String buildPath;
    private String buildFile;
    private String projectName;
    private String componentName;
    private String buildMacro;
    private String langDefName;
    private String text;
    private String uuid;
    private String languageCode;
    private String inputType;
    private String srcLib;
    private String objLib;
    private boolean rebuild;
    private String langDefStateId;
    private String versionId;
    private boolean hfs;
    private String reason;
    private final Set<BuildFileXMLModel> fInputFiles = new HashSet<BuildFileXMLModel>(10);
    private Set<BuildFileXMLModel> fOutputFiles;
    private Set<BuildFileXMLModel> fParserOutputFiles;
    private Set<BuildFileXMLModel> fResolvedInputFiles;
    private Set<String> fWorkItems;
    private Map<String, String> fVariables;
    private static IFileSystemUtil util;

    public BuildableResource() {
    }

    public BuildableResource(String buildPath, String buildFile, String componentName, String projectName, String buildMacro, String langDefName, String uuid, String languageCode, String inputType, String srcLib, String objLib, boolean rebuild, String langDefStateId, String versionId, boolean hfs, String reason) {
        this.setBuildPath(buildPath);
        this.setBuildFile(buildFile);
        this.componentName = componentName;
        this.projectName = projectName;
        this.buildMacro = buildMacro;
        this.langDefName = langDefName;
        this.uuid = uuid;
        this.languageCode = languageCode;
        this.inputType = inputType;
        this.srcLib = srcLib;
        this.objLib = objLib;
        this.rebuild = rebuild;
        this.langDefStateId = langDefStateId;
        this.versionId = versionId;
        this.hfs = hfs;
        this.reason = reason;
        StringBuffer name = new StringBuffer(this.buildPath);
        if (this.buildFile != null) {
            name.append(LEFT_PARENTHESIS).append(this.buildFile).append(RIGHT_PARENTHESIS);
        }
        this.setName(name.toString());
    }

    public boolean isExists() {
        return new File(this.getName()).exists();
    }

    public String getMvsName() {
        return MVS_NAME_PREFIX + this.getName() + MVS_NAME_SUFFIX;
    }

    public InputStream getInputStream() throws IOException {
        return this.isReference() ? ((Resource)this.getCheckedRef()).getInputStream() : new FileInputStream(new File(this.getName()));
    }

    @Override
    public String getBuildPath() {
        return this.buildPath;
    }

    @Override
    public void setBuildPath(String buildPath) {
        if (util == null) {
            util = FileSystemUtilFactory.createFileSystemUtil();
        }
        this.buildPath = util.substituteYenSignIfNeeded(buildPath);
    }

    @Override
    public String getBuildFile() {
        return this.buildFile;
    }

    @Override
    public void setBuildFile(String buildFile) {
        if (util == null) {
            util = FileSystemUtilFactory.createFileSystemUtil();
        }
        this.buildFile = util.substituteYenSignIfNeeded(buildFile);
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public String getBuildMacro() {
        return this.buildMacro;
    }

    public void setBuildMacro(String buildMacro) {
        this.buildMacro = buildMacro;
    }

    public long getSize() {
        return -1L;
    }

    public long getLastModified() {
        return 0L;
    }

    public String toString() {
        return "Resource name: " + this.getName() + " project: " + this.getProjectName() + " mvsName: " + this.getMvsName() + " buildMacro: " + this.getBuildMacro() + " rebuild: " + this.isRebuild();
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @Override
    public String getLangDefName() {
        return this.langDefName;
    }

    public void setLangDefName(String langDefName) {
        this.langDefName = langDefName;
    }

    @Override
    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public void addText(String text) {
        this.text = text;
    }

    @Override
    public String getNestedText() {
        return this.text == null ? null : this.getProject().replaceProperties(this.text);
    }

    @Override
    public boolean isRebuild() {
        return this.rebuild;
    }

    public void setRebuild(boolean rebuild) {
        this.rebuild = rebuild;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    @Override
    public String getSrcLib() {
        return this.srcLib;
    }

    public void setSrcLib(String srcLib) {
        this.srcLib = srcLib;
    }

    @Override
    public String getObjLib() {
        return this.objLib;
    }

    public void setObjLib(String objLib) {
        this.objLib = objLib;
    }

    public void addInputFile(BuildFileXMLModel inputBuildFile) {
        this.fInputFiles.add(inputBuildFile);
    }

    @Override
    public Set<BuildFileXMLModel> getInputFiles() {
        return this.fInputFiles;
    }

    public void setOutputFiles(Set<BuildFileXMLModel> outputFiles) {
        this.fOutputFiles = outputFiles;
    }

    @Override
    public Set<BuildFileXMLModel> getOutputFiles() {
        return this.fOutputFiles;
    }

    public void setParserOutputFiles(Set<BuildFileXMLModel> parserOutputFiles) {
        this.fParserOutputFiles = parserOutputFiles;
    }

    @Override
    public Set<BuildFileXMLModel> getParserOutputFiles() {
        return this.fParserOutputFiles;
    }

    @Override
    public void setResolvedInputFiles(Set<BuildFileXMLModel> resolvedInputFiles) {
        this.fResolvedInputFiles = resolvedInputFiles;
    }

    @Override
    public Set<BuildFileXMLModel> getResolvedInputFiles() {
        return this.fResolvedInputFiles;
    }

    @Override
    public File getBuildMap(Task task) {
        Project project = task.getProject();
        if (this.fInputFiles.size() == 0) {
            return null;
        }
        try {
            String buildResultUUID;
            IBuildMap buildMap = (IBuildMap)IBuildMap.ITEM_TYPE.createItem();
            String buildDefUUID = project.getProperty("team.enterprise.buildDefinitionUUID");
            if (buildDefUUID != null && !buildDefUUID.isEmpty()) {
                buildMap.setBuildDefinition((IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildDefUUID), null));
            }
            if ((buildResultUUID = project.getProperty("buildResultUUID")) != null && !buildResultUUID.isEmpty()) {
                buildMap.setBuildResult((IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildResultUUID), null));
            }
            buildMap.setBuildLabel(project.getProperty(BUILD_LABEL));
            String prefix = project.getProperty("team.enterprise.scm.resourcePrefix");
            buildMap.setResourcePrefix(prefix);
            buildMap.setFetchDestination(project.getProperty("team.enterprise.scm.fetchDestination"));
            buildMap.setSnapshot(project.getProperty("team.enterprise.scm.snapshotId"));
            String workspaceUUID = project.getProperty("team.enterprise.scm.workspaceUUID");
            if (workspaceUUID != null && !workspaceUUID.isEmpty()) {
                buildMap.setWorkspace((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUUID), null));
            }
            if (this.buildMacro != null && !this.buildMacro.isEmpty()) {
                buildMap.setLanguageDefinitionUUID(UUID.valueOf((String)this.buildMacro));
            }
            if (this.langDefStateId != null && !this.langDefStateId.isEmpty()) {
                buildMap.setLanguageDefinitionStateUUID(UUID.valueOf((String)this.langDefStateId));
            }
            List inputs = buildMap.getInputs();
            String memberName = "XXXX";
            IFileSystemUtil util = FileSystemUtilFactory.createFileSystemUtil();
            util.setPrefix(prefix);
            for (BuildFileXMLModel file : this.fInputFiles) {
                file.setBuildPath(util.substituteSystemSymbols(file.getBuildPath()));
                file.setPromotionBuildPath(util.substituteSystemSymbols(file.getPromotionBuildPath()));
                IInputBuildFile inputFile = BuildFileUtil.getInputFileFromXMLModel(file);
                inputs.add(inputFile);
                String type = inputFile.getType();
                if (!"SELF".equals(type)) continue;
                buildMap.setBuildableFile(inputFile.getFile());
                memberName = file.getBuildFile();
            }
            if (this.fResolvedInputFiles != null) {
                List parserOutputs = buildMap.getParserOutputs();
                for (BuildFileXMLModel file : this.fResolvedInputFiles) {
                    IOutputBuildFile bf = BuildFileUtil.getOutputFileFromXMLModel(file);
                    util.normalize(task, (IBuildFile)bf);
                    String promotionBuildPath = bf.getBuildPath();
                    if (promotionBuildPath.startsWith(String.valueOf(prefix) + DOT)) {
                        promotionBuildPath = "${team.enterprise.scm.resourcePrefix}." + promotionBuildPath.substring(prefix.length() + 1);
                    } else if (promotionBuildPath.startsWith(prefix)) {
                        promotionBuildPath = "${team.enterprise.scm.resourcePrefix}" + promotionBuildPath.substring(prefix.length());
                    }
                    bf.setPromotionBuildPath(promotionBuildPath);
                    parserOutputs.add(bf);
                }
            }
            if (this.fWorkItems != null) {
                List wiList = buildMap.getWorkitems();
                ArrayList<Integer> workItemIds = new ArrayList<Integer>(this.fWorkItems.size());
                for (String workItem : this.fWorkItems) {
                    try {
                        Integer integer = Integer.valueOf(workItem);
                        workItemIds.add(integer);
                    }
                    catch (NumberFormatException e) {
                        project.log("Invalid number found in workItem List", (Throwable)e, 4);
                    }
                }
                if (!workItemIds.isEmpty()) {
                    IWorkItemClient workItemClient = (IWorkItemClient)InitTask.getInstance().getTeamRepository().getClientLibrary(IWorkItemClient.class);
                    wiList.addAll(workItemClient.findWorkItemsById(workItemIds, null));
                }
            }
            buildMap.setTemporary(Boolean.parseBoolean(project.getProperty(IBuildResult.PROPERTY_PERSONAL_BUILD)) || Boolean.parseBoolean(project.getProperty("team.enterprise.build.dependency.rebuild.full")) || Boolean.parseBoolean(project.getProperty("team.enterprise.build.dependency.rebuild.binary")));
            File f = new File(BuildableResource.getTmpDir(project), String.valueOf(this.getUuid()) + BUILDMAP_XML);
            BuildMapSerializer ser = new BuildMapSerializer();
            URI bmURI = URI.createURI((String)f.toURI().toString());
            ser.serialize(bmURI, buildMap);
            return f;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public static String getTmpDir(Project project) {
        String tmpDir = project.getProperty("team.enterprise.scm.fetchDestination");
        if (tmpDir == null) {
            tmpDir = System.getProperty(JAVA_IO_TMPDIR);
        }
        return tmpDir;
    }

    public void resolvePhysicalDependencies(Task task) throws Exception {
        Project project = task.getProject();
        Hashtable buildProperties = project.getProperties();
        if (this.fInputFiles != null) {
            IFileSystemUtil util = FileSystemUtilFactory.createFileSystemUtil();
            String prefix = (String)buildProperties.get("team.enterprise.scm.resourcePrefix");
            util.setPrefix(prefix);
            util.setWorkspaceUuid((String)buildProperties.get("team.enterprise.scm.workspaceUUID"));
            for (BuildFileXMLModel inputFile : this.fInputFiles) {
                if (inputFile.getBuildPathDD() != null) continue;
                util.resolveFile(task, this, inputFile);
            }
        }
    }

    public static Properties loadGeneratedOutputProperties(Project project) throws IOException, FileNotFoundException {
        Properties outputsProperties = new Properties();
        File outputsPropertiesFile = new File(String.valueOf(BuildableResource.getTmpDir(project)) + File.separator + GENERATED_OUTPUTS_LIST);
        if (outputsPropertiesFile.exists()) {
            outputsProperties.load(new FileInputStream(outputsPropertiesFile));
        }
        return outputsProperties;
    }

    public static void storeGeneratedOutputProperties(Project project, Properties p) throws FileNotFoundException, IOException {
        if (p != null) {
            int numberOfSources = Integer.parseInt(p.getProperty(NUMBER_OF_SOURCES, ZERO)) + 1;
            p.put(NUMBER_OF_SOURCES, Integer.toString(numberOfSources));
            File outputsPropertiesFile = new File(String.valueOf(BuildableResource.getTmpDir(project)) + File.separator + GENERATED_OUTPUTS_LIST);
            p.store(new FileOutputStream(outputsPropertiesFile), ZERO_LENGTH_STRING);
        }
    }

    public static int getNumberOfSourcesProcessed(Project project) {
        int n = 0;
        try {
            Properties p = BuildableResource.loadGeneratedOutputProperties(project);
            n = p == null ? 0 : Integer.parseInt(p.getProperty(NUMBER_OF_SOURCES, ZERO));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    public boolean needsRebuild(Task task) {
        String binaryRebuild;
        boolean rebuildFlag = this.isRebuild();
        if (rebuildFlag) {
            task.log("Rebuild flag is set for " + this.getName(), 4);
            return rebuildFlag;
        }
        String nestedText = this.getNestedText();
        if (nestedText != null) {
            task.log("An inline source is always going to be built: " + nestedText, 4);
            return true;
        }
        Project project = task.getProject();
        String trustOutputs = project.getProperty("team.enterprise.build.dependency.trustOutputs");
        if (Boolean.parseBoolean(trustOutputs) && !Boolean.parseBoolean(binaryRebuild = project.getProperty("team.enterprise.build.dependency.rebuild.binary"))) {
            return rebuildFlag;
        }
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)project);
        Hashtable buildProperties = project.getProperties();
        if (!rebuildFlag) {
            long timestamp;
            String resourcePrefix = (String)buildProperties.get("team.enterprise.scm.resourcePrefix");
            String resourceTeamPrefix = (String)buildProperties.get("team.enterprise.scm.resourceTeamPrefix");
            IFileSystemUtil util = FileSystemUtilFactory.createFileSystemUtil();
            util.setPrefix(resourcePrefix);
            util.setWorkspaceUuid((String)buildProperties.get("team.enterprise.scm.workspaceUUID"));
            boolean isPersonalBuild = Boolean.parseBoolean(task.getProject().getProperty(IBuildResult.PROPERTY_PERSONAL_BUILD));
            if (this.fOutputFiles != null) {
                for (BuildFileXMLModel outputFile : this.fOutputFiles) {
                    timestamp = outputFile.getTimestamp();
                    String buildPath = outputFile.getBuildPath();
                    if (buildPath == null) continue;
                    if (isPersonalBuild && buildPath.startsWith(resourcePrefix)) {
                        buildPath = String.valueOf(resourceTeamPrefix) + buildPath.substring(resourcePrefix.length());
                    }
                    String expandedBuildPath = this.replaceProperties(buildPath, propertyHelper, buildProperties);
                    IOutputBuildFile f = BuildFileUtil.getOutputFileFromXMLModel(outputFile);
                    String originalBuildPath = outputFile.getBuildPath();
                    expandedBuildPath = util.substituteSystemSymbols(expandedBuildPath);
                    f.setBuildPath(expandedBuildPath);
                    boolean bl = rebuildFlag = !util.exists(task, (IBuildFile)f);
                    if (rebuildFlag) {
                        task.log(String.valueOf(expandedBuildPath) + (f.isHFS() ? ZERO_LENGTH_STRING : LEFT_PARENTHESIS + f.getBuildFile() + RIGHT_PARENTHESIS) + " does not exist. It needs to be rebuilt.", 4);
                        break;
                    }
                    f.setBuildPath(originalBuildPath);
                    long fileSystemTimestamp = util.lastModified(task, (IBuildFile)f);
                    if (timestamp != 0L) {
                        task.log("Output=" + expandedBuildPath + (f.isHFS() ? ZERO_LENGTH_STRING : LEFT_PARENTHESIS + f.getBuildFile() + RIGHT_PARENTHESIS) + " timestamp (build map)=" + timestamp + " timestamp (file system)=" + fileSystemTimestamp, 4);
                    } else {
                        task.log("Output=" + expandedBuildPath + (f.isHFS() ? ZERO_LENGTH_STRING : LEFT_PARENTHESIS + f.getBuildFile() + RIGHT_PARENTHESIS) + " timestamp (file system)=" + fileSystemTimestamp, 4);
                    }
                    if (0L >= fileSystemTimestamp || 0L >= timestamp) continue;
                    boolean bl2 = rebuildFlag = timestamp != fileSystemTimestamp;
                    if (!rebuildFlag) continue;
                    task.log("A timestamp of an input does not match to the one stored in the dependency set. " + this.getName() + " needs to be rebuilt.", 4);
                    break;
                }
            }
            if (!rebuildFlag && this.fParserOutputFiles != null) {
                for (BuildFileXMLModel file : this.fParserOutputFiles) {
                    timestamp = file.getTimestamp();
                    long fileSystemTimestamp = util.lastModified(task, (IBuildFile)BuildFileUtil.getOutputFileFromXMLModel(file));
                    if (fileSystemTimestamp <= 0L || timestamp <= 0L || timestamp == fileSystemTimestamp) continue;
                    rebuildFlag = true;
                    task.log(String.format("Timestamp of a generated input (%s/%s) has changed + (%d -> %d).", file.getBuildPath(), file.getBuildFile(), timestamp, fileSystemTimestamp), 4);
                    break;
                }
            }
        }
        return rebuildFlag;
    }

    private String replaceProperties(String s, PropertyHelper propertyHelper, Hashtable<String, Object> buildProperties) {
        return propertyHelper.replaceProperties(null, s, buildProperties);
    }

    public void setWorkItems(Set<String> workItemsSet) {
        this.fWorkItems = workItemsSet;
    }

    public void setVariables(Map<String, String> variables) {
        this.fVariables = variables;
    }

    @Override
    public Map<String, String> getVariables() {
        return this.fVariables;
    }

    @Override
    public String getVersionId() {
        return this.versionId;
    }

    @Override
    public void setVersionId(String id) {
        this.versionId = id;
    }

    @Override
    public boolean isHFS() {
        return this.hfs;
    }

    @Override
    public void setHFS(boolean hfs) {
        this.hfs = hfs;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public void setReason(String reason) {
        this.reason = reason;
    }

    public static void staticMemoryReset() {
        util = null;
    }
}

