/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.tasks;

import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.ant.tasks.AbstractEETask;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.util.Arrays;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class StartBuildActivityTask
extends AbstractEETask {
    private String fRepositoryAddress = null;
    private String fUserId = null;
    private File fPasswordFile = null;
    private boolean fVerbose = false;
    private String fBuildResultUUID = null;
    private String fComponentName = null;
    private String fActivityIdProperty = null;
    private String fLabel = null;
    private String fParentActivityId = null;
    private boolean fAutoComplete = false;
    private String fCertificateFile;
    private boolean fSmartCard;
    private boolean fKerberos;

    protected String getCertificateFile() {
        return this.fCertificateFile;
    }

    protected void setCertificateFile(String certificateFile) {
        this.fCertificateFile = certificateFile;
    }

    protected boolean isSmartCard() {
        return this.fSmartCard;
    }

    protected void setSmartCard(boolean smartCard) {
        this.fSmartCard = smartCard;
    }

    public boolean isKerberos() {
        return this.fKerberos;
    }

    public void setKerberos(boolean fKerberos) {
        this.fKerberos = fKerberos;
    }

    public String getRepositoryAddress() {
        return this.fRepositoryAddress;
    }

    public void setRepositoryAddress(String repositoryAddress) {
        this.fRepositoryAddress = repositoryAddress;
    }

    public String getUserId() {
        return this.fUserId;
    }

    public void setUserId(String userId) {
        this.fUserId = userId;
    }

    public File getPasswordFile() {
        return this.fPasswordFile;
    }

    public void setPasswordFile(File passwordFile) {
        this.fPasswordFile = passwordFile;
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean verbose) {
        this.fVerbose = verbose;
    }

    public String getBuildResultUUID() {
        return this.fBuildResultUUID;
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.fBuildResultUUID = buildResultUUID;
    }

    public String getComponentName() {
        return this.fComponentName;
    }

    public void setComponentName(String componentName) {
        this.fComponentName = componentName;
    }

    public String getActivityIdProperty() {
        return this.fActivityIdProperty;
    }

    public void setActivityIdProperty(String activityIdProperty) {
        this.fActivityIdProperty = activityIdProperty;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public void setLabel(String label) {
        this.fLabel = label;
    }

    public String getParentActivityId() {
        return this.fParentActivityId;
    }

    public void setParentActivityId(String parentActivityId) {
        this.fParentActivityId = parentActivityId;
    }

    public boolean isAutoComplete() {
        return this.fAutoComplete;
    }

    public void setAutoComplete(boolean autoComplete) {
        this.fAutoComplete = autoComplete;
    }

    public void doExecute() {
        String activityId = null;
        try {
            activityId = InitTask.getInstance().getTeamBuildClient().startBuildActivity(this.getBuildResultHandle(), this.getLabel(), this.getParentActivityId(), this.isAutoComplete(), this.getProgressMonitor());
        }
        catch (IllegalArgumentException e) {
            throw new BuildException((Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw new BuildException((Throwable)e);
        }
        if (this.isVerbose()) {
            this.logMsg(NLS.bind((String)Messages.StartBuildActivityTask_START_BUILD_ACTIVITY, (Object)this.getLabel(), (Object)this.getBuildIdentifier()));
        }
        if (this.fActivityIdProperty != null) {
            this.getProject().setProperty(this.fActivityIdProperty, activityId);
        }
    }

    private IBuildResultHandle getBuildResultHandle() throws TeamRepositoryException {
        return (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.getBuildResultUUID()), null);
    }

    private String getBuildIdentifier() {
        IBuildResult buildResult = this.getBuildResult(new String[]{IBuildResult.PROPERTY_LABEL});
        String identifier = buildResult.getLabel();
        if (identifier == null || identifier.trim().length() == 0) {
            identifier = buildResult.getItemId().getUuidValue();
        }
        return identifier;
    }

    private IBuildResult getBuildResult(String[] properties) throws BuildException {
        try {
            IBuildResultHandle resultHandle = this.getBuildResultHandle();
            IItemManager itemManager = InitTask.getInstance().getTeamRepository().itemManager();
            if (properties == IBuildResult.PROPERTIES_COMPLETE) {
                return (IBuildResult)itemManager.fetchCompleteItem((IItemHandle)resultHandle, 1, this.getProgressMonitor());
            }
            return (IBuildResult)itemManager.fetchPartialItem((IItemHandle)resultHandle, 1, Arrays.asList(properties), this.getProgressMonitor());
        }
        catch (ItemNotFoundException e) {
            throw new BuildException(NLS.bind((String)Messages._ITEM_WITH_ID_NOT_FOUND, (Object)IBuildResult.ITEM_TYPE.getName(), (Object)this.getBuildResultUUID()), (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }
}

