/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.tasks;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.publishing.ContentPublisher;
import com.ibm.team.enterprise.build.ant.IFileSystemUtil;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.ant.internal.utils.FileSystemUtilFactory;
import com.ibm.team.enterprise.build.ant.internal.utils.SimulationUtil;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.enterprise.build.common.simulationregistry.ISimulationRegistry;
import com.ibm.team.enterprise.build.common.simulationregistry.ISimulationRegistryFile;
import com.ibm.team.enterprise.build.common.simulationregistry.util.SimulationRegistryUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class SimulationRegistryTask
extends Task {
    public static final String SIMULATION_REGISTRY_XML = "simulationRegistry.xml";
    private static final String UTF_8 = "UTF-8";
    private static final String TEXT_XML = "text/xml";
    private String buildResultUUID;

    public void execute() throws BuildException {
        ISimulationRegistry registry = SimulationUtil.getRegistry();
        if (registry == null) {
            return;
        }
        File outfile = this.getOutputFile();
        if (outfile.exists()) {
            outfile.delete();
        }
        if (SimulationUtil.isSimulationBuildOutputCheck(this)) {
            this.bulkUpdateBinaryFileExists(registry);
        }
        try {
            SimulationRegistryUtil.serializeRegistry((ISimulationRegistry)registry, (File)outfile);
            this.publishFile(outfile, Messages.SIMULATION_REGISTRY_LABEL);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected File getOutputFile() {
        return new File(new File(this.getProject().getProperty("team.enterprise.scm.fetchDestination")), SIMULATION_REGISTRY_XML);
    }

    protected void publishFile(File file, String label) throws TeamRepositoryException {
        ITeamRepository teamRepository = InitTask.getInstance().getTeamRepository();
        IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.getBuildResultUUID()), null);
        String contributionStatus = BuildStatus.OK.name();
        ContentPublisher filePublisher = new ContentPublisher(IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID, file.getAbsolutePath(), label, TEXT_XML, UTF_8);
        IBuildResultContribution contribution = filePublisher.publish(buildResultHandle, BuildStatus.valueOf((String)contributionStatus), teamRepository);
        if (contribution == null) {
            throw new BuildException(NLS.bind((String)Messages.PUBLISH_FAILED, (Object)filePublisher.getClass().getSimpleName()));
        }
        ITeamBuildClient client = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
        IBuildResultContribution[] contribs = client.getBuildResultContributions(buildResultHandle, IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID, null);
        if (contribs != null && contribs.length > 0) {
            IBuildResultContribution[] iBuildResultContributionArray = contribs;
            int n = contribs.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName;
                IBuildResultContribution contrib = iBuildResultContributionArray[n2];
                if (!contrib.equals(contribution) && SIMULATION_REGISTRY_XML.equals(fileName = contrib.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME))) {
                    client.deleteBuildResultContributions(buildResultHandle, new IBuildResultContribution[]{contrib}, null);
                    break;
                }
                ++n2;
            }
        }
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.buildResultUUID = buildResultUUID;
    }

    public String getBuildResultUUID() {
        return this.buildResultUUID;
    }

    public void bulkUpdateBinaryFileExists(ISimulationRegistry registry) {
        try {
            if (registry.size() > 0) {
                IFileSystemUtil fileSystemUtil = FileSystemUtilFactory.createFileSystemUtil();
                Iterator it = registry.iterator();
                while (it.hasNext()) {
                    try {
                        ISimulationRegistryFile registryFile = (ISimulationRegistryFile)it.next();
                        registryFile.setBinaryExists(fileSystemUtil.fileExists(this, registryFile));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

