/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.tasks;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.extensions.client.BuildCache;
import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.client.util.BuildResult;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.build.extensions.common.nls.Common;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.build.extensions.toolkit.ant.AbstractExtensionsTeamTask;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildReportExtendedContributionCallable;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildReportUtils;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMapHandle;
import com.ibm.team.enterprise.build.client.buildmap.IBuildMapClient;
import com.ibm.team.enterprise.build.extensions.client.BuildCacheFactoryEE;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;

public class PublishBuildMapTask
extends AbstractExtensionsTeamTask {
    private String buildResultUUID;
    private String errors;
    private boolean publish;
    private static ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 5, 90L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public static ThreadPoolExecutor getExecutor() {
        return executor;
    }

    protected void doProcess() throws TeamRepositoryException {
        IBuildResultHandle buildResultHandle;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, mnm});
        }
        if (!Verification.isNonBlank((String)this.buildResultUUID)) {
            throw new TeamRepositoryException(Common.COMMON_REQUIRED_BUILDRESULTUUID);
        }
        ITeamRepository repository = this.getTeamRepository();
        IBuildCacheItem cacheItem = BuildCacheFactoryEE.getBuildMap((Object)repository, (IBuildResultHandle)(buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.buildResultUUID), null)));
        if (cacheItem != null && cacheItem.getItemList().size() > 0 && this.publish) {
            this.processBuildMaps(repository, buildResultHandle, cacheItem.getItemList(), this.errors);
        }
        if (!this.publish || Verification.isNonBlank((String)this.errors)) {
            IBuildResult buildResult = BuildResult.getBuildResult((ITeamRepository)repository, (IBuildResultHandle)buildResultHandle, (IProgressMonitor)this.monitor, (IDebugger)this.dbg);
            IBuildResult workingCopy = (IBuildResult)buildResult.getWorkingCopy();
            workingCopy.setStatus(BuildStatus.ERROR);
            ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
            buildClient.save(workingCopy, (IProgressMonitor)this.monitor);
        }
        BuildCacheFactoryEE.clearBuildMap((Object)repository, (IBuildResultHandle)buildResultHandle);
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, mnm});
        }
    }

    private final void processBuildMaps(ITeamRepository repository, IBuildResultHandle buildResultHandle, List<IBuildMap> buildMaps, String errors) throws TeamRepositoryException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, mnm});
        }
        IBuildMapClient buildMapClient = (IBuildMapClient)repository.getClientLibrary(IBuildMapClient.class);
        ArrayList<String> errorFiles = new ArrayList<String>(Arrays.asList(errors.split(";")));
        for (IBuildMap buildMap : buildMaps) {
            if (errorFiles.contains(buildMap.getBuildableFile().getItemId().getUuidValue())) continue;
            IBuildMapHandle bmh = buildMapClient.saveBuildMap(buildMap, (IProgressMonitor)this.monitor);
            String publicUriRoot = BuildReportUtils.getPublicUriRoot(this.getProject());
            String buildMapURL = BuildReportUtils.getBuildMapUrl(this.getProject(), bmh);
            String buildMapURI = BuildReportUtils.getBuildMapUri(this.getProject(), bmh, publicUriRoot);
            String langDef = (String)BuildCache.getInstance().get(buildMap.getLanguageDefinitionUUID().getUuidValue());
            String buildFile = (String)BuildCache.getInstance().get(buildMap.getBuildableFile().getItemId().getUuidValue());
            String label = BuildReportUtils.getBuildMapLabel(langDef, buildFile);
            this.log("buildMapURL = " + buildMapURL, 4);
            BuildReportUtils.publishBuildMapLinks(this.getProject(), buildMapURI, label);
            BuildReportUtils.gatherInformationForBuildReport(this.getProject(), buildMap, buildMapURL);
            BuildReportExtendedContributionCallable.incrementProcessedCount(null);
            try {
                BuildReportExtendedContributionCallable.run(PublishBuildMapTask.getExecutor(), false);
            }
            catch (ExecutionException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, mnm, LogString.valueOf(buildMaps)});
        }
    }

    public final String getBuildResultUUID() {
        return this.buildResultUUID;
    }

    public final void setBuildResultUUID(String buildResultUUID) {
        this.buildResultUUID = buildResultUUID;
        if (this.dbg.isFlow()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new Mnm(){}.get(), LogString.valueOf((String)buildResultUUID)});
        }
    }

    public final String getErrors() {
        return this.errors;
    }

    public final void setErrors(String errors) {
        this.errors = errors;
        if (this.dbg.isFlow()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new Mnm(){}.get(), LogString.valueOf((String)errors)});
        }
    }

    public final boolean isPublish() {
        return this.publish;
    }

    public final void setPublish(boolean publish) {
        this.publish = publish;
        if (this.dbg.isFlow()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new Mnm(){}.get(), LogString.valueOf((boolean)publish)});
        }
    }
}

