/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.tasks;

import com.ibm.team.build.internal.scm.ComponentLoadRules;
import com.ibm.team.build.internal.scm.LoadComponents;
import com.ibm.team.enterprise.build.ant.IBuildableResource;
import com.ibm.team.enterprise.build.ant.IFileSystemUtil;
import com.ibm.team.enterprise.build.ant.SourceControlUtility;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.ant.internal.utils.FileSystemUtilFactory;
import com.ibm.team.enterprise.build.ant.internal.utils.OperationListParser;
import com.ibm.team.enterprise.build.ant.internal.utils.SimulationUtil;
import com.ibm.team.enterprise.build.ant.tasks.AbstractEETask;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class LoadFiles
extends AbstractEETask {
    private String repositoryAddress;
    private String userId;
    private String passwordFile;
    private String workspaceUUID;
    private String loadDir;
    private String prefix;
    private boolean smartCard;
    private boolean kerberos;
    private String certificateFile;
    private boolean deleteMetadata;
    private File operationList;

    protected boolean isSmartCard() {
        return this.smartCard;
    }

    protected void setSmartCard(boolean smartCard) {
        this.smartCard = smartCard;
    }

    public boolean isKerberos() {
        return this.kerberos;
    }

    public void setKerberos(boolean kerberos) {
        this.kerberos = kerberos;
    }

    public String getCertificateFile() {
        return this.certificateFile;
    }

    public void setCertificateFile(String certificateFile) {
        this.certificateFile = certificateFile;
    }

    public String getRepositoryAddress() {
        return this.repositoryAddress;
    }

    public void setRepositoryAddress(String repositoryAddress) {
        this.repositoryAddress = repositoryAddress;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public String getWorkspaceUUID() {
        return this.workspaceUUID;
    }

    public void setWorkspaceUUID(String workspaceUUID) {
        this.workspaceUUID = workspaceUUID;
    }

    public String getLoadDir() {
        return this.loadDir;
    }

    public void setLoadDir(String targetDirectory) {
        this.loadDir = targetDirectory;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isDeleteMetadata() {
        return this.deleteMetadata;
    }

    public void setDeleteMetadata(boolean deleteMetadata) {
        this.deleteMetadata = deleteMetadata;
    }

    public File getOperationList() {
        return this.operationList;
    }

    public void setOperationList(File operationList) {
        this.operationList = operationList;
    }

    public void doExecute() throws BuildException {
        if (SimulationUtil.isSimulationMode()) {
            String faOpsList = this.operationList == null ? " file agent operations " : this.operationList.getName();
            this.logMsg("Simulation build enabled;  skipping " + faOpsList, 4);
            return;
        }
        OperationListParser parser = new OperationListParser(this.getOperationList());
        try {
            parser.parse();
        }
        catch (Exception e1) {
            throw new BuildException((Throwable)e1);
        }
        if (!this.isDeleteMetadata() && !parser.hasAnythingToLoad()) {
            return;
        }
        ICorruptCopyFileAreaListener corruptSandboxListener = null;
        try {
            try {
                final Path fetchDestinationPath = new Path(new File(this.loadDir).getCanonicalPath());
                corruptSandboxListener = new ICorruptCopyFileAreaListener(){

                    public void corrupt(ICorruptCopyFileAreaEvent event) {
                        if (event.isCorrupt() && fetchDestinationPath.equals((Object)event.getRoot())) {
                            LoadFiles.this.logMsg(NLS.bind((String)Messages.CORRUPT_SANDBOX_DURING_LOAD, (Object)fetchDestinationPath.toOSString()));
                            throw new RuntimeException(NLS.bind((String)Messages.CORRUPT_SANDBOX_DURING_LOAD_2, (Object)fetchDestinationPath.toOSString()));
                        }
                    }
                };
                FileSystemCore.startUp();
                IFileSystemUtil util = FileSystemUtilFactory.createFileSystemUtil();
                util.setPrefix(this.getPrefix());
                util.setWorkspaceUuid(this.getWorkspaceUUID());
                util.setTeamPrefix(this.getProject().getProperty("team.enterprise.scm.resourceTeamPrefix"));
                util.setTeamWorkspaceUuid(this.getProject().getProperty("team.enterprise.scm.teamWorkspaceUUID"));
                util.setDestinationPath(this.getProject().getProperty("team.enterprise.scm.fetchDestination"));
                this.initializeSystemPropeties();
                this.logMsg("Add Corrupt Sandbox Listener.", 4);
                SharingManager sharingManager = (SharingManager)FileSystemCore.getSharingManager();
                sharingManager.addListener(corruptSandboxListener);
                if (this.isDeleteMetadata()) {
                    ISandbox sandbox = sharingManager.getSandbox(util.createLocation(this.prefix), false);
                    sharingManager.eraseSandboxMetadata(sandbox, (IProgressMonitor)new NullProgressMonitor());
                    this.logMsg("MVS sandbox metadata for prefix " + this.prefix + " were erased.", 4);
                }
                if (parser.getWorkspaceID() != null) {
                    this.loadWorkspace(parser, util);
                }
                if (!parser.getFilesToLoad().isEmpty()) {
                    this.loadFiles(parser, util);
                }
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (corruptSandboxListener != null) {
                    this.logMsg("Remove Corrupt Sandbox Listener.", 4);
                    ((SharingManager)FileSystemCore.getSharingManager()).removeListener(corruptSandboxListener);
                }
                this.logMsg("Call FileSystemCore.shutDown()", 4);
                FileSystemCore.shutDown();
            }
            catch (FileSystemException e) {
                throw new BuildException((Throwable)e);
            }
            throw throwable;
        }
        try {
            if (corruptSandboxListener != null) {
                this.logMsg("Remove Corrupt Sandbox Listener.", 4);
                ((SharingManager)FileSystemCore.getSharingManager()).removeListener(corruptSandboxListener);
            }
            this.logMsg("Call FileSystemCore.shutDown()", 4);
            FileSystemCore.shutDown();
        }
        catch (FileSystemException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void loadFiles(OperationListParser parser, IFileSystemUtil util) {
        List<IBuildableResource> filesToLoad = parser.getFilesToLoad();
        util.loadFiles((Task)this, filesToLoad);
    }

    private void loadWorkspace(OperationListParser parser, IFileSystemUtil util) throws TeamRepositoryException {
        long start;
        ITeamRepository teamRepository = InitTask.getInstance().getTeamRepository();
        IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository).getWorkspaceConnection((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.getWorkspaceUUID()), null), null);
        boolean includedComponents = Boolean.parseBoolean(this.getProject().getProperty("team.enterprise.scm.includeComponents"));
        String componentUuids = this.getProject().getProperty("team.enterprise.scm.loadComponents");
        Collection components = new LoadComponents(teamRepository, componentUuids).getComponentHandles();
        NullProgressMonitor monitor = new NullProgressMonitor();
        boolean synchronizeLoad = false;
        String componentLoadRuleUuids = this.getProject().getProperty("team.enterprise.scm.componentLoadRules");
        Collection loadRules = new ComponentLoadRules(componentLoadRuleUuids).getLoadRules(workspaceConnection, (IProgressMonitor)monitor);
        boolean createFoldersForComponents = Boolean.parseBoolean(this.getProject().getProperty("team.enterprise.scm.createFoldersForComponents"));
        String alwaysLoadComponentProperty = this.getProject().getProperty("team.enterprise.scm.alwaysLoadComponents");
        Collection alwaysLoadComponents = new LoadComponents(teamRepository, alwaysLoadComponentProperty).getComponentHandles();
        if (parser.isLoadHFS()) {
            start = System.currentTimeMillis();
            this.logMsg("load HFS contents...", 4);
            SourceControlUtility.updateFileCopyArea(workspaceConnection, util, true, includedComponents, components, false, loadRules, createFoldersForComponents, (IProgressMonitor)monitor);
            this.logMsg("done... Elapsed time: " + (System.currentTimeMillis() - start) + " msecs.", 4);
        }
        if (parser.isLoadLibaray()) {
            start = System.currentTimeMillis();
            this.logMsg("load non-HFS contents...", 4);
            SourceControlUtility.updateFileCopyArea(workspaceConnection, util, false, alwaysLoadComponents.size() > 0, alwaysLoadComponents, false, loadRules, createFoldersForComponents, (IProgressMonitor)monitor);
            this.logMsg("done... Elapsed time: " + (System.currentTimeMillis() - start) + " msecs.", 4);
        }
    }
}

