/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.tasks;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.IStaticReset;
import com.ibm.team.enterprise.build.ant.IFileSystemUtil;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.ant.internal.utils.AuthenticationUtilities;
import com.ibm.team.enterprise.build.ant.internal.utils.FileSystemUtilFactory;
import com.ibm.team.enterprise.build.ant.internal.utils.SimulationUtil;
import com.ibm.team.enterprise.build.ant.tasks.AbstractEETask;
import com.ibm.team.enterprise.build.ant.tasks.MyFrameworkLog;
import com.ibm.team.enterprise.build.common.IBuildConstants;
import com.ibm.team.enterprise.build.common.simulationregistry.util.SimulationRegistryUtil;
import com.ibm.team.filesystem.common.internal.FilesystemPackage;
import com.ibm.team.repository.client.ILoginHandler2;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.login.IAliasChooser;
import com.ibm.team.repository.client.login.KerberosLoginInfo;
import com.ibm.team.repository.client.login.SSLCertificateLoginInfo;
import com.ibm.team.repository.client.login.SmartCardLoginInfo;
import com.ibm.team.repository.client.login.UsernameAndPasswordLoginInfo;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.scm.common.internal.ScmPackage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.AntVersion;
import org.eclipse.osgi.util.NLS;

public class InitTask
extends AbstractEETask
implements IStaticReset {
    private static final String KERBEROS_REALM_PROP = "java.security.krb5.realm";
    private static final String KERBEROS_KDC_PROP = "java.security.krb5.kdc";
    private static final String KERBEROS_CONFIG_PROP = "java.security.krb5.conf";
    private static final String[] ENTERPRISE_BUILD_TOOLKIT_JARS = new String[]{"com.ibm.team.enterprise.build.ant_*.jar", "com.ibm.team.enterprise.zos.build.ant_*.jar", "com.ibm.teamp.ant_*.jar"};
    private static final int SIXTEEN = 16;
    private static final String COMMA_AND_SPACE = ", ";
    private static final String BLD_TOOLKIT = "BLD_TOOLKIT";
    private static final int[] BUILD_CAPABILITIES_AVAILABLE;
    private static final String ENV_REPOSITORY_ADDRESS = "env.repositoryAddress";
    private static InitTask singleton;
    private ITeamRepository fTeamRepository = null;
    private ITeamBuildClient fTeamBuildClient = null;
    private boolean performanceAnalysisEnabled;

    static {
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 7;
        nArray[7] = 6;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 13;
        nArray[12] = 14;
        BUILD_CAPABILITIES_AVAILABLE = nArray;
        singleton = null;
        try {
            Field frameworkLogField = NLS.class.getDeclaredField("frameworkLog");
            frameworkLogField.setAccessible(true);
            frameworkLogField.set(null, new MyFrameworkLog());
        }
        catch (Exception exception) {
            // empty catch block
        }
        RepositoryPackage.eINSTANCE.eContents();
        ScmPackage.eINSTANCE.eContents();
        FilesystemPackage.eINSTANCE.eContents();
        BuildItemFactory.initializeBuildPackage();
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
    }

    private static String getBuildCapabilitiesAvailable(Project project) {
        BigInteger buildCapabilitiesAvailable = BigInteger.ZERO;
        int[] nArray = BUILD_CAPABILITIES_AVAILABLE;
        int n = BUILD_CAPABILITIES_AVAILABLE.length;
        int n2 = 0;
        while (n2 < n) {
            int capability = nArray[n2];
            buildCapabilitiesAvailable = buildCapabilitiesAvailable.setBit(capability);
            ++n2;
        }
        AntVersion av = new AntVersion();
        av.setAtLeast("1.8.0");
        if (av.eval()) {
            buildCapabilitiesAvailable = buildCapabilitiesAvailable.setBit(11);
            buildCapabilitiesAvailable = buildCapabilitiesAvailable.setBit(12);
        } else {
            project.log(Messages.TOOLKIT_CAPABILITIES_ANT180_WARNING, 1);
        }
        return buildCapabilitiesAvailable.toString(16);
    }

    private static boolean isAllRequiredCapabilitiesAvailable(String required, String available) {
        BigInteger capabilitiesRequired = new BigInteger(required, 16);
        BigInteger capabilitiesAvailable = new BigInteger(available, 16);
        return capabilitiesRequired.and(capabilitiesAvailable).equals(capabilitiesRequired);
    }

    public boolean isPerformanceAnalysisEnabled() {
        return this.performanceAnalysisEnabled;
    }

    public InitTask() {
        if (singleton == null) {
            singleton = this;
        }
    }

    public static InitTask getInstance() {
        return singleton;
    }

    public static void staticMemoryReset() {
        singleton = null;
    }

    @Override
    public void init() throws BuildException {
        super.init();
        this.performanceAnalysisEnabled = Boolean.valueOf(System.getProperty("team.enterprise.build.toolkit.enableAntTaskStats"));
    }

    public void doExecute() {
        String trustOutputs;
        Object file;
        this.getProject().setProperty("team.enterprise.build.start.time", String.valueOf(System.currentTimeMillis()));
        String dir = this.getProject().getProperty("team.enterprise.scm.fetchDestination");
        if (dir != null) {
            String[] files;
            File directory = new File(dir);
            String[] stringArray = files = directory.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                file = stringArray[n2];
                if (((String)file).startsWith("buildmap") && ((String)file).endsWith(".xml") || ".buildmapExists".equals(file) || "generatedOutputs.properties".equals(file) || ".compileErrorOccurred".equals(file)) {
                    File f = new File(directory, (String)file);
                    f.delete();
                }
                ++n2;
            }
        }
        this.logEnterpriseBuildToolkitJarFileNames();
        this.checkCapabilities();
        if (SimulationUtil.isSimulationMode()) {
            trustOutputs = this.getProject().getProperty("team.enterprise.build.dependency.trustOutputs");
            if (!Boolean.parseBoolean(trustOutputs)) {
                throw new BuildException(Messages.SIMULATION_BUILD_REQUIRES_TRUST_OUTPUTS);
            }
            IFileSystemUtil fileSystemUtil = FileSystemUtilFactory.createFileSystemUtil();
            if (SimulationUtil.isSimulationBuildOutputCheck((Task)this) && !fileSystemUtil.isNativePlatform()) {
                throw new BuildException(Messages.SIMULATION_CHECK_OUTPUTS_REQUIRES_TARGET_HOST);
            }
            if (!fileSystemUtil.isNativePlatform()) {
                this.logMsg(Messages.SIMULATION_WARN_NON_NATIVE_PLATFORM, 3);
            }
            if (((File)(file = new File(dir, "simulationRegistry.xml"))).exists()) {
                try {
                    SimulationUtil.setRegistry(SimulationRegistryUtil.createRegistryFromFile((File)file));
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            } else {
                throw new BuildException(Messages.SIMULATION_REGISTRY_NOT_FOUND);
            }
        }
        if (Boolean.parseBoolean(this.getProject().getProperty("team.enterprise.conditional.sysdefs.used")) && !Boolean.parseBoolean(trustOutputs = this.getProject().getProperty("team.enterprise.build.dependency.trustOutputs"))) {
            throw new BuildException(Messages.CONDITIONAL_REQUIRES_TRUST_OUTPUTS);
        }
        String poolSize = this.getProject().getProperty("team.enterprise.build.BuildResultPoolSize");
        try {
            int pool = Integer.parseInt(poolSize);
            if (pool >= 1) {
                InitTask.getExecutor().setCorePoolSize(pool);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void checkCapabilities() throws BuildException {
        String buildCapabilitiesRequired = this.getProject().getProperty("team.enterprise.build.toolkit.capabilitiesRequired");
        if (buildCapabilitiesRequired != null) {
            String buildCapabilitiesAvailable = InitTask.getBuildCapabilitiesAvailable(this.getProject());
            this.getProject().setProperty("team.enterprise.build.toolkit.capabilitiesAvailable", buildCapabilitiesAvailable);
            this.logMsg(NLS.bind((String)Messages.AVAILABLE_BUILD_CAPABILITIES, (Object)buildCapabilitiesAvailable), 3);
            if (!InitTask.isAllRequiredCapabilitiesAvailable(buildCapabilitiesRequired, buildCapabilitiesAvailable)) {
                throw new BuildException(NLS.bind((String)Messages.BUILD_NOT_COMPATIBLE, (Object)this.getMissingRequiredCapabilities(buildCapabilitiesRequired, buildCapabilitiesAvailable)));
            }
        }
    }

    private String getMissingRequiredCapabilities(String required, String available) {
        BigInteger capabilitiesRequired = new BigInteger(required, 16);
        BigInteger capabilitiesAvailable = new BigInteger(available, 16);
        BigInteger missing = capabilitiesRequired.xor(capabilitiesAvailable).and(capabilitiesAvailable.not());
        String capabilityNames = "";
        for (Integer bit : IBuildConstants.capabilityMessageMap.keySet()) {
            if (!missing.testBit(bit)) continue;
            capabilityNames = this.addStringDelimitedWithCommas(capabilityNames, (String)IBuildConstants.capabilityMessageMap.get(bit));
        }
        return capabilityNames;
    }

    private String addStringDelimitedWithCommas(String orig, String addon) {
        if (orig == null || orig.equals("")) {
            return addon;
        }
        return String.valueOf(orig) + COMMA_AND_SPACE + addon;
    }

    public ITeamRepository getTeamRepository() {
        if (this.fTeamRepository == null) {
            Project p = this.getProject();
            String userId = System.getenv("JAZZ_USER");
            String repositoryAddress = p.getProperty("repositoryAddress");
            if (repositoryAddress == null) {
                repositoryAddress = p.getProperty(ENV_REPOSITORY_ADDRESS);
            }
            try {
                this.fTeamRepository = AuthenticationUtilities.getLoggedInTeamRepository(p, repositoryAddress, userId, new File(System.getenv("JAZZ_PASSWORD_FILE")));
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        return this.fTeamRepository;
    }

    protected ITeamBuildClient getTeamBuildClient() throws TeamRepositoryException {
        if (this.fTeamBuildClient == null) {
            this.fTeamBuildClient = ClientFactory.getTeamBuildClient((ITeamRepository)this.getTeamRepository());
        }
        return this.fTeamBuildClient;
    }

    private void logEnterpriseBuildToolkitJarFileNames() {
        String basedir = System.getenv(BLD_TOOLKIT);
        if (basedir != null) {
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(basedir);
            ds.setIncludes(ENTERPRISE_BUILD_TOOLKIT_JARS);
            ds.scan();
            String[] files = ds.getIncludedFiles();
            String s = "";
            if (files != null) {
                String[] stringArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (s.length() > 0) {
                        s = String.valueOf(s) + COMMA_AND_SPACE;
                    }
                    s = String.valueOf(s) + string;
                    ++n2;
                }
            }
            this.logMsg(NLS.bind((String)Messages.BUILD_TOOLKIT_VERSIONS, (Object)s), 3);
        }
        try {
            Properties props = new Properties();
            FileInputStream in = new FileInputStream(String.valueOf(basedir) + "/../../properties/version/RTC-Buildsystem-build.properties");
            props.load(in);
            in.close();
            for (String string : props.keySet()) {
                String value = props.getProperty(string);
                this.logMsg(String.valueOf(string) + "=" + value, 3);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static abstract class AbstractLoginHandler {
        private final ILoginInfo2 loginInfo;

        protected AbstractLoginHandler(ILoginInfo2 loginInfo) {
            this.loginInfo = loginInfo;
        }

        protected final ILoginInfo2 getLoginInfo() {
            return this.loginInfo;
        }
    }

    private static abstract class AbstractLoginHandler2
    extends AbstractLoginHandler
    implements ILoginHandler2 {
        protected AbstractLoginHandler2(ILoginInfo2 loginInfo) {
            super(loginInfo);
        }

        public ILoginInfo2 challenge(ITeamRepository repository) {
            return this.getLoginInfo();
        }
    }

    private static class CertificateLoginHandler
    extends AbstractLoginHandler2 {
        private CertificateLoginHandler(String certificateFile, String password) {
            super((ILoginInfo2)new SSLCertificateLoginInfo(certificateFile, password));
        }
    }

    public static class KerberosLoginHandler
    extends AbstractLoginHandler2 {
        public static KerberosLoginHandler create(String kerberosConfigPath, String kerberosKdc, String kerberosRealm) {
            KerberosLoginInfo kerberosLoginInfo = new KerberosLoginInfo();
            if (kerberosConfigPath != null && kerberosConfigPath.trim().length() > 0) {
                System.setProperty(InitTask.KERBEROS_CONFIG_PROP, kerberosConfigPath);
            }
            if (kerberosKdc != null && kerberosKdc.trim().length() > 0) {
                System.setProperty(InitTask.KERBEROS_KDC_PROP, kerberosKdc);
            }
            if (kerberosRealm != null && kerberosRealm.trim().length() > 0) {
                System.setProperty(InitTask.KERBEROS_REALM_PROP, kerberosRealm);
            }
            return new KerberosLoginHandler(kerberosLoginInfo);
        }

        private KerberosLoginHandler(KerberosLoginInfo kerberosLoginInfo) {
            super((ILoginInfo2)kerberosLoginInfo);
        }

        public KerberosLoginHandler() {
            this(new KerberosLoginInfo());
        }
    }

    private static class LoginHandler
    extends AbstractLoginHandler
    implements ITeamRepository.ILoginHandler,
    ITeamRepository.ILoginHandler.ILoginInfo {
        private LoginHandler(String username, String password) {
            super((ILoginInfo2)new UsernameAndPasswordLoginInfo(username, password));
        }

        public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repository) {
            return this;
        }

        public String getPassword() {
            try {
                return this.getUsernameAndPasswordLoginInfo().getPassword();
            }
            catch (SavedPasswordNotObtainedException e) {
                return null;
            }
        }

        public String getUserId() {
            return this.getUsernameAndPasswordLoginInfo().getUsername();
        }

        private UsernameAndPasswordLoginInfo getUsernameAndPasswordLoginInfo() {
            return (UsernameAndPasswordLoginInfo)this.getLoginInfo();
        }
    }

    private static class SmartCardLoginHandler
    extends AbstractLoginHandler2 {
        private static IAliasChooser createAliasChooser(final String requestedAlias) {
            return new IAliasChooser(){

                public String chooseAlias(List<String> aliases) {
                    for (String alias : aliases) {
                        if (!alias.equals(requestedAlias)) continue;
                        return alias;
                    }
                    return null;
                }
            };
        }

        private static SmartCardLoginInfo createSmartCardLoginInfo(String requestedAlias) {
            IAliasChooser chooser = SmartCardLoginHandler.createAliasChooser(requestedAlias);
            return new SmartCardLoginInfo(chooser);
        }

        public SmartCardLoginHandler(String alias) {
            super((ILoginInfo2)SmartCardLoginHandler.createSmartCardLoginInfo(alias));
        }
    }
}

