/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.tasks;

import com.ibm.team.enterprise.build.ant.IFileSystemUtil;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.ant.internal.utils.FileSystemUtilFactory;
import com.ibm.team.enterprise.build.ant.internal.utils.SimulationUtil;
import com.ibm.team.enterprise.build.ant.tasks.AbstractCompileTask;
import com.ibm.team.enterprise.build.ant.tasks.AbstractEETask;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.enterprise.build.ant.types.resources.BuildableResource;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMapHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFileHandle;
import com.ibm.team.enterprise.build.client.buildmap.IBuildMapClient;
import com.ibm.team.enterprise.build.common.IDeletedBuildableFile;
import com.ibm.team.enterprise.build.common.IDeletedOutputFile;
import com.ibm.team.enterprise.build.common.util.DeleteFilesUtils;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DeleteBuildMapsTask
extends AbstractEETask {
    private File deletedBuildableFilesFile;
    private String buildDefinitionUuid;
    private String repositoryAddress;
    private String userId;
    private File passwordFile;
    private String certificateFile;
    private boolean smartCard;
    private boolean kerberos;
    private List<IDeletedBuildableFile> deletedBuildMaps;
    private Set<IDeletedOutputFile> deletedOutputFiles;

    public void setDeletedBuildableFilesFile(File file) {
        this.deletedBuildableFilesFile = file;
    }

    public void setBuildDefinitionUuid(String buildDefinitionUuid) {
        this.buildDefinitionUuid = buildDefinitionUuid;
    }

    public void setRepositoryAddress(String repositoryAddress) {
        this.repositoryAddress = repositoryAddress;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPasswordFile(File passwordFile) {
        this.passwordFile = passwordFile;
    }

    public void setCertificateFile(String certificateFile) {
        this.certificateFile = certificateFile;
    }

    public boolean isSmartCard() {
        return this.smartCard;
    }

    public void setSmartCard(boolean smartCard) {
        this.smartCard = smartCard;
    }

    public boolean isKerberos() {
        return this.kerberos;
    }

    public void setKerberos(boolean kerberos) {
        this.kerberos = kerberos;
    }

    public void doExecute() {
        this.logMsg(Messages.DELETE_BUILD_MAPS_OUTPUTS_MSG, 2);
        this.parseDeletedFiles();
        if (this.deletedBuildMaps.size() > 0) {
            this.logMsg(NLS.bind((String)Messages.DELETE_BUILD_MAPS_SIZE, (Object)this.deletedBuildMaps.size()), 2);
            IBuildMapClient buildMapClient = (IBuildMapClient)InitTask.getInstance().getTeamRepository().getClientLibrary(IBuildMapClient.class);
            for (IDeletedBuildableFile deleteFile : this.deletedBuildMaps) {
                try {
                    IBuildMap buildMap = null;
                    String uuid = deleteFile.getFileUUID();
                    String componentUuid = deleteFile.getComponentUUID();
                    boolean deleteBuildMap = false;
                    if (uuid != null && uuid.length() > 0) {
                        buildMap = buildMapClient.getBuildMap(UUID.valueOf((String)deleteFile.getFileUUID()), UUID.valueOf((String)this.buildDefinitionUuid), null);
                        if (buildMap != null) {
                            deleteBuildMap = true;
                            IInputBuildFileHandle selfHandle = buildMap.getSelf();
                            if (selfHandle instanceof IInputBuildFile) {
                                IInputBuildFile self = (IInputBuildFile)selfHandle;
                                String selfUuid = self.getComponent().getItemId().getUuidValue();
                                if (componentUuid != null && !selfUuid.equals(componentUuid)) {
                                    deleteBuildMap = false;
                                    this.logMsg(NLS.bind((String)Messages.DELETE_BUILD_MAPS_FOR_FILE_COMP_NO_MATCH, (Object)deleteFile.getFileName()), 2);
                                }
                            }
                        } else {
                            this.logMsg(NLS.bind((String)Messages.DELETE_BUILD_MAPS_FOR_FILE_SKIPPED, (Object)deleteFile.getFileName()), 2);
                        }
                    }
                    if (!deleteBuildMap || buildMap == null) continue;
                    this.logMsg(NLS.bind((String)Messages.DELETE_BUILD_MAPS_FOR_FILE, (Object)deleteFile.getFileName()), 2);
                    if (buildMap == null) continue;
                    buildMapClient.delete((IBuildMapHandle)buildMap, (IProgressMonitor)this.monitor);
                }
                catch (TeamRepositoryException e) {
                    String msg = NLS.bind((String)Messages.DELETE_BUILD_MAP_ERROR, (Object)deleteFile.getFileName(), (Object)e.getLocalizedMessage());
                    throw new BuildException(msg, (Throwable)e);
                }
            }
        } else {
            this.logMsg(Messages.DELETE_BUILD_MAPS_NONE, 2);
        }
        if (!this.deletedOutputFiles.isEmpty()) {
            if (SimulationUtil.isSimulationMode()) {
                this.logMsg(NLS.bind((String)Messages.DELETING_OUTPUTS_SIMULATION_MSG, (Object)this.deletedOutputFiles.size()), 2);
                for (IDeletedOutputFile output : this.deletedOutputFiles) {
                    this.logMsg(this.getFormattedDisplayName(output), 2);
                }
            } else {
                IFileSystemUtil util = FileSystemUtilFactory.createFileSystemUtil();
                this.logMsg(NLS.bind((String)Messages.DELETING_OUTPUTS_MSG, (Object)this.deletedOutputFiles.size()), 2);
                for (IDeletedOutputFile output : this.deletedOutputFiles) {
                    String buildFile = output.getBuildFile();
                    String buildPath = output.getBuildPath();
                    if (buildPath == null || buildPath.isEmpty()) {
                        this.logMsg(NLS.bind((String)Messages.DELETE_OUTPUT_EMPTY_PATH_ERROR, (Object)buildFile), 0);
                        continue;
                    }
                    try {
                        if (util.exists((Task)this, buildFile, buildPath, output.getSequential())) {
                            long timestampOnSystem = util.lastModified((Task)this, output);
                            if (timestampOnSystem == 0L) {
                                this.logMsg(NLS.bind((String)Messages.DELETED_BUILDABLE_FILES_NO_SYSTEM_TIMESTAMP_ERROR, (Object)this.getFormattedDisplayName(output)), 0);
                                continue;
                            }
                            if (output.getTimestamp() != -1L && timestampOnSystem != output.getTimestamp()) {
                                this.logMsg(NLS.bind((String)Messages.DELETED_BUILDABLE_FILES_TIMESTAMPS_NOT_MATCH_ERROR, (Object[])new String[]{this.getFormattedDisplayName(output), String.valueOf(output.getTimestamp()), String.valueOf(timestampOnSystem)}), 0);
                                continue;
                            }
                            try {
                                util.delete((Task)this, buildFile, buildPath, output.getSequential());
                                this.logMsg(NLS.bind((String)Messages.DELETED_OUTPUT_MSG, (Object)this.getFormattedDisplayName(output)), 2);
                            }
                            catch (Exception e) {
                                this.logMsg(NLS.bind((String)Messages.DELETE_OUTPUT_ERROR, (Object)this.getFormattedDisplayName(output), (Object)e.getLocalizedMessage()), e, 0);
                            }
                            continue;
                        }
                        this.logMsg(NLS.bind((String)Messages.DELETED_BUILDABLE_FILES_NOT_EXIST_ERROR, (Object)this.getFormattedDisplayName(output)), 0);
                    }
                    catch (Exception e) {
                        this.logMsg(NLS.bind((String)Messages.DELETE_OUTPUT_ERROR, (Object)this.getFormattedDisplayName(output), (Object)e.getLocalizedMessage()), 0);
                        throw new BuildException((Throwable)e);
                    }
                }
            }
        } else {
            this.logMsg(Messages.DELETE_OUTPUTS_NONE, 2);
        }
    }

    private String buildFileFullPathNameForProperties(IDeletedOutputFile file) {
        String type;
        StringBuilder buf = new StringBuilder(100);
        buf.append(file.getBuildPath());
        buf.append('/');
        buf.append(file.getBuildFile());
        String sequential = file.getSequential();
        if (sequential != null && sequential.length() > 1) {
            buf.append('/');
            buf.append(sequential);
        }
        if ((type = file.getOutputType()) != null && type.length() > 1) {
            buf.append('.');
            buf.append(type, 1, type.length());
        }
        return buf.toString();
    }

    private String getFormattedDisplayName(IDeletedOutputFile file) {
        StringBuilder buf = new StringBuilder(100);
        buf.append(file.getBuildPath());
        String sequential = file.getSequential();
        if (Boolean.parseBoolean(sequential)) {
            if (file.getBuildFile() != null && !file.getBuildFile().isEmpty()) {
                buf.append('.');
                buf.append(file.getBuildFile());
            }
        } else {
            String type = file.getOutputType();
            if (type != null && type.length() > 1) {
                buf.append('/');
                buf.append(file.getBuildFile());
                buf.append('.');
                buf.append(type, 1, type.length());
            } else {
                buf.append('(');
                buf.append(file.getBuildFile());
                buf.append(')');
            }
        }
        return buf.toString();
    }

    protected void parseDeletedFiles() {
        if (this.deletedBuildableFilesFile == null || !this.deletedBuildableFilesFile.exists()) {
            this.logMsg(Messages.DELETED_BUILD_FILES_NOT_FOUND, 3);
            return;
        }
        try {
            Properties outputList = BuildableResource.loadGeneratedOutputProperties(this.getProject());
            this.deletedBuildMaps = new ArrayList<IDeletedBuildableFile>();
            this.deletedOutputFiles = new HashSet<IDeletedOutputFile>();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            String outputNS = "http://www.ibm.com/team/enterprise/build/buildmap/outputs/1.0/";
            String buildableNS = "http://www.ibm.com/team/enterprise/build/buildablefiles/1.0/";
            Document document = documentBuilderFactory.newDocumentBuilder().parse(this.deletedBuildableFilesFile);
            NodeList fileList = document.getElementsByTagNameNS(buildableNS, "file");
            int i = 0;
            while (i < fileList.getLength()) {
                Element fileElement = (Element)fileList.item(i);
                String uuid = fileElement.getAttributeNS(buildableNS, "uuid");
                String name = fileElement.getAttributeNS(buildableNS, "name");
                String componentUuid = fileElement.getAttributeNS(buildableNS, "componentUuid");
                if (!this.isValidUuid(uuid)) {
                    this.logMsg(NLS.bind((String)Messages.DELETED_BUILD_MAP_INVALID_UUID, (Object)uuid, (Object)name), 0);
                } else {
                    IDeletedBuildableFile deletedBuildFile = DeleteFilesUtils.createDeletedBuildableFile((String)uuid, (String)name, (String)componentUuid);
                    this.deletedBuildMaps.add(deletedBuildFile);
                }
                ++i;
            }
            NodeList outputs = document.getElementsByTagNameNS(outputNS, "file");
            int j = 0;
            while (j < outputs.getLength()) {
                Element outputElement = (Element)outputs.item(j);
                String buildFile = outputElement.getAttributeNS(outputNS, "buildFile");
                String buildPath = outputElement.getAttributeNS(outputNS, "buildPath");
                String outputType = outputElement.getAttributeNS(outputNS, "outputType");
                String sequential = outputElement.getAttributeNS(outputNS, "sequential");
                String requireBuiltUUID = outputElement.getAttributeNS(outputNS, "requireBuiltUUID");
                String timestampValue = outputElement.getAttributeNS(outputNS, "timestamp");
                long timestamp = "".equals(timestampValue) ? -1L : Long.parseLong(timestampValue);
                IDeletedOutputFile deletedOutputFile = DeleteFilesUtils.createDeletedOuputFile((String)buildFile, (String)buildPath, (String)outputType, (String)sequential, (String)requireBuiltUUID, (long)timestamp);
                if (requireBuiltUUID != null && !requireBuiltUUID.isEmpty() && !AbstractCompileTask.fileUUIDsBuiltSuccessfully.contains(requireBuiltUUID)) {
                    this.logMsg("Removing " + this.getFormattedDisplayName(deletedOutputFile) + " from the list of outputs to delete because its buildable file was not rebuilt.", 4);
                } else {
                    String outputKey = this.buildFileFullPathNameForProperties(deletedOutputFile);
                    if (outputList.containsKey(outputKey)) {
                        this.logMsg("Removing " + this.getFormattedDisplayName(deletedOutputFile) + " from the list of outputs to delete because it has been produced by this build.", 4);
                    } else {
                        this.deletedOutputFiles.add(deletedOutputFile);
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            this.logMsg(NLS.bind((String)Messages.DELETED_BUILDABLE_FILES_PARSE_ERROR, (Object)this.deletedBuildableFilesFile.getAbsolutePath()), 0);
            throw new BuildException((Throwable)e);
        }
    }

    private boolean isValidUuid(String uuidValue) {
        try {
            UUID.valueOf((String)uuidValue);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

