/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.tasks;

import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildReportUtils;
import com.ibm.team.enterprise.build.ant.tasks.AbstractCompileTask;
import com.ibm.team.enterprise.build.ant.types.resources.BuildMapLinkCollection;
import com.ibm.team.enterprise.build.ant.types.resources.BuildableResource;
import com.ibm.team.enterprise.build.ant.types.resources.FailedBuildableResourceCollection;
import com.ibm.team.enterprise.build.common.buildreport.BuildReportGenerator;
import com.ibm.team.enterprise.build.common.buildreport.ReturnCodeResourceCollection;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class BuildReportTask
extends Task {
    private String loadDir;
    private File fBuildableList;
    private String buildResultUUID;
    private boolean preview;
    private File fPasswordFile;
    private String fPassword;
    private String fUserId;
    private String fRepositoryAddress;
    private String certificateFile;
    private boolean smartCard;
    private boolean kerberos;

    protected String getCertificateFile() {
        return this.certificateFile;
    }

    protected void setCertificateFile(String certificateFile) {
        this.certificateFile = certificateFile;
    }

    protected boolean isSmartCard() {
        return this.smartCard;
    }

    protected void setSmartCard(boolean smartCard) {
        this.smartCard = smartCard;
    }

    public boolean isKerberos() {
        return this.kerberos;
    }

    public void setKerberos(boolean kerberos) {
        this.kerberos = kerberos;
    }

    public File getPasswordFile() {
        return this.fPasswordFile;
    }

    public void setPasswordFile(File passwordFile) {
        this.fPasswordFile = passwordFile;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public void setPassword(String password) {
        this.fPassword = password;
    }

    public String getUserId() {
        return this.fUserId;
    }

    public void setUserId(String userId) {
        this.fUserId = userId;
    }

    public String getRepositoryAddress() {
        return this.fRepositoryAddress;
    }

    public void setRepositoryAddress(String repositoryAddress) {
        this.fRepositoryAddress = repositoryAddress;
    }

    public void execute() {
        File outfile = new File(new File(this.getProject().getProperty("team.enterprise.scm.fetchDestination")), "buildReport.xml");
        if (outfile.exists()) {
            outfile.delete();
        }
        try {
            Properties outputsProperties = BuildableResource.loadGeneratedOutputProperties(this.getProject());
            Hashtable componentsBuildMapLinks = BuildMapLinkCollection.getInstance().getResources();
            Hashtable componentsReturnCodes = ReturnCodeResourceCollection.getInstance().getResources();
            boolean isPersonalBuild = Boolean.valueOf(this.getProject().getProperty(IBuildResult.PROPERTY_PERSONAL_BUILD));
            BuildReportGenerator buildReportGenerator = new BuildReportGenerator(this.fBuildableList, outfile, this.getProject().getProperty("team.enterprise.scm.resourcePrefix"), outputsProperties, (Map)componentsBuildMapLinks, (Map)componentsReturnCodes, AbstractCompileTask.fileUUIDsBuiltSuccessfully, FailedBuildableResourceCollection.getInstance().getFailedUUIDSet(), this.preview, isPersonalBuild);
            buildReportGenerator.run();
            BuildReportUtils.publishBuildReport(outfile, this.getProject(), this.buildResultUUID, this.preview);
            if (FailedBuildableResourceCollection.getInstance().getSize() > 0) {
                BuildReportUtils.generateFailedBuildReport(this.getProject(), this.buildResultUUID);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public File getBuildableList() {
        return this.fBuildableList;
    }

    public void setBuildableList(File buildableList) {
        this.fBuildableList = buildableList;
    }

    public String getLoadDir() {
        return this.loadDir;
    }

    public void setLoadDir(String loadDir) {
        this.loadDir = loadDir;
    }

    public String getBuildResultUUID() {
        return this.buildResultUUID;
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.buildResultUUID = buildResultUUID;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }
}

