/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.tasks;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.publishing.AbstractContributionPublisher;
import com.ibm.team.enterprise.build.common.IBuildConstants;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;

public class BuildReportExtendedContributionPublisher
extends AbstractContributionPublisher {
    private final String fUrl;
    private final int fIndex;
    private final int fFailed;
    private String label;

    public BuildReportExtendedContributionPublisher(String url, String label, int index, int failed) {
        this(IBuildResultContribution.LINK_EXTENDED_CONTRIBUTION_ID, url, label, index, failed);
    }

    public BuildReportExtendedContributionPublisher(String extendedContributionTypeId, String url, String label, int index, int failed) {
        super(extendedContributionTypeId, label);
        this.fUrl = url;
        this.fIndex = index;
        this.fFailed = failed;
        this.label = label;
    }

    protected void initializeContribution(IBuildResultContribution contribution, ITeamRepository teamRepository) throws TeamRepositoryException {
        contribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_URL, this.fUrl);
        contribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_SIZE, Integer.toString(this.fIndex));
        contribution.setExtendedContributionProperty(IBuildConstants.PROPERTY_NAME_FILE_FAILED, Integer.toString(this.fFailed));
    }

    public IBuildResultContribution createContribution(ITeamRepository teamRepository, BuildStatus contributionStatus) throws TeamRepositoryException {
        IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
        contribution.setLabel(this.label);
        contribution.setImpactsPrimaryResult(true);
        contribution.setStatus(contributionStatus);
        contribution.setExtendedContributionTypeId(this.getExtendedContributionTypeId());
        if (this.getComponentName() != null) {
            contribution.setComponentName(this.getComponentName());
        }
        this.initializeContribution(contribution, teamRepository);
        return contribution;
    }
}

