/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.tasks;

import com.ibm.team.build.common.IStaticReset;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.scm.LoadComponents;
import com.ibm.team.enterprise.build.ant.EEPropertyHelper;
import com.ibm.team.enterprise.build.ant.IBuildableResource;
import com.ibm.team.enterprise.build.ant.IFileSystemUtil;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.ant.internal.utils.AbstractMacroExec;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildFileUtil;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildReportExtendedContributionCallable;
import com.ibm.team.enterprise.build.ant.internal.utils.FileSystemUtilFactory;
import com.ibm.team.enterprise.build.ant.internal.utils.SimulationUtil;
import com.ibm.team.enterprise.build.ant.internal.utils.VariableUtil;
import com.ibm.team.enterprise.build.ant.tasks.AbstractEETask;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.enterprise.build.ant.types.resources.BuildableResource;
import com.ibm.team.enterprise.build.ant.types.resources.BuildableResourceCollection;
import com.ibm.team.enterprise.build.ant.types.resources.FailedBuildableResourceCollection;
import com.ibm.team.enterprise.build.ant.types.resources.LangOutputsCollection;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.client.buildmap.IBuildMapClient;
import com.ibm.team.enterprise.build.client.dependencyset.ClientFactory;
import com.ibm.team.enterprise.build.client.dependencyset.IDependencySetClient;
import com.ibm.team.enterprise.build.common.buildreport.BuildFileXMLModel;
import com.ibm.team.enterprise.build.common.buildreport.ReturnCodeResource;
import com.ibm.team.enterprise.build.common.buildreport.ReturnCodeResourceCollection;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractCompileTask
extends AbstractEETask
implements IStaticReset {
    protected static final String ZOS_DEPENDENCY_BUILD_TEMPLATE = "com.ibm.team.enterprise.zos.build.dependency.template";
    protected static final String IBMI_DEPENDENCY_BUILD_TEMPLATE = "com.ibm.team.enterprise.ibmi.build.dependency.template";
    protected static final String RC_ERROR_MESSAGE_PATTERN = "CRHTC1655E The return code \\((\\d+)\\)";
    public static final String COMPILE_ERROR_OCCURRED = ".compileErrorOccurred";
    protected static final String LOG_EXTENSION = ".log";
    public static final Set<String> fileUUIDsBuiltSuccessfully = new HashSet<String>();
    protected static final int DEFAULT_SIZE = 5;
    protected ResourceCollection fResourceCollection;
    protected boolean preview;
    private String userId;
    private File passwordFile;
    private String repositoryAddress;
    private String certificateFile;
    private boolean smartCard;
    private boolean kerberos;
    protected boolean disabledGlobalCache;
    protected int total = 0;
    protected int updated = 0;
    protected int uptodate = 0;
    protected int failed = 0;
    private String buildResultUUID;
    protected static HashMap<String, IInputBuildFile> physicalDependencyCache;
    protected IFileSystemUtil util = null;
    protected Exception the_exception = null;

    public void doExecute() {
        PropertyHelper origHelper = PropertyHelper.getPropertyHelper((Project)this.getProject());
        if (!(origHelper instanceof EEPropertyHelper)) {
            EEPropertyHelper newHelper = new EEPropertyHelper();
            newHelper.init(origHelper, this.getProject());
        }
        this.configureTaskAttributes();
        this.initialize();
        this.util = FileSystemUtilFactory.createFileSystemUtil();
        this.util.setPrefix(this.getProject().getProperty("team.enterprise.scm.resourcePrefix"));
        this.util.setWorkspaceUuid(this.getProject().getProperty("team.enterprise.scm.workspaceUUID"));
        this.util.setTeamPrefix(this.getProject().getProperty("team.enterprise.scm.resourceTeamPrefix"));
        this.util.setTeamWorkspaceUuid(this.getProject().getProperty("team.enterprise.scm.teamWorkspaceUUID"));
        this.util.setDestinationPath(this.getProject().getProperty("team.enterprise.scm.fetchDestination"));
        this.initializeSystemPropeties();
        String templateId = this.getProject().getProperty("com.ibm.team.build.internal.template.id");
        boolean isDependencyBasedBuild = IBMI_DEPENDENCY_BUILD_TEMPLATE.equals(templateId) || ZOS_DEPENDENCY_BUILD_TEMPLATE.equals(templateId);
        ArrayList<IBuildableResource> buildables = new ArrayList<IBuildableResource>(5);
        BuildReportExtendedContributionCallable.init(UUID.valueOf((String)this.getBuildResultUUID()), Boolean.valueOf(this.getProject().getProperty(IBuildResult.PROPERTY_PERSONAL_BUILD)));
        this.doLoad(isDependencyBasedBuild, buildables);
        this.doCompile(isDependencyBasedBuild, buildables);
        this.logSummary();
    }

    protected void doLoad(boolean isDependencyBasedBuild, List<IBuildableResource> buildables) {
        boolean isCheckAll = Boolean.valueOf(this.getProject().getProperty("team.enterprise.build.ant.checkAll"));
        boolean isRebuildAll = Boolean.valueOf(this.getProject().getProperty("team.enterprise.build.ant.buildChangesOnly")) == false;
        boolean isFetchAll = Boolean.valueOf(this.getProject().getProperty("team.enterprise.build.ant.fetchAll"));
        boolean isFetchAllHFS = Boolean.valueOf(this.getProject().getProperty("team.enterprise.build.ant.fetchWorkspaceBeforeBuild"));
        boolean isPersonalBuild = Boolean.valueOf(this.getProject().getProperty(IBuildResult.PROPERTY_PERSONAL_BUILD));
        boolean isFullMinimumLoad = Boolean.valueOf(this.getProject().getProperty("team.enterprise.build.ant.fullMinimumLoad"));
        boolean isRunningAsSimpleJUnit = Boolean.valueOf(this.getProject().getProperty("team.enterprise.build.dependency.runAsSimpleJUnit"));
        boolean hasAlwaysLoadComponents = false;
        boolean hasExcludeComponents = false;
        if (!isRunningAsSimpleJUnit) {
            String alwaysLoadComponentUuidValues = this.getProject().getProperty("team.enterprise.scm.alwaysLoadComponents");
            ITeamRepository teamRepository = InitTask.getInstance().getTeamRepository();
            LoadComponents alwaysLoadComponents = new LoadComponents(teamRepository, alwaysLoadComponentUuidValues);
            hasAlwaysLoadComponents = alwaysLoadComponents.getComponentHandles().size() > 0;
            String excludeComponentUuidValues = this.getProject().getProperty("team.enterprise.scm.loadComponents");
            LoadComponents excludeComponents = new LoadComponents(teamRepository, excludeComponentUuidValues);
            boolean bl = hasExcludeComponents = !excludeComponents.getComponentHandles().isEmpty();
        }
        if (physicalDependencyCache == null || this.disabledGlobalCache) {
            this.logMsg("creating new file physical dependency cache" + (this.disabledGlobalCache ? " because global cache was disabled" : ""), 4);
            physicalDependencyCache = new HashMap();
        }
        if (this.fResourceCollection != null) {
            this.total = this.fResourceCollection.size();
        }
        if (isDependencyBasedBuild) {
            boolean isFetchingHFSWorkspacePartially;
            boolean isFetchingWorkspacePartially;
            ArrayList<IBuildableResource> hfsResources = new ArrayList<IBuildableResource>(this.fResourceCollection.size());
            ArrayList<IBuildableResource> nonHfsResources = new ArrayList<IBuildableResource>(this.fResourceCollection.size());
            try {
                for (Resource res : this.fResourceCollection) {
                    if (!(res instanceof BuildableResource)) continue;
                    BuildableResource buildable = (BuildableResource)res;
                    buildable.setBuildPath(this.util.substituteSystemSymbols(buildable.getBuildPath()));
                    this.logMsg("Resolving physical dependencies for " + buildable.getMvsName(), 4);
                    buildable.resolvePhysicalDependencies((Task)this);
                    if (isRebuildAll || !isCheckAll && buildable.needsRebuild((Task)this)) {
                        if (buildable.getBuildMacro() != null && !this.preview && !buildable.isRebuild() && buildable.getInputFiles().size() == 0) {
                            if (!isRunningAsSimpleJUnit) {
                                if (isPersonalBuild) {
                                    this.callBuildMapService(buildable);
                                } else {
                                    this.callDependencySetService(buildable);
                                }
                            }
                            buildable.resolvePhysicalDependencies((Task)this);
                        }
                        buildables.add(buildable);
                        if (buildable.isHFS()) {
                            hfsResources.add(buildable);
                            continue;
                        }
                        nonHfsResources.add(buildable);
                        continue;
                    }
                    this.logMsg(NLS.bind((String)Messages.JOB_UP_TO_DATE, (Object)buildable.getLangDefName(), (Object)buildable.getName()), 3);
                    ++this.uptodate;
                }
            }
            catch (Exception e1) {
                throw new BuildException((Throwable)e1);
            }
            boolean bl = isFetchingWorkspacePartially = !isFetchAll || hasAlwaysLoadComponents;
            if (!(this.preview || !isFetchingWorkspacePartially || isPersonalBuild && !isFullMinimumLoad || nonHfsResources.size() <= 0 || isRunningAsSimpleJUnit)) {
                this.util.loadFiles((Task)this, nonHfsResources, true);
            }
            boolean bl2 = isFetchingHFSWorkspacePartially = !isFetchAllHFS || hasExcludeComponents;
            if (!(this.preview || !isFetchingHFSWorkspacePartially || isPersonalBuild && !isFullMinimumLoad || hfsResources.size() <= 0 || isRunningAsSimpleJUnit)) {
                this.util.loadFiles((Task)this, hfsResources, true);
            }
        } else {
            for (Resource res : this.fResourceCollection) {
                if (!(res instanceof BuildableResource)) continue;
                buildables.add((BuildableResource)res);
            }
        }
    }

    protected void doCompile(boolean isDependencyBasedBuild, List<IBuildableResource> buildables) {
        boolean isFirst = true;
        String languageDefinition = null;
        for (IBuildableResource res : buildables) {
            String buildableResourceName = res.getName();
            if (buildableResourceName == null) {
                buildableResourceName = Messages.INSTREAM_SOURCE;
            }
            buildableResourceName = this.util.substituteSystemSymbols(buildableResourceName);
            ((Resource)res).setName(buildableResourceName);
            boolean userbuild = Boolean.parseBoolean(this.getProject().getProperty("team.enterprise.build.userbuild"));
            if (userbuild) {
                String fileName = String.valueOf(res.getName()) + LOG_EXTENSION;
                this.logMsg("This is a userbuild, clean logs : " + fileName, 4);
                File logFile = new File(fileName);
                if (logFile.exists()) {
                    logFile.delete();
                }
            }
            AbstractMacroExec job = this.getMacroExec(res);
            if (!this.preprocess(res)) {
                this.logMsg("Preprocessor determined that the build is not required.", 4);
                continue;
            }
            if (isFirst) {
                languageDefinition = job.getLangDefName();
                this.logMsg(NLS.bind((String)Messages.COMPILE_TASK_STARTED, (Object)languageDefinition), 2);
                isFirst = false;
            }
            job = job.call();
            this.finalizeMacro();
            Exception ex = this.handeException(job, isDependencyBasedBuild, this.the_exception == null && isDependencyBasedBuild && !this.shouldFailOnError());
            if (ex == null) continue;
            if (this.the_exception == null) {
                this.the_exception = ex;
                System.out.println("Line 312");
            }
            if (isDependencyBasedBuild && this.shouldFailOnError()) break;
        }
        if (languageDefinition != null) {
            this.writelogSummary(languageDefinition);
        }
    }

    protected void writelogSummary(String languageDefinition) {
        this.logMsg(NLS.bind((String)(this.preview ? Messages.PREVIEW_BUILD_SUMMARY : Messages.BUILD_SUMMARY), (Object[])new Object[]{this.total, this.updated, this.uptodate, this.failed, languageDefinition}));
    }

    protected void logSummary() {
        if (this.the_exception != null && this.shouldFailOnError()) {
            System.out.println(this.the_exception.getMessage());
            throw new BuildException(Messages.EXCEPTIONS_DURING_PROCESSING, (Throwable)this.the_exception);
        }
    }

    protected Exception handeException(AbstractMacroExec job, boolean isDependencyBasedBuild, boolean createCompileErrorFile) {
        Exception ex = job.getException();
        if (ex != null) {
            Pattern pattern;
            Matcher matcher;
            if (createCompileErrorFile) {
                File compileErrorOccurredFile = new File(String.valueOf(BuildableResource.getTmpDir(this.getProject())) + File.separator + COMPILE_ERROR_OCCURRED);
                try {
                    compileErrorOccurredFile.createNewFile();
                }
                catch (IOException e1) {
                    this.logMsg(e1.getMessage(), 3);
                }
            }
            if (isDependencyBasedBuild) {
                this.cleanUpOutputs(job.getBuildableResource());
            }
            ++this.failed;
            this.logMsg(NLS.bind((String)Messages.JOB_FAILED, (Object[])new Object[]{job.getLangDefName(), job.getBuildableResource().getName(), ex.getClass().getSimpleName(), ex.getMessage()}), 0);
            this.logMsg(ex, 4);
            if (job.getBuildableResource() != null && ex.getMessage().contains("CRHTC1655E") && (matcher = (pattern = Pattern.compile(RC_ERROR_MESSAGE_PATTERN)).matcher(ex.getMessage())).find() && matcher.groupCount() >= 1) {
                String rc = matcher.group(1);
                ReturnCodeResource rcResource = new ReturnCodeResource(job.getBuildableResource().getComponentName(), job.getBuildableResource().getProjectName(), job.getBuildableResource().getBuildPath(), job.getBuildableResource().getBuildFile(), rc);
                ReturnCodeResourceCollection.getInstance().addResource(job.getBuildableResource().getComponentName(), job.getBuildableResource().getProjectName(), (Object)rcResource);
            }
            this.putFailedBuildableResource(job.getBuildableResource(), job, this.getProject());
            this.publishFailedFiles(job.getBuildableResource());
        } else {
            fileUUIDsBuiltSuccessfully.add(job.getBuildableResource().getUuid());
            ++this.updated;
            this.logMsg(NLS.bind((String)(this.preview ? Messages.JOB_TO_BE_UPDATED : Messages.JOB_UPDATED), (Object)job.getLangDefName(), (Object)job.getBuildableResource().getName()));
        }
        return ex;
    }

    protected void publishFailedFiles(IBuildableResource res) {
        try {
            BuildReportExtendedContributionCallable.incrementFailedCount();
            BuildReportExtendedContributionCallable.run(AbstractCompileTask.getExecutor(), false);
        }
        catch (Exception e1) {
            this.logMsg(e1.getMessage(), 3);
        }
    }

    protected void putFailedBuildableResource(IBuildableResource res, AbstractMacroExec job, Project project) {
        Set<IOutputBuildFile> langOutputs = null;
        try {
            langOutputs = LangOutputsCollection.getInstance(this.getProject().getProperty("team.enterprise.scm.fetchDestination")).getResource(job.getBuildMacro());
        }
        catch (Exception e) {
            this.logMsg(NLS.bind((String)Messages.JOB_FAILED, (Object[])new Object[]{job.getLangDefName(), res.getName(), e.getClass().getSimpleName(), e.getMessage()}), 0);
        }
        HashSet<IOutputBuildFile> outputs = new HashSet<IOutputBuildFile>();
        if (langOutputs != null) {
            Map<String, String> jobProperties = job.getJobProperties();
            for (IOutputBuildFile langOutput : langOutputs) {
                String buildFile = langOutput.getBuildFile();
                String buildPath = langOutput.getBuildPath();
                try {
                    buildFile = VariableUtil.getValueWithVariables(buildFile, 3, jobProperties, project);
                    buildPath = VariableUtil.getValueWithVariables(buildPath, 3, jobProperties, project);
                }
                catch (Exception e) {
                    this.logMsg(NLS.bind((String)Messages.JOB_FAILED, (Object[])new Object[]{job.getLangDefName(), res.getName(), e.getClass().getSimpleName(), e.getMessage()}), 0);
                }
                IOutputBuildFile output = (IOutputBuildFile)IOutputBuildFile.ITEM_TYPE.createItem();
                output.setBuildFile(buildFile);
                output.setBuildPath(buildPath);
                output.setType(langOutput.getType());
                output.setOutputType(langOutput.getOutputType());
                output.setSequential(langOutput.isSequential());
                output.setHFS(langOutput.isHFS());
                output.setResourceDefinitionUUID(langOutput.getResourceDefinitionUUID());
                output.setResourceDefinitionStateUUID(langOutput.getResourceDefinitionStateUUID());
                outputs.add(output);
            }
        }
        FailedBuildableResourceCollection.getInstance().addFailedBuildableResource(res.getUuid(), outputs);
    }

    protected abstract AbstractMacroExec getMacroExec(IBuildableResource var1);

    protected void initialize() {
    }

    protected boolean preprocess(IBuildableResource res) {
        return true;
    }

    protected void finalizeMacro() {
    }

    protected void cleanUpOutputs(IBuildableResource res) {
        Set<BuildFileXMLModel> outputs;
        if (!SimulationUtil.isSimulationMode() && (outputs = res.getOutputFiles()) != null) {
            for (BuildFileXMLModel output : outputs) {
                IOutputBuildFile o = BuildFileUtil.getOutputFileFromXMLModel(output);
                if (output.isHFS() || !this.util.exists((Task)this, (IBuildFile)o)) continue;
                this.util.delete((Task)this, (IBuildFile)o);
            }
        }
    }

    public void add(ResourceCollection resourceCollection) {
        this.fResourceCollection = resourceCollection;
    }

    public ResourceCollection getResourceCollection() {
        return this.fResourceCollection;
    }

    protected final void callDependencySetService(BuildableResource buildable) {
        try {
            this.logMsg("call DependencySetService", 4);
            IDependencySetClient client = ClientFactory.getDependencySetClient((ITeamRepository)InitTask.getInstance().getTeamRepository());
            String dependencySetXML = client.buildDependencySet2(buildable.getUuid(), buildable.getBuildMacro(), buildable.getComponentName(), this.getProject().getProperty("team.enterprise.scm.workspaceUUID"), (Map)this.getProject().getProperties(), (IProgressMonitor)new NullProgressMonitor());
            this.logMsg("dependencySet=" + dependencySetXML, 4);
            BuildableResourceCollection.updateDependencySet(buildable, dependencySetXML);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void callBuildMapService(BuildableResource buildable) {
        try {
            this.logMsg("call callBuildMapService", 4);
            IBuildMapClient buildMapClient = (IBuildMapClient)InitTask.getInstance().getTeamRepository().getClientLibrary(IBuildMapClient.class);
            IBuildMap buildMap = buildMapClient.getBuildMap(UUID.valueOf((String)buildable.getUuid()), UUID.valueOf((String)this.getProject().getProperty("team.enterprise.buildDefinitionUUID")), null);
            if (buildMap != null) {
                List inputs = buildMap.getInputs();
                this.logMsg("callBuildMapService: inputSet.size()=" + inputs.size(), 4);
                BuildableResourceCollection.updateDependencySet(buildable, true, inputs);
            } else {
                this.logMsg("callBuildMapService: build map for " + buildable.getName() + " was not found.", 4);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void configureTaskAttributes() {
        String s;
        Project project = this.getProject();
        if (this.getUserId() == null && (s = System.getenv("JAZZ_USER")) != null) {
            this.setUserId(s);
        }
        if (this.getPasswordFile() == null && (s = System.getenv("JAZZ_PASSWORD_FILE")) != null) {
            this.setPasswordFile(new File(s));
        }
        if (this.getRepositoryAddress() == null && (s = project.getProperty("repositoryAddress")) != null) {
            this.setRepositoryAddress(s);
        }
        if (this.getBuildResultUUID() == null && (s = project.getProperty("buildResultUUID")) != null) {
            this.setBuildResultUUID(s);
        }
        String previewBuild = project.getProperty("team.enterprise.build.dependency.previewBuild");
        this.preview = Boolean.parseBoolean(previewBuild);
        this.disabledGlobalCache = Boolean.parseBoolean(project.getProperty("team.enterprise.build.disableGlobalFileSystemCache"));
    }

    public String getBuildResultUUID() {
        return this.buildResultUUID;
    }

    public String getCertificateFile() {
        return this.certificateFile;
    }

    public void setCertificateFile(String certificateFile) {
        this.certificateFile = certificateFile;
    }

    public boolean isSmartCard() {
        return this.smartCard;
    }

    public void setSmartCard(boolean smartCard) {
        this.smartCard = smartCard;
    }

    public boolean isKerberos() {
        return this.kerberos;
    }

    public void setKerberos(boolean kerberos) {
        this.kerberos = kerberos;
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.buildResultUUID = buildResultUUID;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public File getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(File passwordFile) {
        this.passwordFile = passwordFile;
    }

    public String getRepositoryAddress() {
        return this.repositoryAddress;
    }

    public void setRepositoryAddress(String repositoryAddress) {
        this.repositoryAddress = repositoryAddress;
    }

    public boolean shouldFailOnError() {
        return this.isFailOnError();
    }

    public HashMap<String, IInputBuildFile> getPhysicalDependencyCache() {
        return physicalDependencyCache;
    }

    public static void staticMemoryReset() {
        if (fileUUIDsBuiltSuccessfully != null) {
            fileUUIDsBuiltSuccessfully.clear();
        }
        if (physicalDependencyCache != null) {
            physicalDependencyCache.clear();
        }
    }
}

