/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.tasks;

import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildRequestHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.extensions.client.BuildCache;
import com.ibm.team.enterprise.build.ant.EEPropertyHelper;
import com.ibm.team.enterprise.build.ant.IBuildableResource;
import com.ibm.team.enterprise.build.ant.IFileSystemUtil;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.ant.internal.utils.AbstractMacroExec;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildFileUtil;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildReportExtendedContributionCallable;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildReportUtils;
import com.ibm.team.enterprise.build.ant.internal.utils.FileSystemUtilFactory;
import com.ibm.team.enterprise.build.ant.internal.utils.SimulationUtil;
import com.ibm.team.enterprise.build.ant.tasks.AbstractEETask;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.enterprise.build.ant.types.resources.BuildLogResource;
import com.ibm.team.enterprise.build.ant.types.resources.BuildableResource;
import com.ibm.team.enterprise.build.ant.types.resources.OutputResource;
import com.ibm.team.enterprise.build.buildmap.common.model.BuildLog;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildLog;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMapHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFileHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.util.BuildMapSerializer;
import com.ibm.team.enterprise.build.buildmap.common.util.BuildMapUtil;
import com.ibm.team.enterprise.build.client.buildmap.IBuildMapClient;
import com.ibm.team.enterprise.build.common.buildreport.BuildFileXMLModel;
import com.ibm.team.enterprise.build.common.buildreport.BuildReportGenerator;
import com.ibm.team.enterprise.build.common.simulationregistry.ISimulationRegistry;
import com.ibm.team.enterprise.build.common.simulationregistry.ISimulationRegistryFile;
import com.ibm.team.enterprise.build.extensions.client.BuildCacheFactoryEE;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractBuildMapTask
extends AbstractEETask {
    static final Object verrou = 0;
    static final String XML = ".xml";
    static final String BUILDMAP = "buildmap";
    static final String BUILDMAP_EXISTS = ".buildmapExists";
    static final String DBG_CHKOUTCOND = "Checking conditional output: path=%s file=%s if=%s";
    static final String DBG_SKPOUTCOND = "Skipping conditional output: path=%s file=%s if=%s";
    static final String DBG_CHKLOGCOND = "Checking conditional logging: path=%s file=%s if=%s";
    static final String DBG_SKPLOGCOND = "Skipping conditional logging: path=%s file=%s if=%s";
    static final ReentrantReadWriteLock indexexToAddLock = new ReentrantReadWriteLock();
    static final ReentrantLock publishLock = new ReentrantLock();
    static final AtomicInteger indexesToAdd = new AtomicInteger();
    private String buildResultUUID;
    private File fFile;
    private String langDef;
    private String languageCode;
    private String buildableFile;
    private boolean preview;
    private String repositoryAddress;
    private String userId;
    private File passwordFile;
    private String prefix;
    private String certificateFile;
    private boolean smartCard;
    private boolean kerberos;
    private static final int DEFAULT_SIZE = 10;
    private final List<OutputResource> fResources = new ArrayList<OutputResource>(10);
    private final List<BuildLogResource> fLogsResources = new ArrayList<BuildLogResource>(10);
    private final Object buildDefinitionPropertiesLock = new Object();
    private List<String> buildDefinitionProperties;

    protected String getCertificateFile() {
        return this.certificateFile;
    }

    protected void setCertificateFile(String certificateFile) {
        this.certificateFile = certificateFile;
    }

    protected boolean isSmartCard() {
        return this.smartCard;
    }

    protected void setSmartCard(boolean smartCard) {
        this.smartCard = smartCard;
    }

    protected boolean isKerberos() {
        return this.kerberos;
    }

    protected void setKerberos(boolean kerberos) {
        this.kerberos = kerberos;
    }

    public final String getBuildResultUUID() {
        return this.buildResultUUID;
    }

    public final void setBuildResultUUID(String buildResultUUID) {
        this.buildResultUUID = buildResultUUID;
    }

    public File getFile() {
        return this.fFile;
    }

    public void setFile(File file) {
        this.fFile = file;
    }

    public final String getLangDef() {
        return this.langDef;
    }

    public final void setLangDef(String langDef) {
        this.langDef = langDef;
    }

    public final String getLanguageCode() {
        return this.languageCode;
    }

    public final void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public final String getBuildableFile() {
        return this.buildableFile;
    }

    public final void setBuildableFile(String buildableFile) {
        this.buildableFile = buildableFile;
    }

    public final void add(OutputResource outputResource) {
        this.fResources.add(outputResource);
    }

    public final void add(BuildLogResource logResource) {
        this.fLogsResources.add(logResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void doExecute() {
        if (this.buildableFile != null && this.buildableFile.startsWith("&&")) {
            this.logMsg("Do not generate a build map for an inline resource.", 4);
            return;
        }
        if (Boolean.parseBoolean(this.getProject().getProperty("team.enterprise.build.userbuild"))) {
            this.logMsg("Do not generate a build map because it is a userbuild.", 4);
            return;
        }
        this.logMsg("This is not a userbuild, continue with build map", 4);
        Properties temporaryOutputProperties = new Properties();
        try {
            String fullPathName;
            String ifProperty;
            if (!(this.isPreview() || this.fFile != null && this.fFile.isFile() && this.fFile.exists())) {
                this.logMsg("Build map is not found for " + this.getBuildableFile() + ".", 4);
                return;
            }
            IBuildMap buildMap = null;
            if (!this.isPreview()) {
                BuildMapSerializer ser = new BuildMapSerializer();
                URI bmURI = URI.createURI((String)this.fFile.toURI().toString());
                buildMap = ser.deserialize(bmURI);
                this.fFile.delete();
            }
            boolean needCreateBuildMap = !this.isPreview() && !buildMap.isTemporary();
            IFileSystemUtil util = FileSystemUtilFactory.createFileSystemUtil();
            Project project = this.getProject();
            this.prefix = project.getProperty("team.enterprise.scm.resourcePrefix");
            util.setPrefix(this.prefix);
            util.setWorkspaceUuid(project.getProperty("team.enterprise.scm.workspaceUUID"));
            PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)this.getProject());
            boolean isSimulation = Boolean.parseBoolean(project.getProperty("team.enterprise.build.ant.simulationMode"));
            for (OutputResource outputResource : this.fResources) {
                ifProperty = outputResource.getIf();
                if (ifProperty != null && !ifProperty.isEmpty()) {
                    this.logMsg(String.format(DBG_CHKOUTCOND, outputResource.getBuildPath(), outputResource.getBuildFile(), ifProperty), 4);
                    boolean outputIsRelevant = false;
                    if (outputResource.isHFS()) {
                        outputIsRelevant = true;
                        String[] stringArray = ifProperty.split(",");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String property = stringArray[n2];
                            if ((property = property.trim()).length() > 0 && !Boolean.parseBoolean(this.getProject().getProperty(property))) {
                                outputIsRelevant = false;
                                break;
                            }
                            ++n2;
                        }
                    } else if (Boolean.parseBoolean(ifProperty)) {
                        outputIsRelevant = true;
                    }
                    if (!outputIsRelevant) {
                        this.logMsg(String.format(DBG_SKPOUTCOND, outputResource.getBuildPath(), outputResource.getBuildFile(), ifProperty), 4);
                        continue;
                    }
                }
                Object[] unescape = this.unescape(outputResource.isHFS() ? outputResource.getBuildPath() : this.buildFileFullPathNameForBuildMap(outputResource));
                fullPathName = (String)unescape[0];
                if (((Boolean)unescape[1]).booleanValue() && propertyHelper instanceof EEPropertyHelper) {
                    ((EEPropertyHelper)propertyHelper).setIgnoreFiltering(true);
                }
                String resolvedName = propertyHelper.replaceProperties(null, fullPathName, this.getProject().getProperties());
                resolvedName = util.substituteSystemSymbols(resolvedName);
                if (((Boolean)unescape[1]).booleanValue() && propertyHelper instanceof EEPropertyHelper) {
                    ((EEPropertyHelper)propertyHelper).setIgnoreFiltering(false);
                }
                if (outputResource.isHFS()) {
                    String baseDir = this.getProject().getProperty("team.enterprise.build.hfs.outputdir");
                    util.resolveHFSOutputs((Task)this, baseDir, fullPathName, resolvedName, buildMap, outputResource.getResourceDefinitionId(), outputResource.getResourceDefinitionStateId(), this.getBuildDefinitionProperties(), outputResource.getDeployType(), temporaryOutputProperties);
                    continue;
                }
                IOutputBuildFile file = (IOutputBuildFile)IOutputBuildFile.ITEM_TYPE.createItem();
                file.setBuildFile(outputResource.getBuildFile());
                file.setBuildPath(resolvedName);
                if (outputResource.getResourceDefinitionStateId() != null && outputResource.getResourceDefinitionStateId().length() > 0) {
                    file.setResourceDefinitionStateUUID(UUID.valueOf((String)outputResource.getResourceDefinitionStateId()));
                }
                if (outputResource.getResourceDefinitionId() != null && outputResource.getResourceDefinitionId().length() > 0) {
                    file.setResourceDefinitionUUID(UUID.valueOf((String)outputResource.getResourceDefinitionId()));
                } else {
                    AbstractMacroExec exec = (AbstractMacroExec)this.getProject().getReference(this.buildableFile);
                    if (exec != null) {
                        IBuildableResource resource = exec.getBuildableResource();
                        Set<BuildFileXMLModel> files = resource.getInputFiles();
                        for (BuildFileXMLModel f : files) {
                            if (!f.getType().equals("SELF")) continue;
                            file.setResourceDefinitionUUID(UUID.valueOf((String)f.getResourceDefinitionUUID()));
                            break;
                        }
                    }
                }
                file.setOutputType(outputResource.getOutputType());
                file.setSequential(Boolean.valueOf(outputResource.getSequential()).booleanValue());
                file.setHFS(outputResource.isHFS());
                file.setDeployType(outputResource.getDeployType());
                file.setConsumableAsSource(outputResource.isUsedAsInput());
                file.setType("");
                long timestamp = util.lastModified((Task)this, (IBuildFile)file, !this.isPreview());
                temporaryOutputProperties.put(BuildReportGenerator.buildFileFullPathNameForProperties((BuildFileXMLModel)BuildFileUtil.getXMLModelFromOutputBuildFile(file)), String.valueOf(timestamp));
                if (needCreateBuildMap) {
                    file.setTimestamp(new Timestamp(timestamp));
                    Reference ref = outputResource.getRefid();
                    if (ref == null || "".equals(ref.getRefId())) {
                        file.setPromotionBuildPath(fullPathName);
                    } else {
                        file.setPromotionBuildPath("${" + ref.getRefId() + "}");
                    }
                    this.addIntrospectionInformation((IBuildFile)file);
                } else if (buildMap.isTemporary()) {
                    file.setTimestamp(new Timestamp(timestamp));
                }
                if (this.isPreview() || this.skipOutputMissinginSimBld(util, isSimulation, file) || !util.doesFileExist((Task)this, file)) continue;
                buildMap.getOutputs().add(file);
            }
            if (buildMap != null) {
                int n;
                int n3 = -1;
                try {
                    n = Integer.parseInt(this.getProject().getProperty("team.enterprise.build.maxNumOutputs"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n > 0 && buildMap.getOutputs().size() > n) {
                    throw new BuildException(NLS.bind((String)Messages.TOO_MANY_OUTPUTS_ERROR, (Object[])new Object[]{this.buildableFile, buildMap.getOutputs().size(), n, "team.enterprise.build.maxNumOutputs"}));
                }
            }
            if (!this.isPreview() && !isSimulation && this.fLogsResources != null) {
                for (BuildLogResource buildLogResource : this.fLogsResources) {
                    ifProperty = buildLogResource.getIf();
                    if (ifProperty != null && !ifProperty.isEmpty()) {
                        this.logMsg(String.format(DBG_CHKLOGCOND, buildLogResource.getLogPath(), buildLogResource.getLogFile(), ifProperty), 4);
                        if (!Boolean.parseBoolean(ifProperty)) {
                            this.logMsg(String.format(DBG_SKPLOGCOND, buildLogResource.getLogPath(), buildLogResource.getLogFile(), ifProperty), 4);
                            continue;
                        }
                    }
                    BuildLog buildLog = (BuildLog)IBuildLog.ITEM_TYPE.createItem();
                    fullPathName = this.getBuildLogFullPathNameForBuildMap(buildLogResource);
                    String resolvedName = propertyHelper.replaceProperties(null, fullPathName, this.getProject().getProperties());
                    resolvedName = util.substituteSystemSymbols(resolvedName);
                    buildLog.setLogPath(resolvedName);
                    buildLog.setLogFile(buildLogResource.getLogFile());
                    if (buildLogResource.getResourceDefinitionStateId() != null && buildLogResource.getResourceDefinitionStateId().length() > 0) {
                        buildLog.setResourceDefinitionStateUUID(UUID.valueOf((String)buildLogResource.getResourceDefinitionStateId()));
                    }
                    if (buildLogResource.getResourceDefinitionId() != null && buildLogResource.getResourceDefinitionId().length() > 0) {
                        buildLog.setResourceDefinitionUUID(UUID.valueOf((String)buildLogResource.getResourceDefinitionId()));
                    }
                    if (buildLogResource.getTranslatorId() != null && buildLogResource.getTranslatorId().length() > 0) {
                        buildLog.setTranslatorUUID(UUID.valueOf((String)buildLogResource.getTranslatorId()));
                    }
                    if (buildLogResource.getTranslatorStateId() != null && buildLogResource.getTranslatorStateId().length() > 0) {
                        buildLog.setTranslatorStateUUID(UUID.valueOf((String)buildLogResource.getTranslatorStateId()));
                    }
                    buildLog.setDdIndex(buildLogResource.getDdIndex());
                    buildLog.setHost((String)this.getProject().getProperties().get("buildEngineHostName"));
                    buildLog.setType(buildLogResource.getType());
                    buildLog.setSequential(Boolean.valueOf(buildLogResource.getSequential()).booleanValue());
                    buildLog.setCompacted(buildLogResource.isCompacted());
                    IOutputBuildFile tempOutput = (IOutputBuildFile)IOutputBuildFile.ITEM_TYPE.createItem();
                    tempOutput.setBuildFile(buildLog.getLogFile());
                    tempOutput.setBuildPath(buildLog.getLogPath());
                    tempOutput.setOutputType(buildLog.getType());
                    tempOutput.setSequential(buildLog.isSequential());
                    long timestamp = util.lastModified((Task)this, (IBuildFile)tempOutput, !this.isPreview());
                    buildLog.setTimestamp(new Timestamp(timestamp));
                    buildMap.getLogs().add(buildLog);
                }
            }
            Object object = verrou;
            synchronized (object) {
                try {
                    Properties outputsProperties = BuildableResource.loadGeneratedOutputProperties(this.getProject());
                    outputsProperties.putAll((Map<?, ?>)temporaryOutputProperties);
                    BuildableResource.storeGeneratedOutputProperties(this.getProject(), outputsProperties);
                }
                catch (FileNotFoundException e1) {
                    throw new BuildException((Throwable)e1);
                }
                catch (IOException e1) {
                    throw new BuildException((Throwable)e1);
                }
            }
            if (needCreateBuildMap) {
                ITeamRepository iTeamRepository = InitTask.getInstance().getTeamRepository();
                IBuildMapClient buildMapClient = (IBuildMapClient)iTeamRepository.getClientLibrary(IBuildMapClient.class);
                IBuildMap existingBuildMap = buildMapClient.getBuildMap(buildMap.getBuildableFile().getItemId(), buildMap.getBuildDefinition().getItemId(), null);
                Set removedBuildLogs = null;
                if (existingBuildMap != null) {
                    this.logMsg("found an existing buildmap", 4);
                    existingBuildMap = (IBuildMap)existingBuildMap.getWorkingCopy();
                    removedBuildLogs = BuildMapUtil.mergeBuildLogs((List)buildMap.getLogs(), (List)existingBuildMap.getLogs(), (boolean)false);
                    buildMap = BuildMapUtil.mergeIntoComplete((IBuildMap)buildMap, (IBuildMap)existingBuildMap);
                }
                this.logMsg(buildMap.toString(), 4);
                this.logMsg("Before buildmap save:" + buildMap.getInputs().size() + (buildMap.getInputs().size() < 1 ? " inputs." : " inputs,input[" + (buildMap.getInputs().size() - 1) + "]=" + ((IInputBuildFileHandle)buildMap.getInputs().get(buildMap.getInputs().size() - 1)).toString()), 4);
                IBuildMapHandle bmh = null;
                boolean postCompile = false;
                String postCompileFile = project.getProperty("team.enterprise.build.ant.postCompileFile");
                if (postCompileFile == null || postCompileFile.isEmpty()) {
                    this.logMsg("postCompileFile not defined", 4);
                } else {
                    this.logMsg("postCompileFile defined as " + postCompileFile, 2);
                    postCompile = true;
                }
                if (postCompile) {
                    this.logMsg("saving buildmap to cache", 4);
                    String buildResultUUID = project.getProperty("buildResultUUID");
                    IBuildResultHandle brh = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildResultUUID), null);
                    BuildCacheFactoryEE.addBuildMap((ITeamRepository)iTeamRepository, (IBuildResultHandle)brh, (IBuildMap)buildMap);
                    BuildCache.getInstance().set(buildMap.getLanguageDefinitionUUID().getUuidValue(), (Object)this.getLangDef());
                    BuildCache.getInstance().set(buildMap.getBuildableFile().getItemId().getUuidValue(), (Object)this.getBuildableFile());
                    bmh = (IBuildMapHandle)buildMap.getItemHandle();
                } else {
                    this.logMsg("saving buildmap", 4);
                    bmh = buildMapClient.saveBuildMap(buildMap, null);
                    String publicUriRoot = BuildReportUtils.getPublicUriRoot(project);
                    String buildMapURL = BuildReportUtils.getBuildMapUrl(project, bmh);
                    String buildMapURI = BuildReportUtils.getBuildMapUri(project, bmh, publicUriRoot);
                    String label = BuildReportUtils.getBuildMapLabel(this.getLangDef(), this.getBuildableFile());
                    this.logMsg("buildMapURL = " + buildMapURL, 4);
                    BuildReportUtils.publishBuildMapLinks(project, buildMapURI, label);
                    BuildReportUtils.gatherInformationForBuildReport(project, buildMap, buildMapURL);
                    BuildReportExtendedContributionCallable.incrementProcessedCount(null);
                    BuildReportExtendedContributionCallable.run(AbstractBuildMapTask.getExecutor(), false);
                }
                if (removedBuildLogs != null && removedBuildLogs.size() > 0) {
                    buildMapClient.deleteBuildLogs(removedBuildLogs, null);
                }
            } else if (buildMap != null && buildMap.isTemporary()) {
                void var8_27;
                BuildReportUtils.gatherInformationForBuildReport(project, buildMap, null);
                String string = "";
                List inputs = buildMap.getInputs();
                for (IInputBuildFileHandle input : inputs) {
                    void var8_25;
                    IInputBuildFile file = (IInputBuildFile)input;
                    if (!"SELF".equals(file.getType())) continue;
                    if (file.isHFS()) {
                        String string2 = file.getSCMLocation();
                    } else {
                        String string3 = String.valueOf(file.getBuildPath()) + "(" + file.getBuildFile() + ")";
                    }
                    String string4 = util.substituteSystemSymbols((String)var8_25);
                    break;
                }
                BuildReportExtendedContributionCallable.incrementProcessedCount((String)var8_27);
                BuildReportExtendedContributionCallable.run(AbstractBuildMapTask.getExecutor(), false);
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new BuildException((Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private boolean skipOutputMissinginSimBld(IFileSystemUtil util, boolean isSimulation, IOutputBuildFile file) {
        boolean result = false;
        if (isSimulation && SimulationUtil.isSimulationBuildOutputCheck((Task)this) && !file.isSequential()) {
            String outputNativePath = null;
            try {
                ISimulationRegistry registry = SimulationUtil.getRegistry();
                for (ISimulationRegistryFile regFile : registry) {
                    try {
                        if (regFile.isHFS() != file.isHFS() || !regFile.getBuildFile().equals(file.getBuildFile()) || !regFile.getBuildPath().equals(file.getBuildPath())) continue;
                        boolean exists = util.fileExists((Task)this, regFile);
                        result = !exists;
                        outputNativePath = regFile.getNativePath();
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                this.logMsg("Couldn't determine whether the binary exists for " + this.buildableFile, e, 1);
                result = false;
            }
            if (result) {
                this.logMsg(NLS.bind((String)"The following output does not exist in the filesystem and will not be added to the buildmap: {0}", outputNativePath), 2);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBuildDefinitionProperties() throws TeamRepositoryException {
        Object object = this.buildDefinitionPropertiesLock;
        synchronized (object) {
            if (this.buildDefinitionProperties == null) {
                this.buildDefinitionProperties = new ArrayList<String>();
                IBuildResultHandle resultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.buildResultUUID), null);
                IBuildResult result = (IBuildResult)InitTask.getInstance().getTeamRepository().itemManager().fetchPartialItem((IItemHandle)resultHandle, 0, Arrays.asList(IBuildResult.PROPERTY_BUILD_REQUESTS), null);
                if (result.getBuildRequests().size() > 0) {
                    IBuildRequestHandle requestHandle = (IBuildRequestHandle)result.getBuildRequests().get(0);
                    IBuildRequest request = (IBuildRequest)InitTask.getInstance().getTeamRepository().itemManager().fetchPartialItem((IItemHandle)requestHandle, 0, Arrays.asList(IBuildRequest.PROPERTY_BUILD_DEFINITION_INSTANCE), null);
                    for (IBuildProperty property : request.getBuildDefinitionInstance().getProperties()) {
                        this.buildDefinitionProperties.add(property.getName());
                    }
                }
            }
        }
        return this.buildDefinitionProperties;
    }

    private String buildFileFullPathNameForBuildMap(OutputResource res) {
        String suffix;
        String s = res.getBuildPath();
        if (s.endsWith(suffix = "(" + res.getBuildFile() + ")")) {
            s = s.substring(0, s.lastIndexOf("("));
        }
        if (res.isPrefix()) {
            s = "${team.enterprise.scm.resourcePrefix}." + s;
        } else if (this.prefix != null && s.startsWith(this.prefix)) {
            s = "${team.enterprise.scm.resourcePrefix}" + s.substring(this.prefix.length());
        }
        return s;
    }

    private String getBuildLogFullPathNameForBuildMap(BuildLogResource res) {
        String s = res.getLogPath();
        if (res.isPrefix()) {
            s = "${team.enterprise.scm.resourcePrefix}." + s;
        } else if (this.prefix != null && s.startsWith(this.prefix)) {
            s = "${team.enterprise.scm.resourcePrefix}" + s.substring(this.prefix.length());
        }
        return s;
    }

    private Object[] unescape(String value) {
        boolean wasUnescaped = false;
        String decoded = value;
        if (value != null && value.startsWith("ENC:\\")) {
            try {
                decoded = URLDecoder.decode(value.substring("ENC:\\".length()), "UTF-8");
                wasUnescaped = true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new Object[]{decoded, wasUnescaped};
    }

    public String getRepositoryAddress() {
        return this.repositoryAddress;
    }

    public void setRepositoryAddress(String repositoryAddress) {
        this.repositoryAddress = repositoryAddress;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public File getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(File passwordFile) {
        this.passwordFile = passwordFile;
    }

    protected abstract void addIntrospectionInformation(IBuildFile var1);
}

