/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.process;

import com.ibm.team.enterprise.build.ant.process.AbstractBuildProcess;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tools.ant.launch.AntMain;
import org.apache.tools.ant.launch.Launcher;

public class AntBuildProcess
extends AbstractBuildProcess {
    private static ClassLoader antClassLoader = null;
    private static final String ANT_MAIN = "com.ibm.team.enterprise.build.ant.process.AntBuildMain";
    private static final String PERSISTENT_JVM_LOG_TAG = "-using_pjvm";
    private static final PrintStream defaultErr = System.err;
    private static final String PJVM_ERR = "PJVM_ERR";
    private static final String PJVM_GOOD = "PJVM_GOOD";

    @Override
    public void runProcess(String processCommand) throws Exception {
        this.debug("+AntBuildProcess.runProcess(" + processCommand + ")");
        StringTokenizer t = new StringTokenizer(processCommand);
        ArrayList<String> commandArgList = new ArrayList<String>();
        String[] ignore = new String[]{"--nouserlib", "-nouserlib", "--launchdiag", "--noclasspath", "-noclasspath"};
        String[] ignoreNext = new String[]{"-lib", "-cp", "-main"};
        while (t.hasMoreTokens()) {
            String arg = t.nextToken();
            if (arg.equals(PERSISTENT_JVM_LOG_TAG)) {
                AntBuildProcess.setupErr();
                continue;
            }
            if (antClassLoader != null) {
                if (Arrays.asList(ignoreNext).contains(arg)) {
                    t.nextToken();
                    continue;
                }
                if (Arrays.asList(ignore).contains(arg)) continue;
                commandArgList.add(arg);
                continue;
            }
            commandArgList.add(arg);
        }
        if (antClassLoader == null) {
            commandArgList.add("-main");
            commandArgList.add(ANT_MAIN);
        }
        Object[] commandArgs = new String[commandArgList.size()];
        commandArgList.toArray(commandArgs);
        this.debug("Args = " + Arrays.toString(commandArgs));
        this.debug("Executing script with env var. . ");
        Map<String, String> env = System.getenv();
        for (String envName : env.keySet()) {
            this.debug(String.valueOf(envName) + "=" + env.get(envName));
        }
        try {
            try {
                if (antClassLoader == null) {
                    Launcher.main((String[])commandArgs);
                } else {
                    Class<?> mainClass = antClassLoader.loadClass(ANT_MAIN);
                    AntMain main = (AntMain)mainClass.newInstance();
                    main.startAnt((String[])commandArgs, null, null);
                }
            }
            catch (SecurityException mainClass) {
                AntBuildProcess.resetErr();
                antClassLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception e) {
                throw e;
            }
        }
        finally {
            AntBuildProcess.resetErr();
            antClassLoader = Thread.currentThread().getContextClassLoader();
        }
    }

    public static void main(String[] args) throws IOException {
        AntBuildProcess process = new AntBuildProcess();
        if (args.length > 0 && args[0].equals("-debug")) {
            process.debug = true;
        }
        process.run();
    }

    private static void setupErr() {
        System.setErr(new MyPrintStream(new MyErrorStream(System.out)));
    }

    private static void resetErr() {
        if (!System.err.equals(defaultErr)) {
            System.err.flush();
            System.err.close();
        }
        System.setErr(defaultErr);
    }

    private static class MyErrorStream
    extends OutputStream {
        private final PrintStream toPrint;
        private boolean flag;

        public MyErrorStream(PrintStream set) {
            this.toPrint = set;
            this.flag = false;
        }

        @Override
        public void write(int b) {
            this.toPrint.write(b);
            this.flag = true;
        }

        @Override
        public void write(byte[] b) {
            try {
                this.toPrint.write(b);
                this.flag = true;
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.toPrint.write(b, off, len);
            this.flag = true;
        }

        @Override
        public void flush() {
            this.toPrint.flush();
        }

        @Override
        public void close() {
            if (this.flag) {
                System.out.println(AntBuildProcess.PJVM_ERR);
            } else {
                System.out.println(AntBuildProcess.PJVM_GOOD);
            }
        }
    }

    private static class MyPrintStream
    extends PrintStream {
        OutputStream outStream;

        public MyPrintStream(OutputStream out) {
            super(out);
            this.outStream = out;
        }

        @Override
        public void close() {
            try {
                this.outStream.close();
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
        }
    }
}

