/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.internal.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class VariableUtil {
    private static final String VARIABLE_FLAG = "&";

    public static boolean isAntProperty(String name) {
        return name.startsWith("${") && name.endsWith("}");
    }

    public static String extractAntPropertyName(String name) {
        if (!VariableUtil.isAntProperty(name)) {
            return name;
        }
        if (name.trim().equals("${}")) {
            return "";
        }
        return name.substring(2, name.trim().length() - 1);
    }

    public static boolean isVariable(String name) {
        return name.startsWith(VARIABLE_FLAG);
    }

    public static boolean isValidNameChar(char c) {
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || Character.isDigit(c) || '_' == c;
    }

    public static String substituteVars(String str, HashMap<String, String> map, Task task) {
        String result;
        String prevResult = result = str;
        HashMap<String, String> tempMap = new HashMap<String, String>(map);
        int size = tempMap.size();
        task.log("substituteVars - map size: " + size, 4);
        int i = 0;
        while (i < size) {
            task.log("substituteVars - loop # : " + (i + 1) + " - number of elements: " + tempMap.size(), 4);
            result = VariableUtil.internalSubstituteVars(result, tempMap, task);
            task.log("substituteVars - result=" + result, 4);
            task.log("substituteVars - previous result=" + prevResult, 4);
            if (result.equals(prevResult)) break;
            prevResult = result;
            ++i;
        }
        return result;
    }

    private static String internalSubstituteVars(String str, HashMap<String, String> map, Task task) {
        String result = str;
        Set<String> keys = map.keySet();
        Iterator<String> iterator = keys.iterator();
        while (iterator != null && iterator.hasNext()) {
            String currentKey = iterator.next();
            String currentValue = map.get(currentKey);
            Pattern p = Pattern.compile(String.valueOf(currentKey) + "\\.?", 66);
            Matcher m = p.matcher(result);
            StringBuffer sb = new StringBuffer();
            boolean isAntProperty = false;
            boolean isFoundMatch = false;
            while (m.find()) {
                char followOnChar;
                isFoundMatch = true;
                int last = m.end();
                if (last < result.length() && VariableUtil.isValidNameChar(followOnChar = result.charAt(last)) && result.charAt(last - 1) != '.') continue;
                if (VariableUtil.isAntProperty(currentValue)) {
                    String antPropertyValue = task.getProject().getProperty(VariableUtil.extractAntPropertyName(currentValue));
                    if (antPropertyValue != null) {
                        result = m.replaceAll(Matcher.quoteReplacement(antPropertyValue));
                        break;
                    }
                    task.log("ERROR: Ant property not set: " + currentValue, 0);
                    result = m.replaceAll(Matcher.quoteReplacement(""));
                    isAntProperty = true;
                    break;
                }
                m.appendReplacement(sb, Matcher.quoteReplacement(currentValue));
            }
            if (!isAntProperty) {
                m.appendTail(sb);
                result = sb.toString();
            }
            if (!isFoundMatch) continue;
            iterator.remove();
        }
        return result;
    }

    public static String getValueWithVariables(String source, int level, Map<String, String> jobProperties, Project project) throws Exception {
        String result = null;
        if (source == null || source.length() == 0 || project == null || jobProperties == null) {
            return result;
        }
        if (!source.contains("@{") && !source.contains("${")) {
            return source;
        }
        --level;
        Matcher paraMatch = VariableUtil.getMatcher(source, "@\\{([-0-9a-zA-Z_.]+)\\}|\\$\\{([-0-9a-zA-Z_.]+)\\}");
        StringBuffer sb = new StringBuffer();
        while (paraMatch.find()) {
            String antProNAme;
            String jobProName = paraMatch.group(1);
            if (jobProName != null) {
                result = jobProperties.get(jobProName.toLowerCase());
                if (level > -1) {
                    result = VariableUtil.getValueWithVariables(result, level, jobProperties, project);
                }
                paraMatch.appendReplacement(sb, result);
            }
            if ((antProNAme = paraMatch.group(2)) == null) continue;
            result = project.getProperty(antProNAme);
            if (level > -1) {
                result = VariableUtil.getValueWithVariables(result, level, jobProperties, project);
            }
            paraMatch.appendReplacement(sb, result);
        }
        paraMatch.appendTail(sb);
        result = sb.toString();
        return result;
    }

    public static Matcher getMatcher(String listStr, String pattern) {
        Pattern p = Pattern.compile(pattern, 34);
        Matcher m = p.matcher(listStr);
        return m;
    }
}

