/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.internal.utils;

import com.ibm.team.enterprise.build.ant.agent.StaticResetAgent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class StaticMemoryReset {
    private static final String INTERFACE = "IStaticReset";
    private static final String METHOD_NAME = "staticMemoryReset";
    private static final int MAX_THREAD = 1;
    private static String fileName = null;
    private static String logPath = null;

    private static void setFileName(String newName) {
        if (logPath != null) {
            fileName = String.valueOf(logPath) + "/" + newName;
        }
    }

    private static void setLogPath(String path) {
        logPath = path;
    }

    private static void log(Object o) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName, true));
            writer.append(o.toString());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void inspectClasses(String fName, Class[] classes) {
        StaticMemoryReset.setFileName(fName);
        File tmp = new File(fileName);
        if (tmp.exists()) {
            tmp.delete();
        }
        ArrayList<JSON> jsonList = new ArrayList<JSON>();
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            Field[] fields = clazz.getDeclaredFields();
            Boolean containsStatic = Arrays.stream(fields).anyMatch(f -> StaticMemoryReset.filterField(f, clazz));
            if (containsStatic.booleanValue()) {
                JSON json = new JSON();
                json.put("name", clazz.getSimpleName());
                json.put("path", clazz.getCanonicalName());
                ArrayList<String> staticFields = new ArrayList<String>();
                Field[] fieldArray = fields;
                int n3 = fields.length;
                int n4 = 0;
                while (n4 < n3) {
                    Field field = fieldArray[n4];
                    field.setAccessible(true);
                    if (StaticMemoryReset.filterField(field, clazz)) {
                        try {
                            if (field.get(null) != null) {
                                staticFields.add(String.valueOf(field.getName()) + " : " + field.get(null).toString());
                            } else {
                                staticFields.add(String.valueOf(field.getName()) + " : null");
                            }
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n4;
                }
                json.put("static fields", staticFields.toArray());
                jsonList.add(json);
            }
            ++n2;
        }
        StaticMemoryReset.log(JSON.jsonify("allClasses", jsonList));
    }

    private static boolean filterField(Field field, Class clazz) {
        return Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers()) && !field.getType().equals(String.class) && !Arrays.stream(clazz.getInterfaces()).anyMatch(c -> c.getName().contains(INTERFACE));
    }

    public static void debug(String log) {
        if (log != null) {
            StaticMemoryReset.setLogPath(log);
            Class[] classes = StaticResetAgent.getClasses();
            StaticMemoryReset.inspectClasses("loadedClasses.json", classes);
        }
    }

    public static void reset() {
        Class[] classes = StaticResetAgent.getClasses();
        int i = 0;
        int j = classes.length;
        int groupSize = j / 1;
        int t = 0;
        while (t < 1) {
            if (i + groupSize <= j - groupSize && t + 1 < 1) {
                StaticMemoryReset.createThread(i, i + groupSize, classes);
            } else {
                StaticMemoryReset.createThread(i, j, classes);
            }
            i += groupSize;
            ++t;
        }
    }

    public static void createThread(final int i, final int j, final Class[] classes) {
        Thread t = new Thread(){

            @Override
            public void run() {
                int ci = i;
                while (ci < j) {
                    Class clazz = classes[ci];
                    Class<?>[] classArray = clazz.getInterfaces();
                    int n = classArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> c = classArray[n2];
                        if (c.getName().contains(StaticMemoryReset.INTERFACE)) {
                            try {
                                Method callMe = clazz.getMethod(StaticMemoryReset.METHOD_NAME, new Class[0]);
                                if (callMe != null) {
                                    callMe.invoke(null, new Object[0]);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ++n2;
                    }
                    ++ci;
                }
            }
        };
        t.start();
    }

    private static class JSON {
        private static final String OPENC = "{";
        private static final String CLOSEC = "}";
        private static final String OPENB = "[";
        private static final String CLOSEB = "]";
        private static final String COLON = ":";
        private static final String COMMA = ",";
        private static final String TAB = "\t";
        private static final String NEWLINE = "\n";
        private static final String QUOTE = "\"";
        HashMap<String, Object[]> backingMap = new HashMap();

        public static String jsonify(String name, ArrayList<JSON> jsons) {
            StringBuilder json = new StringBuilder();
            json.append(OPENC);
            json.append(NEWLINE);
            json.append(TAB);
            json.append(JSON.quotify("name"));
            json.append(COLON);
            json.append(JSON.quotify(name));
            json.append(COMMA);
            json.append(NEWLINE);
            json.append(TAB);
            json.append(JSON.quotify("classes"));
            json.append(COLON);
            json.append(OPENB);
            json.append(NEWLINE);
            int j = 0;
            while (j < jsons.size()) {
                json.append(jsons.get(j).create());
                if (j < jsons.size() - 1) {
                    json.append(COMMA);
                }
                json.append(NEWLINE);
                ++j;
            }
            json.append(TAB);
            json.append(CLOSEB);
            json.append(NEWLINE);
            json.append(CLOSEC);
            return json.toString();
        }

        public void put(String s1, String s2) {
            this.backingMap.put(s1, new String[]{s2});
        }

        public void put(String s1, Object[] s2) {
            this.backingMap.put(s1, s2);
        }

        private static String quotify(Object s) {
            String regex = "[^\\w|:|.|\\[|\\]|,]";
            return s == null ? "\"null\"" : QUOTE + s.toString().replace(QUOTE, "").replace(NEWLINE, "").replaceAll(regex, "") + QUOTE;
        }

        public String create() {
            StringBuilder json = new StringBuilder();
            json.append(NEWLINE);
            json.append("\t{");
            json.append(NEWLINE);
            int counter = 0;
            for (String key : this.backingMap.keySet()) {
                ++counter;
                if (this.backingMap.get(key).length == 1) {
                    json.append("\t\t");
                    json.append(JSON.quotify(key));
                    json.append(COLON);
                    json.append(JSON.quotify(this.backingMap.get(key)[0]));
                    if (counter < this.backingMap.size()) {
                        json.append(COMMA);
                    }
                    json.append(NEWLINE);
                    continue;
                }
                json.append("\t\t");
                json.append(JSON.quotify(key));
                json.append(COLON);
                json.append(OPENB);
                json.append(NEWLINE);
                int i = 0;
                while (i < this.backingMap.get(key).length) {
                    json.append("\t\t\t");
                    json.append(JSON.quotify(this.backingMap.get(key)[i].toString()));
                    if (i < this.backingMap.get(key).length - 1) {
                        json.append(COMMA);
                    }
                    json.append(NEWLINE);
                    ++i;
                }
                json.append("\t\t]");
                if (counter < this.backingMap.size()) {
                    json.append(COMMA);
                }
                json.append(NEWLINE);
            }
            json.append("\t}");
            return json.toString();
        }
    }
}

