/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.internal.utils;

import com.ibm.team.build.common.IStaticReset;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile;
import com.ibm.team.enterprise.build.common.simulationregistry.ISimulationRegistry;
import com.ibm.team.enterprise.build.common.simulationregistry.ISimulationRegistryFile;
import com.ibm.team.enterprise.build.common.simulationregistry.util.SimulationRegistryUtil;
import org.apache.tools.ant.Task;

public class SimulationUtil
implements IStaticReset {
    private static final long timestamp = System.currentTimeMillis();
    private static boolean isSimulationMode = System.getProperty("scmee.simulate") != null;
    private static Boolean isSimulationBuildOutputCheck;
    private static ISimulationRegistry registry;

    private SimulationUtil() {
    }

    public static void delete(IBuildFile buildFile) {
    }

    public static boolean exists(IBuildFile buildFile, String nativePath) {
        if (registry == null) {
            return false;
        }
        ISimulationRegistryFile file = SimulationRegistryUtil.createFile((IBuildFile)buildFile, (long)timestamp, (String)nativePath);
        return registry.contains(file);
    }

    public static boolean exists(String buildFile, String buildPath, String nativePath, boolean isHFS) {
        if (registry == null) {
            return false;
        }
        ISimulationRegistryFile file = SimulationRegistryUtil.createFile((String)buildFile, (String)buildPath, (long)timestamp, (String)nativePath, (boolean)isHFS);
        return registry.contains(file);
    }

    public static long lastModified(IBuildFile buildFile, boolean save, String nativePath) {
        if (registry == null) {
            return 0L;
        }
        ISimulationRegistryFile simFile = SimulationRegistryUtil.createFile((IBuildFile)buildFile, (long)timestamp, (String)nativePath);
        ISimulationRegistryFile resolvedFile = registry.findFile(simFile);
        if (save && resolvedFile == null) {
            registry.add(simFile);
            resolvedFile = simFile;
        }
        return resolvedFile == null ? timestamp : resolvedFile.getTimestamp();
    }

    public static void addToRegistry(IBuildFile buildFile, long timestamp, String nativePath) {
        registry.add(SimulationRegistryUtil.createFile((IBuildFile)buildFile, (long)timestamp, (String)nativePath));
    }

    public static void setRegistry(ISimulationRegistry registry) {
        SimulationUtil.registry = registry;
    }

    public static ISimulationRegistry getRegistry() {
        return registry;
    }

    public static long getTimestamp() {
        return timestamp;
    }

    public static boolean isSimulationMode() {
        return isSimulationMode;
    }

    public static boolean isSimulationBuildOutputCheck(Task task) {
        if (isSimulationBuildOutputCheck == null) {
            isSimulationBuildOutputCheck = Boolean.valueOf(task.getProject().getProperty("team.enterprise.build.ant.simulationModeBinaryCheck"));
        }
        return isSimulationBuildOutputCheck;
    }

    public static void setIsSimulationMode(boolean value) {
        isSimulationMode = value;
    }

    public static void staticMemoryReset() {
        isSimulationMode = System.getProperty("scmee.simulate") != null;
        isSimulationBuildOutputCheck = null;
        registry = null;
    }
}

