/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.internal.utils;

import com.ibm.team.enterprise.build.ant.IBuildableResource;
import com.ibm.team.enterprise.build.ant.types.resources.BuildableResource;
import com.ibm.team.enterprise.build.common.buildreport.BuildFileXMLModel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OperationListParser {
    private static final String LOAD_WORKSPACE_ELEMENT = "loadWorkspace";
    private static final String LOAD_FILES_ELEMENT = "loadFiles";
    private static final String WORKSPACE_UUID_ATTRIBUTE = "workspaceUUID";
    private static final String DATA_SET_PREFIX_ATTRIBUTE = "dataSetPrefix";
    private static final String HFS_DESTINATION_ATTRIBUTE = "HFSDestination";
    private static final String LOAD_HFS_ATTRIBUTE = "loadHFS";
    private static final String LOAD_LIBRARY_ATTRIBUTE = "loadLibrary";
    private static final String FILE_ELEMENT = "file";
    private static final String COMPONENT_NAME_ATTRIBUTE = "componentName";
    private static final String FILE_PATH_ATTRIBUTE = "filePath";
    private static final String FILE_UUID_ATTRIBUTE = "fileUUID";
    private static final String FILE_STATE_UUID_ATTRIBUTE = "fileStateUUID";
    private final File operationListFile;
    private String workspaceID;
    private String datasetPrefix;
    private String destinationHFS;
    private boolean loadHFS;
    private boolean loadLibrary;
    private boolean hasAnythingToLoad;
    private final List<IBuildableResource> filesToLoad = new ArrayList<IBuildableResource>();

    public OperationListParser(File operationListFile) {
        this.operationListFile = operationListFile;
    }

    public String getWorkspaceID() {
        return this.workspaceID;
    }

    public String getDatasetPrefix() {
        return this.datasetPrefix;
    }

    public String getDestinationHFS() {
        return this.destinationHFS;
    }

    public boolean isLoadHFS() {
        return this.loadHFS;
    }

    public boolean isLoadLibaray() {
        return this.loadLibrary;
    }

    public List<IBuildableResource> getFilesToLoad() {
        return this.filesToLoad;
    }

    public boolean hasAnythingToLoad() {
        return this.hasAnythingToLoad;
    }

    public void parse() throws Exception {
        Element element;
        Node node;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        Document operationList = docBuilderFactory.newDocumentBuilder().parse(this.operationListFile);
        NodeList list = operationList.getElementsByTagName(LOAD_WORKSPACE_ELEMENT);
        int i = 0;
        while (i < list.getLength()) {
            node = list.item(i);
            if (node.getNodeType() == 1) {
                element = (Element)node;
                this.loadWorkspace(element);
            }
            ++i;
        }
        list = operationList.getElementsByTagName(LOAD_FILES_ELEMENT);
        i = 0;
        while (i < list.getLength()) {
            node = list.item(i);
            if (node.getNodeType() == 1) {
                element = (Element)node;
                this.loadFiles(element);
            }
            ++i;
        }
    }

    private void loadWorkspace(Element element) {
        this.hasAnythingToLoad = true;
        this.workspaceID = element.getAttribute(WORKSPACE_UUID_ATTRIBUTE);
        this.datasetPrefix = element.getAttribute(DATA_SET_PREFIX_ATTRIBUTE);
        this.destinationHFS = element.getAttribute(HFS_DESTINATION_ATTRIBUTE);
        this.loadHFS = Boolean.parseBoolean(element.getAttribute(LOAD_HFS_ATTRIBUTE));
        this.loadLibrary = Boolean.parseBoolean(element.getAttribute(LOAD_LIBRARY_ATTRIBUTE));
    }

    private void loadFiles(Element element) {
        NodeList list = element.getElementsByTagName(FILE_ELEMENT);
        if (list != null && list.getLength() > 0) {
            this.hasAnythingToLoad = true;
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.getNodeType() == 1) {
                    int index;
                    Element file = (Element)node;
                    String componentName = file.getAttribute(COMPONENT_NAME_ATTRIBUTE);
                    String fileUUID = file.getAttribute(FILE_UUID_ATTRIBUTE);
                    String fileStateUUID = file.getAttribute(FILE_STATE_UUID_ATTRIBUTE);
                    String filePath = file.getAttribute(FILE_PATH_ATTRIBUTE);
                    String fileName = null;
                    if (filePath != null && (index = filePath.lastIndexOf(47)) > 0) {
                        fileName = filePath.substring(index + 1);
                    }
                    BuildableResource res = new BuildableResource();
                    res.setBuildFile(fileName);
                    res.setBuildPath(filePath);
                    res.setComponentName(componentName);
                    res.setUuid(fileUUID);
                    BuildFileXMLModel f = new BuildFileXMLModel();
                    f.setBuildFile(fileName);
                    f.setBuildPath(filePath);
                    f.setComponentName(componentName);
                    f.setFileUUID(fileUUID);
                    f.setFileStateUUID(fileStateUUID);
                    res.getInputFiles().add(f);
                    this.filesToLoad.add(res);
                }
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        try {
            new OperationListParser(new File("C:/tmp/FAOperationList.xml")).parse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

