/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.internal.utils;

import com.ibm.team.build.common.IStaticReset;
import com.ibm.team.enterprise.build.ant.IFileSystemUtil;
import org.apache.tools.ant.BuildException;

public final class FileSystemUtilFactory
implements IStaticReset {
    private static final String IBMI_FILE_SYSTEM_UTIL = "com.ibm.teamp.build.ant.ibmi.utils.FileSystemUtil";
    private static final String ZOS_FILE_SYSTEM_UTIL = "com.ibm.team.enterprise.zos.build.ant.internal.utils.FileSystemUtil";
    private static final String GET_INSTANCE_METHOD = "getInstance";
    private static final String PLATFORM_Z = "z/OS";
    private static IFileSystemUtil util = null;

    private FileSystemUtilFactory() {
    }

    public static IFileSystemUtil createFileSystemUtil() {
        if (util == null) {
            try {
                util = FileSystemUtilFactory.isRunningOnZ() ? (IFileSystemUtil)Class.forName(ZOS_FILE_SYSTEM_UTIL).getMethod(GET_INSTANCE_METHOD, null).invoke(null, null) : (IFileSystemUtil)Class.forName(IBMI_FILE_SYSTEM_UTIL).getMethod(GET_INSTANCE_METHOD, null).invoke(null, null);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        return util;
    }

    public static void deleteFileSystemUtil() {
        util = null;
    }

    public static boolean isRunningOnZ() {
        try {
            String osOverride = System.getProperty("junit.os.override");
            String osName = osOverride == null ? System.getProperty("os.name") : osOverride;
            return PLATFORM_Z.equalsIgnoreCase(osName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void staticMemoryReset() {
        util = null;
    }
}

