/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.internal.utils;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.publishing.ContentPublisher;
import com.ibm.team.build.internal.publishing.LinkPublisher;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildFileUtil;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildReportExtendedContributionCallable;
import com.ibm.team.enterprise.build.ant.tasks.AbstractEETask;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.enterprise.build.ant.types.resources.BuildMapLinkCollection;
import com.ibm.team.enterprise.build.ant.types.resources.BuildableResource;
import com.ibm.team.enterprise.build.ant.types.resources.FailedBuildableResourceCollection;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMapHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFileHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFileHandle;
import com.ibm.team.enterprise.build.buildmap.common.util.FailedOutputsContants;
import com.ibm.team.enterprise.build.buildmap.common.util.OutputXMLUtils;
import com.ibm.team.enterprise.build.common.IBuildConstants;
import com.ibm.team.enterprise.build.common.buildreport.BuildFileXMLModel;
import com.ibm.team.enterprise.build.common.buildreport.BuildMapLinkResource;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.osgi.util.NLS;

public class BuildReportUtils {
    public static final String BUILD_REPORT_XML = "buildReport.xml";
    private static final String UTF_8 = "UTF-8";
    private static final String TEXT_XML = "text/xml";

    private BuildReportUtils() {
    }

    public static void publishBuildReport(File filePath, Project project, String buildResultUUID, boolean isPreview) throws TeamRepositoryException {
        BuildReportUtils.publishFile(filePath, Messages.BUILD_REPORT, buildResultUUID);
        String publicUriRoot = project.getProperty("server.webapp.url");
        if (publicUriRoot == null || publicUriRoot.length() == 0) {
            publicUriRoot = project.getProperty("repositoryAddress");
        }
        String buildReportURL = String.valueOf(BuildReportUtils.getBuildMapURIRoot(publicUriRoot)) + "buildReport/_buildResultUUID=" + buildResultUUID;
        BuildReportUtils.publishLink(buildReportURL, BUILD_REPORT_XML, project, buildResultUUID, isPreview);
    }

    public static void publishFile(File file, String label, String buildResultUUID) throws TeamRepositoryException {
        ITeamRepository teamRepository = InitTask.getInstance().getTeamRepository();
        IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildResultUUID), null);
        String contributionStatus = BuildStatus.OK.name();
        ContentPublisher filePublisher = new ContentPublisher(IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID, file.getAbsolutePath(), label, TEXT_XML, UTF_8);
        IBuildResultContribution contribution = filePublisher.publish(buildResultHandle, BuildStatus.valueOf((String)contributionStatus), teamRepository);
        if (contribution == null) {
            throw new BuildException(NLS.bind((String)Messages.PUBLISH_FAILED, (Object)filePublisher.getClass().getSimpleName()));
        }
    }

    public static void publishLink(String urlString, String label, Project project, String buildResultUUID, boolean isPreview) throws TeamRepositoryException {
        ITeamRepository teamRepository = InitTask.getInstance().getTeamRepository();
        IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildResultUUID), null);
        String contributionStatus = BuildStatus.OK.name();
        BuildReportUtils.publishBuildReportExtendedContribution(project, urlString, teamRepository, buildResultHandle, contributionStatus, isPreview);
        LinkPublisher linkPublisher = new LinkPublisher(urlString, BUILD_REPORT_XML);
        linkPublisher.setComponentName(com.ibm.team.enterprise.build.common.Messages.REPORTS_LABEL);
        IBuildResultContribution contribution = linkPublisher.publish(buildResultHandle, BuildStatus.valueOf((String)contributionStatus), teamRepository);
        if (contribution == null) {
            throw new BuildException("LinkPublisher failed (contribution == null)");
        }
    }

    public static void publishBuildReportExtendedContribution(Project project, String urlString, ITeamRepository teamRepository, IBuildResultHandle buildResultHandle, String contributionStatus, boolean isPreviewBuild) throws TeamRepositoryException {
        String numberOfFilesBuilt;
        int index = 0;
        int failed = 0;
        if (isPreviewBuild) {
            index = BuildableResource.getNumberOfSourcesProcessed(project);
            numberOfFilesBuilt = NLS.bind((String)(index == 1 ? Messages.PREVIEW_BUILD_REPORT_LABEL_1 : Messages.PREVIEW_BUILD_REPORT_LABEL), (Object)index);
        } else {
            try {
                BuildReportExtendedContributionCallable.init(buildResultHandle.getItemId(), false);
                BuildReportExtendedContributionCallable.run(AbstractEETask.getExecutor(), true).get();
            }
            catch (InterruptedException e) {
                project.log("Interrupted waiting for BuildReportExtendedContributionThread", (Throwable)e, 3);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new BuildException((Throwable)e);
            }
            ITeamBuildClient client = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
            IBuildResultContribution[] contributions = client.getBuildResultContributions(buildResultHandle, "com.ibm.team.enterprise.build.buildReport", null);
            failed = 0;
            if (contributions != null && contributions.length > 0) {
                String totalStr = contributions[0].getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_SIZE);
                if (totalStr != null) {
                    index = Integer.parseInt(totalStr);
                }
                if ((totalStr = contributions[0].getExtendedContributionProperty(IBuildConstants.PROPERTY_NAME_FILE_FAILED)) != null) {
                    failed = Integer.parseInt(totalStr);
                }
                client.deleteBuildResultContributions(buildResultHandle, contributions, null);
            }
            numberOfFilesBuilt = NLS.bind((String)Messages.BUILD_REPORT_LABEL_RESAULT, (Object)(index - failed), (Object)failed);
        }
        final int fIndex = index;
        final int fFailed = failed;
        LinkPublisher linkPublisher = new LinkPublisher("com.ibm.team.enterprise.build.buildReport", urlString, numberOfFilesBuilt){

            protected void initializeContribution(IBuildResultContribution contribution, ITeamRepository teamRepository) throws TeamRepositoryException {
                super.initializeContribution(contribution, teamRepository);
                contribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_SIZE, Integer.toString(fIndex));
                contribution.setExtendedContributionProperty(IBuildConstants.PROPERTY_NAME_FILE_FAILED, Integer.toString(fFailed));
            }
        };
        IBuildResultContribution contribution = linkPublisher.publish(buildResultHandle, BuildStatus.valueOf((String)contributionStatus), teamRepository);
        if (contribution == null) {
            throw new BuildException("LinkPublisher (build report contribution) failed (contribution == null)");
        }
    }

    private static String getBuildMapURIRoot(String repositoryLocation) {
        StringBuffer buildMapURI = new StringBuffer();
        if (repositoryLocation != null) {
            buildMapURI.append(repositoryLocation);
            if (buildMapURI.charAt(buildMapURI.length() - 1) != '/') {
                buildMapURI.append('/');
            }
            buildMapURI.append("enterprise_buildmap");
            buildMapURI.append('/');
        }
        return buildMapURI.toString();
    }

    public static void generateFailedBuildReport(Project project, String buildResultUUID) throws FileNotFoundException, XMLStreamException, TeamRepositoryException {
        File failedOutfile = new File(new File(project.getProperty("team.enterprise.scm.fetchDestination")), "failedBuildReport.xml");
        if (failedOutfile.exists()) {
            failedOutfile.delete();
        }
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = outputFactory.createXMLStreamWriter(new FileOutputStream(failedOutfile), UTF_8);
        writer.writeStartDocument(UTF_8, "1.0");
        writer.writeCharacters("\n");
        writer.writeStartElement(FailedOutputsContants.BUILDFILE_BUILDABLE_ELEMENT);
        writer.writeAttribute(FailedOutputsContants.BUILDFILE_XML_PREFIX, FailedOutputsContants.BUILDFILE_NAMESPACE);
        writer.writeAttribute("xmlns:outputs", "http://www.ibm.com/team/enterprise/build/buildmap/outputs/1.0/");
        Set<String> fileUUIDs = FailedBuildableResourceCollection.getInstance().getFailedUUIDSet();
        for (String fileUUID : fileUUIDs) {
            writer.writeCharacters("\n\t");
            writer.writeStartElement(FailedOutputsContants.BUILDFILE_FILE_ELEMENT);
            writer.writeAttribute(FailedOutputsContants.BUILDFILE_FILE_UUID_ATTRIBUTE, fileUUID);
            Set<IOutputBuildFile> outputs = FailedBuildableResourceCollection.getInstance().getFailedOutput(fileUUID);
            for (IOutputBuildFile output : outputs) {
                OutputXMLUtils.generateOutputXML((XMLStreamWriter)writer, (IOutputBuildFile)output);
            }
            writer.writeCharacters("\n\t");
            writer.writeEndElement();
        }
        writer.writeCharacters("\n");
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        writer.close();
        BuildReportUtils.publishFile(failedOutfile, Messages.FAILED_BUILD_REPORT, buildResultUUID);
    }

    public static String getPublicUriRoot(Project project) {
        String publicUriRoot = project.getProperty("server.webapp.url");
        if (publicUriRoot == null || publicUriRoot.length() == 0) {
            publicUriRoot = project.getProperty("repositoryAddress");
        }
        return publicUriRoot;
    }

    public static String getBuildMapUrl(Project project, IBuildMapHandle bmh) {
        return Location.stateLocation((IItemHandle)bmh, null).toRelativeUri().toString();
    }

    public static String getBuildMapUri(Project project, IBuildMapHandle bmh, String publicUriRoot) {
        return Location.stateLocation((IItemHandle)bmh, (String)publicUriRoot).toAbsoluteUri().toString();
    }

    public static String getBuildMapLabel(String langDef, String buildableFile) {
        return NLS.bind((String)Messages.BUILD_MAP_INFO, (Object)langDef, (Object)buildableFile);
    }

    public static void gatherInformationForBuildReport(Project project, IBuildMap buildMap, String buildMapURL) throws TeamRepositoryException {
        IItemManager itemManager = InitTask.getInstance().getTeamRepository().itemManager();
        HashSet<BuildFileXMLModel> outputs = new HashSet<BuildFileXMLModel>();
        for (IOutputBuildFileHandle outputHandle : buildMap.getOutputs()) {
            outputs.add(BuildFileUtil.getXMLModelFromOutputBuildFile((IOutputBuildFile)outputHandle));
        }
        List inputs = buildMap.getInputs();
        for (IInputBuildFileHandle inputHandle : inputs) {
            IInputBuildFile file = (IInputBuildFile)inputHandle;
            if (!file.getType().equals("SELF")) continue;
            IComponentHandle componentHandle = file.getComponent();
            IComponent component = (IComponent)itemManager.fetchCompleteItem((IItemHandle)componentHandle, 0, null);
            String componentName = component.getName();
            String scmLocation = file.getSCMLocation();
            String projectName = BuildReportUtils.getProjectName(scmLocation);
            String buildPath = file.getBuildPath();
            String buildFile = file.getBuildFile();
            BuildMapLinkResource linkResource = new BuildMapLinkResource(componentName, projectName, scmLocation, buildPath, buildFile, buildMapURL, outputs);
            BuildMapLinkCollection.getInstance().addResource(componentName, projectName, linkResource);
        }
    }

    private static String getProjectName(String scmLocation) {
        StringTokenizer tokenizer;
        String projectName = "";
        if (scmLocation != null && (tokenizer = new StringTokenizer(scmLocation, "/")).hasMoreTokens()) {
            projectName = tokenizer.nextToken();
        }
        return projectName;
    }

    public static void publishBuildMapLinks(Project project, String buildMapURL, String label) {
        boolean suppressBuildMapLinks;
        String suppressBuildMapLinksProperty = project.getProperty("team.enterprise.build.suppressBuildMapLinks");
        boolean bl = suppressBuildMapLinks = suppressBuildMapLinksProperty == null || Boolean.parseBoolean(suppressBuildMapLinksProperty);
        if (suppressBuildMapLinks) {
            project.log("Publishing build map links to build results is suppressed.", 4);
        } else {
            IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
            contribution.setLabel(label);
            contribution.setImpactsPrimaryResult(true);
            contribution.setStatus(BuildStatus.OK);
            contribution.setComponentName(Messages.BUILD_MAPS);
            contribution.setExtendedContributionTypeId(IBuildResultContribution.LINK_EXTENDED_CONTRIBUTION_ID);
            contribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_URL, buildMapURL);
            BuildReportExtendedContributionCallable.queueContribution(contribution);
        }
    }
}

