/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.internal.utils;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.IStaticReset;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.ant.tasks.BuildReportExtendedContributionPublisher;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.enterprise.build.common.IBuildConstants;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public class BuildReportExtendedContributionCallable
implements Callable<Collection<IBuildResultContribution>>,
IStaticReset {
    private static AtomicInteger indexes = new AtomicInteger();
    private static AtomicInteger failures = new AtomicInteger();
    private static String lastModifiedInputFileName;
    private static Future<Collection<IBuildResultContribution>> future;
    private static ReentrantLock publishLock;
    private static ReentrantReadWriteLock indexesLock;
    private static Vector<IBuildResultContribution> queuedContributions;
    private static boolean initialized;
    private static UUID buildResult;
    private static boolean isPersonal;

    static {
        publishLock = new ReentrantLock();
        indexesLock = new ReentrantReadWriteLock();
        queuedContributions = new Vector();
        initialized = false;
    }

    public static synchronized void init(UUID buildResult, boolean isPersonal) {
        if (initialized) {
            return;
        }
        initialized = true;
        BuildReportExtendedContributionCallable.buildResult = buildResult;
        BuildReportExtendedContributionCallable.isPersonal = isPersonal;
    }

    public static synchronized Future<Collection<IBuildResultContribution>> run(ExecutorService executor, boolean force) throws ExecutionException, InterruptedException {
        if (force || future == null || future.isDone()) {
            if (future != null && (future.isDone() || force)) {
                future.get();
            }
            future = executor.submit(new BuildReportExtendedContributionCallable());
        }
        return future;
    }

    public static void incrementProcessedCount(String inputFileName) {
        indexesLock.readLock().lock();
        indexes.incrementAndGet();
        indexesLock.readLock().unlock();
        lastModifiedInputFileName = inputFileName;
    }

    public static void incrementFailedCount() {
        indexesLock.readLock().lock();
        failures.incrementAndGet();
        indexes.incrementAndGet();
        indexesLock.readLock().unlock();
    }

    public static void queueContribution(IBuildResultContribution contribution) {
        queuedContributions.add(contribution);
    }

    protected BuildReportExtendedContributionCallable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IBuildResultContribution> call() {
        ArrayList<IBuildResultContribution> contribs = new ArrayList<IBuildResultContribution>();
        if (publishLock.tryLock()) {
            try {
                int index = 0;
                int indexToAdd = 0;
                int failed = 0;
                int failedToAdd = 0;
                ITeamRepository teamRepository = InitTask.getInstance().getTeamRepository();
                IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(buildResult, null);
                ITeamBuildClient client = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
                if (indexes.get() != 0) {
                    IBuildResultContribution[] contributions = client.getBuildResultContributions(buildResultHandle, "com.ibm.team.enterprise.build.buildReport", null);
                    if (contributions != null && contributions.length > 0) {
                        String fileSize = contributions[0].getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_SIZE);
                        if (fileSize != null) {
                            index = Integer.parseInt(fileSize);
                        }
                        if ((fileSize = contributions[0].getExtendedContributionProperty(IBuildConstants.PROPERTY_NAME_FILE_FAILED)) != null) {
                            failed = Integer.parseInt(fileSize);
                        }
                        client.deleteBuildResultContributions(buildResultHandle, contributions, null);
                    }
                    indexesLock.writeLock().lock();
                    indexToAdd = indexes.get();
                    index += indexToAdd;
                    failedToAdd = failures.get();
                    failed += failedToAdd;
                    indexesLock.writeLock().unlock();
                    String label = null;
                    if (!isPersonal) {
                        label = failed > 0 ? NLS.bind((String)(index == 1 ? Messages.BUILD_REPORT_LABEL_1_FAILED : Messages.BUILD_REPORT_LABEL_FAILED), (Object)index, (Object)failed) : NLS.bind((String)(index == 1 ? Messages.BUILD_REPORT_LABEL_1 : Messages.BUILD_REPORT_LABEL), (Object)index, (Object)failed);
                    } else if (failed > 0) {
                        Object[] argArray = new String[]{String.valueOf(index), lastModifiedInputFileName, String.valueOf(failed)};
                        label = NLS.bind((String)(index == 1 ? Messages.PERSONAL_BUILD_REPORT_LABEL_1_FAILED : Messages.PERSONAL_BUILD_REPORT_LABEL_FAILED), (Object[])argArray);
                    } else {
                        label = NLS.bind((String)(index == 1 ? Messages.PERSONAL_BUILD_REPORT_LABEL_1 : Messages.PERSONAL_BUILD_REPORT_LABEL), (Object)index, (Object)lastModifiedInputFileName);
                    }
                    BuildReportExtendedContributionPublisher publisher = new BuildReportExtendedContributionPublisher("com.ibm.team.enterprise.build.buildReport", "", label, index, failed);
                    IBuildResultContribution contribution = publisher.createContribution(teamRepository, BuildStatus.OK);
                    if (contribution == null) {
                        throw new BuildException(NLS.bind((String)Messages.PUBLISH_FAILED, (Object)((Object)((Object)publisher)).getClass().getSimpleName()));
                    }
                    IBuildResultContribution filesCompletedContribution = BuildItemFactory.createBuildResultContribution();
                    filesCompletedContribution.setExtendedContributionTypeId("com.ibm.team.enterprise.build.buildReport");
                    filesCompletedContribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_EXTENDED_ACTIVITIES_PROCESSED, Integer.toString(index));
                    filesCompletedContribution.setImpactsPrimaryResult(false);
                    filesCompletedContribution.setLabel(Integer.toString(index));
                    contribs.addAll(Arrays.asList(contribution, filesCompletedContribution));
                }
                Vector<IBuildResultContribution> vector = queuedContributions;
                synchronized (vector) {
                    contribs.addAll(queuedContributions);
                    queuedContributions.clear();
                }
                if (!contribs.isEmpty()) {
                    client.addBuildResultContributions(buildResultHandle, contribs.toArray(new IBuildResultContribution[0]), null);
                }
                InitTask.getInstance().getProject().log("Published " + contribs.size() + " contributions" + (indexToAdd != 0 ? " including Extended" : "") + " in background thread", 4);
                indexes.getAndAdd(-indexToAdd);
                failures.getAndAdd(-failedToAdd);
                ArrayList<IBuildResultContribution> arrayList = contribs;
                return arrayList;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            finally {
                publishLock.unlock();
            }
        }
        InitTask.getInstance().getProject().log("background publishing thread failed to get lock", 4);
        return Collections.emptyList();
    }

    public static void staticMemoryReset() {
        indexes = new AtomicInteger();
        failures = new AtomicInteger();
        lastModifiedInputFileName = null;
        future = null;
        publishLock = new ReentrantLock();
        indexesLock = new ReentrantReadWriteLock();
        queuedContributions = new Vector();
        initialized = false;
        buildResult = null;
        isPersonal = false;
    }
}

