/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.internal.utils;

import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.InputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.OutputBuildFile;
import com.ibm.team.enterprise.build.common.buildreport.BuildFileXMLModel;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.sql.Timestamp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.Task;

public class BuildFileUtil {
    public static final String TYPE_SELF = "SELF";
    public static final String TYPE_COPY = "COPY";
    public static final String TYPE_OUTPUT = "OUTPUT";
    public static final String TYPE_OBJ = "OBJ";
    private static final String COMMA = ",";

    public static BuildFileXMLModel getXMLModelFromInputBuildFile(IInputBuildFile i) throws Exception {
        if (i == null) {
            return null;
        }
        BuildFileXMLModel x = new BuildFileXMLModel();
        x.setBuildFile(i.getBuildFile());
        x.setBuildPath(i.getBuildPath());
        x.setParserOutputBuildPath(i.getParserOutputBuildPath());
        x.setPromotionBuildPath(i.getPromotionBuildPath());
        if (i.getResourceDefinitionUUID() != null) {
            x.setResourceDefinitionUUID(i.getResourceDefinitionUUID().getUuidValue());
        }
        if (i.getResourceDefinitionStateUUID() != null) {
            x.setResourceDefinitionStateUUID(i.getResourceDefinitionStateUUID().getUuidValue());
        }
        if (i.getTimestamp() != null) {
            x.setTimestamp(i.getTimestamp().getTime());
        }
        x.setInputType(i.getInputType());
        x.setType(i.getType());
        x.setModule(i.getModule());
        x.setPathName(i.getPathName());
        x.setScmLocation(i.getSCMLocation());
        x.setServiceProgram(i.getServiceProgram());
        if (i.getComponent() != null) {
            IItemManager itemManager = InitTask.getInstance().getTeamRepository().itemManager();
            x.setComponentUUID(i.getComponent().getItemId().getUuidValue());
            IComponent component = (IComponent)itemManager.fetchCompleteItem((IItemHandle)i.getComponent(), 0, null);
            x.setComponentName(component.getName());
        }
        if (i.getFile() != null) {
            x.setFileUUID(i.getFile().getItemId().getUuidValue());
        }
        if (i.getFileStateUUID() != null) {
            x.setFileStateUUID(i.getFileStateUUID().getUuidValue());
        }
        x.setReserved(((InputBuildFile)i).getReserved());
        x.setHFS(i.isHFS());
        x.setResolvedTo(i.getResolvedTo());
        return x;
    }

    public static IOutputBuildFile getOutputFileFromXMLModel(BuildFileXMLModel x) {
        if (x == null) {
            return null;
        }
        IOutputBuildFile o = (IOutputBuildFile)IOutputBuildFile.ITEM_TYPE.createItem();
        o.setType(x.getType());
        o.setBuildFile(x.getBuildFile());
        o.setBuildPath(x.getBuildPath());
        o.setPromotionBuildPath(x.getPromotionBuildPath());
        if (x.getResourceDefinitionUUID() != null && x.getResourceDefinitionUUID().length() > 0) {
            o.setResourceDefinitionUUID(UUID.valueOf((String)x.getResourceDefinitionUUID()));
        }
        if (x.getResourceDefinitionStateUUID() != null && x.getResourceDefinitionStateUUID().length() > 0) {
            o.setResourceDefinitionStateUUID(UUID.valueOf((String)x.getResourceDefinitionStateUUID()));
        }
        if (x.getResourceDefinitionStateUUID() != null && x.getResourceDefinitionStateUUID().length() > 0) {
            o.setResourceDefinitionStateUUID(UUID.valueOf((String)x.getResourceDefinitionStateUUID()));
        }
        if (x.getResourceDefinitionUUID() != null && x.getResourceDefinitionUUID().length() > 0) {
            o.setResourceDefinitionUUID(UUID.valueOf((String)x.getResourceDefinitionUUID()));
        }
        o.setTimestamp(new Timestamp(x.getTimestamp()));
        o.setOutputType(x.getOutputType());
        o.setSequential(Boolean.valueOf(x.getSequential()).booleanValue());
        o.setHFS(x.isHFS());
        o.setConsumableAsSource(Boolean.valueOf(x.getConsumableAsSource()).booleanValue());
        ((OutputBuildFile)o).setReserved(x.getReserved());
        return o;
    }

    public static IInputBuildFile getInputFileFromXMLModel(BuildFileXMLModel x) {
        if (x == null) {
            return null;
        }
        IInputBuildFile r = (IInputBuildFile)IInputBuildFile.ITEM_TYPE.createItem();
        r.setBuildFile(x.getBuildFile());
        r.setBuildPath(x.getBuildPath());
        r.setPromotionBuildPath(x.getPromotionBuildPath());
        if (x.getComponentUUID() != null && x.getComponentUUID().length() > 0) {
            r.setComponent((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)x.getComponentUUID()), null));
        }
        if (x.getFileUUID() != null && x.getFileUUID().length() > 0) {
            r.setFile((IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)x.getFileUUID()), null));
        }
        if (x.getFileStateUUID() != null && x.getFileStateUUID().length() > 0) {
            r.setFileStateUUID(UUID.valueOf((String)x.getFileStateUUID()));
        }
        r.setInputType(x.getInputType());
        r.setModule(x.getModule());
        r.setPathName(x.getPathName());
        if (x.getResourceDefinitionStateUUID() != null && x.getResourceDefinitionStateUUID().length() > 0) {
            r.setResourceDefinitionStateUUID(UUID.valueOf((String)x.getResourceDefinitionStateUUID()));
        }
        if (x.getResourceDefinitionUUID() != null && x.getResourceDefinitionUUID().length() > 0) {
            r.setResourceDefinitionUUID(UUID.valueOf((String)x.getResourceDefinitionUUID()));
        }
        r.setSCMLocation(x.getScmLocation());
        r.setServiceProgram(x.getServiceProgram());
        r.setTimestamp(new Timestamp(x.getTimestamp()));
        r.setType(x.getType());
        r.setHFS(x.isHFS());
        ((InputBuildFile)r).setReserved(x.getReserved());
        r.setResolvedTo(x.getResolvedTo());
        return r;
    }

    public static IInputBuildFile cloneInputBuildFile(IInputBuildFile i) throws Exception {
        if (i == null) {
            return null;
        }
        IInputBuildFile r = (IInputBuildFile)IInputBuildFile.ITEM_TYPE.createItem();
        r.setBuildFile(i.getBuildFile());
        r.setBuildPath(i.getBuildPath());
        r.setPromotionBuildPath(i.getPromotionBuildPath());
        r.setComponent(i.getComponent());
        r.setFile(i.getFile());
        r.setFileStateUUID(i.getFileStateUUID());
        r.setInputType(i.getInputType());
        r.setModule(i.getModule());
        r.setPathName(i.getPathName());
        r.setResourceDefinitionStateUUID(i.getResourceDefinitionStateUUID());
        r.setResourceDefinitionUUID(i.getResourceDefinitionUUID());
        r.setSCMLocation(i.getSCMLocation());
        r.setServiceProgram(i.getServiceProgram());
        r.setTimestamp(i.getTimestamp());
        r.setType(i.getType());
        r.setHFS(i.isHFS());
        ((InputBuildFile)r).setReserved(((InputBuildFile)i).getReserved());
        r.setResolvedTo(i.getResolvedTo());
        return r;
    }

    public static IOutputBuildFile convertInputBuildFileToOutputBuildFile(IInputBuildFile i) throws Exception {
        if (i == null) {
            return null;
        }
        IOutputBuildFile o = (IOutputBuildFile)IOutputBuildFile.ITEM_TYPE.createItem();
        o.setType(i.getType());
        o.setBuildFile(i.getBuildFile());
        o.setBuildPath(i.getBuildPath());
        o.setPromotionBuildPath(i.getPromotionBuildPath());
        o.setResourceDefinitionUUID(i.getResourceDefinitionUUID());
        o.setResourceDefinitionStateUUID(i.getResourceDefinitionStateUUID());
        o.setTimestamp(i.getTimestamp());
        ((OutputBuildFile)o).setReserved(((InputBuildFile)i).getReserved());
        o.setHFS(i.isHFS());
        return o;
    }

    public static BuildFileXMLModel getXMLModelFromOutputBuildFile(IOutputBuildFile o) {
        if (o == null) {
            return null;
        }
        BuildFileXMLModel x = new BuildFileXMLModel();
        x.setBuildFile(o.getBuildFile());
        x.setBuildPath(o.getBuildPath());
        x.setPromotionBuildPath(o.getPromotionBuildPath());
        if (o.getResourceDefinitionUUID() != null) {
            x.setResourceDefinitionUUID(o.getResourceDefinitionUUID().getUuidValue());
        }
        if (o.getResourceDefinitionStateUUID() != null) {
            x.setResourceDefinitionStateUUID(o.getResourceDefinitionStateUUID().getUuidValue());
        }
        if (o.getTimestamp() != null) {
            x.setTimestamp(o.getTimestamp().getTime());
        }
        x.setSequential(Boolean.toString(o.isSequential()));
        x.setHFS(o.isHFS());
        x.setOutputType(o.getOutputType());
        x.setType(o.getType());
        x.setDeployType(o.getDeployType());
        x.setConsumableAsSource(Boolean.toString(o.isConsumableAsSource()));
        x.setReserved(((OutputBuildFile)o).getReserved());
        return x;
    }

    public static boolean isDsNameExcludedFromParserOutput(String dsname, String member, Task task) {
        String excludeFilter = task.getProject().getProperty("team.enterprise.build.toolkit.linkEditExcludeNameFilter");
        if (excludeFilter != null && BuildFileUtil.isExcludedByFilter(dsname, member, excludeFilter)) {
            task.log(String.valueOf(dsname) + "(" + member + ") was excluded from the parser output by user defined exclude name filter: " + excludeFilter, 4);
            return true;
        }
        return false;
    }

    public static boolean isExcludedByFilter(String dsname, String member, String filter) {
        String[] filters;
        if (filter == null || filter.trim().length() == 0) {
            return false;
        }
        String fullDsName = String.valueOf(dsname) + "." + member;
        String[] stringArray = filters = filter.trim().split(COMMA);
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String origRule = s.trim();
            Pattern rule = Pattern.compile("^" + origRule.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*").replaceAll("\\$", "\\\\\\$"));
            Matcher m = rule.matcher(fullDsName);
            if (m.find()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

