/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.internal.utils;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.internal.PasswordHelper;
import com.ibm.team.build.internal.scm.RepositoryManager;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.tools.ant.Project;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public final class AuthenticationUtilities {
    private AuthenticationUtilities() {
    }

    public static ITeamRepository getLoggedInTeamRepository(final Project project, AbstractTeamBuildTask.AuthenticationPolicy authenticationPolicy, String repositoryAddress, String userId, File passwordFile, File certificateFile, File repositoriesFile, boolean smartCard, boolean kerberos) throws TeamRepositoryException, FileNotFoundException, IOException {
        String password = AuthenticationUtilities.getPassword(passwordFile);
        RepositoryManager repositoryManager = null;
        ITeamRepository repository = null;
        RepositoryManager.IConsole console = new RepositoryManager.IConsole(){

            public void print(String message) {
                project.log(message, 3);
            }
        };
        String authenticationValues = NLS.bind((String)Messages.AUTHENTICATION_ATTEMPTED_WITH_VALUES, (Object[])new Object[]{authenticationPolicy, userId, passwordFile != null ? passwordFile.getAbsolutePath() : "null", certificateFile != null ? certificateFile.getAbsolutePath() : "null", smartCard, repositoriesFile != null ? repositoriesFile.getAbsolutePath() : "null", kerberos}, (Object[])new Object[0]);
        project.log(authenticationValues, 3);
        switch (authenticationPolicy) {
            case USERNAME_PASSWORD_POLICY: {
                if (userId == null || userId.length() < 1 || password == null || password.length() < 1) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.AUTHENTICATION_PROBLEM_WITH_USERNAME_PASSWORD_POLICY, (Object)authenticationPolicy, (Object[])new Object[0]));
                }
                repositoryManager = RepositoryManager.createForUsernameAndPassword((String)repositoryAddress, (String)userId, (String)password, (RepositoryManager.IConsole)console);
                break;
            }
            case CERTIFICATE_FILE_POLICY: {
                if (certificateFile == null || !certificateFile.exists() || password == null || password.length() < 1) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.AUTHENTICATION_PROBLEM_WITH_CERTIFICATE_FILE_POLICY, (Object)authenticationPolicy, (Object[])new Object[0]));
                }
                repositoryManager = RepositoryManager.createForCertificateFile((String)repositoryAddress, (File)certificateFile, (String)password, (RepositoryManager.IConsole)console);
                break;
            }
            case SMART_CARD_POLICY: {
                if (userId == null || userId.length() < 1) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.AUTHENTICATION_PROBLEM_WITH_SMART_CARD_POLICY, (Object)authenticationPolicy, (Object[])new Object[0]));
                }
                repositoryManager = RepositoryManager.createForSmartCard((String)repositoryAddress, (String)userId, (RepositoryManager.IConsole)console);
                break;
            }
            case REGISTRY_POLICY: {
                if (repositoriesFile == null || !repositoriesFile.exists()) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.AUTHENTICATION_PROBLEM_WITH_REGISTRY_POLICY, (Object)authenticationPolicy, (Object[])new Object[0]));
                }
                repositoryManager = RepositoryManager.createFromRegistryFile((File)repositoriesFile, (RepositoryManager.IConsole)console);
                break;
            }
            case KERBEROS_POLICY: {
                repositoryManager = RepositoryManager.createForKerberos((String)repositoryAddress, (RepositoryManager.IConsole)console);
                break;
            }
            default: {
                throw new TeamRepositoryException(NLS.bind((String)Messages.AUTHENTICATION_UNKNOWN_POLICY, (Object[])new Object[]{AbstractTeamBuildTask.AuthenticationPolicy.USERNAME_PASSWORD_POLICY, AbstractTeamBuildTask.AuthenticationPolicy.CERTIFICATE_FILE_POLICY, AbstractTeamBuildTask.AuthenticationPolicy.SMART_CARD_POLICY, AbstractTeamBuildTask.AuthenticationPolicy.KERBEROS_POLICY, AbstractTeamBuildTask.AuthenticationPolicy.REGISTRY_POLICY}, (Object[])new Object[0]));
            }
        }
        repository = repositoryManager.getRepository(repositoryAddress, true);
        try {
            repositoryManager.login(repository, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (TeamRepositoryException tre) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.AUTHENTICATION_FAILED, (Object)repositoryAddress, (Object[])new Object[]{authenticationValues}), (Throwable)tre);
        }
        return repository;
    }

    public static ITeamRepository getLoggedInTeamRepository(Project p, String repositoryAddress, String userId, File passwordFile) throws TeamRepositoryException, FileNotFoundException, IOException {
        return AuthenticationUtilities.getLoggedInTeamRepository(p, AuthenticationUtilities.getAuthenticationPolicy(p), repositoryAddress, userId, passwordFile, AuthenticationUtilities.getCertificateFile(p), AuthenticationUtilities.getRegistryFile(p), AuthenticationUtilities.isSmartCard(p), AuthenticationUtilities.isKerberos(p));
    }

    protected static File getCertificateFile(Project p) {
        String value = p.getProperty("env.JAZZ_CERTIFICATE_FILE");
        return value == null ? null : new File(value);
    }

    protected static File getRegistryFile(Project p) {
        String value = p.getProperty("env.JAZZ_REGISTRY");
        return value == null ? null : new File(value);
    }

    protected static boolean isSmartCard(Project p) {
        return Boolean.valueOf(p.getProperty("env.JAZZ_SMARTCARD"));
    }

    protected static boolean isKerberos(Project p) {
        return Boolean.valueOf(p.getProperty("env.JAZZ_KERBEROS"));
    }

    protected static AbstractTeamBuildTask.AuthenticationPolicy getAuthenticationPolicy(Project p) {
        String method = p.getProperty("env.JAZZ_AUTH_METHOD");
        return AbstractTeamBuildTask.AuthenticationPolicy.valueOf((String)(method == null ? "USERNAME_PASSWORD_POLICY" : method));
    }

    public static void setAuthenticationAttributes(AbstractTeamBuildTask task, String repositoryAddress, String userId, File passwordFile) {
        Project p = task.getProject();
        AbstractTeamBuildTask.AuthenticationPolicy policy = AuthenticationUtilities.getAuthenticationPolicy(p);
        switch (policy) {
            case CERTIFICATE_FILE_POLICY: {
                task.setAuthenticationPolicy(AbstractTeamBuildTask.AuthenticationPolicy.CERTIFICATE_FILE_POLICY);
                task.setCertificateFile(AuthenticationUtilities.getCertificateFile(p));
                task.setPasswordFile(passwordFile);
                break;
            }
            case SMART_CARD_POLICY: {
                task.setAuthenticationPolicy(AbstractTeamBuildTask.AuthenticationPolicy.SMART_CARD_POLICY);
                task.setUserId(userId);
                break;
            }
            case KERBEROS_POLICY: {
                task.setAuthenticationPolicy(AbstractTeamBuildTask.AuthenticationPolicy.KERBEROS_POLICY);
                break;
            }
            case REGISTRY_POLICY: {
                task.setAuthenticationPolicy(AbstractTeamBuildTask.AuthenticationPolicy.REGISTRY_POLICY);
                task.setRepositoriesFile(AuthenticationUtilities.getRegistryFile(p));
                break;
            }
            default: {
                task.setAuthenticationPolicy(AbstractTeamBuildTask.AuthenticationPolicy.USERNAME_PASSWORD_POLICY);
                task.setPasswordFile(passwordFile);
                task.setUserId(userId);
            }
        }
    }

    protected static String getPassword(File passwordFile) throws TeamRepositoryException {
        if (passwordFile != null) {
            try {
                return PasswordHelper.getPassword((File)passwordFile);
            }
            catch (Exception exception) {
                throw new TeamRepositoryException((Throwable)exception);
            }
        }
        return null;
    }
}

