/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.internal.utils;

import com.ibm.team.build.common.IStaticReset;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.enterprise.build.ant.IBuildableResource;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.systemdefinition.common.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.MemberNamePattern;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MacroDef;
import org.apache.tools.ant.taskdefs.MacroInstance;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractMacroExec
implements Callable<AbstractMacroExec>,
IStaticReset {
    private static final String KEY_OUTPUT_NAME_KIND = "outputNameKind";
    private static final String KEY_OUTPUT_NAME = "outputName";
    private static final char HYPHEN_CHAR = '-';
    private static final char UNDERSCORE_CHAR = '_';
    protected static final String DOT = ".";
    private static final String VARIABLE_ATTR_PREFIX = "var.";
    public static final String INPUT_LIBRARY = "input.library";
    public static final String INPUT_SOURCE_PF = "input.sourcepf";
    public static final String INPUT_MEMBER_NAME = "input.membername";
    public static final String INPUT_MEMBER_TYPE = "input.membertype";
    public static final String OUTPUT_LIBRARY = "output.library";
    public static final String OUTPUT_NAME = "output.name";
    public static final String BUILDMAP = "buildmap";
    public static final String SOURCE_VERSION = "source.version";
    public static final String SOURCE_DATASET = "source.dataset";
    public static final String SOURCE_MEMBER = "source.member";
    public static final String SOURCE_MEMBER_NAME = "source.member.name";
    public static final String SOURCE_PROJECT = "source.project";
    public static final String SOURCE_COMPONENT = "source.component";
    public static final String SOURCE_MEMBER_SCM_LOCATION = "source.member.scm.location";
    public static final String SOURCE_MEMBER_FILE_EXTENSION = "source.member.file.extension";
    public static final String REASON_TO_REBUILD = "source.reasontorebuild";
    public static final String CONSOLIDATE_LOGS = "consolidate.logs";
    public static final String CURRENT_DATE = "current.date";
    public static final String CURRENT_TIME = "current.time";
    public static final String CURRENT_MILLISECOND = "current.millisecond";
    public static final int CONSOLIDATE_INHERIT = 0;
    public static final int CONSOLIDATE_NEVER = 1;
    public static final int CONSOLIDATE_ALWAYS = 2;
    public static final int CONSOLIDATE_ON_SUCCESS = 3;
    private static final String JOB = "job";
    private static final String BUILD_MACRO_PREFIX = "team.enterprise.build.macro.";
    private static Map<String, String> langDefToMacro = null;
    private boolean preview = false;
    protected IBuildableResource buildableResource = null;
    String buildMacro = null;
    String langDefName = null;
    protected Task parentTask = null;
    Exception exception = null;
    protected Map<String, String> fJobProperties = null;
    protected boolean isConsolidatedLogs;
    protected File consolidatedLog;
    protected BuildStatus highestLogSeverity;

    public AbstractMacroExec(Task parentTask, IBuildableResource buildableResource, boolean preview) {
        this.parentTask = parentTask;
        this.buildableResource = buildableResource;
        this.preview = preview;
        this.init(parentTask, buildableResource);
    }

    private void init(Task parentTask, IBuildableResource buildableResource) {
        if (langDefToMacro == null) {
            AbstractMacroExec.initializeMap(parentTask.getProject());
        }
        this.buildMacro = buildableResource.getBuildMacro();
        this.langDefName = buildableResource.getLangDefName();
        if (this.buildMacro == null || this.buildMacro.length() == 0) {
            if (this.langDefName == null || this.langDefName.length() == 0) {
                throw new BuildException(NLS.bind((String)Messages.MODEL_NOT_DEFINED, (Object)buildableResource.getName()));
            }
            this.buildMacro = AbstractMacroExec.getBuildMacro(this.langDefName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractMacroExec call() {
        Task task = this.parentTask.getProject().createTask(this.buildMacro);
        if (task == null) {
            throw new BuildException(NLS.bind((String)Messages.TASK_NOT_CREATED, (Object)this.buildMacro));
        }
        this.log(NLS.bind((String)Messages.PROCESSING_BUILDABLE_FILE, (Object)this.buildableResource.getName().toUpperCase(), (Object)this.langDefName), 3);
        Properties p = null;
        try {
            p = this.getAttributes();
        }
        catch (Exception e) {
            throw new BuildException(Messages.EXCEPTIONS_DURING_PROCESSING, (Throwable)e);
        }
        if (task instanceof MacroInstance) {
            String defaultValue;
            String key;
            MacroDef.Attribute attribute;
            this.fJobProperties = new HashMap<String, String>();
            MacroInstance job = (MacroInstance)task;
            MacroDef macroDef = job.getMacroDef();
            List attributes = macroDef.getAttributes();
            for (Object o : attributes) {
                attribute = (MacroDef.Attribute)o;
                key = attribute.getName();
                defaultValue = attribute.getDefault();
                if (!key.startsWith(VARIABLE_ATTR_PREFIX)) continue;
                int index = key.lastIndexOf(DOT);
                String var = key.substring(index + 1).toLowerCase(Locale.US);
                String value = p.getProperty(var);
                if (value != null) {
                    job.setDynamicAttribute(key, value);
                    this.fJobProperties.put(key, value);
                    this.log(NLS.bind((String)Messages.SET_DYNAMIC_ATTRIBUTE, (Object)key, (Object)value), 4);
                    continue;
                }
                p.setProperty(var, defaultValue);
                this.fJobProperties.put(var, defaultValue);
                this.log(NLS.bind((String)Messages.USE_DEFAULT_ATTRIBUTE, (Object)key, (Object)defaultValue), 4);
            }
            for (Object o : attributes) {
                attribute = (MacroDef.Attribute)o;
                key = attribute.getName();
                defaultValue = attribute.getDefault();
                String description = attribute.getDescription();
                if (this.processMacroDefAttributeDescription(job, key, description, p) || key.startsWith(VARIABLE_ATTR_PREFIX)) continue;
                String value = p.getProperty(key);
                if (value == null && defaultValue != null) {
                    this.log(NLS.bind((String)Messages.USE_DEFAULT_ATTRIBUTE, (Object)key, (Object)defaultValue), 4);
                    value = defaultValue;
                } else if (value == null && key.startsWith(OUTPUT_NAME)) {
                    value = p.getProperty(OUTPUT_NAME);
                }
                job.setDynamicAttribute(key, value);
                this.fJobProperties.put(key, value);
                this.log(NLS.bind((String)Messages.SET_DYNAMIC_ATTRIBUTE, (Object)key, (Object)value), 4);
            }
            this.isConsolidatedLogs = Boolean.parseBoolean(this.fJobProperties.get(CONSOLIDATE_LOGS));
            String tmpdir = AbstractMacroExec.getLoadDir(this.parentTask.getProject());
            StringBuilder tmpPath = new StringBuilder(tmpdir);
            tmpPath.append(File.separatorChar);
            tmpPath.append(this.fJobProperties.get(SOURCE_MEMBER_NAME));
            String extension = this.fJobProperties.get(SOURCE_MEMBER_FILE_EXTENSION);
            if (extension != null && !extension.isEmpty()) {
                tmpPath.append('.');
                tmpPath.append(extension);
            }
            tmpPath.append(".log");
            this.consolidatedLog = new File(tmpPath.toString());
            if (this.consolidatedLog.exists()) {
                this.consolidatedLog.delete();
            }
            this.log(NLS.bind((String)Messages.EXECUTE_MACRO, (Object)this.langDefName), 4);
            try {
                try {
                    Project proj = job.getProject();
                    defaultValue = proj;
                    synchronized (defaultValue) {
                        job.getProject().addReference(JOB, (Object)this);
                    }
                    String key2 = this.buildableResource.getName().toUpperCase();
                    Project project = proj;
                    synchronized (project) {
                        job.getProject().addReference(key2, (Object)this);
                    }
                    job.execute();
                }
                catch (BuildException be) {
                    this.exception = be;
                    String buildMap = p.getProperty(BUILDMAP);
                    if (buildMap != null) {
                        new File(buildMap).delete();
                    }
                    this.cleanup();
                }
            }
            finally {
                this.cleanup();
            }
        }
        return this;
    }

    public static String getLoadDir(Project project) {
        String loadDir = null;
        if (project != null) {
            loadDir = project.getProperty("team.enterprise.scm.fetchDestination");
        }
        if (loadDir == null) {
            loadDir = System.getProperty("java.io.tmpdir");
        }
        return loadDir;
    }

    private boolean processMacroDefAttributeDescription(MacroInstance job, String key, String description, Properties p) {
        ITranslator.OutputNameKind outputNameKind = ITranslator.OutputNameKind.SAME_AS_INPUT;
        String outputName = null;
        if (description != null) {
            try {
                String s;
                JSONObject jsonObject = JSONObject.parse((Reader)new StringReader(description));
                if (jsonObject != null && (outputName = (String)jsonObject.get((Object)KEY_OUTPUT_NAME)) != null && (s = (String)jsonObject.get((Object)KEY_OUTPUT_NAME_KIND)) != null) {
                    outputNameKind = Enum.valueOf(ITranslator.OutputNameKind.class, s);
                    String value = this.calculateOutputName(outputName, outputNameKind, p);
                    job.setDynamicAttribute(key, value);
                    this.fJobProperties.put(key, value);
                    this.log(NLS.bind((String)Messages.SET_DYNAMIC_ATTRIBUTE, (Object)key, (Object)value), 4);
                    return true;
                }
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        return false;
    }

    private Properties getAttributes() throws Exception {
        File buildMap;
        Properties p = new Properties();
        this.getPlatformDependentAttributes(p);
        Date now = new Date();
        SimpleDateFormat formater = new SimpleDateFormat("yyMMdd");
        String val = formater.format(now);
        p.setProperty(CURRENT_DATE, val);
        formater = new SimpleDateFormat("HHmmss");
        val = formater.format(now);
        p.setProperty(CURRENT_TIME, val);
        formater = new SimpleDateFormat("SSSSSS");
        val = formater.format(now);
        p.setProperty(CURRENT_MILLISECOND, val);
        Map<String, String> variablesMap = this.buildableResource.getVariables();
        if (variablesMap != null) {
            Set<String> keySet = variablesMap.keySet();
            for (String key : keySet) {
                String value = variablesMap.get(key);
                p.put(key.replace('_', '-').toLowerCase(Locale.US), value);
            }
        }
        if (!this.preview && (buildMap = this.buildableResource.getBuildMap(this.parentTask)) != null) {
            p.setProperty(BUILDMAP, buildMap.getCanonicalPath());
        }
        return p;
    }

    protected abstract void getPlatformDependentAttributes(Properties var1) throws Exception;

    protected abstract MemberNamePattern getMemberNamePattern();

    protected abstract String getMemberName(Properties var1);

    protected String calculateOutputName(String outputName, ITranslator.OutputNameKind outputNameKind, Properties p) {
        String pattern;
        MemberNamePattern mnp = this.getMemberNamePattern();
        String memberName = this.getMemberName(p);
        String output = null;
        if (ITranslator.OutputNameKind.SAME_AS_INPUT.equals((Object)outputNameKind)) {
            return memberName;
        }
        if (ITranslator.OutputNameKind.USE_VARIABLE.equals((Object)outputNameKind)) {
            String varName = outputName.toLowerCase(Locale.US).replace('_', '-');
            pattern = p.getProperty(varName);
            this.log(NLS.bind((String)Messages.USE_VARIABLE_FOR_RENAMING_OUTPUT, (Object)outputName, (Object)pattern), 4);
        } else {
            pattern = outputName;
            this.log(NLS.bind((String)Messages.USE_PATTERN_FOR_RENAMING_OUTPUT, (Object)pattern), 4);
        }
        if (mnp.containsDateVars(pattern)) {
            String newPattern;
            pattern = newPattern = mnp.substituteDateVars(pattern, this.getCurrentDate(p), this.getCurrentTime(p), this.getCurrentMillisecond(p));
        }
        if (pattern != null) {
            String[] subPatterns = pattern.split("\\.");
            String[] subResults = new String[subPatterns.length];
            int i = 0;
            String[] stringArray = subPatterns;
            int n = subPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                String subPattern = stringArray[n2];
                mnp.validate(subPattern);
                subResults[i] = mnp.convert(subPattern, memberName);
                ++i;
                ++n2;
            }
            stringArray = subResults;
            n = subResults.length;
            n2 = 0;
            while (n2 < n) {
                String subResult = stringArray[n2];
                output = output != null && !output.isEmpty() ? String.valueOf(output) + DOT + subResult : subResult;
                ++n2;
            }
        } else {
            mnp.validate(pattern);
            output = mnp.convert(pattern, memberName);
        }
        this.log(NLS.bind((String)Messages.OUTPUT_RENAMED, (Object[])new String[]{memberName, output, pattern}), 4);
        return output;
    }

    private static String getBuildMacro(String langDefName) {
        String macroName = null;
        if (langDefName != null) {
            macroName = langDefToMacro.get(langDefName);
        }
        if (macroName != null) {
            return macroName;
        }
        throw new BuildException(NLS.bind((String)Messages.MACRO_NOT_FOUND, (Object)langDefName));
    }

    private static void initializeMap(Project project) {
        langDefToMacro = new HashMap<String, String>();
        Hashtable properties = project.getProperties();
        for (String key : properties.keySet()) {
            if (!key.startsWith(BUILD_MACRO_PREFIX)) continue;
            String langDef = (String)properties.get(key);
            String macro = key.substring(BUILD_MACRO_PREFIX.length());
            langDefToMacro.put(langDef, macro);
        }
    }

    public IBuildableResource getBuildableResource() {
        return this.buildableResource;
    }

    public String getBuildMacro() {
        return this.buildMacro;
    }

    public String getLangDefName() {
        return this.langDefName;
    }

    public Exception getException() {
        return this.exception;
    }

    public Task getTask() {
        return this.parentTask;
    }

    public Map<String, String> getJobProperties() {
        return this.fJobProperties;
    }

    public void log(String s) {
        this.log(s, 2);
    }

    public void log(String s, int msgLevel) {
        if (this.parentTask != null) {
            this.parentTask.log(s, msgLevel);
        } else {
            System.out.println(s);
        }
    }

    protected void cleanup() {
    }

    protected String getCurrentDate(Properties p) {
        return p.getProperty(CURRENT_DATE);
    }

    protected String getCurrentTime(Properties p) {
        return p.getProperty(CURRENT_TIME);
    }

    protected String getCurrentMillisecond(Properties p) {
        return p.getProperty(CURRENT_MILLISECOND);
    }

    public void destroy() {
    }

    public boolean isConsolidatedLogs() {
        return this.isConsolidatedLogs;
    }

    public File getConsolidatedLog() {
        return this.consolidatedLog;
    }

    public void recordLogSeverity(BuildStatus status) {
        if (this.highestLogSeverity == null || status.isMoreSevere(this.highestLogSeverity)) {
            this.highestLogSeverity = status;
        }
    }

    public static void staticMemoryReset() {
        langDefToMacro = null;
    }
}

