/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant;

import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.enterprise.build.ant.IBuildableResource;
import com.ibm.team.enterprise.build.ant.IFileSystemUtil;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.common.buildreport.BuildFileXMLModel;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILoadFilter;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.load.LoadFilter;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class SourceControlUtility {
    static {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
            new SourceControlUtility();
        }
    }

    private SourceControlUtility() {
    }

    public static void updateFileCopyArea(final IWorkspaceConnection workspaceConnection, IFileSystemUtil fileSystemUtil, boolean isHFS, boolean includedComponents, Collection<IComponentHandle> components, boolean synchronizeLoad, Collection<ILoadRule2> loadRules, boolean createFoldersForComponents, IProgressMonitor monitor) throws TeamRepositoryException {
        ILoadOperation loadOp;
        Path rootPath = null;
        if (isHFS) {
            File localRoot = new File(fileSystemUtil.getDestinationPath());
            try {
                rootPath = new Path(localRoot.getCanonicalPath());
            }
            catch (IOException e) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.SourceControlUtility_INVALID_ROOT_PATH, (Object)localRoot), (Throwable)e);
            }
            localRoot.mkdirs();
        }
        if (!synchronizeLoad) {
            workspaceConnection.refresh(monitor);
        }
        LoadDilemmaHandler handler = SourceControlUtility.getLoadDilemmaHandler();
        HashSet<UUID> componentsToLoad = new HashSet<UUID>();
        if (includedComponents) {
            for (IComponentHandle component : components) {
                componentsToLoad.add(component.getItemId());
            }
        } else if (components.isEmpty()) {
            for (IComponentHandle component : workspaceConnection.getComponents()) {
                componentsToLoad.add(component.getItemId());
            }
        } else {
            HashSet<UUID> componentIds = new HashSet<UUID>();
            for (IComponentHandle component : components) {
                componentIds.add(component.getItemId());
            }
            for (IComponentHandle component : workspaceConnection.getComponents()) {
                if (componentIds.contains(component.getItemId())) continue;
                componentsToLoad.add(component.getItemId());
            }
        }
        ISynchronizationInfo synchronizationInfo = null;
        if (synchronizeLoad) {
            synchronizationInfo = ISynchronizationInfo.FACTORY.newInstance();
            for (ICurrentComponentInfo componentInfo : workspaceConnection.getComponentsInfo()) {
                if (!componentsToLoad.contains(componentInfo.getComponent().getItemId())) continue;
                synchronizationInfo.addConfigurationTime((IWorkspaceHandle)workspaceConnection.getResolvedWorkspace(), componentInfo.getComponent(), componentInfo.configurationTime());
            }
        }
        ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox((ILocation)(rootPath != null ? new PathLocation((IPath)rootPath) : fileSystemUtil.createLocation(fileSystemUtil.getPrefix())), false);
        ArrayList<ILoadOperation> loadOperations = new ArrayList<ILoadOperation>(1 + loadRules.size());
        HashSet<UUID> componentIdsFromLoadRules = new HashSet<UUID>();
        if (isHFS) {
            for (ILoadRule2 loadRule : loadRules) {
                loadOp = loadRule.getLoadOp(sandbox, handler, monitor);
                for (ILoadRequest request : loadOp.getLoadRequests()) {
                    if (!componentsToLoad.contains(request.getComponent().getItemId())) {
                        IItem component = null;
                        try {
                            component = workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)request.getComponent(), 0, monitor);
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            // empty catch block
                        }
                        if (component instanceof IComponent) {
                            throw new TeamRepositoryException(NLS.bind((String)Messages.SourceControlUtility_LOAD_RULE_FOR_NAMED_UNLOADED_COMPONENT, (Object)((IComponent)component).getName()));
                        }
                        throw new TeamRepositoryException(Messages.SourceControlUtility_LOAD_RULE_FOR_UNLOADED_COMPONENT);
                    }
                    componentIdsFromLoadRules.add(request.getComponent().getItemId());
                    if (!synchronizeLoad || synchronizationInfo == null) continue;
                    loadOp.setSychronizationInfo(synchronizationInfo);
                }
                loadOp.setEclipseSpecificLoadOptions(0);
                loadOperations.add(loadOp);
            }
        }
        ArrayList<IShare> toUnshareList = new ArrayList<IShare>();
        if (isHFS || !includedComponents) {
            IShare[] shares = sandbox.allShares(monitor);
            int i = 0;
            while (i < shares.length) {
                if (shares[i].getSharingDescriptor().getConnectionHandle().sameItemId((IItemHandle)workspaceConnection.getContextHandle()) && !componentsToLoad.contains(shares[i].getSharingDescriptor().getComponent().getItemId())) {
                    toUnshareList.add(shares[i]);
                }
                ++i;
            }
        }
        if (!toUnshareList.isEmpty()) {
            IUnshareOperation unshareOp = IOperationFactory.instance.getUnshareOperation(UnshareDilemmaHandler.getDefault(), new IRepositoryResolver(){

                public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                    return workspaceConnection.teamRepository();
                }
            });
            unshareOp.requestUnshareShares(toUnshareList);
            unshareOp.setDeleteContent(true);
            unshareOp.run(monitor);
        }
        RelativeLocation relativeLocation = null;
        if (isHFS && createFoldersForComponents) {
            for (ILoadOperation loadOperation : loadOperations) {
                Collection requests = loadOperation.getLoadRequests();
                loadOperation.removeLoadRequests(requests);
                IItemHandle prevComponentHandle = null;
                for (ILoadRequest request : requests) {
                    IItem component = null;
                    try {
                        if (!request.getComponent().sameItemId(prevComponentHandle)) {
                            component = workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)request.getComponent(), 1, monitor);
                        }
                    }
                    catch (TeamRepositoryException teamRepositoryException) {
                        // empty catch block
                    }
                    if (!(component instanceof IComponent)) continue;
                    relativeLocation = new RelativeLocation(((IComponent)component).getName());
                    if (request.getRelativeLoadPath() != null) {
                        relativeLocation.append(request.getRelativeLoadPath());
                    }
                    if (!(request.getConnection() instanceof IWorkspaceConnection)) continue;
                    if (request.getAlternativeName() != null && !request.getAlternativeName().equals("")) {
                        loadOperation.requestLoadAs(sandbox, (IRelativeLocation)relativeLocation, request.getAlternativeName(), (IWorkspaceConnection)request.getConnection(), request.getComponent(), request.getVersionableToLoad());
                        continue;
                    }
                    loadOperation.requestLoad(sandbox, (IRelativeLocation)relativeLocation, (IWorkspaceConnection)request.getConnection(), request.getComponent(), Collections.singleton(request.getVersionableToLoad()));
                }
            }
        }
        loadOp = IOperationFactory.instance.getLoadOperation(handler);
        if (synchronizeLoad && synchronizationInfo != null) {
            loadOp.setSychronizationInfo(synchronizationInfo);
        }
        boolean entireComponentsToLoad = false;
        for (IComponentHandle component : workspaceConnection.getComponents()) {
            IItem completeComponent;
            if (!componentsToLoad.contains(component.getItemId()) || componentIdsFromLoadRules.contains(component.getItemId())) continue;
            IConfiguration configuration = workspaceConnection.configuration(component);
            Map children = configuration.childEntriesForRoot(null);
            relativeLocation = null;
            if (isHFS && createFoldersForComponents && (completeComponent = workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)component, 1, monitor)) instanceof IComponent) {
                relativeLocation = new RelativeLocation(((IComponent)completeComponent).getName());
            }
            loadOp.requestLoad(sandbox, (IRelativeLocation)relativeLocation, workspaceConnection, component, children.values());
            entireComponentsToLoad = true;
        }
        if (entireComponentsToLoad) {
            loadOperations.add(loadOp);
        }
        try {
            for (ILoadOperation loadOperation : loadOperations) {
                if (isHFS) {
                    ILoadFilter filter = LoadFilter.exclude((String[])new String[]{"zOSsrc", ".zOSbin", "zOSout"});
                    loadOperation.setLoadFilter(filter);
                }
                loadOperation.run(monitor);
            }
        }
        catch (StaleDataException e) {
            throw new TeamBuildException(Messages.SourceControlUtility_LOAD_STALE_DATA, (Throwable)e);
        }
    }

    public static LoadDilemmaHandler getLoadDilemmaHandler() {
        return SourceControlUtility.getLoadDilemmaHandler(null, null);
    }

    public static LoadDilemmaHandler getLoadDilemmaHandler(final Task task, final List<IBuildableResource> buildables) {
        LoadDilemmaHandler handler = new LoadDilemmaHandler(){

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                for (ICollision collision : collisions) {
                    if (collision.getLocations().size() > 1) {
                        return 2;
                    }
                    collision.setLoadLocation((ILoadLocation)collision.getLocations().iterator().next());
                }
                for (IRemovedShare removedShare : removedShares) {
                    removedShare.isToBeDeleted(true);
                }
                return 0;
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return new BackupDilemmaHandler(){

                    public boolean backupEnabled() {
                        return false;
                    }
                };
            }

            public int deletedContent(Collection<IShareable> contentDeleted) {
                return 0;
            }

            public int invalidLoadRequest(Collection<IInvalidLoadRequest> requests) {
                for (IInvalidLoadRequest invalidRequest : requests) {
                    ILoadRequest loadRequest = invalidRequest.getInvalidRequest();
                    String name = this.resolveName(loadRequest.getVersionableToLoad().getItemId().getUuidValue());
                    if (name == null) {
                        name = loadRequest.getVersionableToLoad().getItemId().getUuidValue();
                    }
                    String message = NLS.bind((String)Messages.SourceControlUtility_INVALID_LOAD_REQUEST, (Object)name);
                    if (task == null) {
                        System.out.println(message);
                        continue;
                    }
                    task.log(message, 1);
                }
                return 2;
            }

            private String resolveName(String uuid) {
                if (buildables != null && uuid != null) {
                    for (IBuildableResource buildable : buildables) {
                        for (BuildFileXMLModel buildFile : buildable.getInputFiles()) {
                            if (!uuid.equals(buildFile.getFileUUID())) continue;
                            if (buildFile.getScmLocation() != null && !buildFile.getScmLocation().equals("")) {
                                return buildFile.getScmLocation();
                            }
                            return buildFile.getBuildFile();
                        }
                    }
                }
                return null;
            }
        };
        return handler;
    }
}

