/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.property.LocalProperties;
import org.apache.tools.ant.taskdefs.condition.AntVersion;

public class EEPropertyHelper
extends PropertyHelper {
    private final ThreadLocal<List<String>> propertiesToFilter = new ThreadLocal();
    private final ThreadLocal<Boolean> ignoreEscaping = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(PropertyHelper orig, Project project) {
        Hashtable props;
        this.setProject(project);
        project.addReference("ant.PropertyHelper", (Object)this);
        orig.copyUserProperties(project);
        orig.copyInheritedProperties(project);
        Hashtable hashtable = props = orig.getProperties();
        synchronized (hashtable) {
            Enumeration e = props.keys();
            while (e.hasMoreElements()) {
                Object arg = e.nextElement();
                Object value = props.get(arg);
                this.setProperty(null, arg.toString(), value.toString(), true);
            }
        }
        AntVersion av = new AntVersion();
        av.setAtLeast("1.8.0");
        if (av.eval()) {
            try {
                Method add = EEPropertyHelper.class.getMethod("add", Class.forName("org.apache.tools.ant.PropertyHelper$Delegate"));
                add.invoke((Object)this, LocalProperties.get((Project)project));
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void parsePropertyString(String value, Vector fragments, Vector propertyRefs) throws BuildException {
        value = this.escape(value);
        super.parsePropertyString(value, fragments, propertyRefs);
    }

    public Object parseProperties(String value) throws BuildException {
        value = this.escape(value);
        return super.parseProperties(value);
    }

    private String escape(String value) {
        if (value == null || value.length() == 0 || value.indexOf(36) == -1 || this.ignoreEscaping.get().booleanValue()) {
            return value;
        }
        int len = value.length();
        StringBuilder buf = new StringBuilder(len + 10);
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            buf.append(c);
            if (c == '$' && (i + 1 >= len || value.charAt(i + 1) != '{')) {
                buf.append('$');
            }
            ++i;
        }
        return buf.toString();
    }

    public Object getProperty(String name) {
        List<String> filters = this.propertiesToFilter.get();
        if (filters != null && filters.contains(name)) {
            return "${" + name + "}";
        }
        return super.getProperty(name);
    }

    public void setThreadLocalFilter(List<String> propertyNames) {
        this.propertiesToFilter.set(propertyNames);
    }

    public void removeThreadLocalFilter() {
        this.propertiesToFilter.remove();
    }

    public void setIgnoreFiltering(boolean ignore) {
        if (ignore) {
            this.ignoreEscaping.set(ignore);
        } else {
            this.ignoreEscaping.remove();
        }
    }
}

