/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.CompileProblemType;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.ICompileContribution;
import com.ibm.team.build.common.model.ICompilePackage;
import com.ibm.team.build.common.model.ICompileProblem;
import com.ibm.team.build.common.model.ICompileSource;
import com.ibm.team.build.internal.PasswordHelper;
import com.ibm.team.build.internal.client.ProxyHelper;
import com.ibm.team.build.internal.publishing.ContentPublisher;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CompileContributionUtility {
    private static final String UTF_8 = "UTF-8";
    private static final String TEXT_XML = "text/xml";
    private static final String YES = "yes";
    private static final String INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    private static final String THREE = "3";

    public static ICompileSource createSourceFile(String filename, String path, int errors, int warnings) {
        ICompileSource compileSource = BuildItemFactory.createCompileSource();
        compileSource.setSourceName(filename);
        compileSource.setSourcePath(path);
        compileSource.setWarningCount(warnings);
        compileSource.setErrorCount(errors);
        return compileSource;
    }

    public static void addErrorToSource(ICompileSource sourceFile, int lineNumber, String msg) {
        ICompileProblem errorObject = BuildItemFactory.createCompileProblem();
        errorObject.setLineNumber(lineNumber);
        errorObject.setMessageText(msg);
        List compileProblems = sourceFile.getErrors();
        compileProblems.add(errorObject);
    }

    public static void addWarningToSource(ICompileSource sourceFile, int lineNumber, String msg) {
        ICompileProblem warningObject = BuildItemFactory.createCompileProblem();
        warningObject.setLineNumber(lineNumber);
        warningObject.setMessageText(msg);
        List compileProblems = sourceFile.getWarnings();
        compileProblems.add(warningObject);
    }

    public static ICompileContribution createProject(String compileContributionLabel, IBuildResultHandle buildResult, Collection<IBuildResultContribution> contributions) {
        ICompileContribution compileContribution = BuildItemFactory.createCompileContribution();
        compileContribution.setBuildResult(buildResult);
        List compilePackageList = compileContribution.getCompilePackages();
        ICompilePackage compilePackage = BuildItemFactory.createCompilePackage();
        compilePackage.setPackageName(compileContributionLabel);
        compilePackage.setPackageType("project");
        compilePackage.setBuildResult(buildResult);
        compilePackageList.add(compilePackage);
        IBuildResultContribution buildResultContribution = BuildItemFactory.createBuildResultContribution();
        buildResultContribution.setLabel(compileContributionLabel);
        buildResultContribution.setImpactsPrimaryResult(true);
        buildResultContribution.setExtendedContribution((IItemHandle)compileContribution);
        buildResultContribution.setExtendedContributionTypeId(ICompileContribution.EXTENDED_CONTRIBUTION_TYPE_ID);
        contributions.add(buildResultContribution);
        return compileContribution;
    }

    public static ICompilePackage addCompilePackage(ICompilePackage compilePackage, String compilePackageLabel, IBuildResultHandle buildResult) {
        List subPackages = compilePackage.getSubCompilePackages();
        ICompilePackage subCompilePackage = BuildItemFactory.createCompilePackage();
        subCompilePackage.setPackageName(compilePackageLabel);
        subCompilePackage.setPackageType("folder");
        subCompilePackage.setBuildResult(buildResult);
        subPackages.add(subCompilePackage);
        return subCompilePackage;
    }

    public static void updateCompilePackageCounts(ICompilePackage compilePackage, int errors, int warnings) {
        compilePackage.setErrorCount(compilePackage.getErrorCount() + errors);
        compilePackage.setWarningCount(compilePackage.getWarningCount() + warnings);
        compilePackage.setClassCount(compilePackage.getClassCount() + 1);
    }

    public static ITeamRepository getTeamRepository(ITeamRepository fTeamRepository, BuildEvent event, String user, String pwd, String repositoryAddress) throws TeamRepositoryException, FileNotFoundException, IOException {
        if (fTeamRepository == null) {
            fTeamRepository = TeamPlatform.getTeamRepositoryService().getUnmanagedRepository(repositoryAddress);
            final String userId = user;
            final String password = pwd;
            fTeamRepository.registerLoginHandler(new ITeamRepository.ILoginHandler(){

                public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repo) {
                    return new ITeamRepository.ILoginHandler.ILoginInfo(){

                        public String getUserId() {
                            return userId;
                        }

                        public String getPassword() {
                            return password;
                        }
                    };
                }
            });
            String host = ProxyHelper.getProxyHost((String)repositoryAddress);
            if (host != null) {
                int port = ProxyHelper.getProxyPort((String)repositoryAddress);
                String proxyType = ProxyHelper.getProxyType((String)repositoryAddress);
                fTeamRepository.setProxy(host, proxyType, port, userId, password);
            }
        }
        if (!fTeamRepository.loggedIn()) {
            fTeamRepository.login(CompileContributionUtility.getProgressMonitor());
        }
        return fTeamRepository;
    }

    public static String getProvidedPassword(BuildEvent event, String pwdFile) throws TeamRepositoryException, FileNotFoundException, IOException {
        File passwordFile = new File(pwdFile);
        if (passwordFile != null && passwordFile.exists()) {
            try {
                return CompileContributionUtility.decryptPassword(passwordFile);
            }
            catch (Exception exception) {
                throw new TeamRepositoryException((Throwable)exception);
            }
        }
        return null;
    }

    public static String decryptPassword(File passwordFile) throws Exception {
        return PasswordHelper.getPassword((File)passwordFile);
    }

    public static IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    public static void publishBuildResultContributions(IBuildResult buildResult, ITeamRepository teamRepository, Collection<IBuildResultContribution> contributions) throws TeamRepositoryException {
        IProgressMonitor monitor = CompileContributionUtility.getProgressMonitor();
        for (IBuildResultContribution contribution : contributions) {
            ICompileContribution compileContribution = (ICompileContribution)contribution.getExtendedContribution();
            for (Object object : compileContribution.getCompilePackages()) {
                ICompilePackage compilePackage = (ICompilePackage)object;
                compileContribution.setClassCount(compileContribution.getClassCount() + compilePackage.getClassCount());
                compileContribution.setErrorCount(compileContribution.getErrorCount() + compilePackage.getErrorCount());
                compileContribution.setWarningCount(compileContribution.getWarningCount() + compilePackage.getWarningCount());
                CompileContributionUtility.saveCompilePackage(compilePackage, teamRepository, CompileContributionUtility.getProgressMonitor());
            }
            if (compileContribution.getErrorCount() > 0) {
                contribution.setStatus(BuildStatus.ERROR);
            }
            ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).save(compileContribution, monitor);
        }
        ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).addBuildResultContributions((IBuildResultHandle)buildResult, contributions.toArray(new IBuildResultContribution[contributions.size()]), monitor);
    }

    public static void publishCompileContributionsXml(File file, IBuildResult buildResult, ITeamRepository teamRepository, Collection<IBuildResultContribution> contributions) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().newDocument();
        Element rootElement = doc.createElement("compiler");
        doc.appendChild(rootElement);
        for (IBuildResultContribution contribution : contributions) {
            ICompileContribution compileContribution = (ICompileContribution)contribution.getExtendedContribution();
            for (Object object : compileContribution.getCompilePackages()) {
                ICompilePackage compilePackage = (ICompilePackage)object;
                Element projectElement = doc.createElement("zproject");
                rootElement.appendChild(projectElement);
                projectElement.setAttribute("name", compilePackage.getPackageName());
                projectElement.setAttribute("classCount", Integer.toString(compilePackage.getClassCount()));
                projectElement.setAttribute("errorCount", Integer.toString(compilePackage.getErrorCount()));
                projectElement.setAttribute("warningCount", Integer.toString(compilePackage.getWarningCount()));
                for (Object obj : compilePackage.getSubCompilePackages()) {
                    ICompilePackage folder = (ICompilePackage)obj;
                    Element folderElement = doc.createElement("zfolder");
                    projectElement.appendChild(folderElement);
                    folderElement.setAttribute("name", folder.getPackageName());
                    folderElement.setAttribute("classCount", Integer.toString(folder.getClassCount()));
                    folderElement.setAttribute("errorCount", Integer.toString(folder.getErrorCount()));
                    folderElement.setAttribute("warningCount", Integer.toString(folder.getWarningCount()));
                    for (Object ob : folder.getCompileSources()) {
                        Element problemElement;
                        ICompileProblem problem;
                        ICompileSource source = (ICompileSource)ob;
                        Element sourceElement = doc.createElement("zfile");
                        folderElement.appendChild(sourceElement);
                        sourceElement.setAttribute("name", source.getSourceName());
                        sourceElement.setAttribute("errorCount", Integer.toString(source.getErrorCount()));
                        sourceElement.setAttribute("warningCount", Integer.toString(source.getWarningCount()));
                        for (Object o : source.getErrors()) {
                            problem = (ICompileProblem)o;
                            problemElement = doc.createElement("problem");
                            sourceElement.appendChild(problemElement);
                            problemElement.setAttribute("msg", problem.getMessageText());
                            problemElement.setAttribute("line", Integer.toString(problem.getLineNumber()));
                            problemElement.setAttribute("type", CompileProblemType.ERROR.toString());
                        }
                        for (Object o : source.getWarnings()) {
                            problem = (ICompileProblem)o;
                            problemElement = doc.createElement("problem");
                            sourceElement.appendChild(problemElement);
                            problemElement.setAttribute("msg", problem.getMessageText());
                            problemElement.setAttribute("line", Integer.toString(problem.getLineNumber()));
                            problemElement.setAttribute("type", CompileProblemType.WARNING.toString());
                        }
                    }
                }
            }
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", YES);
        transformer.setOutputProperty(INDENT_AMOUNT, THREE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
        baos.flush();
        String s = baos.toString(UTF_8);
        baos.close();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        bos.write(s.getBytes(UTF_8));
        bos.flush();
        bos.close();
        CompileContributionUtility.publishFile(file, buildResult, teamRepository, "Compilation contribution XML");
    }

    private static void publishFile(File file, IBuildResult buildResult, ITeamRepository teamRepository, String label) throws TeamRepositoryException {
        String contributionStatus = BuildStatus.OK.name();
        ContentPublisher filePublisher = new ContentPublisher(IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID, file.getAbsolutePath(), label, TEXT_XML, UTF_8);
        IBuildResultContribution contribution = filePublisher.publish((IBuildResultHandle)buildResult, BuildStatus.valueOf((String)contributionStatus), teamRepository);
        if (contribution == null) {
            throw new BuildException("LinkPublisher failed (contribution == null)");
        }
    }

    private static void saveCompilePackage(ICompilePackage compilePackage, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        for (Object object : compilePackage.getSubCompilePackages()) {
            CompileContributionUtility.saveCompilePackage((ICompilePackage)object, teamRepository, monitor);
        }
        ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).save(compilePackage, monitor);
    }

    public static ICompileContribution createPlaceHolderCompilePackage(String name, IBuildResultHandle buildResult, Collection<IBuildResultContribution> contributions) {
        ICompileContribution compileContribution = BuildItemFactory.createCompileContribution();
        compileContribution.setBuildResult(buildResult);
        ICompilePackage compilePackage = BuildItemFactory.createCompilePackage();
        compilePackage.setPackageName(name);
        compilePackage.setPackageType("folder");
        compilePackage.setBuildResult(buildResult);
        compileContribution.getCompilePackages().add(compilePackage);
        IBuildResultContribution buildResultContribution = BuildItemFactory.createBuildResultContribution();
        buildResultContribution.setLabel(name);
        buildResultContribution.setImpactsPrimaryResult(true);
        buildResultContribution.setExtendedContribution((IItemHandle)compileContribution);
        buildResultContribution.setExtendedContributionTypeId(ICompileContribution.EXTENDED_CONTRIBUTION_TYPE_ID);
        contributions.add(buildResultContribution);
        return compileContribution;
    }
}

