/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant;

import com.ibm.team.build.extensions.client.util.SCMComponent;
import com.ibm.team.enterprise.build.ant.EEPropertyHelper;
import com.ibm.team.enterprise.build.ant.IBuildableResource;
import com.ibm.team.enterprise.build.ant.IFileSystemUtil;
import com.ibm.team.enterprise.build.ant.SourceControlUtility;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildFileUtil;
import com.ibm.team.enterprise.build.ant.internal.utils.FileSystemUtilFactory;
import com.ibm.team.enterprise.build.ant.internal.utils.SimulationUtil;
import com.ibm.team.enterprise.build.ant.tasks.AbstractCompileTask;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.common.buildreport.BuildFileXMLModel;
import com.ibm.team.enterprise.build.common.buildreport.BuildReportGenerator;
import com.ibm.team.enterprise.build.common.simulationregistry.ISimulationRegistryFile;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.load.LoadFilter;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractFileSystemUtil
implements IFileSystemUtil {
    private static final String EMPTY_STRING = "";
    private static final char SLASH = '/';
    private static final String COLON = ":";
    private static final String RIGHT_PARENTHESIS = ")";
    private static final String LEFT_PARENTHESIS = "(";
    private static final int INITIAL_SIZE = 5;
    private String prefix;
    private String teamPrefix;
    private String workspaceUuid;
    private String teamWorkspaceUuid;
    private String destinationPath;

    public AbstractFileSystemUtil() {
    }

    public AbstractFileSystemUtil(String prefix, String workspaceUuid) {
        this.prefix = prefix;
        this.workspaceUuid = workspaceUuid;
    }

    @Override
    public boolean doesFileExist(Task task, IOutputBuildFile file) {
        return true;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getTeamPrefix() {
        return this.teamPrefix;
    }

    @Override
    public void setTeamPrefix(String teamPrefix) {
        this.teamPrefix = teamPrefix;
    }

    @Override
    public String getWorkspaceUuid() {
        return this.workspaceUuid;
    }

    @Override
    public void setWorkspaceUuid(String workspaceUuid) {
        this.workspaceUuid = workspaceUuid;
    }

    @Override
    public String getTeamWorkspaceUuid() {
        return this.teamWorkspaceUuid;
    }

    @Override
    public void setTeamWorkspaceUuid(String teamWorkspaceUuid) {
        this.teamWorkspaceUuid = teamWorkspaceUuid;
    }

    @Override
    public String getDestinationPath() {
        return this.destinationPath;
    }

    @Override
    public void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }

    @Override
    public abstract void delete(Task var1, IBuildFile var2);

    @Override
    public abstract void delete(Task var1, String var2, String var3, String var4);

    @Override
    public abstract boolean exists(Task var1, IBuildFile var2);

    @Override
    public abstract boolean fileExists(Task var1, ISimulationRegistryFile var2);

    public boolean fileExistsHFS(Task task, String hfsPath, String baseDir) {
        boolean exists;
        try {
            exists = new File(baseDir, hfsPath).exists();
        }
        catch (Exception e) {
            e.printStackTrace();
            exists = false;
        }
        task.log("HFS file exists: " + exists, 4);
        return exists;
    }

    @Override
    public boolean resolveFile(Task task, IBuildableResource buildableResource, BuildFileXMLModel inputFile) throws Exception {
        boolean result = false;
        String buildPath = inputFile.getBuildPath();
        task.log("Attempt to resolve " + inputFile.getBuildFile() + " with the following build path '" + buildPath + "' for " + buildableResource, 4);
        Project project = task.getProject();
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)project);
        Hashtable buildProperties = project.getProperties();
        task.log("Parser output build path is : " + inputFile.getParserOutputBuildPath(), 4);
        if (buildPath != null) {
            String dsn = this.replaceProperties(buildPath, propertyHelper, buildProperties);
            task.log("dsn is " + dsn, 4);
            ArrayList<String> parserOutputBuildPaths = new ArrayList<String>();
            if (inputFile.getParserOutputBuildPath() != null && !inputFile.getParserOutputBuildPath().isEmpty()) {
                String parserOutputBuildPathValue = this.replaceProperties(inputFile.getParserOutputBuildPath(), propertyHelper, buildProperties);
                parserOutputBuildPathValue = parserOutputBuildPathValue.toLowerCase();
                String[] stringArray = parserOutputBuildPathValue.split(COLON);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String parserOutputBuildPathSegment = stringArray[n2];
                    parserOutputBuildPaths.add(parserOutputBuildPathSegment);
                    task.log("parserOutputBuildPaths added " + parserOutputBuildPathSegment, 4);
                    ++n2;
                }
            }
            if (dsn.contains(COLON) || inputFile.getTimestamp() == 0L) {
                String[] dsns = dsn.split(COLON);
                IInputBuildFile fileFound = null;
                IInputBuildFile f = BuildFileUtil.getInputFileFromXMLModel(inputFile);
                String[] stringArray = dsns;
                int n = dsns.length;
                int n3 = 0;
                while (n3 < n) {
                    String d = stringArray[n3];
                    if (BuildFileUtil.isDsNameExcludedFromParserOutput(d, f.getBuildFile(), task)) {
                        task.log("excluding from parser output " + d, 4);
                    } else if (this.isPDSValid(task, d)) {
                        task.log("PDS " + d + " is a valid PDS, trying to resolve " + f.getBuildFile(), 4);
                        f.setBuildPath(d);
                        if (this.existsBuildFile(task, (IBuildFile)f)) {
                            task.log("file exists " + d, 4);
                            fileFound = f;
                            break;
                        }
                    }
                    ++n3;
                }
                if (fileFound != null) {
                    boolean addedToParserOutput = false;
                    task.log("fileFound = " + this.getDataSetNameWithMember((IBuildFile)fileFound), 4);
                    HashMap<String, IInputBuildFile> physicalDependencyCache = ((AbstractCompileTask)task).getPhysicalDependencyCache();
                    IInputBuildFile cachedInputFile = null;
                    if (!physicalDependencyCache.containsKey(this.getDataSetNameWithMember((IBuildFile)fileFound))) {
                        task.log("not in cache", 4);
                        long timestamp = this.lastModified(task, (IBuildFile)fileFound);
                        if (0L < timestamp) {
                            cachedInputFile = BuildFileUtil.cloneInputBuildFile(fileFound);
                            cachedInputFile.setTimestamp(new Timestamp(timestamp));
                            physicalDependencyCache.put(this.getDataSetNameWithMember((IBuildFile)fileFound), cachedInputFile);
                            task.log("created new cache entry", 4);
                        }
                    } else {
                        task.log("using clone from physical dependency cache " + this.getDataSetNameWithMember((IBuildFile)fileFound), 4);
                        cachedInputFile = physicalDependencyCache.get(this.getDataSetNameWithMember((IBuildFile)fileFound));
                    }
                    task.log("cached inputfile is " + cachedInputFile, 4);
                    if (cachedInputFile != null && (!FileSystemUtilFactory.isRunningOnZ() || parserOutputBuildPaths.contains(cachedInputFile.getBuildPath().toLowerCase()))) {
                        if (buildableResource.getResolvedInputFiles() == null) {
                            buildableResource.setResolvedInputFiles(new HashSet<BuildFileXMLModel>(10));
                        }
                        task.log("Adding " + this.getDataSetNameWithMember((IBuildFile)cachedInputFile) + " to resolved input files", 4);
                        buildableResource.getResolvedInputFiles().add(BuildFileUtil.getXMLModelFromInputBuildFile(cachedInputFile));
                        result = true;
                        task.log("Resolved input files size is now " + buildableResource.getResolvedInputFiles().size(), 4);
                        addedToParserOutput = true;
                    }
                    if (!addedToParserOutput) {
                        task.log("Setting resolvedTo on inputFile to " + fileFound.getBuildPath());
                        inputFile.setResolvedTo(fileFound.getBuildPath());
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    private String replaceProperties(String s, PropertyHelper propertyHelper, Hashtable<String, Object> buildProperties) {
        return propertyHelper.replaceProperties(null, s, buildProperties);
    }

    private boolean existsBuildFile(Task task, IBuildFile f) {
        String fullName = this.getDataSetNameWithMember(f);
        boolean fileExists = false;
        HashMap<String, IInputBuildFile> cache = ((AbstractCompileTask)task).getPhysicalDependencyCache();
        IBuildFile cachedFile = (IBuildFile)cache.get(fullName);
        if (cache.containsKey(fullName)) {
            task.log(String.valueOf(fullName) + " is in the cache", 4);
            fileExists = cachedFile != null;
        } else {
            task.log(String.valueOf(fullName) + " is not in the cache", 4);
            fileExists = this.exists(task, f);
            if (!fileExists) {
                cache.put(fullName, null);
            }
        }
        return fileExists;
    }

    private String getDataSetNameWithMember(IBuildFile buildFile) {
        return String.valueOf(buildFile.getBuildPath()) + LEFT_PARENTHESIS + buildFile.getBuildFile() + RIGHT_PARENTHESIS;
    }

    @Override
    public abstract long lastModified(Task var1, IBuildFile var2);

    @Override
    public abstract long lastModified(Task var1, IBuildFile var2, boolean var3);

    @Override
    public long resolveHFSOutputs(Task task, String baseDir, String hfsOutput, String resolvedName, IBuildMap buildMap, String resourceId, String resourceStateId, List<String> buildDefProperties, String deployType, Properties temporaryOutputProperties) {
        boolean resolveOutputs = !resolvedName.trim().endsWith("/");
        return this.resolveHFSOutputs(task, baseDir, hfsOutput, resolvedName, buildMap, resolveOutputs, true, resourceId, resourceStateId, buildDefProperties, deployType, temporaryOutputProperties);
    }

    private long resolveHFSOutputs(Task task, String baseDir, String hfsOutput, String resolvedName, IBuildMap buildMap, boolean resolveOutputs, boolean topLevel, String resourceId, String resourceStateId, List<String> buildDefProperties, String deployType, Properties temporaryOutputProperties) {
        long lastModified;
        File f;
        String[] dirs;
        String[] files;
        boolean containsWildcard;
        long result = 0L;
        boolean addOutputs = resolveOutputs && buildMap != null;
        boolean needScanner = containsWildcard = resolvedName.contains("*") || resolvedName.contains("?");
        if (!containsWildcard) {
            File file = new File(baseDir, resolvedName);
            if (!file.exists()) {
                throw new BuildException(NLS.bind((String)Messages.HFS_OUTPUT_DOES_NOT_EXIST, (Object)file.getAbsolutePath()));
            }
            boolean expectDirectory = resolvedName.endsWith("/");
            if (file.isDirectory()) {
                needScanner = true;
                if (!expectDirectory) {
                    task.log(NLS.bind((String)Messages.HFS_OUTPUT_FOLDER_NOT_FILE, (Object)resolvedName), 1);
                }
            } else if (expectDirectory) {
                task.log(NLS.bind((String)Messages.HFS_OUTPUT_FILE_NOT_FOLDER, (Object)resolvedName), 1);
            }
        }
        if (needScanner) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(baseDir);
            task.log("basedir is " + scanner.getBasedir(), 4);
            scanner.setIncludes(new String[]{resolvedName});
            task.log("include is " + resolvedName, 4);
            scanner.scan();
            task.log("includedFiles  ==  " + scanner.getIncludedFilesCount(), 4);
            task.log("includedDirs  ==  " + scanner.getIncludedDirsCount(), 4);
            files = scanner.getIncludedFiles();
            dirs = scanner.getIncludedDirectories();
        } else {
            files = new String[]{resolvedName};
            dirs = new String[]{};
        }
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            f = this.getHFSFile(task, baseDir, file);
            lastModified = f.lastModified();
            task.log("lastModified for " + file + " is " + lastModified, 4);
            result = Math.max(result, lastModified);
            if (addOutputs) {
                this.addOutput(task, buildMap, baseDir, file.equals(resolvedName) ? hfsOutput : file, file, false, lastModified, resourceId, resourceStateId, buildDefProperties, deployType, temporaryOutputProperties);
            }
            ++n2;
        }
        stringArray = dirs;
        n = dirs.length;
        n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            f = this.getHFSFile(task, baseDir, dir);
            lastModified = f.lastModified();
            task.log("lastModified for " + dir + " is " + lastModified, 4);
            result = Math.max(result, lastModified);
            if (!topLevel) {
                lastModified = this.resolveHFSOutputs(task, baseDir, hfsOutput, dir, buildMap, resolveOutputs, false, resourceId, resourceStateId, buildDefProperties, deployType, temporaryOutputProperties);
                result = Math.max(result, lastModified);
            }
            if (addOutputs) {
                this.addOutput(task, buildMap, baseDir, dir, dir, true, lastModified, resourceId, resourceStateId, buildDefProperties, deployType, temporaryOutputProperties);
            }
            ++n2;
        }
        if (topLevel && !resolveOutputs && buildMap != null) {
            this.addOutput(task, buildMap, baseDir, hfsOutput, resolvedName, true, result, resourceId, resourceStateId, buildDefProperties, deployType, temporaryOutputProperties);
        }
        return result;
    }

    private File getHFSFile(Task task, String baseDir, String filename) {
        File file = new File(String.valueOf(baseDir) + '/' + filename).getAbsoluteFile();
        task.log("resolved HFS file " + baseDir + " " + filename + " == " + file.getAbsolutePath(), 4);
        return file;
    }

    private String[] getHFSBuildFile(String fname, boolean isDir) {
        String path = null;
        String name = null;
        if (isDir) {
            path = fname;
            name = null;
        } else {
            int i;
            int n = i = fname == null ? -1 : fname.lastIndexOf(47);
            if (i >= 0) {
                path = fname.substring(0, ++i);
                name = i < fname.length() ? fname.substring(i, fname.length()) : null;
            } else {
                path = EMPTY_STRING;
                name = fname;
            }
        }
        return new String[]{path == null ? EMPTY_STRING : path, name == null ? EMPTY_STRING : name};
    }

    private void addOutput(Task task, IBuildMap buildMap, String baseDir, String unresolvedFilename, String filename, boolean isDir, long lastModified, String resourceId, String resourceStateId, List<String> buildDefProperties, String deployType, Properties temporaryOutputProperties) {
        IOutputBuildFile obf = this.createOutputFile(task, unresolvedFilename, filename, isDir, lastModified, resourceId, resourceStateId, buildDefProperties, deployType);
        if (temporaryOutputProperties != null) {
            long timestamp = this.lastModified(task, (IBuildFile)obf, true);
            temporaryOutputProperties.put(BuildReportGenerator.buildFileFullPathNameForProperties((BuildFileXMLModel)BuildFileUtil.getXMLModelFromOutputBuildFile(obf)), String.valueOf(timestamp));
        }
        buildMap.getOutputs().add(obf);
    }

    public IOutputBuildFile createOutputFile(Task task, String unresolvedFilename, String filename, boolean isDir, long lastModified, String resourceId, String resourceStateId, List<String> buildDefProperties, String deployType) {
        IOutputBuildFile obf = (IOutputBuildFile)IOutputBuildFile.ITEM_TYPE.createItem();
        String[] parsedUnresolvedFile = this.getHFSBuildFile(unresolvedFilename, isDir);
        String[] parsedFile = this.getHFSBuildFile(filename, isDir);
        if (parsedUnresolvedFile[0].contains("$")) {
            PropertyHelper helper = PropertyHelper.getPropertyHelper((Project)task.getProject());
            if (helper instanceof EEPropertyHelper) {
                ((EEPropertyHelper)helper).setThreadLocalFilter(buildDefProperties);
            }
            parsedUnresolvedFile[0] = helper.replaceProperties(parsedUnresolvedFile[0]);
            if (helper instanceof EEPropertyHelper) {
                ((EEPropertyHelper)helper).removeThreadLocalFilter();
            }
        }
        parsedUnresolvedFile[0] = this.substituteSystemSymbols(parsedUnresolvedFile[0]);
        obf.setBuildPath(parsedFile[0]);
        obf.setBuildFile(parsedFile[1]);
        obf.setHFS(true);
        obf.setTimestamp(new Timestamp(lastModified));
        obf.setType(EMPTY_STRING);
        obf.setSequential(false);
        obf.setPromotionBuildPath(parsedUnresolvedFile[0]);
        obf.setDeployType(deployType);
        if (resourceStateId != null && resourceStateId.length() > 0) {
            obf.setResourceDefinitionStateUUID(UUID.valueOf((String)resourceStateId));
        }
        if (resourceId != null && resourceId.length() > 0) {
            obf.setResourceDefinitionUUID(UUID.valueOf((String)resourceId));
        }
        return obf;
    }

    protected long lastModifiedHFS(Task task, IBuildFile buildFile, String baseDir) {
        String hfsPath = this.getHFSPath(buildFile);
        return this.resolveHFSOutputs(task, baseDir, hfsPath, hfsPath, null, null, null, null, null, null);
    }

    protected String getHFSPath(IBuildFile buildFile) {
        StringBuilder buf = new StringBuilder();
        if (buildFile.getBuildPath() != null && !buildFile.getBuildPath().isEmpty()) {
            buf.append(buildFile.getBuildPath());
        }
        if (buildFile.getBuildFile() != null && !buildFile.getBuildFile().isEmpty()) {
            if (buf.length() > 0 && buf.charAt(buf.length() - 1) != '/') {
                buf.append('/');
            }
            buf.append(buildFile.getBuildFile());
        }
        return buf.toString();
    }

    private String getHFSPath(String path, String filename) {
        StringBuffer b = new StringBuffer();
        if (path != null) {
            b.append(path);
        }
        if (path != null && filename != null) {
            b.append('/');
        }
        if (filename != null) {
            b.append(filename);
        }
        return b.toString();
    }

    public long lastModifiedHFS(Task task, String baseDir, String buildPath, String buildFile) {
        String hfsPath = this.getHFSPath(buildPath, buildFile);
        return this.resolveHFSOutputs(task, baseDir, hfsPath, hfsPath, null, null, null, null, null, null);
    }

    @Override
    public abstract ILocation createLocation(String var1);

    @Override
    public abstract boolean isNativePlatform();

    @Override
    public abstract String substituteSystemSymbols(String var1);

    @Override
    public String substituteYenSignIfNeeded(String value) {
        return value;
    }

    @Override
    public void loadFiles(Task task, List<IBuildableResource> buildables) {
        this.loadFiles(task, buildables, false);
    }

    @Override
    public void loadFiles(final Task task, List<IBuildableResource> buildables, boolean cleanup) {
        SharingManager sharingManager;
        ICorruptCopyFileAreaListener corruptSandboxListener;
        long start;
        block33: {
            if (SimulationUtil.isSimulationMode()) {
                task.log("Simulation build enabled;  skipping the loading of buildable files", 4);
                return;
            }
            if (buildables == null || buildables.size() == 0) {
                return;
            }
            start = System.currentTimeMillis();
            task.log("loadFiles: entry - # of buildable files: " + buildables.size(), 4);
            task.log("loadFiles:  prefix: " + this.getPrefix() + "  workspaceUuid: " + this.getWorkspaceUuid(), 4);
            if (this.getTeamPrefix() != null) {
                task.log("loadFiles:  teamPrefix: " + this.getTeamPrefix() + "  teamWorkspaceUuid: " + this.getTeamWorkspaceUuid(), 4);
            }
            corruptSandboxListener = null;
            sharingManager = null;
            try {
                try {
                    Map<String, Map<String, IVersionableHandle>> buildableMap;
                    ITeamRepository teamRepository = InitTask.getInstance().getTeamRepository();
                    IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository).getWorkspaceConnection((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.getWorkspaceUuid()), null), null);
                    List compHandles = workspaceConnection.getComponents();
                    HashMap<String, IComponent> componentsByName = new HashMap<String, IComponent>(compHandles.size());
                    List components = teamRepository.itemManager().fetchPartialItems(compHandles, 1, Arrays.asList(IComponent.ROOT_FOLDER_PROPERTY, IComponent.NAME_PROPERTY), null);
                    for (IComponent comp : components) {
                        componentsByName.put(comp.getName(), comp);
                    }
                    HashSet<String> compNames = new HashSet<String>(compHandles.size());
                    if (cleanup) {
                        FileSystemCore.startUp();
                        corruptSandboxListener = new ICorruptCopyFileAreaListener(){

                            public void corrupt(ICorruptCopyFileAreaEvent event) {
                                if (event.isCorrupt()) {
                                    task.log(NLS.bind((String)Messages.CORRUPT_SANDBOX_DURING_LOAD, (Object)event.getRoot().toOSString()));
                                    throw new RuntimeException(NLS.bind((String)Messages.CORRUPT_SANDBOX_DURING_LOAD_2, (Object)event.getRoot().toOSString()));
                                }
                            }
                        };
                        sharingManager = (SharingManager)FileSystemCore.getSharingManager();
                        sharingManager.addListener(corruptSandboxListener);
                    }
                    ArrayList<IBuildableResource> hfsFiles = new ArrayList<IBuildableResource>();
                    ArrayList<IBuildableResource> nonHfsFiles = new ArrayList<IBuildableResource>();
                    for (IBuildableResource file : buildables) {
                        if (file.isHFS()) {
                            hfsFiles.add(file);
                            continue;
                        }
                        nonHfsFiles.add(file);
                    }
                    if (!hfsFiles.isEmpty()) {
                        Path rootPath;
                        boolean createFoldersForComponents = Boolean.parseBoolean(task.getProject().getProperty("team.enterprise.scm.createFoldersForComponents"));
                        long hfsstart = System.currentTimeMillis();
                        task.log("load HFS contents...", 4);
                        File localRoot = new File(this.getDestinationPath());
                        try {
                            rootPath = new Path(localRoot.getCanonicalPath());
                        }
                        catch (IOException e) {
                            throw new TeamRepositoryException(NLS.bind((String)Messages.SourceControlUtility_INVALID_ROOT_PATH, (Object)localRoot), (Throwable)e);
                        }
                        localRoot.mkdirs();
                        Map<String, Map<String, IVersionable>> buildableMap2 = this.getHFSProjects(hfsFiles, teamRepository, workspaceConnection, componentsByName);
                        ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox((ILocation)new PathLocation((IPath)rootPath), false);
                        LoadDilemmaHandler dilemma = SourceControlUtility.getLoadDilemmaHandler(task, hfsFiles);
                        ILoadOperation loadOp = IOperationFactory.instance.getLoadOperation(dilemma);
                        loadOp.setLoadFilter(LoadFilter.exclude((String[])new String[]{"zOSsrc", ".zOSbin", "zOSout"}));
                        for (String compName : componentsByName.keySet()) {
                            IComponent comp = (IComponent)componentsByName.get(compName);
                            compNames.add(compName);
                            Map projectMap = (Map)buildableMap2.get(compName);
                            if (projectMap == null || projectMap.isEmpty()) continue;
                            RelativeLocation relativeLocation = null;
                            if (createFoldersForComponents) {
                                relativeLocation = new RelativeLocation(compName);
                            }
                            loadOp.requestLoad(sandbox, (IRelativeLocation)relativeLocation, workspaceConnection, (IComponentHandle)comp, projectMap.values());
                        }
                        Set keyCompNames = buildableMap2.keySet();
                        for (String keyCompName : keyCompNames) {
                            if (compNames.contains(keyCompName)) continue;
                            throw new BuildException(NLS.bind((String)Messages.COMPONENT_NOT_FOUND, (Object)keyCompName));
                        }
                        task.log("call load operation.", 4);
                        if (InitTask.getInstance() != null && InitTask.getInstance().isPerformanceAnalysisEnabled()) {
                            LoadOperationTask loadOperationTask = new LoadOperationTask(loadOp);
                            loadOperationTask.bindToOwner(task);
                            loadOperationTask.setTaskName("(internal) loadoperationtask");
                            loadOperationTask.perform();
                        } else {
                            loadOp.run(null);
                        }
                        task.log("returned from load operation.", 4);
                        task.log("done... Elapsed time: " + (System.currentTimeMillis() - hfsstart) + " msecs.", 4);
                    }
                    if (nonHfsFiles.isEmpty()) break block33;
                    try {
                        buildableMap = this.getBuildableMap(task, nonHfsFiles);
                    }
                    catch (Exception e) {
                        throw new BuildException((Throwable)e);
                    }
                    ILocation libraryLocation = this.createLocation(this.getPrefix());
                    ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(libraryLocation, false);
                    ILoadOperation loadOp = IOperationFactory.instance.getLoadOperation(SourceControlUtility.getLoadDilemmaHandler(task, nonHfsFiles));
                    for (String compName : componentsByName.keySet()) {
                        Collection<IVersionableHandle> versionableHandles;
                        IComponent comp = (IComponent)componentsByName.get(compName);
                        compNames.add(compName);
                        Map<String, IVersionableHandle> map = buildableMap.get(compName);
                        if (map == null || (versionableHandles = map.values()) == null) continue;
                        loadOp.requestLoad(sandbox, null, workspaceConnection, (IComponentHandle)comp, versionableHandles);
                    }
                    Set<String> keyCompNames = buildableMap.keySet();
                    for (String keyCompName : keyCompNames) {
                        if (compNames.contains(keyCompName)) continue;
                        throw new BuildException(NLS.bind((String)Messages.COMPONENT_NOT_FOUND, (Object)keyCompName));
                    }
                    task.log("call load operation.", 4);
                    if (InitTask.getInstance() != null && InitTask.getInstance().isPerformanceAnalysisEnabled()) {
                        LoadOperationTask loadOperationTask = new LoadOperationTask(loadOp);
                        loadOperationTask.bindToOwner(task);
                        loadOperationTask.setTaskName("(internal) loadoperationtask");
                        loadOperationTask.perform();
                    } else {
                        loadOp.run(null);
                    }
                    task.log("returned from load operation.", 4);
                }
                catch (TeamRepositoryException e) {
                    throw new BuildException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                if (cleanup) {
                    if (sharingManager != null & corruptSandboxListener != null) {
                        sharingManager.removeListener(corruptSandboxListener);
                    }
                    try {
                        FileSystemCore.shutDown();
                    }
                    catch (FileSystemException e) {
                        throw new BuildException((Throwable)e);
                    }
                }
                throw throwable;
            }
        }
        if (cleanup) {
            if (sharingManager != null & corruptSandboxListener != null) {
                sharingManager.removeListener(corruptSandboxListener);
            }
            try {
                FileSystemCore.shutDown();
            }
            catch (FileSystemException e) {
                throw new BuildException((Throwable)e);
            }
        }
        task.log(NLS.bind((String)Messages.LOAD_FILE_TIME, (Object)(System.currentTimeMillis() - start)), 3);
    }

    private Map<String, Map<String, IVersionable>> getHFSProjects(List<IBuildableResource> buildables, ITeamRepository repository, IWorkspaceConnection wsConn, Map<String, IComponent> resolvedComponents) throws TeamRepositoryException {
        HashMap<String, Map<String, IVersionable>> componentMap = new HashMap<String, Map<String, IVersionable>>();
        if (buildables != null && !buildables.isEmpty()) {
            for (IBuildableResource resource : buildables) {
                IVersionable project;
                IComponent component;
                HashMap<String, IVersionable> projectMap = (HashMap<String, IVersionable>)componentMap.get(resource.getComponentName());
                if (projectMap == null) {
                    projectMap = new HashMap<String, IVersionable>();
                    componentMap.put(resource.getComponentName(), projectMap);
                }
                if (projectMap.containsKey(resource.getProjectName()) || (component = resolvedComponents.get(resource.getComponentName())) == null || (project = SCMComponent.getProjectFolder((ITeamRepository)repository, (IWorkspaceConnection)wsConn, (IComponentHandle)component, (String)resource.getProjectName())) == null) continue;
                projectMap.put(resource.getProjectName(), project);
            }
        }
        return componentMap;
    }

    private Map<String, Map<String, IVersionableHandle>> getBuildableMap(Task task, List<IBuildableResource> buildables) throws Exception {
        HashMap<String, Map<String, IVersionableHandle>> map = null;
        if (buildables != null && !buildables.isEmpty()) {
            map = new HashMap<String, Map<String, IVersionableHandle>>(5);
            for (IBuildableResource res : buildables) {
                Set<BuildFileXMLModel> files = res.getInputFiles();
                if (files == null || files.isEmpty()) {
                    if (res.getBuildMacro() == null) continue;
                    this.addResourceToMap(task, map, res.getComponentName(), res.getUuid(), res.getBuildFile());
                    continue;
                }
                for (BuildFileXMLModel f : files) {
                    String buildFile;
                    String uuidString;
                    String compName;
                    if (!f.doLoad() || (compName = f.getComponentName()) == null || compName.length() <= 0 || (uuidString = f.getFileUUID()) == null || uuidString.length() <= 0 || (buildFile = f.getBuildFile()) == null || buildFile.length() <= 0) continue;
                    String SCMLocation = f.getScmLocation();
                    if (SCMLocation != null && SCMLocation.length() > 0) {
                        int j;
                        int i = SCMLocation.indexOf(47);
                        if (i >= (j = SCMLocation.lastIndexOf(47))) continue;
                        this.addResourceToMap(task, map, compName, uuidString, buildFile);
                        continue;
                    }
                    this.addResourceToMap(task, map, compName, uuidString, buildFile);
                }
            }
        }
        return map;
    }

    private void addResourceToMap(Task task, Map<String, Map<String, IVersionableHandle>> map, String compName, String uuidString, String buildFile) {
        String buildFile2 = this.substituteYenSignIfNeeded(buildFile);
        if (compName != null) {
            Map<String, IVersionableHandle> set = map.get(compName);
            if (set == null) {
                set = new HashMap<String, IVersionableHandle>(5);
                map.put(compName, set);
            }
            if (set.get(uuidString) == null) {
                IVersionableHandle v = (IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuidString), null);
                task.log(NLS.bind((String)Messages.ADD_FILE_TO_LIST, (Object)buildFile2, (Object)compName), 3);
                set.put(uuidString, v);
            }
        } else {
            task.log("component name is null. res=" + buildFile2, 4);
        }
    }

    @Override
    public boolean isPDSValid(Task task, String pdsName) {
        return true;
    }

    public class LoadOperationTask
    extends Task {
        ILoadOperation loadOp;

        LoadOperationTask(ILoadOperation loadOp) {
            this.loadOp = loadOp;
        }

        public void execute() {
            try {
                this.loadOp.run(null);
            }
            catch (FileSystemException e) {
                throw new BuildException((Throwable)e);
            }
            catch (TeamRepositoryException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }
}

