/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.ui.table;

import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.enterprise.automation.ui.table.AutomationCategoryNode;
import com.ibm.team.enterprise.automation.ui.table.IAutomationObjectsNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class AutomationTreeContentProvider
implements ITreeContentProvider {
    protected List<AutomationCategoryNode> nodes = new ArrayList<AutomationCategoryNode>();

    public AutomationTreeContentProvider() {
        this.initCategories(this.nodes);
    }

    protected abstract void initCategories(List<AutomationCategoryNode> var1);

    protected abstract void createNode(IBuildResultContribution var1);

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        for (AutomationCategoryNode node : this.nodes) {
            node.getChildren().clear();
        }
        if (newInput instanceof IBuildResultContribution[]) {
            IBuildResultContribution[] iBuildResultContributionArray = (IBuildResultContribution[])newInput;
            int n = iBuildResultContributionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildResultContribution contribution = iBuildResultContributionArray[n2];
                this.createNode(contribution);
                ++n2;
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof AutomationCategoryNode) {
            return ((AutomationCategoryNode)inputElement).getChildren().toArray();
        }
        if (inputElement instanceof IAutomationObjectsNode) {
            return null;
        }
        ArrayList<AutomationCategoryNode> nodesNotEmpty = new ArrayList<AutomationCategoryNode>(this.nodes.size());
        for (AutomationCategoryNode node : this.nodes) {
            if (node.getChildren().isEmpty()) continue;
            nodesNotEmpty.add(node);
        }
        if (nodesNotEmpty.size() == 0) {
            return new Object[0];
        }
        if (nodesNotEmpty.size() == 1) {
            return ((AutomationCategoryNode)nodesNotEmpty.get(0)).getChildren().toArray();
        }
        return nodesNotEmpty.toArray();
    }

    public boolean hasChildren(Object element) {
        return element instanceof AutomationCategoryNode;
    }

    public Object[] getChildren(Object parentElement) {
        return this.getElements(parentElement);
    }

    public String getStringTime(String timeInLong) {
        String time = timeInLong;
        try {
            time = TimeFormatHelper.getDateString((long)Long.parseLong(timeInLong));
        }
        catch (NumberFormatException t) {
            Calendar cal = Calendar.getInstance();
            try {
                cal.set(Integer.parseInt(timeInLong.substring(0, 4)), Integer.parseInt(timeInLong.substring(5, 7)) - 1, Integer.parseInt(timeInLong.substring(8, 10)), Integer.parseInt(timeInLong.substring(11, 13)), Integer.parseInt(timeInLong.substring(14, 16)), Integer.parseInt(timeInLong.substring(17, 19)));
                time = TimeFormatHelper.getDateString((long)cal.getTimeInMillis());
            }
            catch (Exception t2) {
                return "";
            }
        }
        return time;
    }

    public Object getParent(Object element) {
        return null;
    }

    public void dispose() {
        this.nodes = null;
    }
}

