/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.ui.table;

import com.ibm.team.enterprise.automation.ui.table.AutomationViewerComparator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AutomationSortableTree {
    private FormToolkit toolkit;
    private ITableLabelProvider labelProvider;
    private IContentProvider contentProvider;
    private TreeViewer fTreeViewer;
    private Tree fTree;
    private AutomationViewerComparator comparator;
    private String[] columnNames;
    private int[] columnWeights;
    private Object input;

    public AutomationSortableTree(FormToolkit toolkit, ITableLabelProvider labelProvider, IContentProvider contentProvider, String[] columnNames, int[] columnWeights, Object input) {
        this.toolkit = toolkit;
        this.labelProvider = labelProvider;
        this.contentProvider = contentProvider;
        this.columnNames = columnNames;
        this.columnWeights = columnWeights;
        this.input = input;
    }

    public Composite createContents(Composite parent) {
        Composite treeComposite = this.toolkit.createComposite(parent);
        this.fTree = this.toolkit.createTree(treeComposite, 67584);
        this.fTree.setHeaderVisible(true);
        this.fTree.setLinesVisible(true);
        this.fTree.setLayoutData((Object)new GridData(1808));
        this.fTreeViewer = new TreeViewer(this.fTree);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.fTreeViewer.setContentProvider(this.contentProvider);
        this.comparator = new AutomationViewerComparator();
        this.fTreeViewer.setComparator((ViewerComparator)this.comparator);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        this.createTreeColumns(this.fTree, treeColumnLayout);
        treeComposite.setLayout((Layout)treeColumnLayout);
        GridDataFactory.fillDefaults().grab(true, true).indent(0, 4).hint(300, 150).applyTo((Control)treeComposite);
        this.fTree.setSortColumn(this.fTree.getColumn(0));
        this.fTree.setSortDirection(128);
        this.comparator.setColumn(0);
        this.fTreeViewer.setInput(this.input);
        this.fTreeViewer.expandAll();
        return treeComposite;
    }

    public Tree getTree() {
        return this.fTree;
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    protected void createTreeColumns(Tree tree, TreeColumnLayout layout) {
        int i = 0;
        while (i < this.columnNames.length) {
            this.createTreeColumn(tree, layout, this.columnNames[i], this.columnWeights[i], 0, i);
            ++i;
        }
    }

    protected void createTreeColumn(Tree tree, TreeColumnLayout treeColumnLayout, String columnName, int weight, int style, int index) {
        TreeColumn treeColumn = new TreeColumn(tree, style, index);
        treeColumn.setText(columnName);
        treeColumn.addSelectionListener(this.getColumnSelectionListener(tree, treeColumn, index));
        treeColumnLayout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(weight));
    }

    protected SelectionListener getColumnSelectionListener(final Tree tree, final TreeColumn treeColumn, final int columnNum) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomationSortableTree.this.comparator.setColumn(columnNum);
                if (tree.getSortColumn() == treeColumn) {
                    if (tree.getSortDirection() == 1024) {
                        tree.setSortDirection(128);
                    } else {
                        tree.setSortDirection(1024);
                    }
                } else {
                    tree.setSortColumn(treeColumn);
                    tree.setSortDirection(128);
                }
                AutomationSortableTree.this.getTreeViewer().refresh();
            }
        };
    }
}

