/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.ui.table;

import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.enterprise.automation.common.resultcontributions.AutomationResultContribution;
import com.ibm.team.enterprise.automation.internal.ui.nls.Messages;
import com.ibm.team.enterprise.automation.ui.table.AutomationCategoryNode;
import com.ibm.team.enterprise.automation.ui.table.AutomationObjectsIBMiNode;
import com.ibm.team.enterprise.automation.ui.table.AutomationTreeContentProvider;
import java.util.List;

public abstract class AutomationIBMiTreeContentProvider
extends AutomationTreeContentProvider {
    private AutomationCategoryNode objectsNode;
    private AutomationCategoryNode hfsNode;

    @Override
    protected void initCategories(List<AutomationCategoryNode> nodesList) {
        this.objectsNode = new AutomationCategoryNode(Messages.AbstractAutomationConfigurationEditor_ADD_LIBRARY_OBJECTS, 1);
        this.hfsNode = new AutomationCategoryNode(Messages.AbstractAutomationConfigurationEditor_ADD_HFS, 2);
        nodesList.add(this.objectsNode);
        nodesList.add(this.hfsNode);
    }

    @Override
    protected void createNode(IBuildResultContribution contribution) {
        AutomationObjectsIBMiNode node = new AutomationObjectsIBMiNode(contribution.getLabel(), contribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_OBJECTTYPE), contribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_OBJECTSUBTYPE), contribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CONTAINER), this.getStringTime(contribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_LAST_MODIFIED)), this.getTranslatedChangeType(contribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CHANGE_TYPE)), contribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM), contribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM_UUID), contribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_RESOURCE_TYPE));
        if (node.isHFS()) {
            this.hfsNode.getChildren().add(node);
        } else {
            this.objectsNode.getChildren().add(node);
        }
    }

    @Override
    public String getStringTime(String timeInLong) {
        String time = timeInLong;
        try {
            time = TimeFormatHelper.getDateString((long)Long.parseLong(timeInLong));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return time;
    }

    protected abstract String getTranslatedChangeType(String var1);
}

