/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.ui.listeners;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.listeners.AbstractBuildDefinitionChangeListener;
import com.ibm.team.enterprise.automation.ui.AbstractAutomationNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;

public abstract class AbstractAutomationNodeChangeListener
extends AbstractBuildDefinitionChangeListener {
    protected final Object fTreeParent;
    protected final IProjectAreaHandle fProjectAreaHandle;
    protected final EnterpriseExtensionsDomainContentProvider fContentProvider;

    public AbstractAutomationNodeChangeListener(EnterpriseExtensionsDomainContentProvider contentProvider, IProjectAreaHandle projectAreaHandle, AbstractAutomationNode parent, List<BuildDefinitionQueryNode> children) {
        ValidationHelper.validateNotNull((String)"contentProvider", (Object)contentProvider);
        ValidationHelper.validateNotNull((String)"projectAreaHandle", (Object)projectAreaHandle);
        this.fContentProvider = contentProvider;
        this.fProjectAreaHandle = projectAreaHandle;
        this.fTreeParent = parent;
        for (BuildDefinitionQueryNode node : children) {
            this.getItemIdToNodesMap().put(node.getBuildDefinition().getItemId().getUuidValue(), node);
        }
    }

    protected IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectAreaHandle;
    }

    private boolean isViewerDisposed() {
        StructuredViewer viewer = this.getViewer();
        return viewer == null || viewer.getControl().isDisposed();
    }

    protected void addNodesToViewer(Object parent, Object[] nodes) {
        if (!this.isViewerDisposed()) {
            ((TreeViewer)this.getViewer()).add(parent, nodes);
        }
    }

    protected Object getParent() {
        return this.fTreeParent;
    }

    public StructuredViewer getViewer() {
        return this.fContentProvider.getTreeViewer();
    }

    protected void removeNodesFromViewer(Object parent, Object[] nodes) {
        if (!this.isViewerDisposed()) {
            ((TreeViewer)this.getViewer()).remove(parent, nodes);
        }
    }

    protected boolean shouldShowDefinition(IBuildDefinition definition, IProgressMonitor monitor) {
        boolean showDefinition = false;
        if (definition.isPropertySet(IBuildDefinition.PROPERTY_PROCESS_AREA)) {
            List selectedProcessAreas = this.getSelectedProcessAreas();
            for (IProcessAreaHandle handle : selectedProcessAreas) {
                if (!definition.getProcessArea().sameItemId((IItemHandle)handle)) continue;
                showDefinition = true;
                break;
            }
        }
        return showDefinition;
    }

    protected List getSelectedProcessAreas() {
        return this.fContentProvider.getEnterpriseExtensionsDomain().getConnectedProjectAreaRegistry().getSelectedProcessAreas(this.fProjectAreaHandle);
    }
}

