/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.ui;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.enterprise.automation.internal.ui.editors.AbstractAutomationConfigurationEditor;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractAutomationRestoreMappingWizardPage;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AddEditRestoreMappingDialog;
import com.ibm.team.enterprise.automation.ui.Messages;
import com.ibm.team.enterprise.automation.ui.RestoreMappingMember;
import com.ibm.team.enterprise.automation.ui.RestoreMappingTableContentProvider;
import com.ibm.team.enterprise.automation.ui.RestoreMappingTableLabelProvider;
import com.ibm.team.enterprise.automation.ui.table.AutomationViewerComparator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.progress.UIJob;

public class RestoreMappingComposite
extends Composite {
    protected String restorePropertyId;
    public Button restoreMappingsAddButton;
    public Button restoreMappingsEditButton;
    public Button restoreMappingsRemoveButton;
    public TableViewer restoreMappingTableViewer;
    private AutomationViewerComparator comparator;
    private AbstractAutomationConfigurationEditor editor;
    private AbstractAutomationRestoreMappingWizardPage page;
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    private Hashtable<String, RestoreMappingMember> restoreMappingMembers = new Hashtable();
    private String delimiter = ";";
    private String template;

    public RestoreMappingComposite(Composite parent, String restorePropertyId, AbstractAutomationRestoreMappingWizardPage page, IBuildDefinition fBuildDefinitionWorkingCopy) {
        super(parent, 0);
        TableColumn toColumn;
        TableColumn fromColumn;
        this.restorePropertyId = restorePropertyId;
        this.page = page;
        this.fBuildDefinitionWorkingCopy = fBuildDefinitionWorkingCopy;
        this.template = fBuildDefinitionWorkingCopy.getProperty("com.ibm.team.build.internal.template.id").getValue();
        if (this.template.contains("ibmi")) {
            this.delimiter = ";;";
        }
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.setLayoutData(GridDataFactory.fillDefaults().hint(400, -1).grab(true, true).create());
        Composite tableComposite = new Composite((Composite)this, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        GridDataFactory.fillDefaults().indent(5, 0).hint(-1, 250).grab(true, false).applyTo((Control)tableComposite);
        Table restoreMappingTable = new Table(tableComposite, 68354);
        if (this.template.contains("ibmi")) {
            fromColumn = new TableColumn(restoreMappingTable, 16384, 0);
            fromColumn.setText(Messages.RestoreMappingComposite_FROM_LIBRARY);
            tableColumnLayout.setColumnData((Widget)fromColumn, (ColumnLayoutData)new ColumnWeightData(50));
            fromColumn.addSelectionListener(this.getColumnSelectionListener(restoreMappingTable, fromColumn, 0));
            toColumn = new TableColumn(restoreMappingTable, 16384, 1);
            toColumn.setText(Messages.RestoreMappingComposite_TO_LIBRARY);
            tableColumnLayout.setColumnData((Widget)toColumn, (ColumnLayoutData)new ColumnWeightData(50));
            toColumn.addSelectionListener(this.getColumnSelectionListener(restoreMappingTable, toColumn, 1));
        } else {
            fromColumn = new TableColumn(restoreMappingTable, 16384, 0);
            fromColumn.setText(Messages.RestoreMappingComposite_FROM_PDS);
            tableColumnLayout.setColumnData((Widget)fromColumn, (ColumnLayoutData)new ColumnWeightData(50));
            fromColumn.addSelectionListener(this.getColumnSelectionListener(restoreMappingTable, fromColumn, 0));
            toColumn = new TableColumn(restoreMappingTable, 16384, 1);
            toColumn.setText(Messages.RestoreMappingComposite_TO_PDS);
            tableColumnLayout.setColumnData((Widget)toColumn, (ColumnLayoutData)new ColumnWeightData(50));
            toColumn.addSelectionListener(this.getColumnSelectionListener(restoreMappingTable, toColumn, 1));
        }
        restoreMappingTable.pack();
        this.restoreMappingTableViewer = new TableViewer(restoreMappingTable);
        restoreMappingTable.setHeaderVisible(true);
        restoreMappingTable.setLinesVisible(true);
        restoreMappingTable.setSortColumn(restoreMappingTable.getColumn(0));
        restoreMappingTable.setSortDirection(128);
        RestoreMappingTableContentProvider contentProvider = new RestoreMappingTableContentProvider();
        RestoreMappingTableLabelProvider labelProvider = new RestoreMappingTableLabelProvider();
        this.restoreMappingTableViewer.setContentProvider((IContentProvider)contentProvider);
        this.restoreMappingTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.comparator = new AutomationViewerComparator();
        this.comparator.setColumn(0);
        this.restoreMappingTableViewer.setComparator((ViewerComparator)this.comparator);
        this.restoreMappingTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RestoreMappingComposite.this.updateRestoreMappingsButtonsEnablement();
            }
        });
        this.restoreMappingTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RestoreMappingMember selection = (RestoreMappingMember)((IStructuredSelection)RestoreMappingComposite.this.restoreMappingTableViewer.getSelection()).getFirstElement();
                RestoreMappingComposite.this.getAddEditRestoreMappingDialog(selection.getFromContainer(), selection.getToContainer(), RestoreMappingComposite.this.template);
            }
        });
        IBuildProperty property = fBuildDefinitionWorkingCopy.getProperty(restorePropertyId);
        String mappingValue = property.getValue();
        StringTokenizer tokenizer = new StringTokenizer(mappingValue, this.delimiter);
        while (tokenizer.hasMoreTokens()) {
            String fromContainer = tokenizer.nextToken();
            String toContainer = tokenizer.nextToken();
            RestoreMappingMember mapping = new RestoreMappingMember(fromContainer, toContainer);
            this.restoreMappingMembers.put(fromContainer, mapping);
        }
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                RestoreMappingComposite.this.restoreMappingTableViewer.setInput(new ArrayList(RestoreMappingComposite.this.restoreMappingMembers.values()));
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        buttonBar.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        this.restoreMappingsAddButton = new Button(buttonBar, 8);
        this.restoreMappingsAddButton.setText(Messages.RestoreMappingComposite_ADD_BUTTON_LABEL);
        this.restoreMappingsAddButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.restoreMappingsAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestoreMappingComposite.this.getAddEditRestoreMappingDialog("", "", RestoreMappingComposite.this.template);
            }
        });
        this.restoreMappingsEditButton = new Button(buttonBar, 8);
        this.restoreMappingsEditButton.setText(Messages.RestoreMappingComposite_EDIT_BUTTON_LABEL);
        this.restoreMappingsEditButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.restoreMappingsEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestoreMappingMember selection = (RestoreMappingMember)((IStructuredSelection)RestoreMappingComposite.this.restoreMappingTableViewer.getSelection()).getFirstElement();
                RestoreMappingComposite.this.getAddEditRestoreMappingDialog(selection.getFromContainer(), selection.getToContainer(), RestoreMappingComposite.this.template);
            }
        });
        this.restoreMappingsEditButton.setEnabled(false);
        this.restoreMappingsRemoveButton = new Button(buttonBar, 8);
        this.restoreMappingsRemoveButton.setText(Messages.RestoreMappingComposite_REMOVE_BUTTON_LABEL);
        this.restoreMappingsRemoveButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.restoreMappingsRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selection = ((IStructuredSelection)RestoreMappingComposite.this.restoreMappingTableViewer.getSelection()).toList();
                RestoreMappingComposite.this.removeRestoreMappingEntry(selection);
            }
        });
        this.restoreMappingsRemoveButton.setEnabled(false);
    }

    public boolean setFocus() {
        if (this.editor != null) {
            CTabItem tab = this.editor.getOptionsTab();
            CTabFolder folder = this.editor.getTabFolder();
            if (folder != null && tab != null) {
                folder.setSelection(tab);
            }
        }
        return super.setFocus();
    }

    protected SelectionListener getColumnSelectionListener(final Table table, final TableColumn tableColumn, final int columnNum) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestoreMappingComposite.this.comparator.setColumn(columnNum);
                if (table.getSortColumn() == tableColumn) {
                    if (table.getSortDirection() == 1024) {
                        table.setSortDirection(128);
                    } else {
                        table.setSortDirection(1024);
                    }
                } else {
                    table.setSortColumn(tableColumn);
                    table.setSortDirection(128);
                }
                RestoreMappingComposite.this.restoreMappingTableViewer.refresh();
            }
        };
    }

    public RestoreMappingComposite(Composite parent, String restorePropertyId, final AbstractAutomationConfigurationEditor editor, IBuildDefinition fBuildDefinitionWorkingCopy) {
        super(parent, 0);
        this.restorePropertyId = restorePropertyId;
        this.editor = editor;
        this.fBuildDefinitionWorkingCopy = fBuildDefinitionWorkingCopy;
        final String template = fBuildDefinitionWorkingCopy.getProperty("com.ibm.team.build.internal.template.id").getValue();
        if (template.contains("ibmi")) {
            this.delimiter = ";;";
        }
        TableWrapData data = new TableWrapData(256, 256, 1, 2);
        data.heightHint = 250;
        data.maxWidth = 100;
        this.setLayoutData(data);
        Table restoreMappingTable = new Table((Composite)this, 68354);
        TableColumnLayout tcl = new TableColumnLayout();
        String[] columnHeaders = template.contains("ibmi") ? new String[]{Messages.RestoreMappingComposite_FROM_LIBRARY, Messages.RestoreMappingComposite_TO_LIBRARY} : new String[]{Messages.RestoreMappingComposite_FROM_PDS, Messages.RestoreMappingComposite_TO_PDS};
        int[] columnWeights = new int[]{50, 50};
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(restoreMappingTable, 0);
            column.setText(columnHeaders[i]);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
            column.addSelectionListener(this.getColumnSelectionListener(restoreMappingTable, column, i));
            ++i;
        }
        this.setLayout((Layout)tcl);
        restoreMappingTable.setHeaderVisible(true);
        restoreMappingTable.setLinesVisible(true);
        restoreMappingTable.setSortColumn(restoreMappingTable.getColumn(0));
        restoreMappingTable.setSortDirection(128);
        this.restoreMappingTableViewer = new TableViewer(restoreMappingTable);
        RestoreMappingTableContentProvider contentProvider = new RestoreMappingTableContentProvider();
        RestoreMappingTableLabelProvider labelProvider = new RestoreMappingTableLabelProvider();
        this.restoreMappingTableViewer.setContentProvider((IContentProvider)contentProvider);
        this.restoreMappingTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.comparator = new AutomationViewerComparator();
        this.comparator.setColumn(0);
        this.restoreMappingTableViewer.setComparator((ViewerComparator)this.comparator);
        this.restoreMappingTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RestoreMappingComposite.this.updateRestoreMappingsButtonsEnablement();
            }
        });
        this.restoreMappingTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RestoreMappingMember selection = (RestoreMappingMember)((IStructuredSelection)RestoreMappingComposite.this.restoreMappingTableViewer.getSelection()).getFirstElement();
                RestoreMappingComposite.this.getAddEditRestoreMappingDialog(selection.getFromContainer(), selection.getToContainer(), template);
                editor.validate();
            }
        });
        IBuildProperty property = fBuildDefinitionWorkingCopy.getProperty(restorePropertyId);
        String mappingValue = property.getValue();
        StringTokenizer tokenizer = new StringTokenizer(mappingValue, this.delimiter);
        while (tokenizer.hasMoreTokens()) {
            String fromContainer = tokenizer.nextToken();
            String toContainer = tokenizer.nextToken();
            RestoreMappingMember mapping = new RestoreMappingMember(fromContainer, toContainer);
            this.restoreMappingMembers.put(fromContainer, mapping);
        }
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                RestoreMappingComposite.this.restoreMappingTableViewer.setInput(new ArrayList(RestoreMappingComposite.this.restoreMappingMembers.values()));
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayoutData((Object)new TableWrapData(8, 256, 1, 1));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        layout.rightMargin = 0;
        buttonBar.setLayout((Layout)layout);
        this.restoreMappingsAddButton = new Button(buttonBar, 8);
        this.restoreMappingsAddButton.setText(Messages.RestoreMappingComposite_ADD_BUTTON_LABEL);
        this.restoreMappingsAddButton.setLayoutData((Object)new TableWrapData(128, 32));
        this.restoreMappingsAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestoreMappingComposite.this.getAddEditRestoreMappingDialog("", "", template);
                editor.validate();
            }
        });
        this.restoreMappingsEditButton = new Button(buttonBar, 8);
        this.restoreMappingsEditButton.setText(Messages.RestoreMappingComposite_EDIT_BUTTON_LABEL);
        this.restoreMappingsEditButton.setLayoutData((Object)new TableWrapData(128, 32));
        this.restoreMappingsEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestoreMappingMember selection = (RestoreMappingMember)((IStructuredSelection)RestoreMappingComposite.this.restoreMappingTableViewer.getSelection()).getFirstElement();
                RestoreMappingComposite.this.getAddEditRestoreMappingDialog(selection.getFromContainer(), selection.getToContainer(), template);
                editor.validate();
            }
        });
        this.restoreMappingsEditButton.setEnabled(false);
        this.restoreMappingsRemoveButton = new Button(buttonBar, 8);
        this.restoreMappingsRemoveButton.setText(Messages.RestoreMappingComposite_REMOVE_BUTTON_LABEL);
        this.restoreMappingsRemoveButton.setLayoutData((Object)new TableWrapData(128, 32));
        this.restoreMappingsRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selection = ((IStructuredSelection)RestoreMappingComposite.this.restoreMappingTableViewer.getSelection()).toList();
                RestoreMappingComposite.this.removeRestoreMappingEntry(selection);
                editor.validate();
            }
        });
        this.restoreMappingsRemoveButton.setEnabled(false);
    }

    private void getAddEditRestoreMappingDialog(String fromContainer, String toContainer, String template) {
        Object[] results;
        AddEditRestoreMappingDialog dialog = new AddEditRestoreMappingDialog(this.getShell(), fromContainer, toContainer, template);
        if (dialog.open() == 0 && (results = dialog.getResult()).length > 0) {
            RestoreMappingMember result = (RestoreMappingMember)results[0];
            this.restoreMappingMembers.put(result.getFromContainer(), result);
            if (!result.getFromContainer().equals(fromContainer)) {
                this.restoreMappingMembers.remove(fromContainer);
            }
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    RestoreMappingComposite.this.restoreMappingTableViewer.setInput(new ArrayList(RestoreMappingComposite.this.restoreMappingMembers.values()));
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            this.updateRestoreMappingProperty();
        }
    }

    private void updateRestoreMappingProperty() {
        if (this.page != null) {
            this.page.getConfiguration().setContainerMappings(this.createRestoreMappingString());
        } else {
            this.fBuildDefinitionWorkingCopy.setProperty(this.restorePropertyId, this.createRestoreMappingString());
            this.editor.setDirty(true);
        }
    }

    private String createRestoreMappingString() {
        String mapping = "";
        Set<String> fromSet = this.restoreMappingMembers.keySet();
        for (String fromContainerString : fromSet) {
            if (mapping.length() != 0) {
                mapping = String.valueOf(mapping) + this.delimiter;
            }
            mapping = String.valueOf(mapping) + fromContainerString + this.delimiter + this.restoreMappingMembers.get(fromContainerString).getToContainer();
        }
        return mapping;
    }

    public boolean isToContainerMissing() {
        Set<String> fromSet = this.restoreMappingMembers.keySet();
        for (String fromContainerString : fromSet) {
            String toContainer = this.restoreMappingMembers.get(fromContainerString).getToContainer();
            if (toContainer != null && !toContainer.equals("")) continue;
            return true;
        }
        return false;
    }

    private void removeRestoreMappingEntry(List<RestoreMappingMember> selection) {
        for (RestoreMappingMember item : selection) {
            this.restoreMappingMembers.remove(item.getFromContainer());
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    RestoreMappingComposite.this.restoreMappingTableViewer.setInput(new ArrayList(RestoreMappingComposite.this.restoreMappingMembers.values()));
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            this.updateRestoreMappingProperty();
        }
    }

    protected void updateRestoreMappingsButtonsEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.restoreMappingTableViewer.getSelection();
        this.restoreMappingsEditButton.setEnabled(selection.size() == 1);
        this.restoreMappingsRemoveButton.setEnabled(selection.size() >= 1);
    }

    public void mergeRestoreMappingMembers(List<RestoreMappingMember> members) {
        for (RestoreMappingMember member : members) {
            if (this.restoreMappingMembers.containsKey(member.getFromContainer())) continue;
            this.restoreMappingMembers.put(member.getFromContainer(), member);
        }
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                RestoreMappingComposite.this.restoreMappingTableViewer.setInput(new ArrayList(RestoreMappingComposite.this.restoreMappingMembers.values()));
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void setBuildDefinitionWorkingCopy(IBuildDefinition buildDefinitionWorkingCopy) {
        this.fBuildDefinitionWorkingCopy = buildDefinitionWorkingCopy;
    }
}

