/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.ui;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.automation.internal.ui.nls.Messages;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class AutomationUtil {
    private static AutomationUtil instance;

    private AutomationUtil() {
    }

    public static final AutomationUtil getInstance() {
        if (instance == null) {
            instance = new AutomationUtil();
        }
        return instance;
    }

    public boolean includeExistingDefinition(IBuildDefinition definition, String templateIdPrefix) {
        String templateId = definition.getPropertyValue("com.ibm.team.build.internal.template.id", null);
        return templateId != null && templateId.startsWith(templateIdPrefix);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void openInChangeExplorer(List<IChangeSetHandle> changeSets, IWorkspaceHandle targetStreamHandle, ITeamRepository repository, Shell shell) {
        boolean isModal;
        boolean bl;
        if (changeSets.size() == 0) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.AbstractAutomationWorkItemSummaryWizardPage_SUMMARYTREE_TOOLBAR_VIEWCHANGESET, (String)Messages.AbstractAutomationWorkItemSummaryWizardPage_VIEW_CHANGESET_ERROR);
            return;
        }
        if ((shell.getStyle() & 0x10000) != 0 || (shell.getStyle() & 0x20000) != 0 || (shell.getStyle() & 0x8000) != 0) {
            shell.getStyle();
            bl = true;
        } else {
            bl = isModal = false;
        }
        if (isModal && !MessageDialog.openConfirm((Shell)shell, (String)Messages.AbstractAutomationWorkItemSummaryWizardPage_SUMMARYTREE_TOOLBAR_VIEWCHANGESET, (String)Messages.AbstractAutomationWorkItemSummaryWizardPage_VIEW_CHANGESET_CONFIRMATION)) {
            return;
        }
        ChangeSetInput csInput = targetStreamHandle == null ? new ChangeSetInput(changeSets) : new ChangeSetInput((SnapshotId)WorkspaceId.create((ITeamRepository)repository, (IWorkspaceHandle)targetStreamHandle), changeSets);
        Parts.openView((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (Object)csInput, (String)"com.ibm.team.filesystem.ui.changes.views.ChangeExplorerView");
        if (isModal) {
            shell.close();
            return;
        }
        if (shell.getParent() == null) return;
        ((Shell)shell.getParent()).setActive();
    }
}

