/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.ui;

import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.enterprise.automation.ui.AutomationDefinitionQueryNode;
import com.ibm.team.enterprise.automation.ui.IAutomationNode;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.progress.IElementCollector;

public abstract class AbstractAutomationNode
extends AbstractEnterpriseExtensionsNode
implements IAutomationNode {
    protected abstract void addDefinitionListeners(IProjectAreaHandle var1, List<BuildDefinitionQueryNode> var2);

    protected abstract void removeDefinitionListeners(IProjectAreaHandle var1);

    public void fetchDeferredChildren(IElementCollector collector, IProgressMonitor monitor) {
        IProjectAreaHandle projectAreaHandle = this.getProjectAreaHandle();
        try {
            IBuildDefinitionStatusRecord[] statusRecords;
            this.removeDefinitionListeners(projectAreaHandle);
            ArrayList<BuildDefinitionQueryNode> nodes = new ArrayList<BuildDefinitionQueryNode>();
            IBuildDefinitionStatusRecord[] iBuildDefinitionStatusRecordArray = statusRecords = this.getBuildDefinitionStatusRecords(projectAreaHandle, monitor);
            int n = statusRecords.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildDefinitionStatusRecord record = iBuildDefinitionStatusRecordArray[n2];
                boolean includeRecord = this.includeBuildDefinition(record.getBuildDefinition());
                if (includeRecord) {
                    AutomationDefinitionQueryNode node = this.createAutomationDefinitionQueryNode(this.getTeamRepository(), record);
                    node.setParent(this);
                    node.setDomainSubtreeRoot(this.getDomainSubtreeRoot());
                    node.setProjectAreaHandle(this.getProjectAreaHandle());
                    node.setId(node.getBuildDefinitionId());
                    node.setPathId(String.valueOf(this.getPathId()) + "/" + node.getId());
                    node.setViewer(this.getViewer());
                    nodes.add(node);
                }
                ++n2;
            }
            Collections.sort(nodes, new Comparator<BuildDefinitionQueryNode>(){

                @Override
                public int compare(BuildDefinitionQueryNode node1, BuildDefinitionQueryNode node2) {
                    return node1.getLabel().compareTo(node2.getLabel());
                }
            });
            collector.add(nodes.toArray(), monitor);
            this.addDefinitionListeners(projectAreaHandle, nodes);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    protected AutomationDefinitionQueryNode createAutomationDefinitionQueryNode(ITeamRepository repository, IBuildDefinitionStatusRecord record) {
        return new AutomationDefinitionQueryNode(repository, record);
    }

    private IBuildDefinitionStatusRecord[] getBuildDefinitionStatusRecords(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        ITeamBuildRecordClient client = (ITeamBuildRecordClient)teamRepository.getClientLibrary(ITeamBuildRecordClient.class);
        List processAreaHandles = this.getDomain().getConnectedProjectAreaRegistry().getSelectedProcessAreas(projectAreaHandle);
        return client.getBuildDefinitionStatusRecords(processAreaHandles.toArray(new IProcessAreaHandle[processAreaHandles.size()]), monitor);
    }

    public boolean hasChildren() {
        return super.hasChildren();
    }
}

