/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.internal.ui.wizards;

import com.ibm.team.enterprise.automation.common.summary.INode;
import com.ibm.team.enterprise.automation.common.summary.IOutputNode;
import com.ibm.team.enterprise.automation.internal.ui.wizards.Messages;
import com.ibm.team.enterprise.automation.ui.AutomationUIPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class SummaryTreeLabelProvider
implements ILabelProvider {
    public Image getImage(Object object) {
        if (object instanceof INode) {
            INode node = (INode)object;
            switch (node.getType()) {
                case WORKITEM: {
                    return AutomationUIPlugin.getImage("icons/obj16/wi_general.gif");
                }
                case CHANGESET: {
                    return AutomationUIPlugin.getImage("icons/obj16/assocchgset_obj.gif");
                }
                case OUTPUT: {
                    if (((IOutputNode)node).isDeletion()) {
                        return AutomationUIPlugin.getImage("icons/obj16/deleted-output_obj.gif");
                    }
                    return AutomationUIPlugin.getImage("icons/obj16/build-output_obj.gif");
                }
                case ADDITIONAL_OUTPUTS: {
                    return AutomationUIPlugin.getImage("icons/obj16/build-output_obj.gif");
                }
                case LINKED_ARTIFACT: {
                    return AutomationUIPlugin.getImage("icons/obj16/related_obj.gif");
                }
            }
        }
        return null;
    }

    public String getText(Object object) {
        if (object instanceof INode) {
            INode node = (INode)object;
            String label = node.getLabel();
            if (node.getType() == INode.Type.OUTPUT) {
                String deployType;
                if (((IOutputNode)node).isDeletion()) {
                    label = NLS.bind((String)Messages.SummaryTreeLabelProvider_OUTPUT_DELETION, (Object)label);
                }
                if ((deployType = ((IOutputNode)node).deployType()) != null && !deployType.isEmpty()) {
                    label = NLS.bind((String)Messages.SummaryTreeLabelProvider_OUTPUT_DEPLOY_TYPE, (Object[])new Object[]{label, ((IOutputNode)node).deployType()});
                }
                if (!((IOutputNode)node).isExactMatch()) {
                    label = NLS.bind((String)Messages.SummaryTreeLabelProvider_OUTPUT_NEWER_THAN_WORKITEM_CHANGESET, (Object)label);
                }
            }
            return label;
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }
}

