/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.internal.ui.wizards;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.wizards.builddefinition.NewBuildDefinitionWizard;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;

public class NewAutomationDefinitionWizard
extends NewBuildDefinitionWizard {
    public NewAutomationDefinitionWizard() {
    }

    public NewAutomationDefinitionWizard(IProjectAreaHandle projectAreaHandle) {
        super(projectAreaHandle);
    }

    public NewAutomationDefinitionWizard(ITeamRepository teamRepository) {
        super(teamRepository);
    }

    protected void initializeAutomationDefinition(String scriptXML, String fileSystemPropertyname) throws IllegalArgumentException {
        if (this.getWizardContext().isExistingBuildDefinition()) {
            super.initializeBuildDefinition();
        } else {
            IBuildProperty fileSystemProperty;
            String buildFileValue;
            super.initializeBuildDefinition();
            IBuildDefinition buildDefinition = this.getWizardContext().getBuildDefinition();
            String buildFile = null;
            String fileSystemPropertyValue = null;
            IBuildProperty property = buildDefinition.getProperty("com.ibm.team.build.internal.template.id");
            if (property != null) {
                String propertyValue = property.getValue().toLowerCase();
                if (propertyValue.equals("com.ibm.team.enterprise.packaging.nonseq.ibmi")) {
                    buildFile = "${BLD_TOOLKIT}/scripts/enterprise/packaging/" + scriptXML;
                    fileSystemPropertyValue = "ibmi";
                } else if (propertyValue.equals("com.ibm.team.enterprise.deployment.nonseq.ibmi")) {
                    buildFile = "${BLD_TOOLKIT}/scripts/enterprise/deployment/" + scriptXML;
                    fileSystemPropertyValue = "ibmi";
                } else if (propertyValue.equals("com.ibm.team.enterprise.packaging.nonseq.zos")) {
                    buildFile = "${BLD_TOOLKIT}/scripts/enterprise/packaging/" + scriptXML;
                    fileSystemPropertyValue = "zos";
                } else if (propertyValue.equals("com.ibm.team.enterprise.deployment.nonseq.zos")) {
                    buildFile = "${BLD_TOOLKIT}/scripts/enterprise/deployment/" + scriptXML;
                    fileSystemPropertyValue = "zos";
                } else if (propertyValue.endsWith("zos")) {
                    buildFile = "${BLD_TOOLKIT}/scripts/enterprise/" + scriptXML;
                    fileSystemPropertyValue = "zos";
                } else if (propertyValue.endsWith("ibmi")) {
                    buildFile = "${BLD_TOOLKIT}/scripts/enterprise/" + scriptXML;
                    fileSystemPropertyValue = "ibmi";
                } else if (propertyValue.endsWith("luw")) {
                    buildFile = "${BLD_TOOLKIT}/scripts/enterprise/" + scriptXML;
                    fileSystemPropertyValue = "luw";
                }
            }
            if (buildFile != null && buildDefinition.getConfigurationElement("com.ibm.team.build.ant") != null && (buildFileValue = buildDefinition.getConfigurationPropertyValue("com.ibm.team.build.ant", "com.ibm.team.build.ant.buildFile", "")) == "") {
                buildDefinition.setConfigurationProperty("com.ibm.team.build.ant", "com.ibm.team.build.ant.buildFile", buildFile);
            }
            if (fileSystemPropertyValue != null && (fileSystemProperty = buildDefinition.getProperty(fileSystemPropertyname)) == null) {
                fileSystemProperty = BuildItemFactory.createBuildProperty();
                fileSystemProperty.setGenericEditAllowed(false);
                fileSystemProperty.setName(fileSystemPropertyname);
                fileSystemProperty.setValue(fileSystemPropertyValue);
                buildDefinition.getProperties().add(fileSystemProperty);
            }
        }
    }
}

