/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.internal.ui.wizards;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.query.IBaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.common.model.query.BaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionDialogMessages;
import com.ibm.team.build.internal.ui.domain.ConnectedProjectAreaRegistryHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractAutomationWorkItemWizardPage;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class FetchDefinitionsJob
extends TeamBuildJob {
    private final AbstractAutomationWorkItemWizardPage fAutomationWizardPage;
    protected IBuildDefinition[] fFetchedBuildDefinitions;
    protected int fConnectedRepositoryCount = 0;
    protected int fDisconnectedRepositoryCount = 0;

    public FetchDefinitionsJob(AbstractAutomationWorkItemWizardPage wizardPage) {
        super(BuildDefinitionDialogMessages.FetchBuildDefinitionStatusRecordsJob_0, false);
        this.fAutomationWizardPage = wizardPage;
    }

    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return this.checkForAutomationDefinitions(monitor);
    }

    private IStatus checkForAutomationDefinitions(IProgressMonitor monitor) {
        ITeamRepository[] connectedRepositories;
        ArrayList<IBuildDefinition> allBuilds = new ArrayList<IBuildDefinition>();
        ArrayList<IStatus> errors = null;
        ITeamRepository[] iTeamRepositoryArray = connectedRepositories = this.getConnectedRepositories();
        int n = connectedRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            if (repository.loggedIn()) {
                try {
                    IBuildDefinition[] definitions = this.fetchBuildDefinitions(repository, monitor);
                    allBuilds.addAll(Arrays.asList(definitions));
                    ++this.fConnectedRepositoryCount;
                }
                catch (OperationCanceledException exception) {
                    return Status.CANCEL_STATUS;
                }
                catch (Exception exception) {
                    String repoId;
                    if (errors == null) {
                        errors = new ArrayList<IStatus>();
                    }
                    if ((repoId = repository.getName()) == null || repoId.length() == 0) {
                        repoId = repository.getRepositoryURI();
                    }
                    String errorMessage = NLS.bind((String)BuildDefinitionDialogMessages.FetchBuildDefinitionStatusRecordsJob_ERROR_CONNECTING_TO_REPOSITORY_X, (Object)repoId);
                    errors.add(this.createStatus(errorMessage, exception));
                }
            } else {
                ++this.fDisconnectedRepositoryCount;
            }
            ++n2;
        }
        this.fFetchedBuildDefinitions = allBuilds.toArray(new IBuildDefinition[allBuilds.size()]);
        IStatus status = Status.OK_STATUS;
        if (errors != null) {
            String message = null;
            message = connectedRepositories.length == 1 ? BuildDefinitionDialogMessages.FetchBuildDefinitionStatusRecordsJob_COULD_NOT_CONNECT_TO_REPOSITORY : (this.fConnectedRepositoryCount == 0 ? BuildDefinitionDialogMessages.FetchBuildDefinitionStatusRecordsJob_COULD_NOT_CONNECT_TO_ANY_REPOSITORIES : BuildDefinitionDialogMessages.FetchBuildDefinitionStatusRecordsJob_COULD_NOT_CONNECT_TO_ALL_REPOSITORIES);
            IStatus[] statuses = errors.toArray(new IStatus[errors.size()]);
            status = new MultiStatus(BuildUIPlugin.getUniqueIdentifier(), 0, statuses, message, null);
        }
        return status;
    }

    protected IBuildDefinition[] fetchBuildDefinitions(ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel.ROOT);
        IProcessAreaHandle[] processAreaHandles = this.getProcessAreaHandles(repository, monitor);
        IItemHandleInputArg[] itemHandleArgs = new IItemHandleInputArg[processAreaHandles.length];
        int i = 0;
        while (i < processAreaHandles.length) {
            itemHandleArgs[i] = itemQuery.newItemHandleArg();
            ++i;
        }
        IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel buildDefinitionQueryModel = IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildDefinitionQueryModel);
        IPredicate filter = ((BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel)buildDefinitionQueryModel).processArea()._in(itemHandleArgs);
        query.filter(filter);
        query.orderByDscUsingLocale(buildDefinitionQueryModel.id());
        IItemManager itemManager = repository.itemManager();
        ItemQueryIterator iter = new ItemQueryIterator(ClientFactory.getTeamBuildClient((ITeamRepository)repository), itemQuery, new Object[0]);
        LinkedList buildDefinitions = new LinkedList();
        while (iter.hasNext(monitor)) {
            List definitionHandles = iter.next(512, monitor);
            buildDefinitions.addAll(itemManager.fetchCompleteItems(definitionHandles, 0, monitor));
        }
        Iterator definitionsIter = buildDefinitions.iterator();
        while (definitionsIter.hasNext()) {
            Object next = definitionsIter.next();
            if (next != null) continue;
            definitionsIter.remove();
        }
        ArrayList<IBuildDefinition> filteredDefinitions = new ArrayList<IBuildDefinition>();
        for (IBuildDefinition genericBD : buildDefinitions) {
            if (genericBD.getConfigurationElement(this.fAutomationWizardPage.getConfigurationElementID()) == null) continue;
            filteredDefinitions.add(genericBD);
        }
        return filteredDefinitions.toArray(new IBuildDefinition[filteredDefinitions.size()]);
    }

    protected ITeamRepository[] getConnectedRepositories() {
        Set connectedRepositories = ConnectedProjectAreaRegistryHelper.getConnectedRepositories();
        return connectedRepositories.toArray(new ITeamRepository[connectedRepositories.size()]);
    }

    protected IProcessAreaHandle[] getProcessAreaHandles(ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        LinkedList<IProjectAreaHandle> allProcessAreaHandles = new LinkedList<IProjectAreaHandle>();
        List projectAreaHandles = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(repository);
        List projectAreas = repository.itemManager().fetchPartialItems(projectAreaHandles, 0, Arrays.asList(IProjectArea.ITEM_ID_PROPERTY), monitor);
        for (IProjectArea projectArea : projectAreas) {
            if (projectArea == null) continue;
            allProcessAreaHandles.add((IProjectAreaHandle)projectArea.getItemHandle());
            allProcessAreaHandles.addAll(projectArea.getTeamAreas());
        }
        return allProcessAreaHandles.toArray(new IProcessAreaHandle[allProcessAreaHandles.size()]);
    }

    protected void jobFinished(IStatus status) {
        if (status.getSeverity() == 8) {
            return;
        }
        this.updateWizardPage();
    }

    protected void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    protected boolean isBuildDefinitionSelectionDialogDisposed() {
        return this.fAutomationWizardPage.getShell() == null || this.fAutomationWizardPage.getShell().isDisposed();
    }

    protected void updateWizardPage() {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (FetchDefinitionsJob.this.isBuildDefinitionSelectionDialogDisposed()) {
                    return;
                }
                if (FetchDefinitionsJob.this.fFetchedBuildDefinitions.length == 1) {
                    FetchDefinitionsJob.this.fAutomationWizardPage.handleInitializeDefinitionComplete(FetchDefinitionsJob.this.fFetchedBuildDefinitions[0]);
                } else {
                    FetchDefinitionsJob.this.fAutomationWizardPage.handleInitializeDefinitionComplete(null);
                }
            }
        });
    }
}

