/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.internal.ui.wizards;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialogSectionExtension;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialogSectionExtensionManager;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import com.ibm.team.enterprise.automation.internal.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BuildOptionsDialog
extends StatusDialog {
    protected IBuildDefinition fBuildDefinition;
    protected IBuildResult fBuildResult;
    protected IBuildRequest fBuildRequest;
    protected boolean fIsRebuild;
    protected boolean fIsPersonalBuild;
    protected List<IBuildProperty> fOriginalBuildProperties;
    protected IBuildEngine fHandlingEngine;
    private TeamBuildJob fInitializationJob;
    protected IBuildResultHandle fBuildResultHandle;
    protected IBuildDefinitionHandle fBuildDefinitionHandle;
    protected List<RequestBuildSection> fSections = new ArrayList<RequestBuildSection>();

    public BuildOptionsDialog(Shell parent, IBuildDefinition definition) {
        super(parent);
        this.fBuildDefinition = definition;
        this.fBuildDefinitionHandle = this.fBuildDefinition;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.BuildOptionsDialog_BUILDOPTIONSDIALOG_TITLE);
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        Composite mainComposite = new Composite(dialogAreaComposite, 0);
        mainComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).create());
        mainComposite.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 5).grab(true, true).create());
        Label dialogDescription = new Label(mainComposite, 0);
        dialogDescription.setText(Messages.BuildOptionsDialog_BUILDOPTIONSDIALOG_DESCRIPTION);
        dialogDescription.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).create());
        Label label = new Label(mainComposite, 0);
        GridDataFactory.fillDefaults().span(3, 1).hint(-1, 5).applyTo((Control)label);
        this.fSections = this.createSections();
        Composite sectionsComposite = new Composite(mainComposite, 0);
        GridDataFactory.fillDefaults().indent(5, 0).grab(true, true).span(3, 1).applyTo((Control)sectionsComposite);
        GridLayoutFactory.fillDefaults().applyTo(sectionsComposite);
        for (RequestBuildSection section : this.fSections) {
            section.createContent(sectionsComposite);
        }
        this.initializeInBackground();
        return dialogAreaComposite;
    }

    public IBuildDefinition getfBuildDefinition() {
        return this.fBuildDefinition;
    }

    protected RequestBuildSectionSite createSectionSite() {
        return new RequestBuildSectionSite(){

            public void setProperty(String propertyName, Object value) {
                if ("personalBuild".equals(propertyName)) {
                    BuildOptionsDialog.this.fIsPersonalBuild = (Boolean)value;
                } else if ("handlingEngine".equals(propertyName)) {
                    BuildOptionsDialog.this.fHandlingEngine = (IBuildEngine)value;
                }
                BuildOptionsDialog.this.notifyPropertyChanged(propertyName);
                BuildOptionsDialog.this.revalidate();
            }

            public void revalidate() {
                BuildOptionsDialog.this.revalidate();
            }

            public void layoutChanged() {
                BuildOptionsDialog.this.handleLayoutChanged();
            }

            public boolean isRebuild() {
                return BuildOptionsDialog.this.fIsRebuild;
            }

            public boolean isPersonalBuild() {
                return BuildOptionsDialog.this.fIsPersonalBuild;
            }

            public IBuildResult getBuildResult() {
                return BuildOptionsDialog.this.fBuildResult;
            }

            public IBuildRequest getBuildRequest() {
                return BuildOptionsDialog.this.fBuildRequest;
            }

            public IBuildDefinition getBuildDefinition() {
                return BuildOptionsDialog.this.fBuildDefinition;
            }

            public ITeamRepository getTeamRepository() {
                return BuildOptionsDialog.this.fBuildDefinition == null ? null : (ITeamRepository)BuildOptionsDialog.this.fBuildDefinition.getOrigin();
            }

            public List<IBuildProperty> getOriginalBuildProperties() {
                return BuildOptionsDialog.this.fOriginalBuildProperties;
            }

            public IBuildEngine getHandlingEngine() {
                return BuildOptionsDialog.this.fHandlingEngine;
            }

            public void addErrorMessage(Object id, String errorMessage) {
            }

            public void removeErrorMessage(Object id) {
            }

            public void addWarningMessage(Object id, String warningMessage) {
            }

            public void removeWarningMessage(Object id) {
            }
        };
    }

    protected List<RequestBuildSection> createSections() {
        RequestBuildDialogSectionExtension[] extensions;
        RequestBuildSectionSite site = this.createSectionSite();
        ArrayList<RequestBuildSection> sections = new ArrayList<RequestBuildSection>();
        RequestBuildDialogSectionExtension[] requestBuildDialogSectionExtensionArray = extensions = RequestBuildDialogSectionExtensionManager.getInstance().getRequestBuildDialogSectionExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            RequestBuildDialogSectionExtension extension = requestBuildDialogSectionExtensionArray[n2];
            try {
                sections.add(extension.createSectionFactory().createRequestBuildSection(site));
            }
            catch (Exception e) {
                BuildUIPlugin.log((Throwable)e);
            }
            ++n2;
        }
        return sections;
    }

    private void revalidate() {
        boolean valid = true;
        for (RequestBuildSection section : this.fSections) {
            if (section.validate() == null) continue;
            valid = false;
            break;
        }
        Button okButton = this.getButton(0);
        okButton.setEnabled(valid);
    }

    private void handleLayoutChanged() {
        this.getShell().pack(true);
    }

    protected void notifyPropertyChanged(String propertyName) {
        for (RequestBuildSection section : this.fSections) {
            section.handlePropertyChanged(propertyName);
        }
    }

    protected IBuildDefinition getBuildDefinition(IBuildDefinitionHandle buildDefinitionHandle, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)buildDefinitionHandle.getOrigin();
        return (IBuildDefinition)teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildDefinitionHandle, 1, monitor);
    }

    private void initializeInBackground() {
        ITeamRepository jobTeamRepository = null;
        if (this.fBuildDefinitionHandle != null) {
            jobTeamRepository = (ITeamRepository)this.fBuildDefinitionHandle.getOrigin();
        }
        String jobName = Messages.BuildOptionsDialog_BUILDOPTIONSDIALOG_JOBNAME;
        this.fInitializationJob = new TeamBuildJob(jobName, true, jobTeamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                for (RequestBuildSection section : BuildOptionsDialog.this.fSections) {
                    section.initialize(monitor);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BuildOptionsDialog.this.handleInitializationComplete();
                    }
                });
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getSeverity() != 0) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BuildOptionsDialog.this.close();
                        }
                    });
                }
            }
        };
        this.fInitializationJob.schedule();
    }

    protected void handleInitializationComplete() {
        this.fOriginalBuildProperties = this.fBuildDefinition.getProperties();
        this.fBuildDefinition = (IBuildDefinition)this.fBuildDefinition.getWorkingCopy();
        if (this.fIsRebuild) {
            List requestProperties = this.fBuildRequest.getBuildDefinitionInstance().getProperties();
            this.fBuildDefinition.getProperties().clear();
            for (IBuildProperty requestProperty : requestProperties) {
                if (requestProperty.getName().equals("scheduledBuild")) continue;
                IBuildProperty newProperty = requestProperty.copyProperty();
                this.fBuildDefinition.getProperties().add(newProperty);
            }
        }
        for (RequestBuildSection section : this.fSections) {
            section.initializationComplete();
        }
        this.revalidate();
        this.getContents().getParent().pack();
    }

    protected void okPressed() {
        for (RequestBuildSection section : this.fSections) {
            section.applyProperties(this.fBuildDefinition);
        }
        super.okPressed();
    }
}

