/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.internal.ui.wizards;

import com.ibm.team.enterprise.automation.internal.ui.wizards.Messages;
import com.ibm.team.enterprise.automation.ui.RestoreMappingMember;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.teami.filesystem.common.validators.IBMiLibraryValidator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class AddEditRestoreMappingDialog
extends SelectionStatusDialog {
    private String fromContainer;
    private String toContainer;
    private Text fromContainerText;
    private Text toContainerText;
    private String template;
    private List<String> toContainersFromDefinition = null;

    public AddEditRestoreMappingDialog(Shell parent, String fromContainer, String toContainer, String template) {
        super(parent);
        this.fromContainer = fromContainer;
        this.toContainer = toContainer;
        this.template = template;
        this.setTitle(Messages.AddEditRestoreMappingDialog_RESTORE_MAPPING_DIALOG_TITLE);
        this.setHelpAvailable(false);
        this.setStatusLineAboveButtons(true);
    }

    public AddEditRestoreMappingDialog(Shell parent, String fromContainer, String toContainer, String template, List<String> toContainersFromDefinition) {
        this(parent, fromContainer, toContainer, template);
        this.toContainersFromDefinition = toContainersFromDefinition;
    }

    protected void computeResult() {
    }

    protected void okPressed() {
        this.fromContainer = this.fromContainerText.getText().trim();
        this.toContainer = this.toContainerText.getText().trim();
        if (this.template.contains("zos")) {
            this.fromContainer = this.fromContainer.toUpperCase();
            this.toContainer = this.toContainer.toUpperCase();
        }
        super.okPressed();
    }

    public Object[] getResult() {
        if (!this.fromContainer.equals("") && !this.toContainer.equals("")) {
            return new RestoreMappingMember[]{new RestoreMappingMember(this.fromContainer, this.toContainer)};
        }
        return new RestoreMappingMember[0];
    }

    protected Control createDialogArea(Composite parent) {
        Dialog.applyDialogFont((Control)parent);
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(1808);
        layoutData.minimumWidth = 450;
        Label fromContainerLabel = new Label(result, 0);
        fromContainerLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        if (this.template.contains("ibmi")) {
            fromContainerLabel.setText(Messages.AddEditRestoreMappingDialog_FROM_CONTAINER_TEXT_LABEL_IBMi);
        } else {
            fromContainerLabel.setText(Messages.AddEditRestoreMappingDialog_FROM_CONTAINER_TEXT_LABEL_ZOS);
        }
        this.fromContainerText = new Text(result, 2048);
        this.fromContainerText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fromContainerText.setText(this.fromContainer);
        this.fromContainerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddEditRestoreMappingDialog.this.fromContainer = AddEditRestoreMappingDialog.this.fromContainerText.getText();
                AddEditRestoreMappingDialog.this.validate();
            }
        });
        Label toContainerLabel = new Label(result, 0);
        toContainerLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        if (this.template.contains("ibmi")) {
            toContainerLabel.setText(Messages.AddEditRestoreMappingDialog_TO_CONTAINER_TEXT_LABEL_IBMi);
        } else {
            toContainerLabel.setText(Messages.AddEditRestoreMappingDialog_TO_CONTAINER_TEXT_LABEL_ZOS);
        }
        this.toContainerText = new Text(result, 2048);
        this.toContainerText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.toContainerText.setText(this.toContainer);
        this.toContainerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddEditRestoreMappingDialog.this.toContainer = AddEditRestoreMappingDialog.this.toContainerText.getText();
                AddEditRestoreMappingDialog.this.validate();
            }
        });
        result.setLayoutData((Object)layoutData);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private void validate() {
        Status status = new Status(0, "com.ibm.team.enterprise.automation.ui", "");
        if (this.template.contains("zos")) {
            MappingValidation fValidator = new MappingValidation();
            if (!this.fromContainer.equals("") && fValidator.isValidDSName(this.fromContainer.trim()) != 0) {
                status = new Status(4, "com.ibm.team.enterprise.automation.ui", Messages.AddEditRestoreMappingDialog_VALIDATE_FROMPDS);
            } else if (!this.toContainer.equals("") && fValidator.isValidDSName(this.toContainer.trim()) != 0) {
                status = new Status(4, "com.ibm.team.enterprise.automation.ui", Messages.AddEditRestoreMappingDialog_VALIDATE_TOPDS);
            } else if (!this.validateNonDuplicateContainerFromDefinition()) {
                status = new Status(4, "com.ibm.team.enterprise.automation.ui", Messages.AddEditRestoreMappingDialog_VALIDATE_TOPDS_DUPLICATE);
            }
        } else if (!this.fromContainer.equals("") && !IBMiLibraryValidator.isValidLibraryName((String)this.fromContainer.trim())) {
            status = new Status(4, "com.ibm.team.enterprise.automation.ui", Messages.AddEditRestoreMappingDialog_VALIDATE_FROMLIBRARY);
        } else if (!this.toContainer.equals("") && !IBMiLibraryValidator.isValidLibraryName((String)this.toContainer.trim())) {
            status = new Status(4, "com.ibm.team.enterprise.automation.ui", Messages.AddEditRestoreMappingDialog_VALIDATE_TOLIBRARY);
        } else if (!this.validateNonDuplicateContainerFromDefinition()) {
            status = new Status(4, "com.ibm.team.enterprise.automation.ui", Messages.AddEditRestoreMappingDialog_VALIDATE_TOLIBRARY_DUPLICATE);
        }
        this.updateStatus((IStatus)status);
        this.updateButtonsEnableState((IStatus)status);
        if (status.isOK() && (this.fromContainer.equals("") || this.toContainer.equals(""))) {
            this.getOkButton().setEnabled(false);
        }
    }

    private boolean validateNonDuplicateContainerFromDefinition() {
        if (this.toContainersFromDefinition != null) {
            String toContainerString = this.toContainer.trim();
            for (String container : this.toContainersFromDefinition) {
                if (!container.equals(toContainerString)) continue;
                return false;
            }
        }
        return true;
    }
}

