/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.internal.ui.wizards;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionSelectionDialog;
import com.ibm.team.build.internal.ui.dialogs.definitions.FetchBuildDefinitionsInConnectedProjectAreasJob;
import com.ibm.team.enterprise.automation.internal.ui.nls.Messages;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractWorkItemChooser;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractWorkItemTableContentProvider;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractWorkItemTableLabelProvider;
import com.ibm.team.enterprise.automation.internal.ui.wizards.BuildOptionsDialog;
import com.ibm.team.enterprise.automation.internal.ui.wizards.FetchDefinitionsJob;
import com.ibm.team.enterprise.automation.internal.ui.wizards.IAutomationWizardConfiguration;
import com.ibm.team.enterprise.automation.internal.ui.wizards.IAutomationWorkItemWizardPage;
import com.ibm.team.enterprise.automation.ui.AutomationDefinitionQueryNode;
import com.ibm.team.enterprise.automation.ui.AutomationUIPlugin;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.ClientEvaluationContext;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.common.query.IQueryResult;
import com.ibm.team.workitem.common.query.IResolvedResult;
import com.ibm.team.workitem.rcp.ui.internal.queries.QueryExecutionHandlerRegistry;
import com.ibm.team.workitem.rcp.ui.internal.queries.QuerySelectionDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public abstract class AbstractAutomationWorkItemWizardPage
extends WizardPage
implements SelectionListener,
ICheckStateListener,
IAutomationWorkItemWizardPage {
    private final IAutomationWizardConfiguration configuration;
    private final IStructuredSelection selection;
    protected Text definitionText;
    protected Button browseDefinitionButton;
    protected Button buildOptionsButton;
    protected Button openReportWorkItemButton;
    protected CheckboxTableViewer workItemTableViewer;
    protected Button selectAllButton;
    protected Button selectNoneButton;
    protected Button addWorkItemButton;
    protected Button removeWorkItemButton;
    protected Button queryWorkItemButton;
    protected String workItemType = null;
    protected Table workItemTable;
    protected Label tableLabel;
    protected ProgressIndicator progress;
    private Job fFetchingJob;
    private final AutomationDefinitionSelectionDialog selectionDialog;
    protected boolean buildOptionsAreCustomized;
    private Label numberLabel;

    public AbstractAutomationWorkItemWizardPage(Shell parent, IStructuredSelection selection, IAutomationWizardConfiguration config) {
        super("Work Item Selection Page");
        this.setImageDescriptor(AutomationUIPlugin.getImageDescriptor("icons/wizban/workitem_wizban.gif"));
        this.configuration = config;
        this.selection = selection;
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof AutomationDefinitionQueryNode) {
            AutomationDefinitionQueryNode definitionNode = (AutomationDefinitionQueryNode)((Object)selection.getFirstElement());
            this.configuration.setTeamRepository(definitionNode.getTeamRepository());
            this.configuration.setChosenDefinition(definitionNode.getBuildDefinition());
        } else if (firstElement instanceof IWorkItemHandle) {
            this.configuration.setTeamRepository((ITeamRepository)((IWorkItemHandle)firstElement).getOrigin());
        }
        this.selectionDialog = new AutomationDefinitionSelectionDialog(this.getShell());
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.AbstractAutomationWorkItemWizardPage_PAGE_TITLE2);
        this.setDescription(this.getDialogDescription());
        this.fFetchingJob = new FetchBuildDefinitionsInConnectedProjectAreasJob((BuildDefinitionSelectionDialog)this.selectionDialog);
        this.fFetchingJob.schedule();
        Composite dialogAreaComposite = new Composite(parent, 0);
        dialogAreaComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        dialogAreaComposite.setLayoutData((Object)GridDataFactory.fillDefaults().hint(400, -1).grab(true, true).create());
        this.createDefinitionSelection(dialogAreaComposite);
        this.createCustomContentUpper(dialogAreaComposite);
        this.createWorkItemTable(dialogAreaComposite);
        this.createContentLower(dialogAreaComposite);
        this.createCustomContentLower(dialogAreaComposite);
        this.updateSelectionState();
        this.updateBuildOptionsState();
        this.setControl((Control)dialogAreaComposite);
    }

    private void createDefinitionSelection(Composite parent) {
        Composite selectionComposite = new Composite(parent, 0);
        selectionComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).equalWidth(false).create());
        selectionComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label selectionLabel = new Label(selectionComposite, 0);
        selectionLabel.setText(Messages.AbstractAutomationWorkItemWizardPage_DEFINITION_LABEL);
        selectionLabel.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 10).create());
        this.definitionText = new Text(selectionComposite, 2048);
        this.definitionText.setEnabled(false);
        this.definitionText.setLayoutData((Object)GridDataFactory.fillDefaults().indent(0, 5).grab(true, false).create());
        this.initializeDefinitionText();
        this.browseDefinitionButton = new Button(selectionComposite, 8);
        this.browseDefinitionButton.setText(Messages.AbstractAutomationWorkItemWizardPage_DEFINITION_BUTTON_BROWSE);
        this.browseDefinitionButton.setLayoutData((Object)GridDataFactory.fillDefaults().indent(0, 5).create());
        if (this.selection != null && !this.selection.isEmpty() && this.selection.getFirstElement() instanceof AutomationDefinitionQueryNode) {
            IBuildDefinition buildDef = ((AutomationDefinitionQueryNode)((Object)this.selection.getFirstElement())).getBuildDefinition();
            this.definitionText.setData((Object)buildDef.getItemId().getUuidValue());
            this.definitionText.setText(buildDef != null ? buildDef.getId() : "");
            this.browseDefinitionButton.setEnabled(false);
        }
        this.browseDefinitionButton.addSelectionListener((SelectionListener)this);
        if (this.workItemType == null || !this.workItemType.equals("packaging")) {
            this.buildOptionsButton = new Button(selectionComposite, 8);
            this.buildOptionsButton.setText(Messages.AbstractAutomationWorkItemWizardPage_DEFINITION_BUTTON_CUSTOMIZE);
            this.buildOptionsButton.setLayoutData((Object)GridDataFactory.fillDefaults().indent(0, 5).create());
            this.buildOptionsButton.setEnabled(this.definitionText.getData() != null && this.getBuildOptionsState());
            this.buildOptionsButton.addSelectionListener((SelectionListener)this);
        }
    }

    protected void initializeDefinitionText() {
        this.definitionText.setText(Messages.AbstractAutomationWorkItemWizardPage_JOB_CHECK_BUILD_DEFINITIONS);
        if (this.configuration.getChosenDefinition() == null) {
            new FetchDefinitionsJob(this).schedule();
        }
    }

    public void handleInitializeDefinitionComplete(IBuildDefinition initialDefinition) {
        if (initialDefinition != null) {
            if (this.definitionText != null && !this.definitionText.isDisposed()) {
                this.definitionText.setData((Object)initialDefinition.getItemId().getUuidValue());
                this.definitionText.setText(initialDefinition.getId());
                this.configuration.setChosenDefinition(initialDefinition);
            }
        } else if (this.definitionText != null && !this.definitionText.isDisposed() && this.definitionText.getData() == null) {
            this.definitionText.setData(null);
            this.definitionText.setText("");
        }
        this.updateBuildOptionsState();
        this.validate();
    }

    private void createWorkItemTable(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(5, 5).create());
        tableComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.tableLabel = new Label(tableComposite, 0);
        this.tableLabel.setText(Messages.AbstractAutomationWorkItemWizardPage_WORKITEM_TABLE_LABEL);
        new Label(tableComposite, 0);
        this.numberLabel = new Label(tableComposite, 0);
        this.numberLabel.setLayoutData((Object)GridDataFactory.fillDefaults().span(0, 1).indent(5, 0).create());
        new Label(tableComposite, 0);
        Composite wiTableComposite = new Composite(tableComposite, 0);
        this.workItemTable = new Table(wiTableComposite, 68384);
        this.workItemTable.setHeaderVisible(true);
        this.workItemTable.setLinesVisible(true);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        final TableColumn idColumn = new TableColumn(this.workItemTable, 0, 0);
        idColumn.setText(Messages.AbstractAutomationWorkItemWizardPage_WORKITEM_TABLE_COLUMN_ID);
        tableColumnLayout.setColumnData((Widget)idColumn, (ColumnLayoutData)new ColumnWeightData(20));
        TableColumn summaryColumn = new TableColumn(this.workItemTable, 0, 1);
        summaryColumn.setText(Messages.AbstractAutomationWorkItemWizardPage_WORKITEM_TABLE_COLUMN_SUMMARY);
        tableColumnLayout.setColumnData((Widget)summaryColumn, (ColumnLayoutData)new ColumnWeightData(80));
        wiTableComposite.setLayout((Layout)tableColumnLayout);
        GridDataFactory.fillDefaults().indent(5, 0).hint(-1, 150).grab(true, true).applyTo((Control)wiTableComposite);
        this.workItemTable.pack();
        this.workItemTableViewer = new CheckboxTableViewer(this.workItemTable);
        AbstractWorkItemTableContentProvider workItemTableContentProvider = this.getCommonContentProvider();
        AbstractWorkItemTableLabelProvider workItemTableLabelProvider = this.getCommonLabelProvider();
        this.workItemTableViewer.setContentProvider((IContentProvider)workItemTableContentProvider);
        this.workItemTableViewer.setLabelProvider((IBaseLabelProvider)workItemTableLabelProvider);
        if (this.selection.getFirstElement() instanceof IWorkItemHandle) {
            ArrayList<IWorkItemHandle> workItemList = new ArrayList<IWorkItemHandle>();
            List selectionList = this.selection.toList();
            for (Object o : selectionList) {
                if (!(o instanceof IWorkItemHandle)) continue;
                workItemList.add((IWorkItemHandle)o);
            }
            if (!workItemList.isEmpty()) {
                this.workItemTableViewer.setInput(workItemList);
                this.workItemTableViewer.setCheckedElements(workItemList.toArray());
                this.numberLabelRefresh();
                this.updateSelectionResults();
            }
        }
        this.workItemTableViewer.addCheckStateListener((ICheckStateListener)this);
        ViewerSorter viewerSorter = new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IWorkItem workItem;
                if (AbstractAutomationWorkItemWizardPage.this.workItemTable.getSortDirection() == 0) {
                    return 0;
                }
                Object o1 = e1;
                Object o2 = e2;
                if (AbstractAutomationWorkItemWizardPage.this.workItemTable.getSortDirection() == 128) {
                    o2 = e1;
                    o1 = e2;
                }
                int id1 = 0;
                int id2 = 0;
                String s1 = null;
                int colNum = 0;
                AbstractWorkItemTableLabelProvider labelProvider = null;
                if (AbstractAutomationWorkItemWizardPage.this.workItemTable.getSortColumn() != idColumn) {
                    ++colNum;
                }
                if (o1 instanceof IWorkItem) {
                    workItem = (IWorkItem)o1;
                    id1 = workItem.getId();
                    s1 = workItem.getHTMLSummary().getPlainText();
                } else if (o1 instanceof IWorkItemHandle) {
                    labelProvider = (AbstractWorkItemTableLabelProvider)AbstractAutomationWorkItemWizardPage.this.workItemTableViewer.getLabelProvider();
                    if (labelProvider == null) {
                        return 0;
                    }
                    s1 = labelProvider.getColumnText(o1, colNum);
                    if (colNum == 0) {
                        id1 = Integer.parseInt(s1);
                    }
                } else {
                    return 0;
                }
                AbstractAutomationWorkItemWizardPage.this.progress.worked(1.0);
                if (o2 instanceof IWorkItem) {
                    workItem = (IWorkItem)o2;
                    if (colNum > 0) {
                        return s1.compareToIgnoreCase(workItem.getHTMLSummary().getPlainText());
                    }
                    id2 = workItem.getId();
                } else if (o2 instanceof IWorkItemHandle) {
                    if (labelProvider == null && (labelProvider = (AbstractWorkItemTableLabelProvider)AbstractAutomationWorkItemWizardPage.this.workItemTableViewer.getLabelProvider()) == null) {
                        return 0;
                    }
                    String s2 = labelProvider.getColumnText(o2, colNum);
                    if (colNum > 0) {
                        return s1.compareToIgnoreCase(s2);
                    }
                    id2 = Integer.parseInt(s2);
                } else {
                    return 0;
                }
                if (id1 < id2) {
                    return -1;
                }
                if (id1 > id2) {
                    return 1;
                }
                return 0;
            }
        };
        this.workItemTable.setSortColumn(idColumn);
        this.workItemTable.setSortDirection(0);
        this.workItemTableViewer.setSorter(viewerSorter);
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn sortColumn = AbstractAutomationWorkItemWizardPage.this.workItemTable.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = 1024;
                if (sortColumn == currentColumn) {
                    if (AbstractAutomationWorkItemWizardPage.this.workItemTable.getSortDirection() == 1024) {
                        dir = 128;
                    } else if (AbstractAutomationWorkItemWizardPage.this.workItemTable.getSortDirection() == 128) {
                        dir = 0;
                    }
                } else {
                    AbstractAutomationWorkItemWizardPage.this.workItemTable.setSortColumn(currentColumn);
                }
                AbstractAutomationWorkItemWizardPage.this.workItemTable.setSortDirection(dir);
                AbstractAutomationWorkItemWizardPage.this.progress.beginAnimatedTask();
                AbstractAutomationWorkItemWizardPage.this.progress.beginTask(4);
                AbstractAutomationWorkItemWizardPage.this.progress.worked(1.0);
                AbstractAutomationWorkItemWizardPage.this.workItemTableViewer.refresh();
                AbstractAutomationWorkItemWizardPage.this.progress.done();
            }
        };
        idColumn.addListener(13, sortListener);
        summaryColumn.addListener(13, sortListener);
        Composite buttonComposite = new Composite(tableComposite, 0);
        buttonComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        buttonComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        this.selectAllButton = new Button(buttonComposite, 8);
        this.selectAllButton.setText(Messages.AbstractAutomationWorkItemWizardPage_WORKITEM_TABLE_BUTTON_SELECTALL);
        this.selectAllButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.selectAllButton.addSelectionListener((SelectionListener)this);
        this.selectNoneButton = new Button(buttonComposite, 8);
        this.selectNoneButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.selectNoneButton.setText(Messages.AbstractAutomationWorkItemWizardPage_WORKITEM_TABLE_BUTTON_DESELECTALL);
        this.selectNoneButton.addSelectionListener((SelectionListener)this);
        this.addWorkItemButton = new Button(buttonComposite, 8);
        this.addWorkItemButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.addWorkItemButton.setText(Messages.AbstractAutomationWorkItemWizardPage_WORKITEM_TABLE_BUTTON_ADD);
        this.addWorkItemButton.addSelectionListener((SelectionListener)this);
        this.removeWorkItemButton = new Button(buttonComposite, 8);
        this.removeWorkItemButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.removeWorkItemButton.setText(Messages.AbstractAutomationWorkItemWizardPage_WORKITEM_TABLE_BUTTON_REMOVE);
        this.removeWorkItemButton.addSelectionListener((SelectionListener)this);
        this.queryWorkItemButton = new Button(buttonComposite, 8);
        this.queryWorkItemButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.queryWorkItemButton.setText(Messages.AbstractAutomationWorkItemWizardPage_WORKITEM_TABLE_BUTTON_RUNQUERY);
        this.queryWorkItemButton.addSelectionListener((SelectionListener)this);
        this.progress = new ProgressIndicator(tableComposite, 65536);
        this.progress.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).indent(5, 5).grab(false, false).create());
    }

    public void widgetSelected(SelectionEvent event) {
        BuildOptionsDialog dialog;
        Object eventSource = event.getSource();
        if (eventSource == this.openReportWorkItemButton) {
            this.configuration.setOpenReportWorkItem(this.openReportWorkItemButton.getSelection());
        } else if (eventSource == this.addWorkItemButton) {
            AbstractWorkItemChooser chooserDialog = this.getWorkItemChooser();
            if (chooserDialog.open() == 0) {
                this.progress.beginAnimatedTask();
                List<IWorkItemHandle> chosenItems = chooserDialog.getChosenWorkItems();
                this.refreshWITable(chosenItems);
            }
            this.numberLabelRefresh();
        } else if (eventSource == this.removeWorkItemButton) {
            AbstractWorkItemChooser chooserDialogRem = this.getWorkItemChooser();
            if (chooserDialogRem.open() == 0) {
                this.progress.beginAnimatedTask();
                this.progress.beginTask(4);
                this.progress.worked(1.0);
                List<IWorkItemHandle> chosenItems = chooserDialogRem.getChosenWorkItems();
                if (chosenItems != null && !chosenItems.isEmpty()) {
                    List<IWorkItemHandle> currentContents = ((AbstractWorkItemTableContentProvider)this.workItemTableViewer.getContentProvider()).getElementsAsList();
                    HashMap<String, IWorkItemHandle> currentMap = new HashMap<String, IWorkItemHandle>();
                    if (currentContents != null && !currentContents.isEmpty()) {
                        for (IWorkItemHandle existingItem : currentContents) {
                            currentMap.put(existingItem.getItemId().getUuidValue(), existingItem);
                        }
                        for (IWorkItemHandle newItem : chosenItems) {
                            String newItemID = newItem.getItemId().getUuidValue();
                            if (!currentMap.containsKey(newItemID)) continue;
                            currentContents.remove(currentMap.get(newItemID));
                        }
                    }
                    this.progress.worked(1.0);
                    this.workItemTableViewer.refresh();
                }
                this.progress.done();
                this.updateSelectionResults();
                this.numberLabelRefresh();
            }
        } else if (eventSource == this.browseDefinitionButton) {
            if (this.selectionDialog.open() == 0) {
                IBuildDefinition definition = this.selectionDialog.getFirstSelectedBuildDefinition();
                this.definitionText.setData((Object)definition.getItemId().getUuidValue());
                this.definitionText.setText(definition.getId());
                this.configuration.setChosenDefinition(definition);
            }
            this.buildOptionsButton.setEnabled(!this.definitionText.getText().equalsIgnoreCase(""));
        } else if (eventSource == this.selectAllButton) {
            this.workItemTableViewer.setAllChecked(true);
            this.numberLabelRefresh();
            this.updateSelectionResults();
        } else if (eventSource == this.selectNoneButton) {
            this.workItemTableViewer.setAllChecked(false);
            this.numberLabelRefresh();
            this.updateSelectionResults();
        } else if (eventSource == this.queryWorkItemButton) {
            QuerySelectionDialog queryDialog = new QuerySelectionDialog(this.getShell(), false);
            queryDialog.setTitle(Messages.AbstractAutomationWorkItemWizardPage_QUERYSELECTION_DIALOG_TITLE);
            ITeamRepository currentRepo = this.configuration.getTeamRepository();
            if (currentRepo != null) {
                List connectedProjectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(currentRepo);
                queryDialog.configureProjectAreas((Collection)connectedProjectAreas);
            }
            if (queryDialog.open() == 0) {
                final ArrayList<IWorkItemHandle> workItemList = new ArrayList<IWorkItemHandle>();
                final List queryList = queryDialog.getSelectedQueries();
                this.progress.beginAnimatedTask();
                IProgressService ps = PlatformUI.getWorkbench().getProgressService();
                try {
                    ps.busyCursorWhile(new IRunnableWithProgress(){
                        private IQueryDescriptor queryDescriptor;
                        private Expression resolvedExpression;

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            for (IQueryDescriptorHandle query : queryList) {
                                IQueryClient queryClient = (IQueryClient)AbstractAutomationWorkItemWizardPage.this.configuration.getTeamRepository().getClientLibrary(IQueryClient.class);
                                try {
                                    this.queryDescriptor = (IQueryDescriptor)queryClient.getAuditableCommon().resolveAuditable((IAuditableHandle)query, IQueryDescriptor.FULL_PROFILE, null);
                                    this.queryDescriptor.reset();
                                    ClientEvaluationContext evaluationContext = new ClientEvaluationContext(this.queryDescriptor.getProjectArea());
                                    for (VariableAttributeExpression cur : this.queryDescriptor.getParameterVariables().values()) {
                                        cur.getAttribute((IEvaluationContext)evaluationContext, monitor);
                                    }
                                    if (this.queryDescriptor == null) continue;
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (QueryExecutionHandlerRegistry.getExecutionHandler().handleUnboundQueryParameterValues(queryDescriptor, AbstractAutomationWorkItemWizardPage.this.getShell())) {
                                                try {
                                                    resolvedExpression = queryDescriptor.getResolvedExpression();
                                                }
                                                catch (TeamRepositoryException tre) {
                                                    tre.printStackTrace();
                                                }
                                            }
                                        }
                                    });
                                    if (this.resolvedExpression == null) continue;
                                    IQueryResult queryResults = queryClient.getResolvedExpressionResults(this.queryDescriptor.getProjectArea(), this.resolvedExpression, IWorkItem.SMALL_PROFILE);
                                    IResolvedResult resolvedItems = null;
                                    while (queryResults.hasNext(null)) {
                                        resolvedItems = (IResolvedResult)queryResults.next(null);
                                        if (resolvedItems == null) continue;
                                        workItemList.add((IWorkItemHandle)((IWorkItem)resolvedItems.getItem()).getItemHandle());
                                    }
                                }
                                catch (TeamRepositoryException tre) {
                                    tre.printStackTrace();
                                }
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.refreshWITable(workItemList);
                this.numberLabelRefresh();
            }
        } else if (eventSource == this.buildOptionsButton && (dialog = new BuildOptionsDialog(this.getShell(), this.configuration.getChosenDefinition())).open() == 0) {
            this.configuration.setChosenDefinition(dialog.getfBuildDefinition());
            this.buildOptionsAreCustomized = true;
        }
        this.updateSelectionState();
        this.validate();
    }

    private void numberLabelRefresh() {
        if (this.workItemTableViewer != null && this.workItemTableViewer.getTable() != null && !this.workItemTableViewer.getTable().isDisposed()) {
            if (this.workItemTableViewer.getTable().getItemCount() == 0) {
                this.numberLabel.setText("");
            } else {
                int selected = this.workItemTableViewer.getCheckedElements().length;
                this.numberLabel.setText(Messages.bind((String)Messages.AbstractAutomationWorkItemWizardPage_NUMBER_OF_WORK_ITEMS_LABEL_MULTIPLE, (Object)selected, (Object)this.workItemTableViewer.getTable().getItemCount()));
            }
        }
    }

    private void refreshWITable(List<IWorkItemHandle> workItemList) {
        this.progress.beginTask(6);
        if (workItemList != null && !workItemList.isEmpty()) {
            this.progress.worked(2.0);
            List<IWorkItemHandle> currentContents = ((AbstractWorkItemTableContentProvider)this.workItemTableViewer.getContentProvider()).getElementsAsList();
            if (currentContents == null || currentContents.isEmpty()) {
                this.workItemTableViewer.setInput(workItemList);
                this.progress.worked(3.0);
                this.workItemTableViewer.setCheckedElements(workItemList.toArray());
            } else {
                ArrayList<IWorkItemHandle> itemsToCheck = new ArrayList<IWorkItemHandle>();
                HashMap<String, IWorkItemHandle> currentMap = new HashMap<String, IWorkItemHandle>();
                for (IWorkItemHandle existingItem : currentContents) {
                    currentMap.put(existingItem.getItemId().getUuidValue(), existingItem);
                }
                this.progress.worked(1.0);
                for (IWorkItemHandle newItem : workItemList) {
                    String newItemID = newItem.getItemId().getUuidValue();
                    if (currentMap.containsKey(newItemID)) continue;
                    currentMap.put(newItemID, newItem);
                    currentContents.add(newItem);
                    itemsToCheck.add(newItem);
                }
                this.progress.worked(1.0);
                if (!itemsToCheck.isEmpty()) {
                    ArrayList<Object> allItemsToCheck = new ArrayList<Object>();
                    this.workItemTableViewer.refresh();
                    Object[] existingCheckedElements = this.workItemTableViewer.getCheckedElements();
                    allItemsToCheck.addAll(Arrays.asList(existingCheckedElements));
                    allItemsToCheck.addAll(itemsToCheck);
                    this.progress.worked(1.0);
                    this.workItemTableViewer.setCheckedElements(allItemsToCheck.toArray());
                }
            }
            this.progress.worked(1.0);
            this.workItemTableViewer.refresh();
        }
        this.progress.worked(4.0);
        this.updateSelectionResults();
        this.progress.done();
    }

    private void createContentLower(Composite parent) {
        Composite promotionCompositeLower = new Composite(parent, 0);
        promotionCompositeLower.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(5, 0).create());
        promotionCompositeLower.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).create());
        this.openReportWorkItemButton = new Button(promotionCompositeLower, 32);
        this.openReportWorkItemButton.setText(Messages.AbstractAutomationWorkItemWizardPage_TEXT_OPENREPORTITEM);
        this.openReportWorkItemButton.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).align(1, 0x1000008).create());
        this.openReportWorkItemButton.addSelectionListener((SelectionListener)this);
    }

    @Override
    public void createCustomContentLower(Composite parent) {
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.updateSelectionResults();
        this.updateSelectionState();
        this.numberLabelRefresh();
        this.validate();
    }

    private void updateSelectionResults() {
        List<Object> checkedList = Arrays.asList(this.workItemTableViewer.getCheckedElements());
        this.configuration.setSelectionResult(checkedList);
    }

    private void updateSelectionState() {
        int totalItems;
        int numberChecked = this.workItemTableViewer.getCheckedElements().length;
        this.selectAllButton.setEnabled(numberChecked != (totalItems = this.workItemTableViewer.getTable().getItemCount()));
        this.selectNoneButton.setEnabled(numberChecked != 0);
        this.removeWorkItemButton.setEnabled(totalItems != 0);
    }

    protected void validate() {
        Object status = Status.OK_STATUS;
        status = this.workItemTableViewer != null && this.workItemTableViewer.getCheckedElements().length == 0 && (this.workItemType == null || !this.workItemType.equals("packaging")) ? new Status(4, "com.ibm.team.enterprise.automation.ui", Messages.AbstractAutomationWorkItemWizardPage_ERROR_SELECTWORKITEM) : (this.definitionText != null && this.definitionText.getData() == null ? new Status(4, "com.ibm.team.enterprise.automation.ui", Messages.AbstractAutomationWorkItemWizardPage_ERROR_SELECTDEFINITION) : this.validateDefinition());
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    protected IStatus validateDefinition() {
        return Status.OK_STATUS;
    }

    protected void updateBuildOptionsState() {
        if (this.buildOptionsButton != null && !this.buildOptionsButton.isDisposed()) {
            this.buildOptionsButton.setEnabled(this.definitionText.getData() != null && this.getBuildOptionsState());
        }
    }

    protected boolean getBuildOptionsState() {
        return true;
    }

    protected String getHelpText() {
        return null;
    }

    protected void setWorkItemType(String workItemType) {
        this.workItemType = workItemType;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validate();
            String helpText = this.getHelpText();
            if (helpText != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpText());
            }
        }
    }

    public void performHelp() {
        String helpText = this.getHelpText();
        if (helpText != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(helpText);
        }
    }

    protected IProcessAreaHandle getProcessAreaHandle() {
        IBuildDefinition buildDef = this.configuration.getChosenDefinition();
        if (buildDef != null) {
            return buildDef.getProcessArea();
        }
        return null;
    }

    protected ITeamRepository getTeamRepository() {
        return this.configuration.getTeamRepository();
    }

    protected IProcessArea getProcessArea() throws TeamRepositoryException {
        IProcessAreaHandle paHandle = this.getProcessAreaHandle();
        if (paHandle != null) {
            return (IProcessArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)paHandle, 0, null);
        }
        return null;
    }

    protected class AutomationDefinitionSelectionDialog
    extends BuildDefinitionSelectionDialog {
        public AutomationDefinitionSelectionDialog(Shell parent) {
            super(parent, Messages.AbstractAutomationWorkItemWizardPage_PAGE_TITLE, Messages.AbstractAutomationWorkItemWizardPage_PAGE_DESCRIPTION, false, false);
        }

        public void setListElements(Object[] elements) {
            ArrayList<IBuildDefinition> buildDefs = null;
            boolean isAtLeastOneBuildDefinition = false;
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object currObject = objectArray[n2];
                if (currObject instanceof IBuildDefinition) {
                    if (!isAtLeastOneBuildDefinition) {
                        isAtLeastOneBuildDefinition = true;
                    }
                    if (buildDefs == null) {
                        buildDefs = new ArrayList<IBuildDefinition>();
                    }
                    if (((IBuildDefinition)currObject).getConfigurationElement(AbstractAutomationWorkItemWizardPage.this.getConfigurationElementID()) != null) {
                        buildDefs.add((IBuildDefinition)currObject);
                    }
                }
                ++n2;
            }
            if (buildDefs != null && !buildDefs.isEmpty()) {
                super.setListElements(buildDefs.toArray());
            } else if (isAtLeastOneBuildDefinition) {
                super.setListElements(buildDefs.toArray());
            } else {
                super.setListElements(elements);
            }
        }
    }
}

