/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.internal.ui.wizards;

import com.ibm.team.enterprise.automation.common.summary.IChangeSetNode;
import com.ibm.team.enterprise.automation.common.summary.INode;
import com.ibm.team.enterprise.automation.common.summary.ISummaryNode;
import com.ibm.team.enterprise.automation.common.summary.IWorkItemNode;
import com.ibm.team.enterprise.automation.internal.ui.nls.Messages;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AutomationViewerFilter;
import com.ibm.team.enterprise.automation.internal.ui.wizards.IAutomationWizardConfiguration;
import com.ibm.team.enterprise.automation.internal.ui.wizards.SummaryTreeContentProvider;
import com.ibm.team.enterprise.automation.internal.ui.wizards.SummaryTreeLabelProvider;
import com.ibm.team.enterprise.automation.ui.AutomationUIPlugin;
import com.ibm.team.enterprise.automation.ui.AutomationUtil;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractAutomationWorkItemSummaryWizardPage
extends WizardPage
implements SelectionListener {
    private IAutomationWizardConfiguration configuration;
    protected TreeViewer summaryTree;
    private List<ViewerFilter> currentFilters;

    public AbstractAutomationWorkItemSummaryWizardPage(Shell parent, IAutomationWizardConfiguration config) {
        super("Work Item Summary Page");
        this.configuration = config;
        this.currentFilters = new ArrayList<ViewerFilter>();
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.AbstractAutomationWorkItemSummaryWizardPage_PAGE_TITLE);
        this.setDescription(Messages.AbstractAutomationWorkItemSummaryWizardPage_PAGE_DESCRIPTION);
        Composite dialogAreaComposite = new Composite(parent, 0);
        dialogAreaComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        dialogAreaComposite.setLayoutData((Object)GridDataFactory.fillDefaults().hint(400, -1).grab(true, false).create());
        this.createSummaryContent(dialogAreaComposite);
        this.createCustomContent(dialogAreaComposite);
        this.setControl((Control)dialogAreaComposite);
    }

    private void createSummaryContent(Composite parent) {
        Composite treeComposite = new Composite(parent, 0);
        treeComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).create());
        treeComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.setMessageText(treeComposite);
        Composite treeButtonComposite = new Composite(treeComposite, 0);
        treeButtonComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).create());
        treeButtonComposite.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).create());
        ToolBar treeToolBar = new ToolBar(treeButtonComposite, 0x800100);
        if (this.provideViewChangeSetOption()) {
            ToolItem exploreChangeSets = new ToolItem(treeToolBar, 0x800008);
            exploreChangeSets.setImage(AutomationUIPlugin.getImage("icons/obj16/assocchgset_obj.gif"));
            exploreChangeSets.setToolTipText(Messages.AbstractAutomationWorkItemSummaryWizardPage_SUMMARYTREE_TOOLBAR_VIEWCHANGESET);
            exploreChangeSets.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    AbstractAutomationWorkItemSummaryWizardPage.this.viewChangeSetsInChangeExplorer();
                }
            });
        }
        ToolItem expandItem = new ToolItem(treeToolBar, 0x800008);
        expandItem.setImage(AutomationUIPlugin.getImage("icons/obj16/expandall_small.gif"));
        expandItem.setToolTipText(Messages.AbstractAutomationWorkItemSummaryWizardPage_SUMMARYTREE_TOOLBAR_EXPANDALL);
        expandItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractAutomationWorkItemSummaryWizardPage.this.summaryTree.expandAll();
            }
        });
        ToolItem collapseItem = new ToolItem(treeToolBar, 0x800008);
        collapseItem.setImage(AutomationUIPlugin.getImage("icons/obj16/collapseall_small.gif"));
        collapseItem.setToolTipText(Messages.AbstractAutomationWorkItemSummaryWizardPage_SUMMARYTREE_TOOLBAR_COLLAPSEALL);
        collapseItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractAutomationWorkItemSummaryWizardPage.this.summaryTree.collapseAll();
            }
        });
        ToolItem treeToolItem = new ToolItem(treeToolBar, 0x800004);
        treeToolItem.setImage(AutomationUIPlugin.getImage("icons/obj16/filter_ps.gif"));
        treeToolItem.setToolTipText(Messages.AbstractAutomationWorkItemSummaryWizardPage_SUMMARYTREE_TOOLBAR_FILTER);
        AbstractToolBarSelectionListener dropDownListener = new AbstractToolBarSelectionListener(treeToolItem);
        for (AutomationViewerFilter f : this.getSummaryFilters()) {
            dropDownListener.addItem(f.getFilterName(), f.getViewerFilter());
        }
        treeToolItem.addSelectionListener((SelectionListener)dropDownListener);
        this.summaryTree = new TreeViewer(treeComposite);
        this.summaryTree.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, true).create());
        this.summaryTree.setContentProvider((IContentProvider)this.getContentProvider());
        this.summaryTree.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.summaryTree.setInput((Object)"root");
        this.summaryTree.setFilters(this.currentFilters.toArray(new ViewerFilter[0]));
    }

    protected void viewChangeSetsInChangeExplorer() {
        AutomationUtil.openInChangeExplorer(this.collectChangeSets(), null, this.configuration.getTeamRepository(), this.getShell());
    }

    protected List<AutomationViewerFilter> getSummaryFilters() {
        ArrayList<AutomationViewerFilter> commonFilters = new ArrayList<AutomationViewerFilter>();
        return commonFilters;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.summaryTree.setInput((Object)this.getSummaryNode());
            this.summaryTree.refresh();
            String helpText = this.getHelpText();
            if (helpText != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpText());
            }
        }
    }

    protected ITreeContentProvider getContentProvider() {
        return new SummaryTreeContentProvider();
    }

    protected ILabelProvider getLabelProvider() {
        return new SummaryTreeLabelProvider();
    }

    protected boolean provideViewChangeSetOption() {
        return true;
    }

    protected String getHelpText() {
        return null;
    }

    public void performHelp() {
        String helpText = this.getHelpText();
        if (helpText != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(helpText);
        }
    }

    public void widgetSelected(SelectionEvent event) {
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void setMessageText(Composite parent) {
        Label treeLabel = new Label(parent, 0);
        treeLabel.setText(Messages.AbstractAutomationWorkItemSummaryWizardPage_SUMMARYTREE_LABEL);
        treeLabel.setLayoutData((Object)GridDataFactory.fillDefaults().create());
    }

    public abstract void createCustomContent(Composite var1);

    protected abstract ISummaryNode getSummaryNode();

    protected List<IChangeSetHandle> collectChangeSets() {
        ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
        ISummaryNode summaryNode = (ISummaryNode)this.summaryTree.getInput();
        List childrenNodes = summaryNode.getChildren();
        for (INode childNode : childrenNodes) {
            if (childNode.getType() != INode.Type.WORKITEM) continue;
            this.collectChangeSets((IWorkItemNode)childNode, changeSets);
        }
        return changeSets;
    }

    private void collectChangeSets(IWorkItemNode workItemNode, List<IChangeSetHandle> changeSets) {
        for (INode childNode : workItemNode.getChildren()) {
            if (childNode.getType() == INode.Type.WORKITEM) {
                this.collectChangeSets((IWorkItemNode)childNode, changeSets);
                continue;
            }
            if (childNode.getType() != INode.Type.CHANGESET) continue;
            changeSets.add((IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)this.configuration.getTeamRepository(), ((IChangeSetNode)childNode).getNodeId(), null));
        }
    }

    class AbstractToolBarSelectionListener
    extends SelectionAdapter {
        private ToolItem menuItem;
        private Menu menu;

        public AbstractToolBarSelectionListener(ToolItem menuItem) {
            this.menuItem = menuItem;
            this.menu = new Menu((Control)menuItem.getParent().getShell());
        }

        public void addItem(String itemName, final ViewerFilter filter) {
            MenuItem newItem = new MenuItem(this.menu, 32);
            newItem.setText(itemName);
            newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    boolean containsFilter = AbstractAutomationWorkItemSummaryWizardPage.this.currentFilters.contains(filter);
                    if (containsFilter) {
                        AbstractAutomationWorkItemSummaryWizardPage.this.currentFilters.remove(filter);
                    } else {
                        AbstractAutomationWorkItemSummaryWizardPage.this.currentFilters.add(filter);
                    }
                    ((AbstractToolBarSelectionListener)AbstractToolBarSelectionListener.this).AbstractAutomationWorkItemSummaryWizardPage.this.summaryTree.setFilters(AbstractAutomationWorkItemSummaryWizardPage.this.currentFilters.toArray(new ViewerFilter[0]));
                    ((AbstractToolBarSelectionListener)AbstractToolBarSelectionListener.this).AbstractAutomationWorkItemSummaryWizardPage.this.summaryTree.refresh();
                }
            });
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.detail == 4) {
                ToolItem item = (ToolItem)event.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                this.menu.setLocation(pt.x, pt.y + rect.height);
                this.menu.setVisible(true);
            }
        }
    }
}

