/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.internal.ui.view;

import com.ibm.team.enterprise.automation.internal.ui.nls.Messages;
import com.ibm.team.enterprise.automation.internal.ui.view.ISelectResultInput;
import com.ibm.team.enterprise.automation.internal.ui.view.SelectResultTableViewer;
import com.ibm.team.enterprise.build.ui.data.export.IQueryResultExportSupplier;
import com.ibm.team.enterprise.build.ui.data.export.TableData;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.ViewPart;

public class SelectResultView
extends ViewPart
implements IQueryResultExportSupplier {
    private Label statusLabel;
    private SelectResultTableViewer viewer;

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        this.statusLabel = new Label(composite, 16384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.statusLabel);
        this.viewer = new SelectResultTableViewer(composite);
        this.installContextMenu();
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    public void setInput(ISelectResultInput selectResultInput) {
        if (selectResultInput != null) {
            this.viewer.setInput(selectResultInput);
            this.setStatusLabel(selectResultInput.getResults());
        } else {
            this.statusLabel.setText(Messages.SelectResultView_RETRIEVING_PACKAGES);
        }
    }

    public void open() {
        this.viewer.open();
    }

    private void setStatusLabel(List<SelectResult> results) {
        if (results == null) {
            this.statusLabel.setText("");
        } else {
            this.statusLabel.setText(Messages.bind((String)Messages.QUERY_RESULT_VIEW_LABEL, (Object)results.size()));
        }
    }

    private void installContextMenu() {
        MenuManager contextMenuMgr = new MenuManager("#PopupMenu");
        contextMenuMgr.setRemoveAllWhenShown(true);
        this.viewer.installContextMenu(contextMenuMgr);
        this.getSite().registerContextMenu(contextMenuMgr, this.viewer.getSelectionProvider());
    }

    public TableData gatherExportData(IProgressMonitor monitor) {
        return this.viewer.getTableData(monitor);
    }
}

