/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.internal.ui.view;

import com.ibm.team.enterprise.automation.internal.ui.view.BindingExtensionFactory;
import com.ibm.team.enterprise.automation.internal.ui.view.BindingSelection;
import com.ibm.team.enterprise.automation.internal.ui.view.IDefaultActionHandlerAction;
import com.ibm.team.enterprise.automation.internal.ui.view.IResourceBundle;
import com.ibm.team.enterprise.automation.internal.ui.view.ISelectResultInput;
import com.ibm.team.enterprise.automation.internal.ui.view.SelectResultContentProvider;
import com.ibm.team.enterprise.automation.internal.ui.view.SelectResultLabelProvider;
import com.ibm.team.enterprise.automation.internal.ui.view.Util;
import com.ibm.team.enterprise.automation.ui.table.AutomationViewerComparator;
import com.ibm.team.enterprise.build.ui.data.export.TableData;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SelectResultTableViewer {
    private Table table;
    private TableViewer tableViewer;
    private Composite parent;
    private String currentSelectedBindingName;
    private BindingExtensionFactory bindingExtensionFactory;
    private SelectResultLabelProvider labelProvider;
    private ISelectResultInput selectResultInput;
    private AutomationViewerComparator comparator;

    public SelectResultTableViewer(Composite parent) {
        this.parent = parent;
        this.createTable();
        this.bindingExtensionFactory = BindingExtensionFactory.getInstance();
    }

    private void createTable() {
        int style = 101124;
        this.table = new Table(this.parent, style);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)new SelectResultContentProvider());
        this.labelProvider = new SelectResultLabelProvider(this.tableViewer.getTable());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                SelectResultTableViewer.this.currentSelectedBindingName = Util.getBindingAt(SelectResultTableViewer.this.table, event.x);
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SelectResultTableViewer.this.open();
            }
        });
        this.comparator = new AutomationViewerComparator();
        this.comparator.setColumn(1);
        this.comparator.setAscending(false);
        this.tableViewer.setComparator((ViewerComparator)this.comparator);
    }

    protected void open() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        SelectResult result = (SelectResult)selection.getFirstElement();
        IDefaultActionHandlerAction defaultHandlerAction = null;
        if (this.currentSelectedBindingName != null) {
            defaultHandlerAction = this.bindingExtensionFactory.getDefaultHandlerAction(this.selectResultInput.getNamespace(), this.currentSelectedBindingName);
        }
        if (defaultHandlerAction == null) {
            defaultHandlerAction = this.bindingExtensionFactory.getDefaultHandlerAction(this.selectResultInput.getNamespace());
        }
        if (defaultHandlerAction != null) {
            defaultHandlerAction.aboutToOpen(new BindingSelection(this.currentSelectedBindingName, result, this.selectResultInput.getRepository()));
            defaultHandlerAction.open();
        }
    }

    public void setInput(ISelectResultInput selectResultInput) {
        this.selectResultInput = selectResultInput;
        this.labelProvider.setSelectResultInput(selectResultInput);
        if (selectResultInput.getResults() != null && selectResultInput.getResults().size() > 0) {
            this.resetTableColumns(selectResultInput.getResults().get(0));
        } else {
            this.resetTableColumns(null);
        }
        this.tableViewer.setInput(selectResultInput.getResults());
    }

    private void resetTableColumns(SelectResult result) {
        TableColumn[] tableColumns = this.table.getColumns();
        if (tableColumns.length == 0) {
            TableColumn tableColumn = new TableColumn(this.table, 0x1000000);
            tableColumn.setWidth(30);
        } else {
            int i = 1;
            while (i < tableColumns.length) {
                tableColumns[i].dispose();
                ++i;
            }
        }
        if (result != null) {
            int i = 1;
            for (Binding binding : result.getBindings()) {
                TableColumn tableColumn = new TableColumn(this.table, 16384, i);
                tableColumn.setData((Object)binding.getName());
                tableColumn.setText(this.getBindingLabel(binding.getName()));
                tableColumn.setWidth(150);
                if (i == 1) {
                    this.table.setSortColumn(tableColumn);
                    this.table.setSortDirection(1024);
                }
                tableColumn.addSelectionListener(this.getPackageColumnSelectionListener(this.table, tableColumn, i++));
            }
        }
        this.comparator.setColumn(1);
        this.comparator.setAscending(false);
        this.tableViewer.refresh();
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    private String getBindingLabel(String bindingName) {
        IResourceBundle resourceBundle = this.bindingExtensionFactory.getResourceBundle(this.selectResultInput.getNamespace(), bindingName);
        if (resourceBundle == null) {
            resourceBundle = this.bindingExtensionFactory.getResourceBundle(this.selectResultInput.getNamespace());
        }
        if (resourceBundle == null) {
            return bindingName;
        }
        return resourceBundle.getLabel(new BindingSelection(bindingName));
    }

    protected ISelectionProvider getSelectionProvider() {
        return this.tableViewer;
    }

    protected void installContextMenu(MenuManager menuManager) {
        Menu menu = menuManager.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
    }

    public TableData getTableData(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", this.tableViewer.getTable().getItemCount());
        TableData data = new TableData(this.tableViewer.getTable().getColumns());
        int i = 0;
        while (i < this.tableViewer.getTable().getItemCount()) {
            if (monitor.isCanceled()) break;
            data.addRow(this.tableViewer.getTable().getItem(i));
            monitor.worked(1);
            ++i;
        }
        return data;
    }

    protected SelectionListener getPackageColumnSelectionListener(final Table table, final TableColumn column, final int columnNum) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectResultTableViewer.this.comparator.setColumn(columnNum);
                if (table.getSortColumn() == column) {
                    if (table.getSortDirection() == 1024) {
                        table.setSortDirection(128);
                    } else {
                        table.setSortDirection(1024);
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                SelectResultTableViewer.this.tableViewer.refresh();
            }
        };
    }
}

