/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.internal.ui.view;

import com.ibm.team.enterprise.automation.internal.ui.view.IDefaultActionHandlerAction;
import com.ibm.team.enterprise.automation.internal.ui.view.IResourceBundle;
import com.ibm.team.enterprise.automation.internal.ui.view.IValueHandler;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class BindingExtensionFactory {
    private static BindingExtensionFactory instance;
    private Hashtable<String, ExtensionElementInfo> extensionElementInfoHash = new Hashtable();

    private BindingExtensionFactory() {
    }

    public static BindingExtensionFactory getInstance() {
        if (instance == null) {
            instance = new BindingExtensionFactory();
            instance.init();
        }
        return instance;
    }

    private void init() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.ibm.team.enterprise.automation.ui.view.results");
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String namespace;
            IConfigurationElement element = elements[i];
            if (element.getName().equals("default")) {
                namespace = element.getAttribute("namespace");
                ExtensionElementInfo extensionElementInfo = this.getExtensionElementInfo(namespace);
                IDefaultActionHandlerAction defaultHandlerAction = this.createDefaultHandlerAction(element);
                IValueHandler valueHandler = this.createValueHandler(element);
                IResourceBundle resourceBundle = this.createResourceBundle(element);
                DefaultElementInfo defaultElementInfo = new DefaultElementInfo(namespace);
                defaultElementInfo.setDefaultHandlerAction(defaultHandlerAction);
                defaultElementInfo.setValueHandler(valueHandler);
                defaultElementInfo.setResourceBundler(resourceBundle);
                extensionElementInfo.setDefaultElementInfo(defaultElementInfo);
            } else if (element.getName().equals("binding")) {
                namespace = element.getAttribute("namespace");
                String bindingName = element.getAttribute("name");
                ExtensionElementInfo extensionElementInfo = this.getExtensionElementInfo(namespace);
                IDefaultActionHandlerAction defaultHandlerAction = this.createDefaultHandlerAction(element);
                IValueHandler valueHandler = this.createValueHandler(element);
                IResourceBundle resourceBundle = this.createResourceBundle(element);
                BindingElementInfo bindingElementInfo = new BindingElementInfo(namespace, bindingName);
                bindingElementInfo.setDefaultHandlerAction(defaultHandlerAction);
                bindingElementInfo.setResourceBundler(resourceBundle);
                bindingElementInfo.setValueHandler(valueHandler);
                extensionElementInfo.addBindingElementInfo(bindingElementInfo);
            }
            ++i;
        }
    }

    public IDefaultActionHandlerAction getDefaultHandlerAction(String namespace) {
        DefaultElementInfo defaultElementInfo = this.getDefaultElementInfo(namespace);
        if (defaultElementInfo != null) {
            return defaultElementInfo.getDefaultHandlerAction();
        }
        return null;
    }

    public IDefaultActionHandlerAction getDefaultHandlerAction(String namespace, String bindingName) {
        BindingElementInfo bindingElementInfo = this.getBindingElementInfo(namespace, bindingName);
        if (bindingElementInfo != null) {
            return bindingElementInfo.getDefaultHandlerAction();
        }
        return null;
    }

    public IValueHandler getValueHandler(String namespace) {
        DefaultElementInfo defaultElementInfo = this.getDefaultElementInfo(namespace);
        if (defaultElementInfo != null) {
            return defaultElementInfo.getValueHandler();
        }
        return null;
    }

    public IValueHandler getValueHandler(String namespace, String bindingName) {
        BindingElementInfo bindingElementInfo = this.getBindingElementInfo(namespace, bindingName);
        if (bindingElementInfo != null) {
            return bindingElementInfo.getValueHandler();
        }
        return null;
    }

    public IResourceBundle getResourceBundle(String namespace) {
        DefaultElementInfo defaultElementInfo = this.getDefaultElementInfo(namespace);
        if (defaultElementInfo != null) {
            return defaultElementInfo.getResourceBundle();
        }
        return null;
    }

    public IResourceBundle getResourceBundle(String namespace, String bindingName) {
        BindingElementInfo bindingElementInfo = this.getBindingElementInfo(namespace, bindingName);
        if (bindingElementInfo != null) {
            return bindingElementInfo.getResourceBundle();
        }
        return null;
    }

    private DefaultElementInfo getDefaultElementInfo(String namespace) {
        ExtensionElementInfo extensionElementInfo = this.extensionElementInfoHash.get(namespace);
        if (extensionElementInfo != null) {
            return extensionElementInfo.getDefaultElementInfo();
        }
        return null;
    }

    private BindingElementInfo getBindingElementInfo(String namespace, String bindingName) {
        BindingElementInfo bindingElementInfo = null;
        ExtensionElementInfo extensionElementInfo = this.extensionElementInfoHash.get(namespace);
        if (extensionElementInfo != null) {
            bindingElementInfo = extensionElementInfo.getBindingElementInfo(bindingName);
        }
        if (bindingElementInfo == null && (extensionElementInfo = this.extensionElementInfoHash.get("*")) != null) {
            bindingElementInfo = extensionElementInfo.getBindingElementInfo(bindingName);
        }
        return bindingElementInfo;
    }

    private ExtensionElementInfo getExtensionElementInfo(String namespace) {
        ExtensionElementInfo extensionElementInfo = this.extensionElementInfoHash.get(namespace);
        if (extensionElementInfo == null) {
            extensionElementInfo = new ExtensionElementInfo();
            this.extensionElementInfoHash.put(namespace, extensionElementInfo);
        }
        return extensionElementInfo;
    }

    private IDefaultActionHandlerAction createDefaultHandlerAction(IConfigurationElement element) {
        try {
            Object object = element.createExecutableExtension("defaultHandlerAction");
            if (object instanceof IDefaultActionHandlerAction) {
                return (IDefaultActionHandlerAction)object;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    private IValueHandler createValueHandler(IConfigurationElement element) {
        try {
            Object object = element.createExecutableExtension("valueHandler");
            if (object instanceof IValueHandler) {
                return (IValueHandler)object;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    private IResourceBundle createResourceBundle(IConfigurationElement element) {
        try {
            Object object = element.createExecutableExtension("resourceBundle");
            if (object instanceof IResourceBundle) {
                return (IResourceBundle)object;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    class BindingElementInfo
    extends ElementInfo {
        private String bindingName;

        public BindingElementInfo(String namespace, String bindingName) {
            super(namespace);
            this.bindingName = bindingName;
        }

        public String getBindingName() {
            return this.bindingName;
        }
    }

    class DefaultElementInfo
    extends ElementInfo {
        public DefaultElementInfo(String namespace) {
            super(namespace);
        }
    }

    class ElementInfo {
        private String namespace;
        private IDefaultActionHandlerAction defaultHandlerAction;
        private IValueHandler valueHandler;
        private IResourceBundle resourceBundle;

        public ElementInfo(String namespace) {
            this.namespace = namespace;
        }

        public void setDefaultHandlerAction(IDefaultActionHandlerAction action) {
            this.defaultHandlerAction = action;
        }

        public IDefaultActionHandlerAction getDefaultHandlerAction() {
            return this.defaultHandlerAction;
        }

        public void setValueHandler(IValueHandler handler) {
            this.valueHandler = handler;
        }

        public IValueHandler getValueHandler() {
            return this.valueHandler;
        }

        public void setResourceBundler(IResourceBundle bundle) {
            this.resourceBundle = bundle;
        }

        public IResourceBundle getResourceBundle() {
            return this.resourceBundle;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }

    class ExtensionElementInfo {
        private DefaultElementInfo defaultElementInfo;
        private List<BindingElementInfo> bindingElementInfos = new ArrayList<BindingElementInfo>();

        public void setDefaultElementInfo(DefaultElementInfo defaultElementInfo) {
            this.defaultElementInfo = defaultElementInfo;
        }

        public DefaultElementInfo getDefaultElementInfo() {
            return this.defaultElementInfo;
        }

        public void addBindingElementInfo(BindingElementInfo bindingElementInfo) {
            this.bindingElementInfos.add(bindingElementInfo);
        }

        public BindingElementInfo getBindingElementInfo(String bindingName) {
            for (BindingElementInfo bindingElementInfo : this.bindingElementInfos) {
                if (!bindingElementInfo.getBindingName().equals(bindingName)) continue;
                return bindingElementInfo;
            }
            return null;
        }
    }
}

