/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.internal.ui.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorInput;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.enterprise.automation.internal.ui.nls.Messages;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class AbstractAutomationConfigurationEditor
extends AbstractConfigurationElementEditor {
    protected IBuildDefinition fBuildDefinitionWorkingCopy;
    protected Button isCompletePackageButton;
    protected FormToolkit toolkit;
    String os;
    protected Hyperlink fBuildDefinitionTitleHyperlink;
    protected Color fEnabledHyperlinkForegroundColor;
    protected Color fDisabledHyperlinkForegroundColor;
    protected IBuildDefinition fBuildDefinition;

    public AbstractAutomationConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    protected abstract String getApplicationNamePropertyName();

    protected abstract String getApplicationDescriptionPropertyName();

    protected abstract String getApplicationVersionPropertyName();

    protected abstract String getIsCompletePackagePropertyName();

    protected abstract void createApplicationPropertySection(Composite var1, FormToolkit var2);

    protected abstract void createPackageProperties(Composite var1, FormToolkit var2);

    protected abstract void createRuntimeProperties(Composite var1, FormToolkit var2);

    protected abstract void createExtensibleContributionSection(Composite var1, FormToolkit var2);

    protected abstract void createPublishProperties(Composite var1, FormToolkit var2);

    protected abstract void createPlatformProperties(Composite var1, FormToolkit var2);

    protected abstract void createBuildDefinitionSelectionSection(Composite var1, FormToolkit var2);

    protected abstract boolean validateProperties();

    protected abstract String getConfigurationId();

    public boolean validate() {
        boolean isValid = true;
        boolean validatePropertiesResult = this.validateProperties();
        this.setPageStatusIndicator(!isValid || !validatePropertiesResult, false);
        return isValid && validatePropertiesResult;
    }

    public void createContent(Composite parent, FormToolkit kit) {
        this.toolkit = kit;
        parent.setLayout((Layout)new TableWrapLayout());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
        this.createApplicationPropertySection(parent, this.toolkit);
        this.createBuildDefinitionSelectionSection(parent, this.toolkit);
        this.createExtensibleContributionSection(parent, this.toolkit);
        this.createCommonPlatformPropertySection(parent, this.toolkit);
        this.createCommonPublishPropertySection(parent, this.toolkit);
    }

    protected void createCommonPublishPropertySection(Composite parent, FormToolkit toolkit) {
        Section fPublishSection = toolkit.createSection(parent, 322);
        fPublishSection.setLayoutData((Object)new TableWrapData(256, 256));
        fPublishSection.setLayout((Layout)new TableWrapLayout());
        fPublishSection.setText(Messages.AbstractAutomationConfigurationEditor_SECTION_PUBLISH);
        Composite fPublishPropertyComposite = toolkit.createComposite((Composite)fPublishSection);
        fPublishPropertyComposite.setLayoutData((Object)new TableWrapData(256, 256));
        fPublishPropertyComposite.setLayout((Layout)this.getTableWrapLayout());
        this.createPublishProperties(fPublishPropertyComposite, toolkit);
        fPublishSection.setClient((Control)fPublishPropertyComposite);
    }

    protected void createCommonPlatformPropertySection(Composite parent, FormToolkit toolkit) {
        Section fPlatformSection = toolkit.createSection(parent, 322);
        fPlatformSection.setLayoutData((Object)new TableWrapData(256, 256));
        fPlatformSection.setLayout((Layout)new TableWrapLayout());
        fPlatformSection.setText(Messages.AbstractAutomationConfigurationEditor_SECTION_PLATFORM);
        Composite fPlatformPropertyComposite = toolkit.createComposite((Composite)fPlatformSection);
        fPlatformPropertyComposite.setLayoutData((Object)new TableWrapData(256, 256));
        fPlatformPropertyComposite.setLayout((Layout)this.getTableWrapLayout());
        this.createPlatformProperties(fPlatformPropertyComposite, toolkit);
        fPlatformSection.setClient((Control)fPlatformPropertyComposite);
    }

    protected TableWrapLayout getTableWrapLayout() {
        TableWrapLayout newLayout = new TableWrapLayout();
        newLayout.numColumns = 2;
        newLayout.horizontalSpacing = 10;
        newLayout.leftMargin = 20;
        return newLayout;
    }

    protected TableWrapLayout getTableWrapLayoutWithoutIndent() {
        TableWrapLayout newLayout = new TableWrapLayout();
        newLayout.numColumns = 2;
        newLayout.horizontalSpacing = 10;
        return newLayout;
    }

    protected void createSpacer(Composite parent, int height, int horizontalSpan, FormToolkit fToolkit) {
        Label label = fToolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    protected Text createLabeledText(Composite parent, String label, String textValue) {
        return this.createLabeledText(parent, label, textValue, null);
    }

    protected Text createLabeledText(Composite parent, String label, String textValue, final String tooltip) {
        final Label l = this.toolkit.createLabel(parent, label);
        final Text text = this.toolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256));
        if (tooltip != null && !tooltip.isEmpty()) {
            new TooltipSupport((Control)l, true, false){

                public Object getElement(Control control, int x, int y) {
                    return l;
                }

                protected String getMarkup(Object element, boolean isFocus) {
                    return tooltip;
                }
            };
            new TooltipSupport((Control)text, true, false){

                public Object getElement(Control control, int x, int y) {
                    return text;
                }

                protected String getMarkup(Object element, boolean isFocus) {
                    return tooltip;
                }
            };
        }
        return text;
    }

    protected Text createLabeledTextInCell(Composite parent, String label, String textValue) {
        this.toolkit.createLabel(parent, label);
        Text text = this.toolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData());
        return text;
    }

    protected ModifyListener getTextModifyListener(String propertyID, Text propertyWidget) {
        return this.getTextModifyListener(propertyID, propertyWidget, false);
    }

    protected ModifyListener getTextModifyListener(final String propertyID, final Text propertyWidget, final boolean forceNotEditable) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractAutomationConfigurationEditor.this.validate();
                AbstractAutomationConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty(propertyID, propertyWidget.getText().trim());
                if (forceNotEditable) {
                    AbstractAutomationConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty(propertyID).setGenericEditAllowed(false);
                }
                AbstractAutomationConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getButtonSelectionListener(final String propertyName, final Button button) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractAutomationConfigurationEditor.this.validate();
                AbstractAutomationConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty(propertyName, Boolean.toString(button.getSelection()));
                AbstractAutomationConfigurationEditor.this.setDirty(true);
            }
        };
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
        this.os = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.team.build.internal.template.id").getValue();
        if (this.isIBMiDeployDef()) {
            this.setPartName(Messages.DEPLOYMENT_TAB_TITLE_IBMiDeployment);
        } else if (this.isIBMiPackageDef()) {
            this.setPartName(Messages.PACKAGING_TAB_TITLE_IBMiPackaging);
        } else if (this.isZosDeployDef()) {
            this.setPartName(Messages.DEPLOYMENT_TAB_TITLE_zOSDeploymet);
        } else if (this.isZosPackageDef()) {
            this.setPartName(Messages.PACKAGING_TAB_TITLE_zOSPackaging);
        } else if (this.isLUWDeployDef()) {
            this.setPartName(Messages.DEPLOYMENT_TAB_TITLE_LUWDeploymet);
        } else if (this.isLUWPackageDef()) {
            this.setPartName(Messages.PACKAGING_TAB_TITLE_LUWPackaging);
        }
    }

    public boolean isIBMiDeployDef() {
        return this.os.equals("com.ibm.team.enterprise.deployment.ibmi") || this.os.equals("com.ibm.team.enterprise.deployment.nonseq.ibmi");
    }

    public boolean isIBMiDeployDefNonSeq() {
        return this.os.equals("com.ibm.team.enterprise.deployment.nonseq.ibmi");
    }

    public boolean isIBMiPackageDef() {
        return this.os.equals("com.ibm.team.enterprise.packaging.ibmi") || this.os.equals("com.ibm.team.enterprise.packaging.nonseq.ibmi");
    }

    public boolean isIBMiPackageDefNonSeq() {
        return this.os.equals("com.ibm.team.enterprise.packaging.nonseq.ibmi");
    }

    public boolean isZosDeployDef() {
        return this.os.equals("com.ibm.team.enterprise.deployment.zos") || this.os.equals("com.ibm.team.enterprise.deployment.nonseq.zos");
    }

    public boolean isZosDeployDefNonSeq() {
        return this.os.equals("com.ibm.team.enterprise.deployment.nonseq.zos");
    }

    public boolean isZosPackageDef() {
        return this.os.equals("com.ibm.team.enterprise.packaging.zos") || this.os.equals("com.ibm.team.enterprise.packaging.nonseq.zos");
    }

    public boolean isZosPackageDefNonSeq() {
        return this.os.equals("com.ibm.team.enterprise.packaging.nonseq.zos");
    }

    public boolean isLUWDeployDef() {
        return this.os.equals("com.ibm.team.enterprise.deployment.luw") || this.os.equals("com.ibm.team.enterprise.deployment.nonseq.luw");
    }

    public boolean isLUWPackageDef() {
        return this.os.equals("com.ibm.team.enterprise.packaging.luw") || this.os.equals("com.ibm.team.enterprise.packaging.nonseq.luw");
    }

    protected void setBuildDefinitionTitleHyperlinkEnablement(boolean enabled) {
        this.fBuildDefinitionTitleHyperlink.setForeground(enabled ? this.fEnabledHyperlinkForegroundColor : this.fDisabledHyperlinkForegroundColor);
        this.fBuildDefinitionTitleHyperlink.setUnderlined(enabled);
        this.fBuildDefinitionTitleHyperlink.setEnabled(enabled);
    }

    protected IHyperlinkListener getBuildDefinitionHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbstractAutomationConfigurationEditor.this.openBuildDefinitionEditor();
            }
        };
    }

    protected void createCompletePackageButton(Composite parent, FormToolkit toolkit, String label) {
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty(this.getIsCompletePackagePropertyName());
        this.isCompletePackageButton = toolkit.createButton(parent, label, 32);
        if (property != null) {
            boolean propertyValue = Boolean.parseBoolean(property.getValue());
            this.isCompletePackageButton.setSelection(propertyValue);
        } else {
            this.isCompletePackageButton.setSelection(true);
        }
        this.isCompletePackageButton.addSelectionListener(this.getButtonSelectionListener(this.getIsCompletePackagePropertyName(), this.isCompletePackageButton));
        TableWrapData buttonData = new TableWrapData(256, 32);
        buttonData.colspan = 2;
        this.isCompletePackageButton.setLayoutData((Object)buttonData);
    }

    protected void openBuildDefinitionEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                ITeamRepository repository = (ITeamRepository)this.fBuildDefinition.getOrigin();
                IProcessArea processArea = (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)this.fBuildDefinition.getProcessArea(), 0, (IProgressMonitor)new NullProgressMonitor());
                BuildDefinitionEditorInput input = new BuildDefinitionEditorInput(this.fBuildDefinition, processArea, (ITeamRepository)this.fBuildDefinition.getOrigin(), false);
                page.openEditor((IEditorInput)input, "com.ibm.team.build.ui.editors.buildDefinitionEditor");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected IBuildDefinition fetchBuildDefinition(IBuildDefinitionHandle buildDefinitionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IBuildDefinition)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildDefinitionHandle, 0, monitor);
    }

    protected String getContextHelpId() {
        if (this.os.equals("com.ibm.team.enterprise.deployment.ibmi")) {
            return "com.ibm.team.build.ui.editor_deploymentdefinitionibmi";
        }
        if (this.isIBMiDeployDefNonSeq()) {
            return "com.ibm.team.build.ui.editor_deploymentdefinitionibmi_nonseq";
        }
        if (this.os.equals("com.ibm.team.enterprise.packaging.ibmi")) {
            return "com.ibm.team.build.ui.editor_packagedefinitionibmi";
        }
        if (this.isIBMiPackageDefNonSeq()) {
            return "com.ibm.team.build.ui.editor_packagedefinitionibmi_nonseq";
        }
        if (this.os.equals("com.ibm.team.enterprise.deployment.zos")) {
            return "com.ibm.team.build.ui.editor_deploymentdefinitionzos";
        }
        if (this.isZosDeployDefNonSeq()) {
            return "com.ibm.team.build.ui.editor_deploymentdefinitionzos_nonseq";
        }
        if (this.os.equals("com.ibm.team.enterprise.packaging.zos")) {
            return "com.ibm.team.build.ui.editor_packagedefinitionzos";
        }
        if (this.isZosPackageDefNonSeq()) {
            return "com.ibm.team.build.ui.editor_packagedefinitionzos_nonseq";
        }
        if (this.isLUWDeployDef()) {
            return "com.ibm.team.build.ui.editor_deploymentdefinitionluw";
        }
        if (this.isLUWPackageDef()) {
            return "com.ibm.team.build.ui.editor_packagedefinitionluw";
        }
        return super.getContextHelpId();
    }

    public CTabItem getOptionsTab() {
        return null;
    }

    public CTabFolder getTabFolder() {
        return null;
    }
}

