/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.internal.ui.actions;

import com.ibm.team.build.internal.common.helper.ItemHelper;
import com.ibm.team.enterprise.automation.internal.ui.actions.Messages;
import com.ibm.team.enterprise.automation.ui.AutomationUIPlugin;
import com.ibm.team.enterprise.common.ui.util.Utils;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.internal.links.LinksPackage;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IHelperType;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.Workspace;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.rcp.ui.internal.ConnectedProjectAreas;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class AssociateWorkItemAction
extends AbstractActionDelegate {
    private boolean isFileItem = false;
    private boolean fRepositoryMismatch = false;
    private boolean fWorkspaceMismatch = false;
    private ITeamRepository fTeamRepository = null;
    private IWorkspaceHandle fWorkspaceHandle = null;
    private Set<IShareable> fFiles = null;
    private Set<IFileItem> fFileItems = null;
    private Map<String, IComponentHandle> fFileUUIDComponentMap = new HashMap<String, IComponentHandle>();
    private Map<String, IComponentHandle> fUUIDComponentMap = new HashMap<String, IComponentHandle>();

    public void run(final Shell shell, IWorkbenchPage page, final IStructuredSelection selection) {
        Job job = new Job(Messages.AssociateWorkItemAction_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                AssociateWorkItemAction.this.init();
                if (selection.getFirstElement() instanceof IAdaptable) {
                    AssociateWorkItemAction.this.isFileItem = false;
                } else {
                    AssociateWorkItemAction.this.isFileItem = true;
                }
                AssociateWorkItemAction.this.associateFromLocalSharedFiles(shell, selection);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void init() {
        this.fFileUUIDComponentMap.clear();
        this.fUUIDComponentMap.clear();
        if (this.fFileItems != null) {
            this.fFileItems.clear();
        }
        if (this.fFiles != null) {
            this.fFiles.clear();
        }
        this.fRepositoryMismatch = false;
        this.fWorkspaceMismatch = false;
        this.fTeamRepository = null;
        this.fWorkspaceHandle = null;
        this.isFileItem = false;
    }

    private IProjectAreaHandle getProjectAreaHandle(IWorkspaceConnection streamConnection, final UIContext context, final ITeamRepository server, SubMonitor progress) throws TeamRepositoryException {
        IProjectAreaHandle defaultProject;
        IProjectAreaHandle projectAreaHandle = null;
        IProcessAreaHandle processAreaHandle = streamConnection.getProcessArea((IProgressMonitor)progress.newChild(30));
        if (processAreaHandle != null) {
            IProcessArea area = (IProcessArea)streamConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, (IProgressMonitor)progress.newChild(30));
            projectAreaHandle = area.getProjectArea();
        }
        if ((UiPlugin.getBooleanPreference((String)"com.ibm.team.filesystem.ide.ui.prefs_use_currentproject_workitem_prompts") || projectAreaHandle == null) && (defaultProject = ConnectedProjectAreas.getInstance().getDefaultProjectAreaFallback(server, true)) != null) {
            projectAreaHandle = defaultProject;
        }
        if (projectAreaHandle == null) {
            List connectedProjectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(server);
            if (connectedProjectAreas.size() == 0) {
                context.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AssociateWorkItemAction.this.showMessage(context.getShell(), 4, Messages.ASSOCIATE_WORK_ITEM_ERROR, NLS.bind((String)Messages.ASSOCIATE_WORK_ITEM_NO_PROJECT_AREAS, (Object)AssociateWorkItemAction.getRepositoryLabel(server)));
                    }
                });
                return null;
            }
            projectAreaHandle = (IProjectAreaHandle)connectedProjectAreas.get(0);
        }
        return projectAreaHandle;
    }

    private void associateFromLocalSharedFiles(Shell shell, IStructuredSelection selection) {
        try {
            this.extractSelectedBuildableFiles(selection);
        }
        catch (TeamRepositoryException e) {
            AutomationUIPlugin.log(e);
            this.showMessage(shell, 4, Messages.ASSOCIATE_WORK_ITEM_ERROR, NLS.bind((String)Messages.ASSOCIATE_WORK_ITEM_ERROR_PROCESSING_FILES_0, (Object)e.getLocalizedMessage()));
            return;
        }
        catch (Exception e) {
            AutomationUIPlugin.log(e);
            this.showMessage(shell, 4, Messages.ASSOCIATE_WORK_ITEM_ERROR, Messages.ASSOCIATE_WORK_ITEM_ERROR_PROCESSING_FILES_1);
            return;
        }
        if (this.fRepositoryMismatch) {
            this.showMessage(shell, 4, Messages.ASSOCIATE_WORK_ITEM_MULTIPLE_REPOSITORIES_TITLE, Messages.ASSOCIATE_WORK_ITEM_MULTIPLE_REPOSITORIES_MSG);
        } else if (this.fTeamRepository == null) {
            this.showMessage(shell, 4, Messages.ASSOCIATE_WORK_ITEM_NO_REPOSITORY_TITLE, Messages.ASSOCIATE_WORK_ITEM_NO_REPOSITORY_MSG);
        } else if (this.fWorkspaceMismatch) {
            this.showMessage(shell, 4, Messages.ASSOCIATE_WORK_ITEM_MULTIPLE_WORKSPACES_TITLE, Messages.ASSOCIATE_WORK_ITEM_MULTIPLE_WORKSPACES_MSG);
        } else if (this.fWorkspaceHandle == null) {
            this.showMessage(shell, 4, Messages.ASSOCIATE_WORK_ITEM_NO_WORKSPACE_TITLE, Messages.ASSOCIATE_WORK_ITEM_NO_WORKSPACE_MSG);
        } else if (!this.isFileItem && (this.fFiles == null || this.fFiles.size() == 0) || this.isFileItem && (this.fFileItems == null || this.fFileItems.size() == 0)) {
            this.showMessage(shell, 4, Messages.ASSOCIATE_WORK_ITEM_NO_BUILDABLE_FILES_TITLE, Messages.ASSOCIATE_WORK_ITEM_NO_BUILDABLE_FILES_MSG);
        } else {
            final UIContext context = this.getContext();
            final IWorkspaceHandle workspaceHandle = this.fWorkspaceHandle;
            final ITeamRepository server = this.fTeamRepository;
            context.getUserOperationRunner().enqueue(Messages.ASSOCIATE_WORK_ITEM_FETCHING_WS, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    IProjectAreaHandle projectAreaHandle = null;
                    IWorkspace workspace = (IWorkspace)server.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, (IProgressMonitor)progress);
                    IWorkspace stream = AssociateWorkItemAction.getWorkspaceStream(workspace, server);
                    final IWorkspaceConnection streamConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)server).getWorkspaceConnection((IWorkspaceHandle)stream, (IProgressMonitor)progress.newChild(10));
                    if (!AssociateWorkItemAction.this.isFileItem) {
                        if (AssociateWorkItemAction.this.fFileItems == null) {
                            AssociateWorkItemAction.this.fFileItems = new HashSet();
                        }
                        for (final IShareable file : AssociateWorkItemAction.this.fFiles) {
                            IVersionableHandle fileItemHandle = file.getRemote((IProgressMonitor)progress.newChild(5));
                            if (fileItemHandle == null) continue;
                            IComponentHandle componentHandle = AssociateWorkItemAction.this.getComponentHandle(file);
                            IFileItem fileItem = null;
                            IConfiguration configuration = streamConnection.configuration(componentHandle);
                            try {
                                fileItem = (IFileItem)configuration.fetchCompleteItem(fileItemHandle, (IProgressMonitor)progress.newChild(20));
                            }
                            catch (ItemNotFoundException e) {
                                context.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        AssociateWorkItemAction.this.showMessage(context.getShell(), 4, Messages.ASSOCIATE_WORK_ITEM_BUILDABLE_FILE_NOT_IN_STREAM, NLS.bind((String)Messages.ASSOCIATE_WORK_ITEM_BUILDABLE_FILE_NOT_IN_STREAM_MSG, (Object)file.getFullPath().getName()));
                                    }
                                });
                                return;
                            }
                            if (fileItem == null) continue;
                            String fileItemId = fileItem.getItemId().getUuidValue();
                            AssociateWorkItemAction.this.fFileUUIDComponentMap.put(fileItemId, componentHandle);
                            AssociateWorkItemAction.this.fFileItems.add(fileItem);
                        }
                    }
                    if ((projectAreaHandle = AssociateWorkItemAction.this.getProjectAreaHandle(streamConnection, context, server, progress)) == null) {
                        return;
                    }
                    final IProjectArea finalProjectArea = (IProjectArea)server.itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, null);
                    context.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            final IWorkItemHandle workItemHandle = AssociateWorkItemAction.openWorkItemPicker(context.getShell(), context.getPage(), server, (IProjectAreaHandle)finalProjectArea);
                            if (workItemHandle != null) {
                                context.getUserOperationRunner().enqueue(Messages.ASSOCIATE_WORK_ITEM_ADDING_WI, (Operation)new RepositoryOperation(){

                                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                                        if (AssociateWorkItemAction.this.fFileItems != null) {
                                            for (IFileItem file : AssociateWorkItemAction.this.fFileItems) {
                                                IComponentHandle componentHandle = (IComponentHandle)AssociateWorkItemAction.this.fFileUUIDComponentMap.get(file.getItemId().getUuidValue());
                                                AssociateWorkItemAction.this.createLink(server, workItemHandle, file, componentHandle, streamConnection, finalProjectArea, monitor);
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            });
        }
    }

    private void showMessage(final Shell shell, final int severity, final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialogFactory.showMessage((Shell)shell, (int)severity, (String)title, (String)message);
            }
        });
    }

    private void createLink(ITeamRepository teamRepository, IWorkItemHandle workItemHandle, IFileItem fileItem, IComponentHandle componentHandle, IWorkspaceConnection stream, IProjectArea projectArea, IProgressMonitor progress) throws TeamRepositoryException {
        URI uri = this.getURI(componentHandle, (IWorkspaceHandle)stream.getResolvedWorkspace(), teamRepository, fileItem.getItemId(), projectArea);
        IHelperType helperType = IHelperType.IRegistry.INSTANCE.getHelperType(LinksPackage.eINSTANCE.getReference().getName(), "com.ibm.team.links");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 2);
        String sourceComment = ItemHelper.validateStringAttributeLength((String)(String.valueOf(fileItem.getName()) + " -- " + NLS.bind((String)Messages.ASSOCIATE_WORK_ITEM_COMMENT_LABEL, (Object)dateFormat.format(new Date(System.currentTimeMillis())))), (IType)helperType, (String)LinksPackage.eINSTANCE.getReference_Comment().getName());
        LinkVersionableURIToWorkItemOperation operation = new LinkVersionableURIToWorkItemOperation(uri, sourceComment);
        operation.run(workItemHandle, progress);
    }

    private String getRemoteFullPath(IVersionableHandle v, IComponentHandle c, IWorkspaceConnection stream, IProgressMonitor monitor) throws FileSystemException {
        String remotePath = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IConfiguration configuration = stream.configuration(c);
            IAncestorReport ancestors = (IAncestorReport)configuration.locateAncestors(Collections.singletonList(v), (IProgressMonitor)progress.newChild(90)).get(0);
            if (!ancestors.getNameItemPairs().isEmpty()) {
                StringBuilder builder = new StringBuilder();
                Iterator iterator = ancestors.getNameItemPairs().iterator();
                iterator.next();
                while (iterator.hasNext()) {
                    INameItemPair nameItemPair = (INameItemPair)iterator.next();
                    builder.append('/');
                    builder.append(nameItemPair.getName());
                }
                remotePath = builder.length() == 0 ? "/" : builder.toString();
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        return remotePath;
    }

    private URI getURI(IComponentHandle component, IWorkspaceHandle streamHandle, ITeamRepository repo, UUID fileUUID, IProjectArea projectArea) throws TeamRepositoryException {
        if (fileUUID == null) {
            return null;
        }
        String repoURI = Repositories.getPublicURI((ITeamRepository)repo);
        try {
            String projectName = URLEncoder.encode(projectArea.getName(), "UTF-8");
            return new URI(String.valueOf(repoURI) + "/web/projects/" + projectName + "#action=com.ibm.team.scm.browseElement&workspaceItemId=" + streamHandle.getItemId().getUuidValue() + "&componentItemId=" + component.getItemId().getUuidValue() + "&itemType=com.ibm.team.filesystem.FileItem&itemId=" + fileUUID.getUuidValue());
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private void extractSelectedBuildableFiles(IStructuredSelection selection) throws CoreException, IllegalArgumentException, TeamRepositoryException, IOException {
        this.fTeamRepository = null;
        this.fWorkspaceHandle = null;
        this.fRepositoryMismatch = false;
        this.fWorkspaceMismatch = false;
        List selectionList = selection.toList();
        for (Object obj : selectionList) {
            IShareable shareable = null;
            ITeamRepository repo = null;
            String repositoryId = null;
            IWorkspaceHandle workspace = null;
            IFileItemHandle fileItemHandle = null;
            String fileItemId = null;
            String componentId = null;
            if (obj instanceof IAdaptable) {
                shareable = Utils.getSharable((IAdaptable)((IAdaptable)obj));
                if (shareable == null || shareable.getShare(null) == null) continue;
                repositoryId = this.getTeamRepositoryID(shareable);
                workspace = this.getWorkspaceHandle(shareable);
            } else if (obj instanceof SelectResult) {
                List bindings = ((SelectResult)obj).getBindings();
                String streamId = null;
                for (Binding b : bindings) {
                    if (b.getName().equals("repositoryId")) {
                        repositoryId = b.getValue();
                        continue;
                    }
                    if (b.getName().equals("fileItemId")) {
                        fileItemId = b.getValue();
                        continue;
                    }
                    if (b.getName().equals("streamId")) {
                        streamId = b.getValue();
                        continue;
                    }
                    if (!b.getName().equals("componentId")) continue;
                    componentId = b.getValue();
                }
                if (streamId != null) {
                    workspace = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf(streamId), null);
                }
            }
            repo = this.getTeamRepositoryByID(repositoryId);
            if (repo == null) continue;
            if (this.fTeamRepository == null) {
                this.fTeamRepository = repo;
            } else if (!repo.getId().equals((Object)this.fTeamRepository.getId())) {
                this.fRepositoryMismatch = true;
                return;
            }
            if (workspace == null) continue;
            if (this.fWorkspaceHandle == null) {
                this.fWorkspaceHandle = workspace;
            } else if (!workspace.sameItemId((IItemHandle)this.fWorkspaceHandle)) {
                this.fWorkspaceMismatch = true;
                return;
            }
            if (obj instanceof IAdaptable) {
                if (!this.isBuildableFile(shareable, shareable.getLocalPath().toString(), repo)) continue;
                if (this.fFiles == null) {
                    this.fFiles = new HashSet<IShareable>(selection.size());
                }
                this.fFiles.add(shareable);
                continue;
            }
            if (fileItemId == null || !(obj instanceof SelectResult)) continue;
            fileItemHandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)fileItemId), null);
            if (componentId == null) continue;
            IComponentHandle componentHandle = this.fUUIDComponentMap.get(componentId);
            if (componentHandle == null) {
                componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)componentId), null);
                this.fUUIDComponentMap.put(componentId, componentHandle);
            }
            this.fFileUUIDComponentMap.put(fileItemId, componentHandle);
            IWorkspaceConnection streamConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(workspace, null);
            IConfiguration configuration = streamConnection.configuration(componentHandle);
            IFileItem fileItem = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)fileItemHandle, null);
            if (!this.isBuildableFile((IVersionable)fileItem, repo)) continue;
            if (this.fFileItems == null) {
                this.fFileItems = new HashSet<IFileItem>(selection.size());
            }
            if (fileItem == null) continue;
            this.fFileItems.add(fileItem);
        }
    }

    private String getTeamRepositoryID(IShareable shareable) {
        String result = null;
        if (shareable == null) {
            return result;
        }
        IShare share = null;
        try {
            share = shareable.getShare((IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        if (share == null) {
            return result;
        }
        ISharingDescriptor descriptor = share.getSharingDescriptor();
        UUID id = descriptor == null ? null : descriptor.getRepositoryId();
        result = id == null ? null : id.getUuidValue();
        return result;
    }

    private ITeamRepository getTeamRepositoryByID(String id) {
        ITeamRepository result = null;
        if (id == null) {
            return result;
        }
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        if (repos != null && repos.length > 0) {
            ITeamRepository[] iTeamRepositoryArray = repos;
            int n = repos.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository repo = iTeamRepositoryArray[n2];
                UUID tempID = repo.getId();
                if (tempID != null && id.equals(tempID.getUuidValue())) {
                    result = repo;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    private IWorkspaceHandle getWorkspaceHandle(IShareable share) throws FileSystemException {
        IShare s = share.getShare((IProgressMonitor)new NullProgressMonitor());
        ISharingDescriptor desc = s.getSharingDescriptor();
        IContextHandle workspaceHandle = desc == null ? null : desc.getConnectionHandle();
        return (IWorkspaceHandle)workspaceHandle;
    }

    private IComponentHandle getComponentHandle(IShareable share) throws FileSystemException {
        IShare s = share.getShare((IProgressMonitor)new NullProgressMonitor());
        ISharingDescriptor desc = s.getSharingDescriptor();
        return desc == null ? null : desc.getComponent();
    }

    public static IWorkspace getWorkspaceStream(IWorkspace workspace, ITeamRepository repo) throws TeamRepositoryException {
        IWorkspace flowTarget;
        IWorkspaceHandle flowTargetHandle;
        UUID defaultFlow;
        if (workspace.isStream()) {
            return workspace;
        }
        IWorkspace stream = null;
        Workspace ws = (Workspace)workspace;
        CurrentFlows flows = ws.getCurrentFlows();
        if (flows != null && (defaultFlow = flows.getDefaultAcceptFlow()) != null && (flowTargetHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(defaultFlow, null)) != null && (flowTarget = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)flowTargetHandle, 0, (IProgressMonitor)new NullProgressMonitor())).isStream()) {
            stream = flowTarget;
        }
        return stream;
    }

    public static IWorkItemHandle openWorkItemPicker(Shell parent, IWorkbenchPage page, ITeamRepository server, IProjectAreaHandle projectAreaHandle) {
        WorkItemSelectionDialog dialog = null;
        dialog = projectAreaHandle == null ? new WorkItemSelectionDialog(parent, server, false) : new WorkItemSelectionDialog(parent, projectAreaHandle, false);
        dialog.setTitle(Messages.ASSOCIATE_WORK_ITEM_TO_BUILDABLE_FILES_TITLE);
        if (dialog.open() == 0) {
            return (IWorkItemHandle)dialog.getResult()[0];
        }
        return null;
    }

    public static String getRepositoryLabel(ITeamRepository repo) {
        String label = repo.getName();
        if (label == null || label.equals("")) {
            label = repo.getRepositoryURI();
        }
        return label;
    }

    private boolean isBuildableFile(IShareable shareable, String fileName, ITeamRepository repo) throws IllegalArgumentException, TeamRepositoryException, IOException {
        IMetadataProperties metadataProperties = shareable.getMetadataProperties(null);
        String langDefUUID = (String)metadataProperties.getCurrentProperties().get("team.enterprise.language.definition");
        String extension = "";
        if (fileName.indexOf(46) >= 0) {
            extension = fileName.substring(fileName.indexOf(46) + 1);
        }
        return this.isBuildableFileWork(langDefUUID, extension, repo);
    }

    private boolean isBuildableFile(IVersionable v, ITeamRepository repo) throws IllegalArgumentException, TeamRepositoryException, IOException {
        String langDefUUID = (String)v.getUserProperties().get("team.enterprise.language.definition");
        return this.isBuildableFileWork(langDefUUID, v.getName(), repo);
    }

    private boolean isBuildableFileWork(String langDefUUID, String fileName, ITeamRepository repo) throws TeamRepositoryException, IOException {
        ILanguageDefinition ld = null;
        ISystemDefinitionModelClient sysDefClient = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)repo);
        if (langDefUUID == null || langDefUUID.trim().equals("")) {
            if (!fileName.equals("")) {
                ld = sysDefClient.getDefaultLanguageDefinition(fileName, null);
            }
        } else {
            ld = (ILanguageDefinition)sysDefClient.findSystemDefinition(langDefUUID, null, ILanguageDefinition.ITEM_TYPE, (IProgressMonitor)new NullProgressMonitor());
        }
        if (ld == null) {
            return false;
        }
        return ld.getTranslators() != null && ld.getTranslators().size() > 0;
    }

    private static class LinkVersionableURIToWorkItemOperation
    extends WorkItemOperation {
        private URI fVersionableURI;
        private String fVersionableComment;

        public LinkVersionableURIToWorkItemOperation(URI versionableURI, String versionableComment) {
            super(Messages.ASSOCIATE_WORK_ITEM_LINK_OPERATION, IWorkItem.FULL_PROFILE);
            this.fVersionableURI = versionableURI;
            this.fVersionableComment = versionableComment;
        }

        protected void execute(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
            boolean alreadyAdded = false;
            List artifactLinks = workingCopy.getReferences().getReferences(WorkItemEndPoints.RELATED_ARTIFACT);
            for (IReference artifactLink : artifactLinks) {
                URI artifactURI = artifactLink.createURI();
                if (this.fVersionableURI == null || !this.fVersionableURI.equals(artifactURI)) continue;
                alreadyAdded = true;
                break;
            }
            if (!alreadyAdded) {
                IURIReference reference = IReferenceFactory.INSTANCE.createReferenceFromURI(this.fVersionableURI, this.fVersionableComment);
                workingCopy.getReferences().add(WorkItemEndPoints.RELATED_ARTIFACT, (IReference)reference);
            }
        }
    }
}

