/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.toolkit;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.workitem.WorkItemHelper;
import com.ibm.team.build.internal.common.helper.ItemHelper;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.ILinkFactory;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.links.internal.links.LinksPackage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IHelperType;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import java.util.ArrayList;
import java.util.List;

public class WorkItemAutomationPublisher {
    Boolean isDeployment;

    public void publish(IBuildResultHandle buildResult, Object[] workItemUUIDs, ITeamRepository teamRepository, boolean isDeployment) throws TeamRepositoryException {
        this.isDeployment = isDeployment;
        IWorkItemHandle[] workItemHandles = this.getWorkItemHandles(workItemUUIDs);
        this.publish(buildResult, workItemHandles, teamRepository);
    }

    public void publish(IBuildResultHandle buildResult, IWorkItemHandle[] workItemHandles, ITeamRepository teamRepository) throws TeamRepositoryException {
        IBuildResult result = WorkItemHelper.setFixedInBuild((ITeamRepository)teamRepository, (IBuildResultHandle)buildResult, (IWorkItemHandle[])workItemHandles);
        this.tagWorkItems(workItemHandles, result, teamRepository);
    }

    private IWorkItemHandle[] getWorkItemHandles(Object[] workItemUUIDs) throws TeamRepositoryException {
        ArrayList<IWorkItemHandle> workItemHandles = new ArrayList<IWorkItemHandle>();
        int i = 0;
        while (i < workItemUUIDs.length) {
            workItemHandles.add((IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workItemUUIDs[i].toString()), null));
            ++i;
        }
        return workItemHandles.toArray(new IWorkItemHandle[workItemHandles.size()]);
    }

    protected boolean isLinkTypeRegistered() {
        return ILinkTypeRegistry.INSTANCE.isRegistered("com.ibm.team.filesystem.workitems.change_set");
    }

    private void tagWorkItems(IWorkItemHandle[] workItemHandles, IBuildResult buildResult, ITeamRepository teamRepository) throws TeamRepositoryException {
        ILinkManager linkManager = (ILinkManager)teamRepository.getClientLibrary(ILinkManager.class);
        ArrayList<IWorkItemHandle> workItemHandlesList = new ArrayList<IWorkItemHandle>();
        int i = 0;
        while (i < workItemHandles.length) {
            workItemHandlesList.add(workItemHandles[i]);
            ++i;
        }
        ArrayList<ILink> links = new ArrayList<ILink>();
        List workItems = teamRepository.itemManager().fetchCompleteItems(workItemHandlesList, 1, null);
        int i2 = 0;
        while (i2 < workItemHandlesList.size()) {
            IWorkItemHandle workItemHandle = (IWorkItemHandle)workItemHandlesList.get(i2);
            IWorkItem workItem = (IWorkItem)workItems.get(i2);
            links.add(this.createLink(teamRepository, workItemHandle, workItem, buildResult));
            ++i2;
        }
        linkManager.saveLinks(links, null);
    }

    private ILink createLink(ITeamRepository teamRepository, IWorkItemHandle workItemHandle, IWorkItem workItem, IBuildResult result) throws TeamRepositoryException {
        IItemReference target;
        IBuildDefinition definition = (IBuildDefinition)teamRepository.itemManager().fetchCompleteItem((IItemHandle)result.getBuildDefinition(), 0, null);
        IHelperType helperType = IHelperType.IRegistry.INSTANCE.getHelperType(LinksPackage.eINSTANCE.getReference().getName(), "com.ibm.team.links");
        String sourceComment = ItemHelper.validateStringAttributeLength((String)(String.valueOf(definition.getId()) + " " + result.getLabel()), (IType)helperType, (String)LinksPackage.eINSTANCE.getReference_Comment().getName());
        IItemReference source = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)result, sourceComment);
        if (workItem == null) {
            target = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)workItemHandle);
        } else {
            String targetComment = ItemHelper.validateStringAttributeLength((String)WorkItemTextUtilities.getWorkItemText((IWorkItem)workItem), (IType)helperType, (String)LinksPackage.eINSTANCE.getReference_Comment().getName());
            target = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)workItemHandle, targetComment);
        }
        if (this.isDeployment.booleanValue()) {
            return ILinkFactory.INSTANCE.createLink("com.ibm.team.build.linktype.includedDeployments", (IReference)source, (IReference)target);
        }
        return ILinkFactory.INSTANCE.createLink("com.ibm.team.build.linktype.includedPackages", (IReference)source, (IReference)target);
    }
}

