/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.taskdefs;

import com.ibm.team.enterprise.automation.taskdefs.Messages;
import com.ibm.team.enterprise.automation.toolkit.ValidateManifest;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class ValidateManifestTask
extends Task {
    protected String baseDir;
    protected String filePath;
    protected String schemaXSDPath;

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void execute() throws BuildException {
        if (this.filePath == null || this.filePath.length() == 0) {
            this.filePath = this.getProject().getProperty("manifest");
        }
        File manifestFile = new File(this.filePath);
        if (this.schemaXSDPath == null || this.schemaXSDPath.length() == 0) {
            this.schemaXSDPath = this.getProject().getProperty("schema");
        }
        File schemaFile = new File(this.schemaXSDPath);
        if (!manifestFile.exists() || !schemaFile.exists()) {
            throw new BuildException(Messages.ValidateManifestTask_MANIFEST_OR_SCHEMA_NOTFOUND);
        }
        try {
            new ValidateManifest(this.filePath, this.schemaXSDPath);
        }
        catch (Exception e) {
            throw new BuildException(NLS.bind((String)Messages.ValidateManifestTask_SHIPLIST_VALIDATION_ERROR, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public void setSchemaPath(String schema) {
        this.schemaXSDPath = schema;
    }

    public void setManifestPath(String manifest) {
        this.filePath = manifest;
    }

    private boolean isDefinitionVersionGreaterThan30(Project project) {
        if (project.getProperty("com.team.deploy.definition.version") != null) {
            return project.getProperty("com.team.deploy.definition.version").compareTo("3.0.0") > 0;
        }
        return false;
    }
}

