/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.taskdefs;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.enterprise.automation.taskdefs.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractRequestBuildTask
extends AbstractTeamBuildTask {
    public static final String BUILD_DEFINITION_ID = "buildDefinitionId";
    public static final String BUILD_REQUEST_UUID_PROPERTY = "requestUUIDProperty";
    public static final String BUILD_RESULT_UUID_PROPERTY = "resultUUIDProperty";
    public static final String BUILD_OVERRIDE_PROPERTIES_FILE_PROPERTY = "overridePropertiesFile";
    public static final String BUILD_DELETE_PROPERTIES_FILE_PROPERTY = "deletePropertiesFile";
    public static final String BUILD_REQUEST_ALLOW_DUPLICATE_REQUESTS = "allowDuplicateRequests";
    public static final String BUILD_REQUEST_PERSONAL_BUILD = "personalBuild";
    private String fBuildDefinitionId = null;
    private String fRequestUUIDProperty = null;
    private String fResultUUIDProperty = null;
    private File fOverrideProperties = null;
    private File fDeleteProperties = null;
    private boolean fPersonalBuild = false;
    private boolean fAllowDuplicateRequests = true;
    private String fResultUUIDValue = null;
    protected static final String BUILD_RESULT_PARTIAL_URI = "/itemOid/com.ibm.team.build.BuildResult/";

    protected void collectAntAttributes(List antAttributes) {
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_DEFINITION_ID, this.fBuildDefinitionId, true));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_REQUEST_UUID_PROPERTY, this.fRequestUUIDProperty, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_RESULT_UUID_PROPERTY, this.fResultUUIDProperty, false));
        antAttributes.add(new AbstractTeamBuildTask.FileAntAttribute(BUILD_OVERRIDE_PROPERTIES_FILE_PROPERTY, this.fOverrideProperties, false, false));
        antAttributes.add(new AbstractTeamBuildTask.FileAntAttribute(BUILD_DELETE_PROPERTIES_FILE_PROPERTY, this.fDeleteProperties, false, false));
        antAttributes.add(new AbstractTeamBuildTask.BooleanAntAttribute(BUILD_REQUEST_ALLOW_DUPLICATE_REQUESTS, this.fAllowDuplicateRequests, false));
        antAttributes.add(new AbstractTeamBuildTask.BooleanAntAttribute(BUILD_REQUEST_PERSONAL_BUILD, this.fPersonalBuild, false));
    }

    protected void doExecute() throws Exception {
        IBuildDefinition buildDefinition = this.getBuildDefinition(this.fBuildDefinitionId);
        IBuildRequest buildRequest = this.getTeamBuildRequestClient().requestBuild((IBuildDefinitionHandle)buildDefinition, this.getAllProperties(this.fOverrideProperties), this.getProperties(this.fDeleteProperties), this.fAllowDuplicateRequests, this.fPersonalBuild, this.getProgressMonitor());
        if (buildRequest != null) {
            this.setRequestUUIDProperty(buildRequest, this.fRequestUUIDProperty);
            this.setResultUUIDProperty(buildRequest, this.fResultUUIDProperty);
            if (this.isVerbose()) {
                this.log(NLS.bind((String)AntMessages.RequestBuildTask_SUCCESSFULLY_REQUEST_BUILD, (Object)this.fBuildDefinitionId));
            }
            this.log(NLS.bind((String)Messages.AbstractRequestRequestBuildTask_BUILD_RESULT_LOCATION, (Object)this.buildResultURI(buildRequest)));
        } else {
            String message = NLS.bind((String)AntMessages.RequestBuildTask_UNABLE_TO_REQUEST_BUILD, (Object)this.fBuildDefinitionId);
            if (this.shouldFailOnError()) {
                throw new BuildException(message);
            }
            this.log(message, 1);
        }
    }

    protected IBuildProperty[] getAllProperties(File propertiesFile) throws Exception {
        IBuildProperty[] buildProperties = null;
        Properties fileProperties = this.getFileProperties(propertiesFile);
        HashMap<String, String> extendedProperties = this.getExtendedProperties();
        int size = fileProperties.size() + extendedProperties.size();
        if (size > 0) {
            buildProperties = new IBuildProperty[size];
            Enumeration<Object> keys = fileProperties.keys();
            int i = 0;
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                buildProperties[i] = BuildItemFactory.createBuildProperty();
                buildProperties[i].setName(key);
                buildProperties[i].setValue(fileProperties.getProperty(key));
                ++i;
            }
            for (String key : extendedProperties.keySet()) {
                buildProperties[i] = BuildItemFactory.createBuildProperty();
                buildProperties[i].setName(key);
                buildProperties[i].setValue(extendedProperties.get(key));
                ++i;
            }
        }
        return buildProperties;
    }

    protected abstract HashMap<String, String> getExtendedProperties() throws Exception;

    protected String buildResultURI(IBuildRequest buildRequest) {
        String buildResultURI = null;
        buildResultURI = new String(String.valueOf(this.getRepositoryAddress()) + BUILD_RESULT_PARTIAL_URI + this.getResultUUIDValue(buildRequest));
        return buildResultURI;
    }

    protected IBuildProperty[] getProperties(File propertiesFile) throws IOException {
        IBuildProperty[] buildProperties = null;
        if (propertiesFile != null) {
            Properties properties = new Properties();
            FileInputStream inputStream = new FileInputStream(propertiesFile);
            try {
                properties.load(inputStream);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (properties.size() > 0) {
                buildProperties = new IBuildProperty[properties.size()];
                Enumeration<Object> keys = properties.keys();
                int i = 0;
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    buildProperties[i] = BuildItemFactory.createBuildProperty();
                    buildProperties[i].setName(key);
                    buildProperties[i].setValue(properties.getProperty(key));
                    ++i;
                }
            }
        }
        return buildProperties;
    }

    protected Properties getFileProperties(File propertiesFile) throws IOException {
        Properties properties = new Properties();
        if (propertiesFile != null) {
            FileInputStream inputStream = new FileInputStream(propertiesFile);
            try {
                properties.load(inputStream);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    protected IBuildDefinition getBuildDefinition(String buildDefinitionId) throws TeamRepositoryException, BuildException {
        IBuildDefinition buildDefinition = this.getTeamBuildClient().getBuildDefinition(buildDefinitionId, this.getProgressMonitor());
        if (buildDefinition == null) {
            throw new BuildException(NLS.bind((String)AntMessages._ITEM_WITH_ID_NOT_FOUND, (Object)BUILD_DEFINITION_ID, (Object)buildDefinitionId));
        }
        return buildDefinition;
    }

    private void setRequestUUIDProperty(IBuildRequest buildRequest, String antProperty) {
        if (antProperty != null) {
            this.getProject().setProperty(antProperty, buildRequest.getItemId().getUuidValue());
        }
    }

    private void setResultUUIDProperty(IBuildRequest buildRequest, String antProperty) {
        String resultUUID = this.getResultUUIDValue(buildRequest);
        if (antProperty != null) {
            this.getProject().setProperty(antProperty, resultUUID);
        }
    }

    protected String getResultUUIDValue(IBuildRequest buildRequest) {
        if (this.fResultUUIDValue == null) {
            this.fResultUUIDValue = new String(buildRequest.getBuildResult().getItemId().getUuidValue());
        }
        return this.fResultUUIDValue;
    }

    public void setBuildDefinitionId(String buildDefinitionId) {
        this.fBuildDefinitionId = buildDefinitionId;
    }

    public String getBuildDefinitionId() {
        return this.fBuildDefinitionId;
    }

    public void setRequestUUIDProperty(String requestUUIDProperty) {
        this.fRequestUUIDProperty = requestUUIDProperty;
    }

    public void setResultUUIDProperty(String resultUUIDProperty) {
        this.fResultUUIDProperty = resultUUIDProperty;
    }

    public void setOverridePropertiesFile(File overrideProperties) {
        this.fOverrideProperties = overrideProperties;
    }

    public void setDeletePropertiesFile(File deleteProperties) {
        this.fDeleteProperties = deleteProperties;
    }

    public void setAllowDuplicateRequests(boolean allowDuplicateRequests) {
        this.fAllowDuplicateRequests = allowDuplicateRequests;
    }

    public void setPersonalBuild(boolean personalBuild) {
        this.fPersonalBuild = personalBuild;
    }
}

