/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.taskdefs;

import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.automation.internal.AutomationPasswordHelper;
import com.ibm.team.enterprise.build.ant.internal.utils.AuthenticationUtilities;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class AbstractAutomationPublisherTask
extends Task {
    private ITeamRepository fTeamRepository = null;
    private IBuildResult fBuildResult = null;

    protected IBuildEngineHandle getBuildEngineHangle() {
        return (IBuildEngineHandle)IBuildEngine.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.getProject().getProperty("env.engineUUID")), null);
    }

    protected IBuildEngine getBuildEngine() throws FileNotFoundException, TeamRepositoryException, IOException {
        IBuildEngineHandle buildEngineHandle = this.getBuildEngineHangle();
        return (IBuildEngine)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildEngineHandle, 1, this.getProgressMonitor());
    }

    protected IBuildResult getBuildResult() throws BuildException {
        try {
            if (this.fBuildResult == null) {
                IBuildResultHandle resultHandle = this.getBuildResultHandle();
                this.fBuildResult = (IBuildResult)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)resultHandle, 1, this.getProgressMonitor());
            }
            return this.fBuildResult;
        }
        catch (ItemNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected IBuildResultHandle getBuildResultHandle() throws TeamRepositoryException {
        return (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.getBuildResultUUID()), null);
    }

    protected String getBuildResultUUID() {
        return this.getProject().getProperty("env.buildResultUUID");
    }

    protected ITeamRepository getTeamRepository() throws TeamRepositoryException, FileNotFoundException, IOException {
        if (this.fTeamRepository == null) {
            this.fTeamRepository = AuthenticationUtilities.getLoggedInTeamRepository((Project)this.getProject(), (String)this.getRepositoryAddress(), (String)this.getUserId(), (File)new File(this.getPasswordFile()));
        }
        return this.fTeamRepository;
    }

    protected IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    public String getUserId() throws FileNotFoundException, IOException {
        return this.getProject().getProperty("env.JAZZ_USER");
    }

    protected String getProvidedPassword() throws TeamRepositoryException, FileNotFoundException, IOException {
        File passwordFile = new File(this.getPasswordFile());
        try {
            return this.decryptPassword(passwordFile);
        }
        catch (Exception exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
    }

    protected String decryptPassword(File passwordFile) throws Exception {
        return AutomationPasswordHelper.getPassword((File)passwordFile);
    }

    public String getPasswordFile() throws FileNotFoundException, IOException {
        return this.getProject().getProperty("env.JAZZ_PASSWORD_FILE");
    }

    public String getRepositoryAddress() throws FileNotFoundException, IOException {
        return this.getProject().getProperty("env.repositoryAddress");
    }

    public String getStringTimeStamp(String stamp) {
        String timestamp = stamp;
        try {
            Date resourceTimeStamp = new Date(Long.parseLong(stamp));
            if (resourceTimeStamp != null) {
                timestamp = resourceTimeStamp.toString();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return timestamp;
    }

    public String getBuildRoot(String buildRootDir) throws IOException {
        if (buildRootDir == null) {
            return "";
        }
        File buildRootFile = new File(buildRootDir);
        return buildRootFile.getCanonicalPath();
    }
}

